/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NameTest;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.internal.values.QNameCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import java.io.Serializable;
import javax.xml.namespace.QName;

public final class SimpleNameTest
implements NameTest,
NodeTest,
Serializable {
    private static final long serialVersionUID = 3240028785683822736L;
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    VolatileCData qname;
    protected String namespace;
    protected String localPart;
    boolean elements;
    boolean attributes;
    boolean pi;
    boolean allownamespace;
    boolean createQName;

    public static NameTest name(VolatileCData volatileCData) {
        return new SimpleNameTest(volatileCData, volatileCData.getQNameNamespaceURI(1), volatileCData.getQNameLocalPart(1), true, true, true);
    }

    public static NodeTest namespace(String string2, String string3) {
        return new SimpleNameTest(null, string2, string3, false, false, false, true);
    }

    public static NodeTest element(VolatileCData volatileCData) {
        return new SimpleNameTest(volatileCData, volatileCData.getQNameNamespaceURI(1), volatileCData.getQNameLocalPart(1), true, false, false);
    }

    public static NodeTest element(String string2, String string3) {
        return new SimpleNameTest(null, string2, string3, true, false, false);
    }

    public static NodeTest attribute(VolatileCData volatileCData) {
        return new SimpleNameTest(volatileCData, volatileCData.getQNameNamespaceURI(1), volatileCData.getQNameLocalPart(1), false, true, false);
    }

    public static NodeTest attribute(String string2, String string3) {
        return new SimpleNameTest(null, string2, string3, false, true, false);
    }

    public static NodeTest elementOrAttribute(String string2, String string3) {
        return new SimpleNameTest(null, string2, string3, true, true, false);
    }

    public static NodeTest processingInstruction(String string2) {
        return new SimpleNameTest(null, null, string2, false, false, true);
    }

    public SimpleNameTest(VolatileCData volatileCData, boolean bl, String string2, String string3, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.namespace = string2 == null && volatileCData != null ? volatileCData.getQNameNamespaceURI(1) : string2;
        this.localPart = string3 == null && volatileCData != null ? volatileCData.getQNameLocalPart(1) : string3;
        this.elements = bl2;
        this.attributes = bl3;
        this.allownamespace = bl5;
        this.pi = bl4;
        this.qname = volatileCData;
        this.createQName = bl;
    }

    private SimpleNameTest(VolatileCData volatileCData, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        this(volatileCData, true, string2, string3, bl, bl2, bl3, false);
    }

    private SimpleNameTest(VolatileCData volatileCData, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(volatileCData, true, string2, string3, bl, bl2, bl3, bl4);
    }

    public boolean isQName() {
        return this.qname != null || this.createQName && this.namespace != null && this.localPart != null;
    }

    public QName getQName() {
        if (this.qname == null) {
            if (this.createQName) {
                if (this.namespace != null && this.localPart != null) {
                    this.qname = new QNameCData(new QName(this.namespace, this.localPart), TypeRegistry.XSQNAME);
                }
            } else {
                throw new IllegalStateException(XCIMessages.createXCIMessage("ER_WILDCARD_NAMETEST", null));
            }
        }
        return this.qname.getQName(1, null);
    }

    public VolatileCData getName() {
        if (this.getQName() == null) {
            throw new IllegalStateException(XCIMessages.createXCIMessage("ER_WILDCARD_NAMETEST", null));
        }
        return this.qname;
    }

    public boolean isWild() {
        return this.namespace == null && this.localPart == null;
    }

    public boolean hasWildNamespace() {
        return this.namespace == null;
    }

    public boolean hasWildLocalPart() {
        return this.localPart == null;
    }

    public boolean matches(VolatileCData volatileCData) {
        return !(this.localPart != null && !this.localPart.equals(volatileCData.getQNameLocalPart(1)) || this.namespace != null && !this.namespace.equals(volatileCData.getQNameNamespaceURI(1)));
    }

    public boolean allowsDocument() {
        return false;
    }

    public boolean allowsElement(VolatileCData volatileCData) {
        return this.elements && (volatileCData == null || this.matches(volatileCData));
    }

    public boolean allowsAttribute(VolatileCData volatileCData) {
        return this.attributes && (volatileCData == null || this.matches(volatileCData));
    }

    public boolean allowsNamespace(VolatileCData volatileCData) {
        return this.allownamespace && (volatileCData == null || this.matches(volatileCData));
    }

    public boolean allowsText() {
        return false;
    }

    public boolean allowsProcessingInstruction(String string2) {
        return this.pi && (string2 == null || this.localPart.equals(string2));
    }

    public boolean allowsComment() {
        return false;
    }

    public NameTest theNameTest() {
        return this;
    }

    public boolean test(Cursor cursor2) {
        short s = cursor2.itemKind();
        switch (s) {
            case 9: {
                return this.allowsDocument();
            }
            case 1: {
                return this.allowsElement(cursor2.itemName());
            }
            case 4: {
                return this.allowsNamespace(cursor2.itemName());
            }
            case 2: {
                return this.allowsAttribute(cursor2.itemName());
            }
            case 3: {
                return this.allowsText();
            }
            case 8: {
                return this.allowsComment();
            }
            case 7: {
                return this.allowsProcessingInstruction(cursor2.itemName().getQName(1, null).getLocalPart());
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.attributes) {
            stringBuilder.append("attribute(");
            this.appendNameStuff(stringBuilder);
            stringBuilder.append(")");
        } else if (this.elements) {
            stringBuilder.append("element(");
            this.appendNameStuff(stringBuilder);
            stringBuilder.append(")");
        } else if (this.allownamespace) {
            stringBuilder.append("namespace(");
            this.appendNameStuff(stringBuilder);
            stringBuilder.append(")");
        } else if (this.pi) {
            stringBuilder.append("processing-instruction(");
            this.appendNameStuff(stringBuilder);
            stringBuilder.append(")");
        } else {
            this.appendNameStuff(stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void appendNameStuff(StringBuilder stringBuilder) {
        if (this.qname != null || this.createQName && this.namespace != null && this.localPart != null && this.getQName() != null) {
            String string2 = this.qname.getQNameNamespaceURI(1);
            if (string2 != null && string2.length() > 0) {
                stringBuilder.append("{");
                stringBuilder.append(string2);
                stringBuilder.append("}");
                stringBuilder.append(":");
            }
            String string3 = this.qname.getQNameLocalPart(1);
            stringBuilder.append(string3);
        } else {
            if (this.namespace != null && this.namespace.length() > 0) {
                stringBuilder.append("{");
                stringBuilder.append(this.namespace);
                stringBuilder.append("}");
                stringBuilder.append(":");
            } else if (this.namespace == null) {
                stringBuilder.append("*");
                stringBuilder.append(":");
            }
            if (this.localPart != null && this.localPart.length() > 0) {
                stringBuilder.append(this.localPart);
            } else if (this.localPart == null) {
                stringBuilder.append("*");
            } else {
                stringBuilder.append("??");
            }
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalPart() {
        return this.localPart;
    }
}

