/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.xlxp.cdata;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.internal.values.QNameCDataLocalOnly;
import com.ibm.xml.xci.xlxp.cdata.XLXPQNameCData;
import com.ibm.xml.xci.xlxp.cdata.XMLStringCData;
import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.ListDV;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XLXPCDataFactory {
    private XMLStringCData sharedXMLStringCData;

    public VolatileCData createNamespaceCData(String string2) {
        return new QNameCDataLocalOnly(string2);
    }

    public VolatileCData createXLXPQNameCData(QName qName) {
        if ((qName.nsURI == null || qName.nsURI.equals("")) && (qName.prefix == null || qName.prefix.equals(""))) {
            return new QNameCDataLocalOnly(qName.localName);
        }
        return new XLXPQNameCData(qName);
    }

    public VolatileCData createXMLStringCData(XMLString xMLString, XSSimpleTypeDefinition xSSimpleTypeDefinition, Helper helper2, int n2) {
        return this.createXMLStringCData(xMLString, xSSimpleTypeDefinition, helper2, n2, false);
    }

    public VolatileCData createXMLStringCData(XMLString xMLString, XSSimpleTypeDefinition xSSimpleTypeDefinition, Helper helper2, int n2, boolean bl) {
        if (this.isUnionType(xSSimpleTypeDefinition)) {
            TypeValidator typeValidator = helper2.getXLXPType(n2);
            assert (typeValidator.xsTypeDefinition == xSSimpleTypeDefinition);
            return this.createXMLStringCDataForUnion(xMLString, typeValidator, helper2, bl);
        }
        if (this.isListType(xSSimpleTypeDefinition)) {
            TypeValidator typeValidator = helper2.getXLXPType(n2);
            assert (typeValidator.xsTypeDefinition == xSSimpleTypeDefinition);
            return this.createXMLStringCDataForList(xMLString, typeValidator, helper2, bl);
        }
        return this.createXMLStringCDataForAtomic(xMLString, xSSimpleTypeDefinition, helper2, bl);
    }

    private XMLStringCData createXMLStringCData(XMLString xMLString, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext, boolean bl) {
        if (!bl || this.sharedXMLStringCData == null || this.sharedXMLStringCData.isConstant()) {
            this.sharedXMLStringCData = new XMLStringCData(xMLString, xSSimpleTypeDefinition, namespaceContext);
        } else {
            this.sharedXMLStringCData.clear();
            this.sharedXMLStringCData.setValues(xMLString, xSSimpleTypeDefinition, namespaceContext);
        }
        return this.sharedXMLStringCData;
    }

    private VolatileCData createXMLStringCDataForAtomic(XMLString xMLString, XSSimpleTypeDefinition xSSimpleTypeDefinition, Helper helper2, boolean bl) {
        NamespaceContext namespaceContext = null;
        short s = xSSimpleTypeDefinition.getBuiltInKind();
        if (s == 19 || s == 20) {
            namespaceContext = helper2.getNamespaceContext();
        }
        return this.createXMLStringCData(xMLString, xSSimpleTypeDefinition, namespaceContext, bl);
    }

    private VolatileCData createXMLStringCDataForUnion(XMLString xMLString, TypeValidator typeValidator, Helper helper2, boolean bl) {
        typeValidator = helper2.validate(typeValidator, xMLString);
        if (this.isListType(typeValidator.xsTypeDefinition)) {
            return this.createXMLStringCDataForList(xMLString, typeValidator, helper2, bl);
        }
        return this.createXMLStringCDataForAtomic(xMLString, typeValidator.xsTypeDefinition, helper2, bl);
    }

    private VolatileCData createXMLStringCDataForList(XMLString xMLString, TypeValidator typeValidator, Helper helper2, boolean bl) {
        XMLStringCData xMLStringCData = this.createXMLStringCData(xMLString, typeValidator.xsTypeDefinition, null, bl);
        ArrayList<CData> arrayList = new ArrayList<CData>();
        TypeValidator typeValidator2 = ((ListDV)typeValidator).getItemTypeValidator();
        XMLString xMLString2 = new XMLString();
        xMLString2.setValues(xMLString);
        xMLString2.setEndPos(xMLString.firstBuffer, xMLString.startOffset);
        while (this.nextToken(xMLString, xMLString2)) {
            if (this.isUnionType(typeValidator2.xsTypeDefinition)) {
                arrayList.add(this.createXMLStringCDataForUnion(xMLString2, typeValidator2, helper2, false).constant(true));
                continue;
            }
            arrayList.add(this.createXMLStringCDataForAtomic(xMLString2, typeValidator2.xsTypeDefinition, helper2, false).constant(true));
        }
        xMLStringCData.buildList(arrayList);
        xMLString2.unregister();
        return xMLStringCData;
    }

    private boolean nextToken(XMLString xMLString, XMLString xMLString2) {
        DataBuffer dataBuffer = xMLString2.lastBuffer;
        if (dataBuffer == null) {
            dataBuffer = xMLString2.firstBuffer;
        }
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString2.endOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n2];
        while (true) {
            if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                continue;
            }
            if (n2 != n3 || dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            by2 = dataBuffer.bytes[n2];
        }
        if (n2 == n3) {
            return false;
        }
        xMLString2.setStartPos(dataBuffer, n2);
        while (true) {
            if (by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13 && ++n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                continue;
            }
            if (n2 != n3 || dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            by2 = dataBuffer.bytes[n2];
        }
        xMLString2.setEndPos(dataBuffer, n2);
        return true;
    }

    private boolean isUnionType(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return xSSimpleTypeDefinition != null && xSSimpleTypeDefinition.getVariety() == 3;
    }

    private boolean isListType(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return xSSimpleTypeDefinition != null && xSSimpleTypeDefinition.getVariety() == 2;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static interface Helper {
        public NamespaceContext getNamespaceContext();

        public TypeValidator getXLXPType(int var1);

        public TypeValidator validate(TypeValidator var1, XMLString var2);
    }
}

