/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.xlxp.cdata;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.BytesUtils;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.ArrayCData;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xci.dp.values.LazyBaseCData;
import com.ibm.xml.xci.dp.values.TypedValueHelper;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.internal.values.Base64BinaryCData;
import com.ibm.xml.xci.internal.values.BigDecimalCData;
import com.ibm.xml.xci.internal.values.BigIntegerCData;
import com.ibm.xml.xci.internal.values.BooleanCData;
import com.ibm.xml.xci.internal.values.ByteCData;
import com.ibm.xml.xci.internal.values.DoubleCData;
import com.ibm.xml.xci.internal.values.DurationCData;
import com.ibm.xml.xci.internal.values.FloatCData;
import com.ibm.xml.xci.internal.values.HexBinaryCData;
import com.ibm.xml.xci.internal.values.IntCData;
import com.ibm.xml.xci.internal.values.LongCData;
import com.ibm.xml.xci.internal.values.QNameCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.internal.values.URICData;
import com.ibm.xml.xci.internal.values.XMLGregorianCalendarCData;
import com.ibm.xml.xci.serializer.XOutputWriter;
import com.ibm.xml.xlxp.internal.s1.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.datatype.XBinary;
import com.ibm.xml.xlxp.internal.s1.datatype.XDecimal;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.BooleanDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.DecimalDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.DoubleDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.FloatDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.IntegerDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.LanguageDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSBase64BinaryUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSHexBinaryUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSNormalizer;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class XMLStringCData
extends LazyBaseCData {
    private static final Logger logger = LoggerUtil.getLogger(XMLStringCData.class);
    private static final int FLAGS_IS_CONSTANT = 16384;
    private XSSimpleTypeDefinition xstype;
    private byte[] bytes;
    private int startOffset;
    private int length;
    private short flags;
    private short encodeFlags;
    private DataBuffer firstBuffer;
    private SoftReference<String> stringRef;

    protected XMLStringCData(XMLString xMLString, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext) {
        this(xSSimpleTypeDefinition, xMLString.bytes, xMLString.startOffset, xMLString.length, xMLString.flags, xMLString.encodeFlags, xMLString.firstBuffer, namespaceContext);
    }

    protected XMLStringCData(XSSimpleTypeDefinition xSSimpleTypeDefinition, byte[] byArray, int n2, int n3, short s, short s2, DataBuffer dataBuffer, NamespaceContext namespaceContext) {
        this.setValues(xSSimpleTypeDefinition, byArray, n2, n3, s, s2, dataBuffer, namespaceContext);
    }

    @Override
    public XSSimpleTypeDefinition getXSTypeDefinition() {
        return this.xstype;
    }

    @Override
    protected CData parse() {
        Exception exception;
        String string2;
        XMLString xMLString;
        boolean bl;
        block39: {
            bl = LoggerUtil.isAnyTracingEnabled();
            if (bl && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "parse", "entering XMLStringCData.parse");
            }
            xMLString = this.makeXMLString();
            string2 = null;
            exception = null;
            int[] nArray = ArrayAllocator.newIntArray(1);
            try {
                switch (this.xstype.getBuiltInKind()) {
                    case 19: 
                    case 20: {
                        break;
                    }
                    case 3: {
                        Boolean bl2 = BooleanDV.parseBoolean(xMLString);
                        if (bl2 == null) break;
                        this.typedValue = new BooleanCData(bl2, this.xstype);
                        break;
                    }
                    case 36: {
                        byte by2 = XSIntegerUtil.parseByte(xMLString, nArray);
                        if (nArray[0] != 0) break;
                        this.typedValue = new ByteCData(by2, this.xstype);
                        break;
                    }
                    case 35: {
                        short s = XSIntegerUtil.parseShort(xMLString, nArray);
                        if (nArray[0] != 0) break;
                        this.typedValue = new IntCData(s, this.xstype);
                        break;
                    }
                    case 40: {
                        int n2 = XSIntegerUtil.parseUShort(xMLString, nArray);
                        if (nArray[0] != 0) break;
                        this.typedValue = new IntCData(n2, this.xstype);
                        break;
                    }
                    case 41: {
                        short s = XSIntegerUtil.parseUByte(xMLString, nArray);
                        if (nArray[0] != 0) break;
                        this.typedValue = new IntCData(s, this.xstype);
                        break;
                    }
                    case 34: {
                        int n3 = XSIntegerUtil.parseInt(xMLString, nArray);
                        if (nArray[0] != 0) break;
                        this.typedValue = new IntCData(n3, this.xstype);
                        break;
                    }
                    case 39: {
                        long l = XSIntegerUtil.parseUInt(xMLString, nArray);
                        if (nArray[0] != 0) break;
                        this.typedValue = new LongCData(l, this.xstype);
                        break;
                    }
                    case 33: {
                        long l = XSIntegerUtil.parseLong(xMLString, nArray);
                        if (nArray[0] != 0) break;
                        this.typedValue = new LongCData(l, this.xstype);
                        break;
                    }
                    case 5: {
                        float f2 = FloatDV.parse(xMLString, nArray);
                        if (nArray[0] != 0) break;
                        this.typedValue = new FloatCData(f2, this.xstype);
                        break;
                    }
                    case 6: {
                        double d = DoubleDV.parse(xMLString, nArray);
                        if (nArray[0] != 0) break;
                        this.typedValue = new DoubleCData(d, this.xstype);
                        break;
                    }
                    case 4: {
                        XDecimal xDecimal = DecimalDV.parse(xMLString);
                        if (xDecimal == null) break;
                        this.typedValue = new BigDecimalCData(new BigDecimal(xDecimal.toString()), this.xstype);
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 32: 
                    case 37: 
                    case 38: 
                    case 42: {
                        XDecimal xDecimal = IntegerDV.parse(xMLString);
                        if (xDecimal == null) break;
                        BigInteger bigInteger = new BigInteger(xDecimal.toString());
                        if (this.checkBounds(bigInteger, this.xstype.getBuiltInKind())) {
                            this.typedValue = new BigIntegerCData(bigInteger, this.xstype);
                        }
                        break;
                    }
                    case 17: {
                        XBinary xBinary = XSBase64BinaryUtil.parseBase64Binary(xMLString);
                        if (xBinary == null) break;
                        Bytes bytes2 = BytesUtils.make(xBinary.value, 0L, (long)xBinary.length);
                        this.typedValue = new Base64BinaryCData(bytes2, this.xstype);
                        break;
                    }
                    case 16: {
                        XBinary xBinary = XSHexBinaryUtil.parseHexBinary(xMLString);
                        if (xBinary == null) break;
                        Bytes bytes3 = BytesUtils.make(xBinary.value, 0L, (long)xBinary.length);
                        this.typedValue = new HexBinaryCData(bytes3, this.xstype);
                        break;
                    }
                    case 18: {
                        string2 = this.toString();
                        if (string2 == null) break;
                        this.typedValue = new URICData(TypedValueHelper.collapse(string2), this.xstype);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 49: 
                    case 50: {
                        string2 = this.toString();
                        if (string2 == null) break;
                        this.typedValue = new StringCData(string2, this.xstype);
                        break;
                    }
                    case 21: {
                        string2 = this.toString();
                        if (string2 == null) break;
                        this.typedValue = new StringCData(TypedValueHelper.replace(string2), this.xstype);
                        break;
                    }
                    case 22: {
                        string2 = this.toString();
                        if (string2 == null) break;
                        this.typedValue = new StringCData(TypedValueHelper.collapse(string2), this.xstype);
                        break;
                    }
                    case 23: {
                        string2 = LanguageDV.parse(xMLString).toString();
                        if (string2 == null) break;
                        this.typedValue = new StringCData(string2, this.xstype);
                        break;
                    }
                    case 24: {
                        if (!this.isNMTOKEN(xMLString)) break;
                        string2 = this.toString();
                        this.typedValue = new StringCData(TypedValueHelper.trim(string2), this.xstype);
                        break;
                    }
                    case 25: {
                        if (!this.isName(xMLString)) break;
                        string2 = this.toString();
                        this.typedValue = new StringCData(TypedValueHelper.trim(string2), this.xstype);
                        break;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        if (!this.isNCName(xMLString)) break;
                        string2 = this.toString();
                        this.typedValue = new StringCData(TypedValueHelper.trim(string2), this.xstype);
                        break;
                    }
                    case 7: {
                        string2 = StringChars.toString(TypedValueHelper.trim(this.toString()));
                        if (string2 == null) break;
                        this.typedValue = new DurationCData(BaseCData.javaxFactory.newDuration(string2), this.xstype);
                        break;
                    }
                    case 46: {
                        string2 = StringChars.toString(TypedValueHelper.trim(this.toString()));
                        if (string2 == null) break;
                        this.typedValue = new DurationCData(BaseCData.javaxFactory.newDurationYearMonth(string2), this.xstype);
                        break;
                    }
                    case 47: {
                        string2 = StringChars.toString(TypedValueHelper.trim(this.toString()));
                        if (string2 == null) break;
                        this.typedValue = new DurationCData(BaseCData.javaxFactory.newDurationDayTime(string2), this.xstype);
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        try {
                            string2 = StringChars.toString(TypedValueHelper.trim(this.toString()));
                            if (string2 != null) {
                                XMLGregorianCalendar xMLGregorianCalendar = BaseCData.javaxFactory.newXMLGregorianCalendar(string2);
                                if (TypedValueHelper.hasExpectedBuiltInKind(this.xstype.getBuiltInKind(), xMLGregorianCalendar)) {
                                    this.typedValue = new XMLGregorianCalendarCData(xMLGregorianCalendar, this.xstype);
                                }
                            }
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw XCIErrorHelper.createBadTypeValueException(string2, this.xstype.toString(), illegalArgumentException);
                        }
                    }
                }
            }
            catch (Exception exception2) {
                exception = exception2;
                if ($assertionsDisabled || this.typedValue == null) break block39;
                throw new AssertionError();
            }
        }
        if (this.typedValue == null) {
            if (bl && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "parse", "Could not convert value=" + string2 + " into type =" + TypeHelper.prettyPrint(this.xstype));
            }
            xMLString.unregister();
            string2 = this.toString();
            throw XCIErrorHelper.createBadTypeValueException(string2, TypeHelper.prettyPrint(this.xstype), exception);
        }
        return this.typedValue;
    }

    @Override
    public boolean isConstant() {
        return (this.flags & 0x4000) != 0;
    }

    @Override
    public CData constant(boolean bl) {
        if ((this.flags & 0x4000) == 0) {
            this.bytes = new byte[this.length];
            if (this.startOffset + this.length <= this.firstBuffer.endOffset) {
                System.arraycopy(this.firstBuffer.bytes, this.startOffset, this.bytes, 0, this.length);
            } else {
                int n2;
                int n3 = this.startOffset + this.length;
                DataBuffer dataBuffer = this.firstBuffer;
                int n4 = this.startOffset;
                int n5 = 0;
                do {
                    byte[] byArray = dataBuffer.bytes;
                    n2 = dataBuffer.endOffset;
                    System.arraycopy(byArray, n4, this.bytes, n5, n2 - n4);
                    n5 += n2 - n4;
                    dataBuffer = dataBuffer.next;
                } while ((n3 -= n2 - (n4 = dataBuffer.startOffset)) > dataBuffer.endOffset);
                System.arraycopy(dataBuffer.bytes, n4, this.bytes, n5, n3 - n4);
            }
            this.firstBuffer = null;
            this.startOffset = 0;
            this.flags = (short)(this.flags | 0x4000);
        }
        return this;
    }

    @Override
    public String toString() {
        String string2;
        if (this.stringRef == null || (string2 = this.stringRef.get()) == null) {
            try {
                if (this.firstBuffer == null) {
                    if ((this.flags & 0xC) == 0) {
                        string2 = new String(this.bytes, this.startOffset, this.length, "UTF8");
                    } else {
                        this.checkBuffer();
                        string2 = this.firstBuffer.toString(this.startOffset, this.length, this.flags);
                        this.firstBuffer = null;
                    }
                } else {
                    string2 = this.firstBuffer.toString(this.startOffset, this.length, this.flags);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
            this.stringRef = new SoftReference<String>(string2);
        }
        return string2;
    }

    @Override
    public int writeTo(Writer writer, boolean bl) throws IOException {
        String string2 = this.toString();
        writer.write(string2);
        return string2.length();
    }

    @Override
    public Bytes toEncodedBytes(String string2) {
        if (Chars.UTF8.name().equals(string2) && this.bytes != null && (this.flags & 0xC) == 0) {
            return BytesUtils.make(this.bytes, (long)this.startOffset, (long)(this.startOffset + this.length));
        }
        return super.toEncodedBytes(string2);
    }

    void clear() {
        this.stringRef = null;
        this.typedValue = null;
        this.firstBuffer = null;
        this.bytes = null;
        this.startOffset = 0;
        this.length = 0;
        this.flags = 0;
    }

    protected void setValues(XMLString xMLString, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext) {
        this.setValues(xSSimpleTypeDefinition, xMLString.bytes, xMLString.startOffset, xMLString.length, xMLString.flags, xMLString.encodeFlags, xMLString.firstBuffer, namespaceContext);
    }

    protected void setValues(XSSimpleTypeDefinition xSSimpleTypeDefinition, byte[] byArray, int n2, int n3, short s, short s2, DataBuffer dataBuffer, NamespaceContext namespaceContext) {
        this.xstype = xSSimpleTypeDefinition;
        this.bytes = byArray;
        this.startOffset = n2;
        this.length = n3;
        this.flags = s;
        this.encodeFlags = s2;
        this.firstBuffer = dataBuffer;
        this.flags = (short)(this.flags & 0xFFFFBFFF);
        short s3 = this.xstype.getBuiltInKind();
        if (s3 == 19 || s3 == 20) {
            this.processQName(namespaceContext);
        }
    }

    private XMLString makeXMLString() {
        this.checkBuffer();
        XMLString xMLString = new XMLString();
        xMLString.setValuesUsingLength(this.firstBuffer, this.startOffset, this.length);
        xMLString.flags = this.flags;
        return xMLString;
    }

    private boolean checkBuffer() {
        if (this.firstBuffer == null) {
            this.firstBuffer = NullDataBufferFactory.createNewBuffer(this.bytes);
            this.firstBuffer.startOffset = this.startOffset;
            this.firstBuffer.endOffset = this.startOffset + this.length;
            return true;
        }
        return false;
    }

    @Override
    public CharSequence getOriginalLexicalValue() {
        return this.toString();
    }

    private void processQName(NamespaceContext namespaceContext) {
        QName qName = this.parseQName(StringChars.toString(TypedValueHelper.trim(this.toString())), namespaceContext);
        if (qName != null) {
            this.typedValue = new QNameCData(qName, this.xstype);
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "parse", "Could not convert value=" + this.toString() + " into type =" + TypeHelper.prettyPrint(this.xstype));
            }
            this.typedValue = null;
        }
    }

    private QName parseQName(String string2, NamespaceContext namespaceContext) {
        boolean bl = LoggerUtil.isAnyTracingEnabled();
        if (namespaceContext == null) {
            if (bl && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "parseQName", "namespace context was NULL when processing QName:" + string2);
            }
            return null;
        }
        int n2 = string2.indexOf(58);
        String string3 = n2 == -1 ? "" : string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1);
        if (!XMLChar.isValidNCName(string4)) {
            return null;
        }
        String string5 = namespaceContext.getNamespaceURI(string3);
        if (string5 != null) {
            return new QName(string5, string4, string3);
        }
        if (n2 == -1) {
            return new QName("", string4, "");
        }
        if (bl && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "parseQName", "Prefix={" + string3 + "} was not bound to any URI. inside qname=" + string2);
        }
        return null;
    }

    void buildList(List<CData> list) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "buildList", "Building a list of CDatas for the content=" + this.toString());
        }
        CData[] cDataArray = new CData[list.size()];
        cDataArray = list.toArray(cDataArray);
        this.typedValue = new ArrayCData(cDataArray, this.xstype);
    }

    private boolean checkWhitespace() {
        if (this.length > 0) {
            boolean bl = this.checkBuffer();
            try {
                if (UTF8Support.isAllWhitespace(this.firstBuffer, this.startOffset, this.length, this.flags)) {
                    this.flags = (short)(this.flags | 2);
                    boolean bl2 = true;
                    return bl2;
                }
                this.flags = (short)(this.flags | 1);
                boolean bl3 = false;
                return bl3;
            }
            catch (CharConversionException charConversionException) {
                FFDCUtil.log(charConversionException, this);
                throw new IOExceptionWrapper(charConversionException);
            }
            finally {
                if (bl) {
                    this.firstBuffer = null;
                }
            }
        }
        this.flags = (short)(this.flags | 2);
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.length <= 0;
    }

    @Override
    public int length() {
        String string2;
        if (this.stringRef != null && (string2 = this.stringRef.get()) != null) {
            return string2.length();
        }
        boolean bl = this.checkBuffer();
        try {
            int[] nArray = new int[1];
            int n2 = UTF8Support.lengthAsCharacters(this.firstBuffer, this.startOffset, this.length, this.flags, nArray);
            int n3 = n2 + nArray[0];
            return n3;
        }
        catch (CharConversionException charConversionException) {
            FFDCUtil.log(charConversionException, this);
            throw new IOExceptionWrapper(charConversionException);
        }
        finally {
            if (bl) {
                this.firstBuffer = null;
            }
        }
    }

    @Override
    public char charAt(int n2) {
        return this.toString().charAt(n2);
    }

    @Override
    public boolean isSpace() {
        if ((this.flags & 2) != 0) {
            return true;
        }
        if ((this.flags & 1) != 0) {
            return false;
        }
        return this.checkWhitespace();
    }

    @Override
    public boolean mayContain(short s) {
        int n2 = this.encodeFlags != 0 ? (int)this.encodeFlags : -1;
        return (s & n2) != 0;
    }

    @Override
    public int appendQuotedTo(Appendable appendable, short s, boolean bl) throws IOException {
        assert (!this.mayContain(s));
        appendable.append(this);
        return this.length();
    }

    @Override
    public char[] toCharArray() {
        return this.toString().toCharArray();
    }

    @Override
    public int needsEscaping(byte[] byArray) {
        byte by2;
        int n2;
        if ((this.flags & 0x4000) == 0) {
            String string2 = this.toString();
            return this.needsEscaping(string2, 0, string2.length(), byArray);
        }
        byte[] byArray2 = this.bytes;
        int n3 = byArray2.length;
        for (n2 = 0; n2 < n3 && (by2 = byArray2[n2]) >= 0 && byArray[by2] == 0; ++n2) {
        }
        if (n2 == n3) {
            return -1;
        }
        return n2;
    }

    @Override
    public int needsEscaping(int n2, int n3, byte[] byArray) {
        return this.needsEscaping(this.toString(), n2, n3, byArray);
    }

    private int needsEscaping(String string2, int n2, int n3, byte[] byArray) {
        char c;
        int n4;
        for (n4 = n2; n4 < n3 && (c = string2.charAt(n4)) < byArray.length && byArray[c] == 0; ++n4) {
        }
        if (n4 == n3) {
            return -1;
        }
        return n4;
    }

    @Override
    public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
        if (!xOutputWriter.getEncodingInfo().isUTF8()) {
            String string2 = this.toString();
            xOutputWriter.write(string2, encodeContext);
            return;
        }
        if ((this.flags & 0xC) != 0) {
            if (this.firstBuffer == null && (this.flags & 8) == 0) {
                xOutputWriter.writeWithLBNormalization(this.bytes, this.startOffset, this.startOffset + this.length, encodeContext);
            } else {
                String string3 = this.toString();
                xOutputWriter.write(string3, encodeContext);
            }
            return;
        }
        if (!this.mayContain(encodeContext.flags) && xOutputWriter.getCodepointMappings() == null) {
            if (this.firstBuffer == null) {
                xOutputWriter.writeDirectUTF8(this.bytes, this.startOffset, this.length);
            } else if (this.startOffset + this.length <= this.firstBuffer.endOffset) {
                xOutputWriter.writeDirectUTF8(this.firstBuffer.bytes, this.startOffset, this.length);
            } else {
                int n2;
                int n3 = this.startOffset + this.length;
                DataBuffer dataBuffer = this.firstBuffer;
                int n4 = this.startOffset;
                do {
                    byte[] byArray = dataBuffer.bytes;
                    n2 = dataBuffer.endOffset;
                    xOutputWriter.writeDirectUTF8(byArray, n4, n2 - n4);
                    dataBuffer = dataBuffer.next;
                } while ((n3 -= n2 - (n4 = dataBuffer.startOffset)) > dataBuffer.endOffset);
                xOutputWriter.writeDirectUTF8(dataBuffer.bytes, n4, n3 - n4);
            }
            return;
        }
        if (this.firstBuffer == null) {
            xOutputWriter.write(this.bytes, this.startOffset, this.startOffset + this.length, encodeContext);
        } else if (this.startOffset + this.length <= this.firstBuffer.endOffset) {
            xOutputWriter.write(this.firstBuffer.bytes, this.startOffset, this.startOffset + this.length, encodeContext);
        } else {
            int n5;
            int n6 = this.startOffset + this.length;
            DataBuffer dataBuffer = this.firstBuffer;
            int n7 = this.startOffset;
            do {
                byte[] byArray = dataBuffer.bytes;
                n5 = dataBuffer.endOffset;
                xOutputWriter.write(byArray, n7, n5, encodeContext);
                dataBuffer = dataBuffer.next;
            } while ((n6 -= n5 - (n7 = dataBuffer.startOffset)) > dataBuffer.endOffset);
            xOutputWriter.write(dataBuffer.bytes, n7, n6, encodeContext);
        }
    }

    private boolean checkBounds(BigInteger bigInteger, short s) {
        switch (s) {
            case 38: {
                BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
                if (bigInteger.compareTo(BigInteger.ZERO) != -1 && bigInteger.compareTo(bigInteger2) != 1) break;
                return false;
            }
            case 31: {
                if (bigInteger.compareTo(BigInteger.ZERO) != 1) break;
                return false;
            }
            case 37: {
                if (bigInteger.compareTo(BigInteger.ZERO) != -1) break;
                return false;
            }
            case 42: {
                if (bigInteger.compareTo(BigInteger.ZERO) == 1) break;
                return false;
            }
            case 32: {
                if (bigInteger.compareTo(BigInteger.ZERO) == -1) break;
                return false;
            }
        }
        return true;
    }

    private boolean isNMTOKEN(XMLString xMLString) {
        XMLString xMLString2 = XSNormalizer.trim(xMLString, null);
        boolean bl = XMLStringUtil.isNMTOKEN(xMLString2);
        if (xMLString2 != xMLString) {
            xMLString2.unregister();
        }
        return bl;
    }

    private boolean isName(XMLString xMLString) {
        XMLString xMLString2 = XSNormalizer.trim(xMLString, null);
        boolean bl = XMLStringUtil.isName(xMLString2);
        if (xMLString2 != xMLString) {
            xMLString2.unregister();
        }
        return bl;
    }

    private boolean isNCName(XMLString xMLString) {
        XMLString xMLString2 = XSNormalizer.trim(xMLString, null);
        boolean bl = XMLStringUtil.isNCName(xMLString2);
        if (xMLString2 != xMLString) {
            xMLString2.unregister();
        }
        return bl;
    }
}

