/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath;

import com.ibm.xml.xlxp.api.wbm.xpath.AggregateFunction;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.XMLStringHelper;
import com.ibm.xml.xlxp.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
abstract class AbstractDoubleAggregateFunction
implements AggregateFunction {
    private StringBuilder builder;
    private final int[] errorCode = new int[1];
    final int xpathID;

    public AbstractDoubleAggregateFunction(int n2) {
        this.xpathID = n2;
    }

    @Override
    public void reset() {
        this.builder = null;
    }

    @Override
    public void element() {
        this.value(Double.NaN);
        this.builder = null;
    }

    @Override
    public void attribute(XMLString xMLString) {
        this.value(xMLString);
    }

    @Override
    public void textBeforeComment(XMLString xMLString, boolean bl) {
        this.textBeforeCommentOrProcessingInstruction(xMLString, bl);
    }

    @Override
    public void textBeforeProcessingInstruction(XMLString xMLString, boolean bl) {
        this.textBeforeCommentOrProcessingInstruction(xMLString, bl);
    }

    private void textBeforeCommentOrProcessingInstruction(XMLString xMLString, boolean bl) {
        if (xMLString.length > 0) {
            if (bl) {
                if (this.builder == null) {
                    this.builder = new StringBuilder();
                }
                this.builder.append(xMLString.toString());
            } else {
                this.value(xMLString);
            }
        }
    }

    @Override
    public void textBeforeStartTag(XMLString xMLString, boolean bl) {
        this.textBeforeStartOrEmptyTag(xMLString, bl);
    }

    @Override
    public void textBeforeEmptyTag(XMLString xMLString, boolean bl) {
        this.textBeforeStartOrEmptyTag(xMLString, bl);
    }

    private void textBeforeStartOrEmptyTag(XMLString xMLString, boolean bl) {
        if (bl) {
            this.value(Double.NaN);
            this.builder = null;
        } else {
            this.value(xMLString);
        }
    }

    @Override
    public void textBeforeEndTag(XMLString xMLString, boolean bl) {
        if (bl && this.builder != null) {
            if (xMLString.length > 0) {
                this.builder.append(xMLString.toString());
            }
            this.value(this.builder.toString());
            this.builder = null;
            return;
        }
        this.value(xMLString);
    }

    final void value(XMLString xMLString) {
        double d = XMLStringHelper.parseDouble(xMLString, this.errorCode);
        this.value(this.errorCode[0] == 0 ? d : Double.NaN);
    }

    final void value(String string2) {
        string2 = string2.trim();
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c >= '0' && c <= '9' || c == '.' || c == 'E' || c == 'e' || c == '+' || c == '-') continue;
            if ("INF".equals(string2)) {
                this.value(Double.POSITIVE_INFINITY);
            } else if ("-INF".equals(string2)) {
                this.value(Double.NEGATIVE_INFINITY);
            } else {
                this.value(Double.NaN);
            }
            return;
        }
        try {
            this.value(Double.parseDouble(string2));
        }
        catch (NumberFormatException numberFormatException) {
            this.value(Double.NaN);
        }
    }

    abstract void value(double var1);
}

