/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath;

import com.ibm.xml.xlxp.api.wbm.xpath.AbstractDoubleAggregateFunction;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathResultHandler;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class MinFunction
extends AbstractDoubleAggregateFunction {
    private double minValue;
    private boolean sawValues;

    public MinFunction(int n2) {
        super(n2);
    }

    @Override
    public void reset() {
        super.reset();
        this.minValue = 0.0;
        this.sawValues = false;
    }

    @Override
    void value(double d) {
        if (this.sawValues) {
            if (d < this.minValue || Double.isNaN(d)) {
                this.minValue = d;
            }
        } else {
            this.minValue = d;
            this.sawValues = true;
        }
    }

    @Override
    public void writeResult(XPathResultHandler xPathResultHandler) {
        if (this.sawValues) {
            xPathResultHandler.doubleValue(this.xpathID, this.minValue);
        }
    }
}

