/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath;

import com.ibm.xml.xlxp.api.wbm.xpath.AbstractDoubleAggregateFunction;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathResultHandler;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class SumFunction
extends AbstractDoubleAggregateFunction {
    private double total;
    private boolean sawValues;

    public SumFunction(int n2) {
        super(n2);
    }

    @Override
    public void reset() {
        super.reset();
        this.total = 0.0;
        this.sawValues = false;
    }

    @Override
    void value(double d) {
        this.total += d;
        this.sawValues = true;
    }

    @Override
    public void writeResult(XPathResultHandler xPathResultHandler) {
        if (this.sawValues) {
            xPathResultHandler.doubleValue(this.xpathID, this.total);
        } else {
            xPathResultHandler.longValue(this.xpathID, 0L);
        }
    }
}

