/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath;

import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathAttributeInfo;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathDFA;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates.Predicate;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates.PredicateContext;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class XPath {
    static final int FUNCTION_NONE = 0;
    static final int FUNCTION_COUNT = 1;
    static final int FUNCTION_AVG = 2;
    static final int FUNCTION_MAX = 3;
    static final int FUNCTION_MIN = 4;
    static final int FUNCTION_SUM = 5;
    private static final int[] ZERO_LENGTH_INT_ARRAY = new int[0];
    private final QName[] transitionSymbols;
    private final boolean[] textSymbols;
    private final ArrayList<Predicate>[] predicates;
    private final int[][] transitionTable;
    private final boolean[] allowMoreInput;
    private final QName[][] finalAttrDecls;
    private final String expression;
    final int xpathID;
    final int subXPathID;
    final XPath next;
    final int functionID;

    XPath(String string2, int n2, int n3) {
        this.expression = string2;
        this.xpathID = n2;
        this.subXPathID = n3;
        this.next = null;
        this.functionID = 0;
        this.transitionTable = new int[2][0];
        this.transitionSymbols = null;
        this.finalAttrDecls = null;
        this.allowMoreInput = null;
        this.predicates = null;
        this.textSymbols = null;
    }

    XPath(String string2, int n2, int n3, XPathDFA xPathDFA, SymbolTable symbolTable) {
        this(string2, n2, n3, xPathDFA, symbolTable, null);
    }

    XPath(String string2, int n2, int n3, XPathDFA xPathDFA, SymbolTable symbolTable, XPath xPath) {
        int n4;
        int n5;
        int n6;
        this.expression = string2;
        this.xpathID = n2;
        this.subXPathID = n3;
        this.next = xPath;
        this.functionID = this.getFunctionID(xPathDFA.getFunction());
        this.transitionTable = xPathDFA.transitionTable();
        for (int i = 0; i < this.transitionTable.length; ++i) {
            int[] nArray = this.transitionTable[i];
            n6 = 0;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] == 0) continue;
                ++n6;
            }
            if (n6 > 0) {
                int[] nArray2 = new int[n6 * 2];
                int n7 = 0;
                for (n5 = 0; n5 < nArray.length; ++n5) {
                    n4 = nArray[n5];
                    if (n4 == 0) continue;
                    nArray2[n7++] = n5;
                    nArray2[n7++] = n4;
                }
                this.transitionTable[i] = nArray2;
                continue;
            }
            this.transitionTable[i] = ZERO_LENGTH_INT_ARRAY;
        }
        String[] stringArray = xPathDFA.transitionSymbols();
        int n8 = stringArray != null && stringArray.length > 0 ? stringArray.length / 2 : 0;
        this.transitionSymbols = n8 > 0 ? new QName[n8] : null;
        for (n6 = 0; n6 < n8; ++n6) {
            String string3 = stringArray[n6 * 2];
            String string4 = stringArray[n6 * 2 + 1];
            n5 = string3 != null ? symbolTable.addStringSymbol(string3) : -1;
            n4 = string4 != null ? symbolTable.addStringSymbol(string4) : -1;
            this.transitionSymbols[n6] = new QName(n5, n4);
        }
        XPathAttributeInfo[][] xPathAttributeInfoArray = xPathDFA.finalAttrDecls();
        int n9 = xPathAttributeInfoArray == null ? 0 : xPathAttributeInfoArray.length;
        this.finalAttrDecls = n9 > 0 ? new QName[n9][] : (QName[][])null;
        for (int i = 0; i < n9; ++i) {
            int n10 = n5 = xPathAttributeInfoArray[i] == null ? 0 : xPathAttributeInfoArray[i].length;
            if (n5 > 0) {
                this.finalAttrDecls[i] = new QName[n5];
            }
            for (n4 = 0; n4 < n5; ++n4) {
                String string5 = xPathAttributeInfoArray[i][n4].namespace();
                String string6 = xPathAttributeInfoArray[i][n4].name();
                int n11 = string5 != null ? symbolTable.addStringSymbol(string5) : -1;
                int n12 = string6 != null ? symbolTable.addStringSymbol(string6) : -1;
                this.finalAttrDecls[i][n4] = new QName(n11, n12);
            }
        }
        this.allowMoreInput = xPathDFA.allowMoreInput();
        this.predicates = xPathDFA.getPredicates();
        Boolean[] booleanArray = xPathDFA.getTextSymbols();
        this.textSymbols = new boolean[booleanArray.length];
        for (n5 = 0; n5 < this.textSymbols.length; ++n5) {
            Boolean bl = booleanArray[n5];
            this.textSymbols[n5] = bl != null ? bl : false;
        }
        xPathDFA.getFunction();
    }

    public int transition(int n2, int n3, int n4, boolean[] blArray, PredicateContext predicateContext) {
        int[] nArray = this.transitionTable[this.abs(n2)];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < nArray.length; i += 2) {
            n5 = nArray[i];
            if (!this.matchesNameTest(n3, n4, this.transitionSymbols[n5])) continue;
            n6 = nArray[i + 1];
            break;
        }
        if (n6 != 0) {
            ArrayList<Predicate> arrayList = this.predicates[n5];
            if (arrayList != null) {
                int n7 = arrayList.size();
                for (int i = 0; i < n7; ++i) {
                    if (arrayList.get(i).evaluate(predicateContext)) continue;
                    return 0;
                }
            }
            if (n6 < 0) {
                blArray[0] = this.textSymbols[n5];
            }
            return n6;
        }
        return 0;
    }

    public boolean allowMoreInput(int n2) {
        return this.allowMoreInput[this.abs(n2)];
    }

    public QName[] getFinalAttrDecls(int n2) {
        return this.finalAttrDecls[this.abs(n2)];
    }

    public String toString() {
        return this.expression;
    }

    private boolean matchesNameTest(int n2, int n3, QName qName) {
        if (qName.localHandle >= 0) {
            return qName.localHandle == n3 && qName.nsHandle == n2;
        }
        if (qName.nsHandle >= 0) {
            return qName.nsHandle == n2;
        }
        return true;
    }

    private int abs(int n2) {
        return n2 >= 0 ? n2 : -n2;
    }

    private int getFunctionID(XPathDFA.FunctionName functionName) {
        if (functionName == null) {
            return 0;
        }
        switch (functionName) {
            case count: {
                return 1;
            }
            case avg: {
                return 2;
            }
            case max: {
                return 3;
            }
            case min: {
                return 4;
            }
            case sum: {
                return 5;
            }
        }
        throw new RuntimeException("Unknown function: " + functionName.toString());
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class QName {
        final int nsHandle;
        final int localHandle;

        QName(int n2, int n3) {
            this.nsHandle = n2;
            this.localHandle = n3;
        }
    }
}

