/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath;

import com.ibm.xml.xlxp.api.wbm.xpath.XPath;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathEvaluator;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathException;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathScannerHelper;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XPathCollection {
    private final XPath[] fPaths;
    private final int fDFACount;
    private final byte[] fSymbolTable;

    XPathCollection(XPath[] xPathArray, int n2, byte[] byArray) {
        this.fPaths = xPathArray;
        this.fDFACount = n2;
        this.fSymbolTable = byArray;
    }

    public XPathEvaluator newXPathEvaluator() throws XPathException {
        return new XPathScannerHelper(this);
    }

    public String getXPathAt(int n2) {
        XPath xPath = this.fPaths[n2];
        return xPath != null ? xPath.toString() : null;
    }

    public int size() {
        return this.fPaths.length;
    }

    XPath[] toArray() {
        return this.fPaths;
    }

    int getDFACount() {
        return this.fDFACount;
    }

    byte[] getSymbolTable() {
        return this.fSymbolTable;
    }
}

