/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath;

import com.ibm.xml.xlxp.api.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp.api.wbm.xpath.DefaultXPathErrorHandler;
import com.ibm.xml.xlxp.api.wbm.xpath.NamespaceContextResolver;
import com.ibm.xml.xlxp.api.wbm.xpath.XPath;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathCollection;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathErrorHandler;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathException;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathDFA;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathDFABuilder;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XPathFactory {
    private static final String XPATH_20_FN_PREFIX = "fn";
    private static final String XPATH_20_FN_NS_URI = "http://www.w3.org/2005/xpath-functions";
    private static final String XML_SCHEMA_PREFIX = "xs";
    private static final String XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String XQT_ERROR_PREFIX = "err";
    private static final String XQT_ERROR_NS_URI = "http://www.w3.org/2005/xqt-errors";
    private final NamespaceContextWrapper fDefaultNSContext = new NamespaceContextWrapper();
    private final NamespaceContextWrapper fResolvedNSContext = new NamespaceContextWrapper();
    private NamespaceContextResolver fNSContextResolver = null;
    private XPathErrorHandler fXPathErrorHandler = DefaultXPathErrorHandler.getInstance();

    public static XPathFactory newInstance() {
        return new XPathFactory();
    }

    XPathFactory() {
    }

    public XPathCollection compile(String string2) throws XPathException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        return this.compile(arrayList);
    }

    public XPathCollection compile(List<String> list) throws XPathException {
        XPath[] xPathArray = new XPath[list.size()];
        SimpleDataBufferFactory simpleDataBufferFactory = new SimpleDataBufferFactory();
        SymbolTable symbolTable = new SymbolTable((DataBufferFactory)simpleDataBufferFactory);
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer((DataBufferFactory)simpleDataBufferFactory);
        HashMap<String, XMLString> hashMap = new HashMap<String, XMLString>();
        int[] nArray = new int[1];
        for (int i = 0; i < xPathArray.length; ++i) {
            xPathArray[i] = this.compile2(list.get(i), i, symbolTable, hashMap, xMLStringBuffer, nArray);
        }
        return new XPathCollection(xPathArray, nArray[0], this.serialize(symbolTable));
    }

    public void setDefaultNamespaceContext(NamespaceContext namespaceContext) {
        this.fDefaultNSContext.setNamespaceContext(namespaceContext);
    }

    public void setNamespaceContextResolver(NamespaceContextResolver namespaceContextResolver) {
        this.fNSContextResolver = namespaceContextResolver;
    }

    public void setXPathErrorHandler(XPathErrorHandler xPathErrorHandler) {
        this.fXPathErrorHandler = xPathErrorHandler != null ? xPathErrorHandler : DefaultXPathErrorHandler.getInstance();
    }

    private XPath compile2(String string2, int n2, SymbolTable symbolTable, Map<String, XMLString> map2, XMLStringBuffer xMLStringBuffer, int[] nArray) throws XPathException {
        try {
            Object object2;
            XPathDFABuilder xPathDFABuilder = new XPathDFABuilder();
            NamespaceContextWrapper namespaceContextWrapper = this.fDefaultNSContext;
            if (this.fNSContextResolver != null && (object2 = this.fNSContextResolver.resolve(n2)) != null) {
                this.fResolvedNSContext.setNamespaceContext((NamespaceContext)object2);
                namespaceContextWrapper = this.fResolvedNSContext;
            }
            object2 = xPathDFABuilder.computeDFA(string2, n2, namespaceContextWrapper, symbolTable, map2, xMLStringBuffer);
            this.fResolvedNSContext.setNamespaceContext(null);
            int n3 = nArray[0];
            nArray[0] = n3 + 1;
            XPath xPath = new XPath(string2, n2, n3, (XPathDFA)object2, symbolTable);
            for (object2 = object2.getNextDFA(); object2 != null; object2 = object2.getNextDFA()) {
                int n4 = nArray[0];
                nArray[0] = n4 + 1;
                xPath = new XPath(string2, n2, n4, (XPathDFA)object2, symbolTable, xPath);
            }
            return xPath;
        }
        catch (XPathException xPathException) {
            xPathException.setXPathIndex(n2);
            this.fXPathErrorHandler.error(xPathException);
        }
        catch (Exception exception) {
            this.fXPathErrorHandler.error(new XPathException(exception, n2));
        }
        int n5 = nArray[0];
        nArray[0] = n5 + 1;
        return new XPath(string2, n2, n5);
    }

    private byte[] serialize(SymbolTable symbolTable) throws XPathException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            symbolTable.save((OutputStream)byteArrayOutputStream, true);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(exception);
            this.fXPathErrorHandler.fatalError(xPathException);
            throw xPathException;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class NamespaceContextWrapper
    implements NamespaceContext {
        private NamespaceContext fNSContext;

        NamespaceContextWrapper() {
        }

        public void setNamespaceContext(NamespaceContext namespaceContext) {
            this.fNSContext = namespaceContext;
        }

        @Override
        public String getNamespaceURI(String string2) {
            String string3;
            if (string2 == null) {
                throw new IllegalArgumentException();
            }
            if ("xml".equals(string2)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if ("xmlns".equals(string2)) {
                return "http://www.w3.org/2000/xmlns/";
            }
            if (this.fNSContext != null && (string3 = this.fNSContext.getNamespaceURI(string2)) != null && !"".equals(string3)) {
                return string3;
            }
            if (XPathFactory.XPATH_20_FN_PREFIX.equals(string2)) {
                return XPathFactory.XPATH_20_FN_NS_URI;
            }
            if (XPathFactory.XML_SCHEMA_PREFIX.equals(string2)) {
                return XPathFactory.XML_SCHEMA_NS_URI;
            }
            if (XPathFactory.XQT_ERROR_PREFIX.equals(string2)) {
                return XPathFactory.XQT_ERROR_NS_URI;
            }
            return "";
        }

        @Override
        public String getPrefix(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException();
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(string2)) {
                return "xml";
            }
            if ("http://www.w3.org/2000/xmlns/".equals(string2)) {
                return "xmlns";
            }
            if (this.fNSContext != null) {
                return this.fNSContext.getPrefix(string2);
            }
            return null;
        }

        public Iterator getPrefixes(String string2) {
            Iterator<String> iterator;
            if (string2 == null) {
                throw new IllegalArgumentException();
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(string2)) {
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add("xml");
                return arrayList.iterator();
            }
            if ("http://www.w3.org/2000/xmlns/".equals(string2)) {
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add("xmlns");
                return arrayList.iterator();
            }
            if (this.fNSContext != null && (iterator = this.fNSContext.getPrefixes(string2)) != null) {
                return iterator;
            }
            return Collections.EMPTY_LIST.iterator();
        }
    }
}

