/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath;

import com.ibm.xml.xlxp.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp.api.util.ImmutableArrayList;
import com.ibm.xml.xlxp.api.util.SimpleDTDScannerHelper;
import com.ibm.xml.xlxp.api.wbm.xpath.AggregateFunction;
import com.ibm.xml.xlxp.api.wbm.xpath.AvgFunction;
import com.ibm.xml.xlxp.api.wbm.xpath.CountFunction;
import com.ibm.xml.xlxp.api.wbm.xpath.DefaultXPathErrorHandler;
import com.ibm.xml.xlxp.api.wbm.xpath.MaxFunction;
import com.ibm.xml.xlxp.api.wbm.xpath.MinFunction;
import com.ibm.xml.xlxp.api.wbm.xpath.SumFunction;
import com.ibm.xml.xlxp.api.wbm.xpath.Value;
import com.ibm.xml.xlxp.api.wbm.xpath.XMLStringStream;
import com.ibm.xml.xlxp.api.wbm.xpath.XPath;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathCollection;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathErrorHandler;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathEvaluator;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathException;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathResultHandler;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates.PredicateContext;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.XMLStringHelper;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.XPathExceptionWrapper;
import com.ibm.xml.xlxp.scan.DTDScanner;
import com.ibm.xml.xlxp.scan.DTDScannerHelper;
import com.ibm.xml.xlxp.scan.msg.MessageProvider;
import com.ibm.xml.xlxp.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp.scan.util.DTDParsedEntityFactory;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class XPathScannerHelper
extends SimpleDTDScannerHelper
implements PredicateContext,
XPathEvaluator {
    private static final byte[] XMLNS = new byte[]{32, 120, 109, 108, 110, 115, 61, 34};
    private static final byte[] XMLNS_PREFIX = new byte[]{32, 120, 109, 108, 110, 115, 58};
    private static final byte[] EQUALS_QUOTE = new byte[]{61, 34};
    private static final byte[] END_OF_EMPTY_TAG = new byte[]{47, 62};
    private static final int TEXT_CONTENT = 0;
    private static final int ELEMENT_CONTENT_FOR_FUNCTION = 1;
    private static final int TEXT_CONTENT_FOR_FUNCTION = 2;
    private static final int TEXT_BEFORE_END_TAG = 0;
    private static final int TEXT_BEFORE_COMMENT = 1;
    private static final int TEXT_BEFORE_PROCESSING_INSTRUCTION = 2;
    private static final int TEXT_BEFORE_START_TAG = 3;
    private static final int TEXT_BEFORE_EMPTY_TAG = 4;
    private final DTDScanner fDTDScanner;
    private final SAX2ParsedEntityFactory fEntityFactory;
    private final XPath[] fPaths;
    private final AggregateFunction[] fFunctionsByIndex;
    private final AggregateFunction[] fFunctionsList;
    private final int[] fPathStates;
    private final int[] fPathNextDepth;
    private final int[] fInitialValues;
    private final boolean[] fIsTextContent = new boolean[1];
    private final int[] fReturnedErrorCode = new int[1];
    private int[] fPathChangeHistory = new int[16];
    private int fPathChangeHistorySize;
    private int[] fPathChangeHistoryContext = new int[8];
    private int fPathChangeHistoryCurrentContext = -1;
    private int[] fXPathsMatchingTextContent = new int[16];
    private int fXPathsMatchingTextContentSize;
    private int[] fXPathsMatchingTextContentContext = new int[8];
    private int fXPathsMatchingTextContentCurrentContext = 0;
    private int[] fPositionalPredicateCounters = new int[24];
    private int fPositionalPredicateCountersSize;
    private int[] fPositionalPredicateCountersContext = new int[8];
    private int fPositionalPredicateCountersCurrentContext = 0;
    private int fElementDepth = 0;
    private boolean fCollectElemValue = false;
    private final XMLStringBuffer fContentBuffer;
    private int fContentBufferOffset;
    private XMLString fElementString;
    private XMLString fElementStringFirst;
    private final XMLString fElementStringFirstChunk = new XMLString();
    private final XMLString fElementStringCopy = new XMLString();
    private final SimpleResultBuilder fResultHandler;
    final ValueFactory fValueFactory = new ValueFactory();
    private XPathErrorHandler fXPathErrorHandler = DefaultXPathErrorHandler.getInstance();
    private DataBufferReferrer fCurrentStartElementBufferReferrer;
    private DataBuffer fCurrentStartElementBuffer;
    private int fCurrentStartElementOffset;
    private Stack<XMLString> fElementValueStack = new Stack();
    private boolean fNeedReset;
    protected char[][] fCharBuffer;
    protected int[] fCharBufferOffset;

    XPathScannerHelper(XPathCollection xPathCollection) throws XPathException {
        this.restore(xPathCollection.getSymbolTable());
        this.fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory);
        this.fDTDScanner = new DTDScanner((DTDScannerHelper)this, this.fDocumentEntityScanner, this.fBufferFactory, this.fSymbolTable, (DTDParsedEntityFactory)this.fEntityFactory);
        this.fPaths = xPathCollection.toArray();
        AggregateFunction[][] aggregateFunctionArray = XPathScannerHelper.createAggregateFunctions(this.fPaths);
        this.fFunctionsByIndex = aggregateFunctionArray[0];
        this.fFunctionsList = aggregateFunctionArray[1];
        int n2 = xPathCollection.getDFACount();
        this.fInitialValues = new int[n2];
        Arrays.fill(this.fInitialValues, 1);
        this.fPathStates = new int[n2];
        System.arraycopy(this.fInitialValues, 0, this.fPathStates, 0, this.fPathStates.length);
        this.fPathNextDepth = new int[n2];
        System.arraycopy(this.fInitialValues, 0, this.fPathNextDepth, 0, this.fPathStates.length);
        this.fContentBuffer = new XMLStringBuffer(this.fBufferFactory);
        this.fResultHandler = new SimpleResultBuilder(this.fPaths.length);
        this.fCharBuffer = new char[1][256];
        this.fCharBufferOffset = new int[1];
        this.fCurrentStartElementBufferReferrer = new DataBufferReferrer(){

            public boolean hasReferenceTo(DataBuffer dataBuffer) {
                DataBuffer dataBuffer2 = XPathScannerHelper.this.fCurrentStartElementBuffer;
                while (dataBuffer2 != null) {
                    if (dataBuffer2 == dataBuffer) {
                        return true;
                    }
                    dataBuffer2 = dataBuffer2.next;
                }
                return false;
            }
        };
        this.fBufferFactory.addReferrer(this.fCurrentStartElementBufferReferrer);
    }

    private static AggregateFunction[][] createAggregateFunctions(XPath[] xPathArray) {
        AggregateFunction[][] aggregateFunctionArray = new AggregateFunction[2][];
        AggregateFunction[] aggregateFunctionArray2 = new AggregateFunction[xPathArray.length];
        int n2 = 0;
        for (int i = 0; i < xPathArray.length; ++i) {
            AggregateFunction aggregateFunction = null;
            switch (xPathArray[i].functionID) {
                case 1: {
                    aggregateFunction = new CountFunction(i);
                    break;
                }
                case 2: {
                    aggregateFunction = new AvgFunction(i);
                    break;
                }
                case 3: {
                    aggregateFunction = new MaxFunction(i);
                    break;
                }
                case 4: {
                    aggregateFunction = new MinFunction(i);
                    break;
                }
                case 5: {
                    aggregateFunction = new SumFunction(i);
                }
            }
            if (aggregateFunction == null) continue;
            aggregateFunctionArray2[i] = aggregateFunction;
            ++n2;
        }
        if (n2 > 0) {
            aggregateFunctionArray[0] = aggregateFunctionArray2;
            if (n2 == aggregateFunctionArray2.length) {
                aggregateFunctionArray[1] = aggregateFunctionArray2;
            } else {
                AggregateFunction[] aggregateFunctionArray3 = new AggregateFunction[n2];
                n2 = 0;
                for (int i = 0; i < aggregateFunctionArray2.length; ++i) {
                    AggregateFunction aggregateFunction = aggregateFunctionArray2[i];
                    if (aggregateFunction == null) continue;
                    aggregateFunctionArray3[n2++] = aggregateFunction;
                }
                aggregateFunctionArray[1] = aggregateFunctionArray3;
            }
        }
        return aggregateFunctionArray;
    }

    @Override
    public final List<List<Value>> evaluate(String string2) throws XPathException {
        return this.evaluate(new InputSource(string2));
    }

    @Override
    public final List<List<Value>> evaluate(InputStream inputStream) throws XPathException {
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        this.fResultHandler.reset();
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputStream, null);
        try {
            this.parseDocumentEntity(parsedEntity);
        }
        catch (XPathExceptionWrapper xPathExceptionWrapper) {
            throw xPathExceptionWrapper.getXPathException();
        }
        return this.fResultHandler.getResult();
    }

    @Override
    public final List<List<Value>> evaluate(Reader reader) throws XPathException {
        return this.evaluate(new InputSource(reader));
    }

    @Override
    public final List<List<Value>> evaluate(InputSource inputSource) throws XPathException {
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        this.fResultHandler.reset();
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputSource);
        try {
            this.parseDocumentEntity(parsedEntity);
        }
        catch (XPathExceptionWrapper xPathExceptionWrapper) {
            throw xPathExceptionWrapper.getXPathException();
        }
        return this.fResultHandler.getResult();
    }

    @Override
    public final void setXPathErrorHandler(XPathErrorHandler xPathErrorHandler) {
        this.fXPathErrorHandler = xPathErrorHandler != null ? xPathErrorHandler : DefaultXPathErrorHandler.getInstance();
    }

    public final boolean scanStartElementBuffered(ParsedEntity parsedEntity) {
        this.saveStartPosition(parsedEntity);
        return super.scanStartElementBuffered(parsedEntity);
    }

    public final boolean scanStartElementUnbuffered(ParsedEntity parsedEntity) {
        this.saveStartPosition(parsedEntity);
        return super.scanStartElementUnbuffered(parsedEntity);
    }

    private void saveStartPosition(ParsedEntity parsedEntity) {
        this.fCurrentStartElementOffset = parsedEntity.offset;
        this.fCurrentStartElementBuffer = parsedEntity.buffer;
        this.fCurrentStartElementBufferReferrer.active = true;
    }

    private void clearStartPosition() {
        this.fCurrentStartElementBuffer = null;
        this.fCurrentStartElementBufferReferrer.active = false;
    }

    public final boolean produceStartElementEvent() {
        boolean bl = super.produceStartElementEvent();
        ++this.fElementDepth;
        if (this.fCollectElemValue) {
            this.matchedTextContent(3);
            this.fCollectElemValue = false;
            this.fElementString = null;
            this.fElementStringFirst = null;
            this.fElementStringFirstChunk.clear();
        }
        this.pushXPathsMatchingTextContentContext();
        if (!this.startXPaths(true)) {
            this.skipSubtree(this.fElementStringCopy);
            this.fElementStringCopy.clear();
        }
        this.clearStartPosition();
        this.pushPredicateCounterContext();
        return bl;
    }

    public final boolean produceEmptyElementEvent() {
        boolean bl = super.produceEmptyElementEvent();
        ++this.fElementDepth;
        if (this.fCollectElemValue) {
            this.matchedTextContent(4);
            this.fElementString = null;
            this.fElementStringFirst = null;
            this.fElementStringFirstChunk.clear();
        }
        this.pushXPathsMatchingTextContentContext();
        this.startXPaths(false);
        this.clearStartPosition();
        this.endXPaths();
        this.popXPathsMatchingTextContentContext();
        --this.fElementDepth;
        return bl;
    }

    public final boolean produceEndElementEvent(QName qName) {
        boolean bl = super.produceEndElementEvent(qName);
        this.endXPaths();
        if (this.fCollectElemValue) {
            this.matchedTextContent(0);
            this.fCollectElemValue = false;
            this.fElementString = null;
            this.fElementStringFirst = null;
            this.fElementStringFirstChunk.clear();
        }
        this.popXPathsMatchingTextContentContext();
        this.popPredicateCounterContext();
        --this.fElementDepth;
        return bl;
    }

    public final boolean produceCharactersEvent() {
        boolean bl = super.produceCharactersEvent();
        if (this.fCollectElemValue) {
            this.handleCharactersEvent();
        }
        return bl;
    }

    public final boolean produceWhitespaceEvent() {
        boolean bl = super.produceWhitespaceEvent();
        if (this.fCollectElemValue) {
            this.handleCharactersEvent();
        }
        return bl;
    }

    private final void handleCharactersEvent() {
        if (this.fContent.length == 0) {
            return;
        }
        if (this.fElementStringFirst == null) {
            this.fElementStringFirstChunk.setValues(this.fContent);
            this.fElementStringFirst = this.fElementStringFirstChunk;
            return;
        }
        if (this.fElementStringFirst != this.fElementStringCopy) {
            this.fContentBufferOffset = this.fContentBuffer.getOffset();
            this.fContentBuffer.appendXMLString(this.fElementStringFirst);
            this.fElementStringFirst.clear();
            this.fElementStringFirst = this.fElementStringCopy;
        }
        this.fContentBuffer.appendXMLString(this.fContent);
    }

    public final boolean produceCharacterEvent(int n2) {
        boolean bl = super.produceCharacterEvent(n2);
        if (this.fCollectElemValue) {
            this.handleCharacterEvent(n2);
        }
        return bl;
    }

    public final boolean producePredefinedEntityEvent(int n2) {
        boolean bl = super.producePredefinedEntityEvent(n2);
        if (this.fCollectElemValue) {
            this.handleCharacterEvent(n2);
        }
        return bl;
    }

    private final void handleCharacterEvent(int n2) {
        if (this.fElementStringFirst != this.fElementStringCopy) {
            this.fContentBufferOffset = this.fContentBuffer.getOffset();
            if (this.fElementStringFirst != null) {
                this.fContentBuffer.appendXMLString(this.fElementStringFirst);
                this.fElementStringFirst.clear();
            }
            this.fElementStringFirst = this.fElementStringCopy;
        }
        this.fContentBuffer.appendChar(n2);
    }

    public final boolean produceCommentEvent() {
        boolean bl = super.produceCommentEvent();
        if (this.fCollectElemValue) {
            this.matchedTextContent(1);
            this.fElementString = null;
            this.fElementStringFirst = null;
            this.fElementStringFirstChunk.clear();
        }
        return bl;
    }

    public final boolean produceProcessingInstructionEvent() {
        boolean bl = super.produceProcessingInstructionEvent();
        if (this.fCollectElemValue) {
            this.matchedTextContent(2);
            this.fElementString = null;
            this.fElementStringFirst = null;
            this.fElementStringFirstChunk.clear();
        }
        return bl;
    }

    public final boolean produceEndDocumentEvent() {
        boolean bl = super.produceEndDocumentEvent();
        if (this.fFunctionsList != null) {
            for (int i = 0; i < this.fFunctionsList.length; ++i) {
                this.fFunctionsList[i].writeResult(this.fResultHandler);
            }
        }
        return bl;
    }

    public final boolean produceWarningEvent(String string2, int n2) {
        boolean bl = super.produceWarningEvent(string2, n2);
        try {
            XPathException xPathException = new XPathException(this.getErrorMessage());
            this.fXPathErrorHandler.warning(xPathException);
        }
        catch (XPathException xPathException) {
            throw new XPathExceptionWrapper(xPathException);
        }
        return bl;
    }

    public final boolean produceRecoverableErrorEvent(String string2, int n2) {
        boolean bl = super.produceRecoverableErrorEvent(string2, n2);
        try {
            XPathException xPathException = new XPathException(this.getErrorMessage());
            this.fXPathErrorHandler.error(xPathException);
        }
        catch (XPathException xPathException) {
            throw new XPathExceptionWrapper(xPathException);
        }
        return bl;
    }

    public final boolean produceFatalErrorEvent(String string2, int n2) {
        super.produceFatalErrorEvent(string2, n2);
        try {
            XPathException xPathException = new XPathException(this.getErrorMessage());
            this.fXPathErrorHandler.fatalError(xPathException);
            throw new XPathExceptionWrapper(xPathException);
        }
        catch (XPathException xPathException) {
            throw new XPathExceptionWrapper(xPathException);
        }
    }

    public final boolean reportFatalError(String string2, int n2) {
        return this.produceFatalErrorEvent(string2, n2);
    }

    private String getErrorMessage() {
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider((String)this.fErrorURI);
        int n2 = this.fErrorParamsCount;
        Object[] objectArray = new XMLString[n2];
        while (n2-- > 0) {
            objectArray[n2] = this.fErrorParams[n2];
        }
        String string2 = messageProvider.createMessage(null, this.fErrorCode, objectArray);
        return string2;
    }

    private void matchingTextContent(int n2, int n3) {
        if (this.fXPathsMatchingTextContentSize + 1 >= this.fXPathsMatchingTextContent.length) {
            int[] nArray = new int[this.fXPathsMatchingTextContent.length << 1];
            System.arraycopy(this.fXPathsMatchingTextContent, 0, nArray, 0, this.fXPathsMatchingTextContent.length);
            this.fXPathsMatchingTextContent = nArray;
        }
        this.fXPathsMatchingTextContent[this.fXPathsMatchingTextContentSize++] = n2;
        this.fXPathsMatchingTextContent[this.fXPathsMatchingTextContentSize++] = n3;
    }

    private void matchedTextContent(int n2) {
        int n3;
        XMLString xMLString = this.getElementString();
        for (int i = n3 = this.fXPathsMatchingTextContentContext[this.fXPathsMatchingTextContentCurrentContext]; i < this.fXPathsMatchingTextContentSize; i += 2) {
            int n4 = this.fXPathsMatchingTextContent[i];
            int n5 = this.fXPathsMatchingTextContent[i + 1];
            if (n5 == 0) {
                if (xMLString.length <= 0) continue;
                this.fResultHandler.textValue(n4, xMLString);
                continue;
            }
            this.matchedTextContentForFunction(n2, n4, xMLString, n5 == 1);
        }
    }

    private void matchedTextContentForFunction(int n2, int n3, XMLString xMLString, boolean bl) {
        AggregateFunction aggregateFunction = this.fFunctionsByIndex[n3];
        switch (n2) {
            case 0: {
                aggregateFunction.textBeforeEndTag(xMLString, bl);
                break;
            }
            case 1: {
                aggregateFunction.textBeforeComment(xMLString, bl);
                break;
            }
            case 2: {
                aggregateFunction.textBeforeProcessingInstruction(xMLString, bl);
                break;
            }
            case 3: {
                aggregateFunction.textBeforeStartTag(xMLString, bl);
                break;
            }
            case 4: {
                aggregateFunction.textBeforeEmptyTag(xMLString, bl);
            }
        }
    }

    private void pushXPathsMatchingTextContentContext() {
        if (this.fXPathsMatchingTextContentContext.length == ++this.fXPathsMatchingTextContentCurrentContext) {
            int[] nArray = new int[this.fXPathsMatchingTextContentContext.length << 1];
            System.arraycopy(this.fXPathsMatchingTextContentContext, 0, nArray, 0, this.fXPathsMatchingTextContentContext.length);
            this.fXPathsMatchingTextContentContext = nArray;
        }
        this.fXPathsMatchingTextContentContext[this.fXPathsMatchingTextContentCurrentContext] = this.fXPathsMatchingTextContentSize;
    }

    private void popXPathsMatchingTextContentContext() {
        this.fXPathsMatchingTextContentSize = this.fXPathsMatchingTextContentContext[this.fXPathsMatchingTextContentCurrentContext--];
        if (this.fXPathsMatchingTextContentSize > this.fXPathsMatchingTextContentContext[this.fXPathsMatchingTextContentCurrentContext]) {
            this.fCollectElemValue = true;
            this.fElementString = null;
            this.fElementStringFirst = null;
        }
    }

    private boolean skipSubtree(XMLString xMLString) {
        if (this.fCurrentEntity.unbuffered) {
            return this.fDocumentEntityScanner.skipContentUnbuffered(xMLString);
        }
        return this.fDocumentEntityScanner.skipContentBuffered(xMLString);
    }

    private boolean startXPaths(boolean bl) {
        this.startXPathStateHistoryContext();
        boolean bl2 = false;
        for (int i = 0; i < this.fPaths.length; ++i) {
            XPath xPath = this.fPaths[i];
            if (xPath.next != null) {
                bl2 |= this.matchMultiXPath(xPath, bl);
                continue;
            }
            if (this.fPathNextDepth[xPath.subXPathID] != this.fElementDepth) continue;
            bl2 |= this.matchXPath(xPath, bl);
        }
        return bl2;
    }

    private void startXPathStateHistoryContext() {
        if (this.fPathChangeHistoryContext.length == ++this.fPathChangeHistoryCurrentContext) {
            int[] nArray = new int[this.fPathChangeHistoryContext.length << 1];
            System.arraycopy(this.fPathChangeHistoryContext, 0, nArray, 0, this.fPathChangeHistoryContext.length);
            this.fPathChangeHistoryContext = nArray;
        }
        this.fPathChangeHistoryContext[this.fPathChangeHistoryCurrentContext] = this.fPathChangeHistorySize;
    }

    private void endXPaths() {
        int n2 = this.fPathChangeHistorySize;
        this.fPathChangeHistorySize = this.fPathChangeHistoryContext[this.fPathChangeHistoryCurrentContext--];
        while (n2 > this.fPathChangeHistorySize) {
            XMLString xMLString;
            int n3;
            int n4 = this.fPathChangeHistory[--n2];
            if (this.fPathStates[n3 = this.fPathChangeHistory[--n2]] < 0 && (xMLString = this.fElementValueStack.pop()) != null) {
                xMLString.setEndPos(this.fCurrentEntity.buffer, this.fCurrentEntity.offset, 0);
            }
            this.fPathStates[n3] = n4;
            this.fPathNextDepth[n3] = this.fElementDepth;
        }
    }

    private boolean matchMultiXPath(XPath xPath, boolean bl) {
        boolean bl2 = false;
        do {
            if (this.fPathNextDepth[xPath.subXPathID] != this.fElementDepth) continue;
            bl2 |= this.matchXPath(xPath, bl);
        } while ((xPath = xPath.next) != null);
        return bl2;
    }

    private boolean matchXPath(XPath xPath, boolean bl) {
        int n2 = xPath.transition(this.fPathStates[xPath.subXPathID], this.fElementType.nsHandle, this.fElementType.localHandle, this.fIsTextContent, this);
        if (n2 != 0) {
            XPath.QName[] qNameArray = xPath.getFinalAttrDecls(n2);
            boolean bl2 = false;
            boolean bl3 = false;
            if (qNameArray != null) {
                bl2 = true;
                int n3 = this.fAttributes.attributeCount();
                block0: for (int i = 0; i < n3; ++i) {
                    QName qName = this.fAttributes.attributeName(i);
                    for (int j = 0; j < qNameArray.length; ++j) {
                        XPath.QName qName2 = qNameArray[j];
                        if (qName2.localHandle >= 0) {
                            if (qName2.nsHandle >= 0) {
                                if (qName.localHandle != qName2.localHandle || qName.nsHandle != qName2.nsHandle) continue;
                                this.matchedAttribute(xPath.xpathID, xPath.functionID, this.fAttributes.attributeValue(i));
                                continue block0;
                            }
                            if (qName.localHandle != qName2.localHandle) continue;
                            this.matchedAttribute(xPath.xpathID, xPath.functionID, this.fAttributes.attributeValue(i));
                            continue block0;
                        }
                        if (qName2.nsHandle >= 0) {
                            if (qName.nsHandle != qName2.nsHandle) continue;
                            this.matchedAttribute(xPath.xpathID, xPath.functionID, this.fAttributes.attributeValue(i));
                            continue block0;
                        }
                        this.matchedAttribute(xPath.xpathID, xPath.functionID, this.fAttributes.attributeValue(i));
                        continue block0;
                    }
                }
            }
            if (n2 < 0) {
                bl2 = true;
                bl3 = this.fIsTextContent[0];
                if (bl3) {
                    this.matchingTextContent(xPath.xpathID, xPath.functionID == 0 ? 0 : 2);
                    if (!this.fCollectElemValue) {
                        this.fCollectElemValue = true;
                        this.fElementString = null;
                        this.fElementStringFirst = null;
                    }
                    this.fElementValueStack.push(null);
                } else if (xPath.functionID == 0) {
                    XMLString xMLString = this.fResultHandler.elementValue(xPath.xpathID, this.fCurrentStartElementBuffer, this.fCurrentStartElementOffset, this.fCurrentEntity.buffer, this.fCurrentEntity.offset, bl);
                    this.fElementValueStack.push(xMLString);
                } else {
                    if (!bl || xPath.functionID == 1) {
                        this.fFunctionsByIndex[xPath.xpathID].element();
                    } else {
                        bl3 = true;
                        this.matchingTextContent(xPath.xpathID, 1);
                        if (!this.fCollectElemValue) {
                            this.fCollectElemValue = true;
                            this.fElementString = null;
                            this.fElementStringFirst = null;
                        }
                    }
                    this.fElementValueStack.push(null);
                }
            }
            this.saveXPathState(xPath.subXPathID, n2);
            if (!bl2 || xPath.allowMoreInput(n2)) {
                int n4 = xPath.subXPathID;
                this.fPathNextDepth[n4] = this.fPathNextDepth[n4] + 1;
                return true;
            }
            return bl3;
        }
        return false;
    }

    private void matchedAttribute(int n2, int n3, XMLString xMLString) {
        if (n3 == 0) {
            this.fResultHandler.attributeValue(n2, xMLString);
        } else {
            this.fFunctionsByIndex[n2].attribute(xMLString);
        }
    }

    private void saveXPathState(int n2, int n3) {
        if (this.fPathChangeHistorySize + 1 >= this.fPathChangeHistory.length) {
            int[] nArray = new int[this.fPathChangeHistory.length << 1];
            System.arraycopy(this.fPathChangeHistory, 0, nArray, 0, this.fPathChangeHistory.length);
            this.fPathChangeHistory = nArray;
        }
        this.fPathChangeHistory[this.fPathChangeHistorySize++] = n2;
        this.fPathChangeHistory[this.fPathChangeHistorySize++] = this.fPathStates[n2];
        this.fPathStates[n2] = n3;
    }

    public final void reset(boolean bl) {
        this.fDTDScanner.reset(bl);
        this.fEntityFactory.reset(bl);
        System.arraycopy(this.fInitialValues, 0, this.fPathStates, 0, this.fPathStates.length);
        System.arraycopy(this.fInitialValues, 0, this.fPathNextDepth, 0, this.fPathStates.length);
        this.fPathChangeHistoryCurrentContext = -1;
        this.fPathChangeHistorySize = 0;
        this.fXPathsMatchingTextContentCurrentContext = 0;
        this.fXPathsMatchingTextContentSize = 0;
        this.fPositionalPredicateCountersCurrentContext = 0;
        this.fPositionalPredicateCountersSize = 0;
        this.fElementDepth = 0;
        this.fCollectElemValue = false;
        this.fElementStringFirstChunk.clear();
        this.fElementValueStack.clear();
        this.fContentBuffer.reset(false);
        if (this.fFunctionsList != null) {
            for (int i = this.fFunctionsList.length - 1; i >= 0; --i) {
                this.fFunctionsList[i].reset();
            }
        }
        super.reset(bl);
    }

    private XMLString getElementString() {
        if (this.fElementString == null) {
            if (this.fElementStringFirst != null) {
                if (this.fElementStringFirst != this.fElementStringCopy) {
                    this.fElementString = this.fElementStringFirst;
                    return this.fElementString;
                }
                int n2 = this.fContentBuffer.getOffset();
                this.fContentBuffer.setStringValues(this.fContentBufferOffset, n2, this.fElementStringFirst);
                this.fElementString = this.fElementStringFirst;
                return this.fElementString;
            }
            this.fContentBuffer.setStringValues(0, 0, this.fElementStringCopy);
            this.fElementString = this.fElementStringCopy;
            return this.fElementString;
        }
        return this.fElementString;
    }

    private void restore(byte[] byArray) throws XPathException {
        try {
            this.fSymbolTable.restore((InputStream)new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            throw new XPathException(exception);
        }
    }

    @Override
    public final XMLString getAttributeValue(int n2, int n3) {
        for (int i = 0; i < this.fAttributeCount; ++i) {
            QName qName = this.fAttributes.attributeName(i);
            if (n3 != qName.localHandle || n2 != qName.nsHandle) continue;
            return this.fAttributes.attributeValue(i);
        }
        return null;
    }

    @Override
    public final List<XMLString> getAttributeValues(int n2, int n3) {
        ArrayList<XMLString> arrayList = new ArrayList<XMLString>();
        for (int i = 0; i < this.fAttributeCount; ++i) {
            QName qName = this.fAttributes.attributeName(i);
            if (n3 < 0 && n2 < 0) {
                arrayList.add(this.fAttributes.attributeValue(i));
                continue;
            }
            if (n3 < 0 && n2 == qName.nsHandle) {
                arrayList.add(this.fAttributes.attributeValue(i));
                continue;
            }
            if (n3 != qName.localHandle || n2 >= 0) continue;
            arrayList.add(this.fAttributes.attributeValue(i));
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    @Override
    public final int incrementCounter(int n2, int n3) {
        int n4;
        for (int i = n4 = this.fPositionalPredicateCountersContext[this.fPositionalPredicateCountersCurrentContext]; i < this.fPositionalPredicateCountersSize; i += 3) {
            if (this.fPositionalPredicateCounters[i] != n2 || this.fPositionalPredicateCounters[i + 1] != n3) continue;
            int n5 = i + 2;
            int n6 = this.fPositionalPredicateCounters[n5] + 1;
            this.fPositionalPredicateCounters[n5] = n6;
            return n6;
        }
        if (this.fPositionalPredicateCountersSize + 2 >= this.fPositionalPredicateCounters.length) {
            int[] nArray = new int[this.fPositionalPredicateCounters.length << 1];
            System.arraycopy(this.fPositionalPredicateCounters, 0, nArray, 0, this.fPositionalPredicateCounters.length);
            this.fPositionalPredicateCounters = nArray;
        }
        this.fPositionalPredicateCounters[this.fPositionalPredicateCountersSize++] = n2;
        this.fPositionalPredicateCounters[this.fPositionalPredicateCountersSize++] = n3;
        this.fPositionalPredicateCounters[this.fPositionalPredicateCountersSize++] = 1;
        return 1;
    }

    private void pushPredicateCounterContext() {
        if (this.fPositionalPredicateCountersContext.length == ++this.fPositionalPredicateCountersCurrentContext) {
            int[] nArray = new int[this.fPositionalPredicateCountersContext.length << 1];
            System.arraycopy(this.fPositionalPredicateCountersContext, 0, nArray, 0, this.fPositionalPredicateCountersContext.length);
            this.fPositionalPredicateCountersContext = nArray;
        }
        this.fPositionalPredicateCountersContext[this.fPositionalPredicateCountersCurrentContext] = this.fPositionalPredicateCountersSize;
    }

    private void popPredicateCounterContext() {
        this.fPositionalPredicateCountersSize = this.fPositionalPredicateCountersContext[this.fPositionalPredicateCountersCurrentContext--];
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    final class XInteger
    extends OneValueList
    implements Value {
        private long value;
        XInteger next;

        public XInteger(long l) {
            this.setValue(l);
        }

        void setValue(long l) {
            this.value = l;
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public InputStream getInputStream() {
            byte[] byArray;
            String string2 = this.getStringValue();
            try {
                byArray = string2.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string2.getBytes();
            }
            return new ByteArrayInputStream(byArray);
        }

        @Override
        public String getStringValue() {
            return Long.toString(this.value);
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }

        @Override
        public long getLongValue() {
            return this.value;
        }

        @Override
        public void dispose() {
            XPathScannerHelper.this.fValueFactory.freeInteger(this);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    final class XDouble
    extends OneValueList
    implements Value {
        private double value;
        XDouble next;

        public XDouble(double d) {
            this.setValue(d);
        }

        void setValue(double d) {
            this.value = d;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public InputStream getInputStream() {
            byte[] byArray;
            String string2 = this.getStringValue();
            try {
                byArray = string2.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string2.getBytes();
            }
            return new ByteArrayInputStream(byArray);
        }

        @Override
        public String getStringValue() {
            return Double.toString(this.value);
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }

        @Override
        public long getLongValue() {
            return (long)this.value;
        }

        @Override
        public void dispose() {
            XPathScannerHelper.this.fValueFactory.freeDouble(this);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    final class XAttributeOrText
    extends OneValueList
    implements Value {
        private final int type;
        private final XMLString value = new XMLString();
        private int nsContext;
        XAttributeOrText next;

        public XAttributeOrText(XMLString xMLString, boolean bl) {
            this.setValue(xMLString);
            this.type = bl ? 1 : 2;
        }

        void setValue(XMLString xMLString) {
            this.value.setValues(xMLString);
            this.nsContext = XPathScannerHelper.this.fNSContext;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public InputStream getInputStream() {
            return new XMLStringStream(this.value);
        }

        @Override
        public String getStringValue() {
            XPathScannerHelper.this.fCharBufferOffset[0] = 0;
            this.value.getChars(XPathScannerHelper.this.fCharBuffer, XPathScannerHelper.this.fCharBufferOffset);
            return new String(XPathScannerHelper.this.fCharBuffer[0], 0, XPathScannerHelper.this.fCharBufferOffset[0]);
        }

        @Override
        public javax.xml.namespace.QName getQNameValue() {
            javax.xml.namespace.QName qName = XMLStringHelper.parseQName(this.value, XPathScannerHelper.this.fElementStringCopy, XPathScannerHelper.this.fCharBuffer, XPathScannerHelper.this.fCharBufferOffset, XPathScannerHelper.this.fNamespaceContext, this.nsContext, XPathScannerHelper.this.fSymbolTable);
            XPathScannerHelper.this.fElementStringCopy.clear();
            if (qName != null) {
                return qName;
            }
            throw new IllegalStateException();
        }

        @Override
        public double getDoubleValue() {
            double d = XMLStringHelper.parseDouble(this.value, XPathScannerHelper.this.fReturnedErrorCode);
            if (XPathScannerHelper.this.fReturnedErrorCode[0] == 0) {
                return d;
            }
            throw new NumberFormatException();
        }

        @Override
        public long getLongValue() {
            long l = XMLStringHelper.parseLong(this.value, XPathScannerHelper.this.fReturnedErrorCode);
            if (XPathScannerHelper.this.fReturnedErrorCode[0] == 0) {
                return l;
            }
            throw new NumberFormatException();
        }

        @Override
        public void dispose() {
            this.value.unregister();
            if (this.type == 1) {
                XPathScannerHelper.this.fValueFactory.freeAttribute(this);
            } else {
                XPathScannerHelper.this.fValueFactory.freeText(this);
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    final class XElement
    extends OneValueList
    implements Value {
        final XMLString start = new XMLString();
        final XMLString middle = new XMLString();
        final XMLString end = new XMLString();
        XElement next;

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public InputStream getInputStream() {
            if (this.middle.firstBuffer == null) {
                return new XMLStringStream(this.start);
            }
            return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
                int index = 0;
                final int endIndex;
                {
                    this.endIndex = XElement.this.end.firstBuffer != null ? 2 : 1;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.index <= this.endIndex;
                }

                @Override
                public InputStream nextElement() {
                    switch (this.index++) {
                        case 0: {
                            return new XMLStringStream(XElement.this.start);
                        }
                        case 1: {
                            return new XMLStringStream(XElement.this.middle);
                        }
                        case 2: {
                            return new XMLStringStream(XElement.this.end);
                        }
                    }
                    throw new NoSuchElementException();
                }
            });
        }

        @Override
        public String getStringValue() {
            XPathScannerHelper.this.fCharBufferOffset[0] = 0;
            this.start.getChars(XPathScannerHelper.this.fCharBuffer, XPathScannerHelper.this.fCharBufferOffset);
            if (this.middle.firstBuffer != null) {
                this.middle.getChars(XPathScannerHelper.this.fCharBuffer, XPathScannerHelper.this.fCharBufferOffset);
                if (this.end.firstBuffer != null) {
                    this.end.getChars(XPathScannerHelper.this.fCharBuffer, XPathScannerHelper.this.fCharBufferOffset);
                }
            }
            return new String(XPathScannerHelper.this.fCharBuffer[0], 0, XPathScannerHelper.this.fCharBufferOffset[0]);
        }

        @Override
        public double getDoubleValue() {
            throw new NumberFormatException();
        }

        @Override
        public long getLongValue() {
            throw new NumberFormatException();
        }

        @Override
        public void dispose() {
            this.start.unregister();
            this.middle.unregister();
            this.end.unregister();
            XPathScannerHelper.this.fValueFactory.freeElement(this);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static abstract class OneValueList
    extends AbstractList<Value>
    implements Value {
        OneValueList() {
        }

        @Override
        public javax.xml.namespace.QName getQNameValue() {
            throw new IllegalStateException();
        }

        @Override
        public final boolean contains(Object object2) {
            return object2 == this;
        }

        @Override
        public final boolean equals(Object object2) {
            if (object2 == this) {
                return true;
            }
            if (object2 instanceof List) {
                List list = (List)object2;
                return list.size() == 1 && list.get(0) == this;
            }
            return false;
        }

        @Override
        public final Value get(int n2) {
            if (n2 == 0) {
                return this;
            }
            throw new IndexOutOfBoundsException("Index: " + n2);
        }

        @Override
        public final int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public final String toString() {
            return this.getStringValue();
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final Iterator<Value> iterator() {
            return new OneValueIterator();
        }

        @Override
        public final int size() {
            return 1;
        }

        @Override
        public final Object[] toArray() {
            return new Object[]{this};
        }

        @Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
        final class OneValueIterator
        implements Iterator<Value> {
            boolean more = true;

            OneValueIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.more;
            }

            @Override
            public Value next() {
                if (this.more) {
                    this.more = false;
                    return OneValueList.this;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    final class ValueFactory {
        private XElement fFreeElementValues;
        private XAttributeOrText fFreeAttributeValues;
        private XAttributeOrText fFreeTextValues;
        private XDouble fFreeDoubleValues;
        private XInteger fFreeIntegerValues;

        ValueFactory() {
        }

        public XElement createElement() {
            XElement xElement = this.fFreeElementValues;
            if (xElement != null) {
                this.fFreeElementValues = xElement.next;
                xElement.next = null;
            } else {
                xElement = new XElement();
            }
            return xElement;
        }

        public void freeElement(XElement xElement) {
            xElement.next = this.fFreeElementValues;
            this.fFreeElementValues = xElement;
        }

        public XAttributeOrText createAttribute(XMLString xMLString) {
            XAttributeOrText xAttributeOrText = this.fFreeAttributeValues;
            if (xAttributeOrText != null) {
                xAttributeOrText.setValue(xMLString);
                this.fFreeAttributeValues = xAttributeOrText.next;
                xAttributeOrText.next = null;
            } else {
                xAttributeOrText = new XAttributeOrText(xMLString, true);
            }
            return xAttributeOrText;
        }

        public void freeAttribute(XAttributeOrText xAttributeOrText) {
            xAttributeOrText.next = this.fFreeAttributeValues;
            this.fFreeAttributeValues = xAttributeOrText;
        }

        public XAttributeOrText createText(XMLString xMLString) {
            XAttributeOrText xAttributeOrText = this.fFreeTextValues;
            if (xAttributeOrText != null) {
                xAttributeOrText.setValue(xMLString);
                this.fFreeTextValues = xAttributeOrText.next;
                xAttributeOrText.next = null;
            } else {
                xAttributeOrText = new XAttributeOrText(xMLString, false);
            }
            return xAttributeOrText;
        }

        public void freeText(XAttributeOrText xAttributeOrText) {
            xAttributeOrText.next = this.fFreeTextValues;
            this.fFreeTextValues = xAttributeOrText;
        }

        public XDouble createDouble(double d) {
            XDouble xDouble = this.fFreeDoubleValues;
            if (xDouble != null) {
                xDouble.setValue(d);
                this.fFreeDoubleValues = xDouble.next;
                xDouble.next = null;
            } else {
                xDouble = new XDouble(d);
            }
            return xDouble;
        }

        public void freeDouble(XDouble xDouble) {
            xDouble.next = this.fFreeDoubleValues;
            this.fFreeDoubleValues = xDouble;
        }

        public XInteger createInteger(long l) {
            XInteger xInteger = this.fFreeIntegerValues;
            if (xInteger != null) {
                xInteger.setValue(l);
                this.fFreeIntegerValues = xInteger.next;
                xInteger.next = null;
            } else {
                xInteger = new XInteger(l);
            }
            return xInteger;
        }

        public void freeInteger(XInteger xInteger) {
            xInteger.next = this.fFreeIntegerValues;
            this.fFreeIntegerValues = xInteger;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    final class SimpleResultBuilder
    implements XPathResultHandler {
        private final int fSize;
        private List<Value>[] fResult;
        private int[] fMappings = new int[32];
        private XMLString fTempString = new XMLString();

        public SimpleResultBuilder(int n2) {
            this.fSize = n2;
        }

        private void addValue(int n2, OneValueList oneValueList) {
            List<Value> list = this.fResult[n2];
            if (list == null) {
                this.fResult[n2] = oneValueList;
                return;
            }
            if (list.size() <= 1) {
                Value value2 = (Value)((Object)list);
                list = new ArrayList<Value>();
                list.add(value2);
                this.fResult[n2] = list;
            }
            list.add(oneValueList);
        }

        @Override
        public XMLString elementValue(int n2, DataBuffer dataBuffer, int n3, DataBuffer dataBuffer2, int n4, boolean bl) {
            int n5;
            XElement xElement = XPathScannerHelper.this.fValueFactory.createElement();
            this.addValue(n2, xElement);
            xElement.start.setStartPos(dataBuffer, n3);
            int n6 = XPathScannerHelper.this.fNamespaceContext.totalMappingsCount(XPathScannerHelper.this.fNSContext);
            if (n6 <= 1) {
                return xElement.start;
            }
            if (n6 << 1 > this.fMappings.length) {
                this.fMappings = new int[n6 << 2];
            }
            int n7 = XPathScannerHelper.this.fNamespaceContext.inScopeNamespaces(XPathScannerHelper.this.fNSContext, this.fMappings) << 1;
            int n8 = XPathScannerHelper.this.fNamespaceContext.nsDeclCount(XPathScannerHelper.this.fNSContext);
            int n9 = XPathScannerHelper.this.fContentBuffer.getOffset();
            block0: for (n5 = 0; n5 < n7; n5 += 2) {
                int n10 = this.fMappings[n5];
                int n11 = this.fMappings[n5 + 1];
                if (n10 == 2 || n11 == 0) continue;
                for (int i = 0; i < n8; ++i) {
                    if (n10 == XPathScannerHelper.this.fNamespaceContext.nsDeclPrefix(XPathScannerHelper.this.fNSContext, i)) continue block0;
                }
                if (n10 != 0) {
                    XPathScannerHelper.this.fContentBuffer.appendBytes(XMLNS_PREFIX, 0, XMLNS_PREFIX.length);
                    XPathScannerHelper.this.fSymbolTable.setStringValues(n10, this.fTempString);
                    XPathScannerHelper.this.fContentBuffer.appendXMLString(this.fTempString);
                    XPathScannerHelper.this.fContentBuffer.appendBytes(EQUALS_QUOTE, 0, EQUALS_QUOTE.length);
                } else {
                    XPathScannerHelper.this.fContentBuffer.appendBytes(XMLNS, 0, XMLNS.length);
                }
                XPathScannerHelper.this.fSymbolTable.setStringValues(n11, this.fTempString);
                XPathScannerHelper.this.fContentBuffer.appendXMLString(this.fTempString);
                XPathScannerHelper.this.fContentBuffer.appendChar(34);
            }
            n5 = XPathScannerHelper.this.fContentBuffer.getOffset();
            if (n9 == n5) {
                return xElement.start;
            }
            if (bl) {
                this.handleEndOfStartTag(xElement, dataBuffer, dataBuffer2, n4);
                XPathScannerHelper.this.fContentBuffer.setStringValues(n9, n5 + 1, xElement.middle);
                xElement.end.setStartPos(dataBuffer2, n4);
                return xElement.end;
            }
            this.handleEndOfEmptyTag(xElement, dataBuffer, dataBuffer2, n4);
            XPathScannerHelper.this.fContentBuffer.setStringValues(n9, n5 + 2, xElement.middle);
            return null;
        }

        private void handleEndOfStartTag(XElement xElement, DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2) {
            if (dataBuffer2.startOffset != n2) {
                xElement.start.setEndPos(dataBuffer2, n2 - 1, 0);
            } else {
                DataBuffer dataBuffer3 = dataBuffer;
                while (dataBuffer3.next != dataBuffer2) {
                    dataBuffer3 = dataBuffer3.next;
                }
                xElement.start.setEndPos(dataBuffer3, dataBuffer3.endOffset - 1, 0);
            }
            XPathScannerHelper.this.fContentBuffer.appendChar(62);
        }

        private void handleEndOfEmptyTag(XElement xElement, DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2) {
            int n3 = n2 - dataBuffer2.startOffset;
            if (n3 >= 2) {
                xElement.start.setEndPos(dataBuffer2, n2 - 2, 0);
            } else {
                DataBuffer dataBuffer3 = dataBuffer;
                while (dataBuffer3.next != dataBuffer2) {
                    dataBuffer3 = dataBuffer3.next;
                }
                xElement.start.setEndPos(dataBuffer3, dataBuffer3.endOffset + n3 - 2, 0);
            }
            XPathScannerHelper.this.fContentBuffer.appendBytes(END_OF_EMPTY_TAG, 0, END_OF_EMPTY_TAG.length);
        }

        @Override
        public void attributeValue(int n2, XMLString xMLString) {
            this.addValue(n2, XPathScannerHelper.this.fValueFactory.createAttribute(xMLString));
        }

        @Override
        public void textValue(int n2, XMLString xMLString) {
            this.addValue(n2, XPathScannerHelper.this.fValueFactory.createText(xMLString));
        }

        @Override
        public void doubleValue(int n2, double d) {
            this.addValue(n2, XPathScannerHelper.this.fValueFactory.createDouble(d));
        }

        @Override
        public void longValue(int n2, long l) {
            this.addValue(n2, XPathScannerHelper.this.fValueFactory.createInteger(l));
        }

        @Override
        public List<List<Value>> getResult() {
            return new ImmutableArrayList((Object[])this.fResult, this.fSize);
        }

        public void reset() {
            this.fResult = new List[this.fSize];
        }
    }
}

