/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath.impl;

import com.ibm.xml.xlxp.api.wbm.xpath.impl.NonterminalSymbolImpl;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.Production;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.util.BitSet;
import com.ibm.xml.xlxp.util.SymbolTable;
import java.util.Iterator;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class GroupImpl
extends NonterminalSymbolImpl {
    protected final boolean fIsUnboundedLoopSymbol;
    protected boolean fIsNullable = false;
    protected boolean fIsNullableComputed = false;
    private BitSet fFirstSet = null;

    public GroupImpl(SymbolTable symbolTable, boolean bl) {
        super(symbolTable);
        this.fIsUnboundedLoopSymbol = bl;
    }

    @Override
    public boolean isNullable() {
        if (this.fIsNullableComputed) {
            return this.fIsNullable;
        }
        this.fIsNullableComputed = true;
        Iterator iterator = this.expansions();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (!production.isNullable()) continue;
            this.fIsNullable = true;
            return true;
        }
        this.fIsNullable = false;
        return false;
    }

    @Override
    public BitSet firstSet() {
        return this.fFirstSet;
    }

    @Override
    public void computeFirstSet(SymbolTable symbolTable) {
        if (this.fFirstSet == null) {
            this.fFirstSet = symbolTable.newBitSet();
            Iterator iterator = this.expansions();
            while (iterator.hasNext()) {
                Production production = (Production)iterator.next();
                this.fFirstSet.setBits(production.computeFirstSet(symbolTable));
            }
        }
    }

    @Override
    public void handleFollowSet(BitSet bitSet) {
        Iterator iterator = this.expansions();
        if (this.fIsUnboundedLoopSymbol) {
            bitSet.setBits(this.firstSet());
        }
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            production.computeFollowSets((BitSet)bitSet.clone());
        }
        if (this.isNullable()) {
            if (this.fIsUnboundedLoopSymbol) {
                return;
            }
            bitSet.setBits(this.firstSet());
            return;
        }
        bitSet.clearAll();
        bitSet.setBits(this.firstSet());
    }
}

