/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath.impl;

import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathSymbol;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.finiteStateMachine.Factory;
import com.ibm.xml.xlxp.finiteStateMachine.FiniteStateMachine;
import com.ibm.xml.xlxp.util.SymbolTable;
import java.util.List;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XPathFSM
extends Factory {
    private final FiniteStateMachine fFsm;

    public XPathFSM(XPathSymbol xPathSymbol, SymbolTable symbolTable) {
        xPathSymbol.computeFirstSet(symbolTable);
        xPathSymbol.handleFollowSet(symbolTable.newBitSet());
        this.fFsm = this.createFiniteStateMachine();
        this.fFsm.initialise(symbolTable);
        this.fFsm.generate(xPathSymbol.firstSet());
    }

    public XPathFSM(SymbolTable symbolTable) {
        this.fFsm = this.createFiniteStateMachine();
        this.fFsm.initialise(symbolTable);
    }

    public List generate(XPathSymbol xPathSymbol, SymbolTable symbolTable) {
        this.fFsm.releaseObjects();
        xPathSymbol.computeFirstSet(symbolTable);
        xPathSymbol.handleFollowSet(symbolTable.newBitSet());
        this.fFsm.initialise(symbolTable);
        this.fFsm.generate(xPathSymbol.firstSet());
        return this.fFsm.states();
    }

    public String toString() {
        return this.fFsm.toString();
    }

    public List states() {
        return this.fFsm.states();
    }
}

