/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates;

import com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates.Predicate;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates.PredicateContext;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates.PredicateLiteral;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates.PredicateNode;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class PredicateImpl
implements Predicate {
    private final int xpathID;
    private final int predicateID;
    private PredicateNode root;

    public PredicateImpl(int n2, int n3) {
        this.xpathID = n2;
        this.predicateID = n3;
    }

    @Override
    public boolean evaluate(PredicateContext predicateContext) {
        if (this.getRoot() == null) {
            return true;
        }
        PredicateLiteral predicateLiteral = this.getRoot().evaluate(predicateContext);
        if (this.getRoot().getType() == 4) {
            return predicateLiteral != null;
        }
        if (this.getRoot().getType() == 0) {
            int n2 = predicateContext.incrementCounter(this.xpathID, this.predicateID);
            return predicateLiteral.getIntValue() == n2;
        }
        return predicateLiteral.getBooleanValue();
    }

    public PredicateNode getRoot() {
        return this.root;
    }

    public void setRoot(PredicateNode predicateNode) {
        this.root = predicateNode;
    }

    @Override
    public int getPredicateID() {
        return this.predicateID;
    }

    public int getXpathID() {
        return this.xpathID;
    }
}

