/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.impl.BuildableCompilationUnit;
import com.ibm.xml.xlxp.compiler.impl.CodeGenerator;
import com.ibm.xml.xlxp.compiler.impl.ComplexBody;
import com.ibm.xml.xlxp.compiler.impl.ComplexType;
import com.ibm.xml.xlxp.compiler.impl.InstructionList;
import com.ibm.xml.xlxp.compiler.impl.Label;
import com.ibm.xml.xlxp.compiler.impl.NonterminalSymbolImpl;
import com.ibm.xml.xlxp.compiler.impl.Production;
import com.ibm.xml.xlxp.compiler.impl.SymbolTable;
import com.ibm.xml.xlxp.compiler.impl.finiteStateMachine.ComplexTypeFSM;
import com.ibm.xml.xlxp.finiteStateMachine.TransitionSymbol;
import com.ibm.xml.xlxp.util.BitSet;
import java.util.Iterator;

public class ComplexBodyImpl
extends NonterminalSymbolImpl
implements ComplexBody {
    protected final ComplexType fOwner;
    protected final SymbolTable fSymbolTable;
    protected boolean fAllowEmptyTag = false;
    private BitSet fFirstSet = null;
    private BuildableCompilationUnit fBcu = null;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected ComplexBodyImpl(ComplexType complexType, SymbolTable symbolTable) {
        super(symbolTable);
        this.fOwner = complexType;
        this.fSymbolTable = symbolTable;
    }

    public BitSet firstSet() {
        return this.fFirstSet;
    }

    public void computeFirstSet(SymbolTable symbolTable) {
        if (this.fFirstSet == null) {
            Iterator iterator = this.expansions();
            iterator.hasNext();
            Production production = (Production)iterator.next();
            if (iterator.hasNext()) {
                throw new CompilerError();
            }
            this.fFirstSet = production.computeFirstSet(symbolTable);
        }
    }

    public void computeFollowSet(SymbolTable symbolTable) {
        Iterator iterator = this.expansions();
        iterator.hasNext();
        Production production = (Production)iterator.next();
        if (iterator.hasNext()) {
            throw new CompilerError();
        }
        production.computeFollowSets(symbolTable.newBitSet());
    }

    public void computeModelInfo(CodeGenerator codeGenerator) {
        Iterator iterator = this.fSymbolTable.memberIterator(this.fFirstSet, codeGenerator.workList());
        while (iterator.hasNext()) {
            TransitionSymbol transitionSymbol = (TransitionSymbol)iterator.next();
            if (!transitionSymbol.wrappedSymbol().isEOF()) continue;
            this.fAllowEmptyTag = true;
            break;
        }
    }

    public void createTheTables(CodeGenerator codeGenerator) {
        ComplexTypeFSM complexTypeFSM = codeGenerator.getComplexTypeFSM();
        complexTypeFSM.initialise(this.fSymbolTable);
        complexTypeFSM.generate(this.firstSet());
        complexTypeFSM.createTables(this.fOwner);
        this.fBcu = codeGenerator.setCompilationUnit(new InstructionList(codeGenerator.getCompilationUnit()));
        Label label = this.fOwner.label(codeGenerator);
        complexTypeFSM.generateInstructions(label, this.fOwner, this.fOwner.contentType());
        complexTypeFSM.releaseObjects();
        this.fBcu = codeGenerator.setCompilationUnit(this.fBcu);
    }

    public void generateInstructions(CodeGenerator codeGenerator, Label label) {
        codeGenerator.addInstructions(this.fBcu.getInstructionStream());
        this.fBcu = null;
        this.fOwner.endComplexTypeExtensionInstructions(codeGenerator);
        codeGenerator.returnFromSubroutine();
    }

    public boolean allowEmptyTag() {
        return this.fAllowEmptyTag;
    }
}

