/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl;

import com.ibm.xml.xlxp.compiler.impl.ComplexType;
import com.ibm.xml.xlxp.compiler.impl.GrammarSymbol;
import com.ibm.xml.xlxp.compiler.impl.SymbolTable;
import com.ibm.xml.xlxp.compiler.impl.iterators.SymbolIterator;
import com.ibm.xml.xlxp.util.BitSet;
import com.ibm.xml.xlxp.util.SymbolImpl;

public abstract class GrammarSymbolImpl
extends SymbolImpl
implements GrammarSymbol {
    private BitSet fEmptySet = null;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public GrammarSymbolImpl(SymbolTable symbolTable) {
        super(symbolTable);
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isUnboundedLoopSymbol() {
        return false;
    }

    public BitSet firstSet() {
        return this.fEmptySet;
    }

    public void computeFirstSet(SymbolTable symbolTable) {
        this.fEmptySet = symbolTable.newBitSet();
    }

    public void computeFollowSet(SymbolTable symbolTable) {
        if (this.fEmptySet == null) {
            this.fEmptySet = symbolTable.newBitSet();
        }
    }

    protected void setOwnFollowSet(BitSet bitSet) {
        if (this.isUnboundedLoopSymbol()) {
            bitSet.setBits(this.firstSet());
        }
        this.setFollowSet(bitSet);
    }

    protected void setFollowSet(BitSet bitSet) {
    }

    protected void nextFollowSet(BitSet bitSet) {
        if (!this.isNullable()) {
            bitSet.clearAll();
        } else if (this.isUnboundedLoopSymbol()) {
            return;
        }
        bitSet.setBits(this.firstSet());
    }

    public void handleFollowSet(BitSet bitSet) {
        this.setOwnFollowSet(bitSet);
        this.nextFollowSet(bitSet);
    }

    public boolean isEndOfParent() {
        return false;
    }

    public static void computeFirstAndFollowSets(SymbolTable symbolTable) {
        GrammarSymbolImpl.computeFirstSets(symbolTable);
        GrammarSymbolImpl.computeFollowSets(symbolTable);
    }

    public static void computeFirstSets(SymbolTable symbolTable) {
        SymbolIterator symbolIterator = symbolTable.grammarSymbolIterator();
        while (symbolIterator.hasNext()) {
            GrammarSymbol grammarSymbol = (GrammarSymbol)symbolIterator.next();
            grammarSymbol.computeFirstSet(symbolTable);
        }
    }

    private static void computeFollowSets(SymbolTable symbolTable) {
        SymbolIterator symbolIterator = symbolTable.complexTypeSymbolIterator();
        while (symbolIterator.hasNext()) {
            ComplexType complexType = (ComplexType)symbolIterator.next();
            complexType.computeFollowSet(symbolTable);
        }
    }
}

