/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.impl.OwnedAttributes;
import com.ibm.xml.xlxp.compiler.impl.WildcardAttribute;
import com.ibm.xml.xlxp.compiler.impl.WildcardAttributeInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSObjectList;

public class OwnedAttributesImpl
implements OwnedAttributes {
    private final int fNumOwnedAttribs;
    private final int fNumberOfAttributes;
    private final XSObjectList fOwnedAttributes;
    private final WildcardAttribute fWildcard;
    private final List fWcAttributes;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public OwnedAttributesImpl(XSObjectList xSObjectList, WildcardAttribute wildcardAttribute) {
        if (xSObjectList == null || xSObjectList.getLength() == 0) {
            this.fOwnedAttributes = null;
            this.fNumOwnedAttribs = 0;
        } else {
            this.fOwnedAttributes = xSObjectList;
            this.fNumOwnedAttribs = xSObjectList.getLength();
        }
        this.fWildcard = wildcardAttribute;
        int n2 = 0;
        if (wildcardAttribute == null) {
            this.fWcAttributes = null;
        } else {
            this.fWcAttributes = this.removeDuplicateAttrDecls(wildcardAttribute.getKnownAttributes());
            n2 = this.fWcAttributes != null ? this.fWcAttributes.size() : 0;
        }
        this.fNumberOfAttributes = this.fNumOwnedAttribs + n2;
    }

    public boolean isEmpty() {
        return this.fNumberOfAttributes == 0;
    }

    public int getLength() {
        return this.fNumberOfAttributes;
    }

    public XSAttributeUse use(int n2) {
        if (n2 >= this.fNumberOfAttributes) {
            throw new CompilerError();
        }
        return this.fOwnedAttributes == null ? null : (XSAttributeUse)this.fOwnedAttributes.item(n2);
    }

    public XSAttributeDeclaration decl(int n2) {
        if (n2 < this.fNumOwnedAttribs) {
            XSAttributeUse xSAttributeUse = this.use(n2);
            return xSAttributeUse.getAttrDeclaration();
        }
        return (XSAttributeDeclaration)this.fWcAttributes.get(n2 - this.fNumOwnedAttribs);
    }

    public WildcardAttribute wildcard() {
        return this.fWildcard;
    }

    public WildcardAttributeInfo wildcardInfo() {
        if (this.fWildcard == null) {
            return null;
        }
        return this.fWildcard.wildcardInfo();
    }

    private List removeDuplicateAttrDecls(List list) {
        int n2;
        Object object2;
        if (list == null || this.fOwnedAttributes == null) {
            return list;
        }
        int n3 = list.size();
        int n4 = 0;
        block0: while (n4 < n3) {
            object2 = (XSAttributeDeclaration)list.get(n4);
            n2 = 0;
            while (n2 < this.fNumOwnedAttribs) {
                if (object2 == ((XSAttributeUse)this.fOwnedAttributes.item(n2)).getAttrDeclaration()) break block0;
                ++n2;
            }
            ++n4;
        }
        if (n4 == n3) {
            return list;
        }
        object2 = new ArrayList(n3 - 1);
        n2 = 0;
        while (n2 < n4) {
            ((ArrayList)object2).add(list.get(n2));
            ++n2;
        }
        block3: while (++n4 < n3) {
            XSAttributeDeclaration xSAttributeDeclaration = (XSAttributeDeclaration)list.get(n4);
            int n5 = 0;
            while (n5 < this.fNumOwnedAttribs) {
                if (xSAttributeDeclaration == ((XSAttributeUse)this.fOwnedAttributes.item(n5)).getAttrDeclaration()) continue block3;
                ++n5;
            }
            ((ArrayList)object2).add(xSAttributeDeclaration);
        }
        return object2;
    }
}

