/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.finiteStateMachine;

import com.ibm.xml.xlxp.compiler.impl.CodeGenerator;
import com.ibm.xml.xlxp.compiler.impl.ComplexType;
import com.ibm.xml.xlxp.compiler.impl.Label;
import com.ibm.xml.xlxp.compiler.impl.finiteStateMachine.ComplexTypeFSMStateInfo;
import com.ibm.xml.xlxp.compiler.tables.Table;
import com.ibm.xml.xlxp.finiteStateMachine.Factory;
import com.ibm.xml.xlxp.finiteStateMachine.FiniteStateMachine;
import com.ibm.xml.xlxp.finiteStateMachine.State;
import com.ibm.xml.xlxp.util.BitSet;
import com.ibm.xml.xlxp.util.FreeList;
import com.ibm.xml.xlxp.util.Recyclable;
import com.ibm.xml.xlxp.util.SymbolTable;
import java.util.Iterator;
import java.util.List;

public class ComplexTypeFSM
extends Factory {
    private FreeList fStateInfos = new FreeList(128);
    private Label fGetEndOfParentLabel = null;
    private Label fEndOfCodeLabel = null;
    private final CodeGenerator fGen;
    private final FiniteStateMachine fFSM;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ComplexTypeFSM(CodeGenerator codeGenerator) {
        this.fGen = codeGenerator;
        this.fFSM = this.createFiniteStateMachine();
    }

    public void initialise(SymbolTable symbolTable) {
        this.fFSM.initialise(symbolTable);
        this.fGetEndOfParentLabel = null;
        this.fEndOfCodeLabel = null;
    }

    public void generate(BitSet bitSet) {
        this.fFSM.generate(bitSet);
    }

    public void releaseObjects() {
        this.fFSM.releaseObjects();
    }

    public List states() {
        return this.fFSM.states();
    }

    public void createTables(ComplexType complexType) {
        ComplexTypeFSMStateInfo complexTypeFSMStateInfo;
        State state;
        Iterator iterator = this.fFSM.states().iterator();
        while (iterator.hasNext()) {
            state = (State)iterator.next();
            complexTypeFSMStateInfo = (ComplexTypeFSMStateInfo)state.getStateInfo();
            complexTypeFSMStateInfo.setInfo(this.fGen, complexType);
        }
        iterator = this.fFSM.states().iterator();
        while (iterator.hasNext()) {
            state = (State)iterator.next();
            complexTypeFSMStateInfo = (ComplexTypeFSMStateInfo)state.getStateInfo();
            Table table2 = complexTypeFSMStateInfo.createTable(this.fGen);
            if (table2 == null) continue;
            this.fGen.addTable(table2);
        }
    }

    public void generateInstructions(Label label, ComplexType complexType, int n2) {
        this.fEndOfCodeLabel = this.fGen.createLabel();
        Iterator iterator = this.fFSM.states().iterator();
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            ComplexTypeFSMStateInfo complexTypeFSMStateInfo = (ComplexTypeFSMStateInfo)state.getStateInfo();
            complexTypeFSMStateInfo.generateInstructions(this.fGen, label, complexType, n2);
            label = null;
        }
        if (this.fGetEndOfParentLabel != null) {
            this.fGen.generateLabel(this.fGetEndOfParentLabel);
            if (complexType != null) {
                this.fGen.readEndOfParent(n2);
            }
        }
        this.fGen.generateLabel(this.fEndOfCodeLabel);
    }

    public Label getEndOfParentLabel() {
        if (this.fGetEndOfParentLabel == null) {
            this.fGetEndOfParentLabel = this.fGen.createLabel();
        }
        return this.fGetEndOfParentLabel;
    }

    public Label endOfCodeLabel() {
        return this.fEndOfCodeLabel;
    }

    public boolean allowEmptyTag() {
        return ((State)this.fFSM.states().get(0)).isFinalState();
    }

    public Object createStateInfo() {
        Recyclable recyclable = this.fStateInfos.getObject();
        if (recyclable == null) {
            recyclable = new ComplexTypeFSMStateInfo();
        }
        return recyclable;
    }

    public void initialiseStateInfo(State state) {
        ComplexTypeFSMStateInfo complexTypeFSMStateInfo = (ComplexTypeFSMStateInfo)state.getStateInfo();
        complexTypeFSMStateInfo.initialise(state, this.fGen.createLabel(), this);
    }

    public void releaseStateInfo(Object object2) {
        Recyclable recyclable = (Recyclable)object2;
        recyclable.releaseObjects();
        this.fStateInfos.freeObject(recyclable);
    }
}

