/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.idc;

import com.ibm.xml.xlxp.compiler.impl.SymbolTable;
import com.ibm.xml.xlxp.compiler.impl.SymbolTableImpl;
import com.ibm.xml.xlxp.compiler.impl.idc.IDCSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathDFA;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathHandler;
import com.ibm.xml.xlxp.compiler.impl.iterators.SymbolIterator;
import java.util.List;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.xs.XSIDCDefinition;
import org.apache.xerces.xs.XSObject;

public class IDCHandler {
    private SymbolTable fSymbolTable = new SymbolTableImpl();
    private XPathHandler fXPathHandler = new XPathHandler();
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public IDCSymbol findOrCreate(XSIDCDefinition xSIDCDefinition) {
        IDCSymbol iDCSymbol = (IDCSymbol)this.fSymbolTable.get((XSObject)xSIDCDefinition);
        if (iDCSymbol == null) {
            iDCSymbol = this.create(xSIDCDefinition);
        }
        return iDCSymbol;
    }

    public SymbolIterator idcSymbolIterator() {
        return this.fSymbolTable.idcSymbolIterator();
    }

    public List xpathDFAList() {
        return this.fXPathHandler.xpathDFAList();
    }

    public int idcCount() {
        return this.fSymbolTable.maxId() + 1;
    }

    public void renumberXPathIds() {
        this.fXPathHandler.renumberFieldXPathIds();
    }

    private IDCSymbol create(XSIDCDefinition xSIDCDefinition) {
        IdentityConstraint identityConstraint = (IdentityConstraint)xSIDCDefinition;
        int n2 = identityConstraint.getFieldCount();
        IDCSymbol iDCSymbol = new IDCSymbol(xSIDCDefinition, this.fSymbolTable, n2);
        XPathDFA xPathDFA = this.fXPathHandler.generateXPath(identityConstraint.getSelector().getXPath(), iDCSymbol.getId(), true);
        iDCSymbol.setSelector(xPathDFA);
        int n3 = 0;
        while (n3 < n2) {
            xPathDFA = this.fXPathHandler.generateXPath(identityConstraint.getFieldAt(n3).getXPath(), iDCSymbol.getId(), false);
            iDCSymbol.addField(xPathDFA);
            ++n3;
        }
        this.fSymbolTable.put((XSObject)xSIDCDefinition, iDCSymbol);
        if (xSIDCDefinition.getRefKey() != null) {
            iDCSymbol.setKeyRef(this.findOrCreate(xSIDCDefinition.getRefKey()));
        }
        return iDCSymbol;
    }
}

