/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.idc;

import com.ibm.xml.xlxp.compiler.impl.SymbolTable;
import com.ibm.xml.xlxp.compiler.impl.SymbolTableImpl;
import com.ibm.xml.xlxp.compiler.impl.idc.ChoiceSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.EOFSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.IdcFsm;
import com.ibm.xml.xlxp.compiler.impl.idc.PathSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.SequenceSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathActualTransitionSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathDFA;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathDFAImpl;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathElementActualTransitionSymbolIterator;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathQNameActualTransitionSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathWildcardActualTransitionSymbol;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathWildcardActualTransitionSymbolIterator;
import com.ibm.xml.xlxp.util.FreeList;
import com.ibm.xml.xlxp.util.Recyclable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.xni.QName;

public class XPathHandler {
    private int fSelectorCount = 0;
    private ArrayList fXPathDFAList = new ArrayList();
    private SymbolTable fSymbolTable = new SymbolTableImpl();
    private TreeMap fQNameActualSymbols = new TreeMap();
    private TreeMap fActiveActualSymbols = new TreeMap();
    private Vector fPathInfos = new Vector(4);
    private IdcFsm fIdcFsm = new IdcFsm(this.fSymbolTable);
    private final FreeList fFreedPathInfos = new FreeList(4);
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public XPathDFA generateXPath(XPath xPath, int n2, boolean bl) {
        this.fFreedPathInfos.freeObjects(this.fPathInfos);
        this.fPathInfos.clear();
        this.fActiveActualSymbols.clear();
        return this.processXPathExpression(xPath.getLocationPaths(), n2, bl);
    }

    public List xpathDFAList() {
        return this.fXPathDFAList;
    }

    public void renumberFieldXPathIds() {
        int n2 = this.fSelectorCount;
        while (n2 < this.fXPathDFAList.size()) {
            XPathDFAImpl xPathDFAImpl = (XPathDFAImpl)this.fXPathDFAList.get(n2);
            xPathDFAImpl.setId(n2);
            ++n2;
        }
    }

    private XPathSymbol buildXPathTree() {
        ArrayList<XPathSymbol> arrayList = new ArrayList<XPathSymbol>();
        if (this.fPathInfos.size() == 1) {
            arrayList.add(((PathInfo)this.fPathInfos.get(0)).generate(this.fSymbolTable));
        } else {
            ArrayList<XPathSymbol> arrayList2 = new ArrayList<XPathSymbol>();
            int n2 = 0;
            while (n2 < this.fPathInfos.size()) {
                XPathSymbol xPathSymbol = ((PathInfo)this.fPathInfos.get(n2)).generate(this.fSymbolTable);
                arrayList2.add(xPathSymbol);
                ++n2;
            }
            arrayList.add(new ChoiceSymbol(arrayList2, false, this.fSymbolTable));
        }
        arrayList.add(new PathSymbol(new EOFSymbol(this.fSymbolTable), false, this.fSymbolTable));
        return new SequenceSymbol(arrayList, false, this.fSymbolTable);
    }

    private XPathDFA processXPathExpression(XPath.LocationPath[] locationPathArray, int n2, boolean bl) {
        int n3 = bl ? this.fSelectorCount : -1;
        int n4 = 0;
        while (n4 < locationPathArray.length) {
            this.fPathInfos.add(this.processLocationPath(locationPathArray[n4]));
            ++n4;
        }
        if (this.overlappingSymbols()) {
            this.handleOverlappingSymbols();
        }
        List list = this.fIdcFsm.generate(this.buildXPathTree(), this.fSymbolTable);
        XPathDFAImpl xPathDFAImpl = new XPathDFAImpl(n3, n2, list, this.activeSymbols());
        if (bl) {
            if (this.fSelectorCount == 0) {
                this.fXPathDFAList.add(xPathDFAImpl);
            } else {
                this.fXPathDFAList.add(this.fSelectorCount, xPathDFAImpl);
            }
            ++this.fSelectorCount;
        } else {
            this.fXPathDFAList.add(xPathDFAImpl);
        }
        return xPathDFAImpl;
    }

    private PathInfo processLocationPath(XPath.LocationPath locationPath) {
        XPath.Step[] stepArray = locationPath.steps;
        PathInfo pathInfo = (PathInfo)this.fFreedPathInfos.getObject();
        if (pathInfo == null) {
            pathInfo = new PathInfo();
        }
        int n2 = 0;
        while (n2 < stepArray.length) {
            XPath.Step step2 = stepArray[n2];
            if (step2.axis.type == 4) {
                pathInfo.addSymbol(this.findOrCreate(step2.nodeTest.name), true);
            } else if (step2.axis.type == 2) {
                pathInfo.addSymbol(this.findOrCreate(step2.nodeTest.name, (short)3), false);
            } else if (step2.axis.type == 1) {
                if (step2.nodeTest.type == 4 || step2.nodeTest.type == 2) {
                    pathInfo.addSymbol(this.findOrCreate(step2.nodeTest.name), false);
                } else if (step2.nodeTest.type == 1) {
                    pathInfo.addSymbol(this.findOrCreate(step2.nodeTest.name, (short)1), false);
                }
            }
            ++n2;
        }
        return pathInfo;
    }

    private void handleOverlappingSymbols() {
        XPathWildcardActualTransitionSymbolIterator xPathWildcardActualTransitionSymbolIterator = new XPathWildcardActualTransitionSymbolIterator(this.fActiveActualSymbols);
        while (xPathWildcardActualTransitionSymbolIterator.hasNext()) {
            XPathWildcardActualTransitionSymbol xPathWildcardActualTransitionSymbol = (XPathWildcardActualTransitionSymbol)xPathWildcardActualTransitionSymbolIterator.value();
            XPathElementActualTransitionSymbolIterator xPathElementActualTransitionSymbolIterator = new XPathElementActualTransitionSymbolIterator(this.fActiveActualSymbols);
            while (xPathElementActualTransitionSymbolIterator.hasNext()) {
                XPathActualTransitionSymbol xPathActualTransitionSymbol = (XPathActualTransitionSymbol)xPathElementActualTransitionSymbolIterator.value();
                if (xPathWildcardActualTransitionSymbol == xPathActualTransitionSymbol) continue;
                xPathWildcardActualTransitionSymbol.addOverlappedSymbol(xPathActualTransitionSymbol);
            }
        }
    }

    private boolean overlappingSymbols() {
        int n2 = 0;
        while (n2 < this.fPathInfos.size()) {
            XPathActualTransitionSymbol xPathActualTransitionSymbol = ((PathInfo)this.fPathInfos.get(n2)).getFirstSymbol();
            if (xPathActualTransitionSymbol instanceof XPathWildcardActualTransitionSymbol) {
                return true;
            }
            int n3 = n2 + 1;
            while (n3 < this.fPathInfos.size()) {
                if (xPathActualTransitionSymbol == ((PathInfo)this.fPathInfos.get(n3)).getFirstSymbol()) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    private String actualSymbolKey(QName qName, short s) {
        StringBuffer stringBuffer = new StringBuffer();
        if (qName.uri != null) {
            stringBuffer.append(qName.uri);
        }
        stringBuffer.append("_");
        if (qName.localpart != null) {
            stringBuffer.append(qName.localpart);
        }
        stringBuffer.append("_" + s);
        return stringBuffer.toString();
    }

    private XPathActualTransitionSymbol findOrCreate(QName qName) {
        String string2 = this.actualSymbolKey(qName, (short)2);
        XPathActualTransitionSymbol xPathActualTransitionSymbol = (XPathActualTransitionSymbol)this.fActiveActualSymbols.get(string2);
        if (xPathActualTransitionSymbol == null) {
            xPathActualTransitionSymbol = new XPathWildcardActualTransitionSymbol(qName.uri, this.fSymbolTable);
            this.fActiveActualSymbols.put(string2, xPathActualTransitionSymbol);
        }
        return xPathActualTransitionSymbol;
    }

    private XPathActualTransitionSymbol findOrCreate(QName qName, short s) {
        String string2 = this.actualSymbolKey(qName, s);
        XPathActualTransitionSymbol xPathActualTransitionSymbol = (XPathActualTransitionSymbol)this.fActiveActualSymbols.get(string2);
        if (xPathActualTransitionSymbol == null) {
            xPathActualTransitionSymbol = (XPathActualTransitionSymbol)this.fQNameActualSymbols.get(string2);
            if (xPathActualTransitionSymbol == null) {
                xPathActualTransitionSymbol = new XPathQNameActualTransitionSymbol(s, qName.localpart, qName.uri, this.fSymbolTable);
                this.fQNameActualSymbols.put(string2, xPathActualTransitionSymbol);
            }
            this.fActiveActualSymbols.put(string2, xPathActualTransitionSymbol);
        }
        return xPathActualTransitionSymbol;
    }

    private List activeSymbols() {
        int n2 = -1;
        int n3 = -1;
        ArrayList<XPathActualTransitionSymbol> arrayList = new ArrayList<XPathActualTransitionSymbol>();
        Iterator iterator = this.fActiveActualSymbols.values().iterator();
        while (iterator.hasNext()) {
            XPathActualTransitionSymbol xPathActualTransitionSymbol = (XPathActualTransitionSymbol)iterator.next();
            if (xPathActualTransitionSymbol.type == 1) {
                if (n2 == -1) {
                    arrayList.add(xPathActualTransitionSymbol);
                    continue;
                }
                arrayList.add(n2++, xPathActualTransitionSymbol);
                if (n3 == -1) continue;
                ++n3;
                continue;
            }
            if (xPathActualTransitionSymbol.type != 2) continue;
            if (n2 == -1) {
                n2 = arrayList.size();
            }
            if (xPathActualTransitionSymbol.namespace == null) {
                if (n3 == -1) {
                    n3 = arrayList.size();
                }
                arrayList.add(xPathActualTransitionSymbol);
                continue;
            }
            if (n3 == -1) {
                arrayList.add(xPathActualTransitionSymbol);
                continue;
            }
            arrayList.add(n3++, xPathActualTransitionSymbol);
        }
        return arrayList;
    }

    public static class PathInfo
    implements Recyclable {
        private ArrayList fSymbols = new ArrayList();
        private ArrayList fRepeats = new ArrayList();
        private XPathActualTransitionSymbol fFirstSymbol;

        public void releaseObjects() {
            this.fSymbols.clear();
            this.fRepeats.clear();
            this.fFirstSymbol = null;
        }

        public void addSymbol(XPathActualTransitionSymbol xPathActualTransitionSymbol, boolean bl) {
            if (this.fFirstSymbol == null) {
                this.fFirstSymbol = xPathActualTransitionSymbol;
            }
            this.fSymbols.add(xPathActualTransitionSymbol);
            this.fRepeats.add(new Boolean(bl));
        }

        public XPathSymbol generate(SymbolTable symbolTable) {
            ArrayList<XPathSymbol> arrayList = new ArrayList<XPathSymbol>();
            int n2 = 0;
            while (n2 < this.fSymbols.size()) {
                XPathActualTransitionSymbol xPathActualTransitionSymbol = (XPathActualTransitionSymbol)this.fSymbols.get(n2);
                Boolean bl = (Boolean)this.fRepeats.get(n2);
                arrayList.add(this.generate(xPathActualTransitionSymbol, symbolTable, bl));
                ++n2;
            }
            if (arrayList.size() == 0) {
                arrayList.add(new PathSymbol(new EOFSymbol(symbolTable), false, symbolTable));
            }
            return new SequenceSymbol(arrayList, false, symbolTable);
        }

        private XPathSymbol generate(XPathActualTransitionSymbol xPathActualTransitionSymbol, SymbolTable symbolTable, boolean bl) {
            if (xPathActualTransitionSymbol instanceof XPathQNameActualTransitionSymbol) {
                return new PathSymbol(xPathActualTransitionSymbol, bl, symbolTable);
            }
            Iterator iterator = ((XPathWildcardActualTransitionSymbol)xPathActualTransitionSymbol).overlappedSymbols();
            if (!iterator.hasNext()) {
                return new PathSymbol(xPathActualTransitionSymbol, bl, symbolTable);
            }
            ArrayList<XPathSymbol> arrayList = new ArrayList<XPathSymbol>();
            arrayList.add(new PathSymbol(xPathActualTransitionSymbol, false, symbolTable));
            while (iterator.hasNext()) {
                XPathActualTransitionSymbol xPathActualTransitionSymbol2 = (XPathActualTransitionSymbol)iterator.next();
                arrayList.add(this.generate(xPathActualTransitionSymbol2, symbolTable, false));
            }
            return new ChoiceSymbol(arrayList, bl, symbolTable);
        }

        public XPathActualTransitionSymbol getFirstSymbol() {
            return this.fFirstSymbol;
        }
    }
}

