/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl.regularExpressions;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.compiler.impl.CodeGenerator;
import com.ibm.xml.xlxp.compiler.impl.GrammarSymbolImpl;
import com.ibm.xml.xlxp.compiler.impl.Production;
import com.ibm.xml.xlxp.compiler.impl.ProductionImpl;
import com.ibm.xml.xlxp.compiler.impl.SymbolTable;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AllLetters;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AllMarks;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AllNumbers;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AllOthers;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AllPunctuation;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AllSeparators;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.AllSymbols;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Atom;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.BlockEscape;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharAtom;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharAtomImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharClassSub;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.CharacterRange;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Close;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Connector;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Control;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Currency;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Dash;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.DecimalDigit;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Dot;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.EOF;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Enclosing;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.FinalQuote;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Format;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.InitialNameCharsString;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.InitialQuote;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Letter;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Line;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Lowercase;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Math;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Modifier;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.NameCharsString;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.NegCharGroupImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Nonspacing;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.NotAssigned;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.NullCharacterRange;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Open;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.OtherLetters;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.OtherNumbers;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.OtherPunctuation;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.OtherSymbols;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Paragraph;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Piece;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.PosCharGroup;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.PosCharGroupImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.PosCharGroupMember;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.PrivateUse;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.RegExp;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.RegularExpression;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.RegularExpressionSymbolTable;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.RegularExpressionSymbolTableImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.RegularExpressionTableImpl;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Space;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.SpaceCombining;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.SpaceString;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Titlecase;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.Uppercase;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.WhatEver;
import com.ibm.xml.xlxp.compiler.impl.regularExpressions.finiteStateMachine.RegularExpressionFSM;
import com.ibm.xml.xlxp.compiler.tables.RegularExpressionTable;
import com.ibm.xml.xlxp.util.Symbol;
import java.util.ArrayList;
import java.util.Iterator;

public class RegularExpressionImpl
implements RegularExpression {
    private RegularExpressionTable fTable;
    private char[] fInput;
    private int fIndex;
    protected RegExp fRegEx;
    protected RegularExpressionSymbolTable fSymbolTable = new RegularExpressionSymbolTableImpl(128);
    private final NullCharacterRange fNullCharacterRange = new NullCharacterRange(this.fSymbolTable);
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public RegularExpressionImpl(String string2) {
        int n2 = string2.length();
        this.fInput = new char[n2];
        string2.getChars(0, n2, this.fInput, 0);
        this.fIndex = 0;
        this.fRegEx = this.parseRegEx(true);
        this.fInput = null;
    }

    private boolean atEnd() {
        return this.fIndex >= this.fInput.length || this.fInput[this.fIndex] == ')';
    }

    private boolean branchEnd() {
        return this.atEnd() || this.fInput[this.fIndex] == '|';
    }

    private void expect(char c) {
        if (this.fInput[this.fIndex] != c) {
            throw new CompilerError();
        }
        ++this.fIndex;
    }

    private RegExp parseRegEx(boolean bl) {
        RegExp regExp = new RegExp(this.fSymbolTable, false);
        while (!this.atEnd()) {
            regExp.addProduction(this.parseBranch(bl));
        }
        return regExp;
    }

    /*
     * Unable to fully structure code
     */
    private Production parseBranch(boolean var1_1) {
        block2: {
            var2_2 = new ArrayList<EOF>();
            if (this.fInput[this.fIndex] != '|') ** GOTO lbl6
            ++this.fIndex;
            break block2;
lbl-1000:
            // 1 sources

            {
                this.parsePiece(var2_2);
lbl6:
                // 2 sources

                ** while (!this.branchEnd())
            }
        }
        if (var1_1) {
            var2_2.add(this.fSymbolTable.eof());
        }
        return new ProductionImpl(var2_2);
    }

    private void parsePiece(ArrayList arrayList) {
        Object object2 = this.parseAtom();
        this.parseQuantifier(object2, arrayList);
    }

    private void parseQuantifier(Object object2, ArrayList arrayList) {
        if (!this.atEnd()) {
            switch (this.fInput[this.fIndex]) {
                case '?': {
                    ++this.fIndex;
                    this.createPieces(object2, 0, 1, false, arrayList, this.fSymbolTable);
                    return;
                }
                case '*': {
                    ++this.fIndex;
                    this.createPieces(object2, 0, 0, true, arrayList, this.fSymbolTable);
                    return;
                }
                case '+': {
                    ++this.fIndex;
                    this.createPieces(object2, 1, 0, true, arrayList, this.fSymbolTable);
                    return;
                }
                case '{': {
                    ++this.fIndex;
                    int n2 = this.parseInt();
                    if (this.fInput[this.fIndex] == '}') {
                        ++this.fIndex;
                        this.createPieces(object2, n2, n2, false, arrayList, this.fSymbolTable);
                        return;
                    }
                    this.expect(',');
                    if (this.fInput[this.fIndex] == '}') {
                        ++this.fIndex;
                        this.createPieces(object2, n2, 0, true, arrayList, this.fSymbolTable);
                        return;
                    }
                    int n3 = this.parseInt();
                    if (n2 == 0 && n3 == 0) {
                        return;
                    }
                    this.createPieces(object2, n2, n3, false, arrayList, this.fSymbolTable);
                    this.expect('}');
                    return;
                }
            }
        }
        this.createPieces(object2, 1, 1, false, arrayList, this.fSymbolTable);
    }

    /*
     * Unable to fully structure code
     */
    private void createPieces(Object var1_1, int var2_2, int var3_3, boolean var4_4, ArrayList var5_5, SymbolTable var6_6) {
        if (var1_1 instanceof RegExp) {
            this.createRegExpPieces((RegExp)var1_1, var2_2, var3_3, var4_4, var5_5, var6_6);
            return;
        }
        var7_7 = (Atom)var1_1;
        var8_8 = 1;
        while (var8_8 <= var2_2) {
            var5_5.add(new Piece(var7_7, false, false, var6_6));
            ++var8_8;
        }
        if (!var4_4) ** GOTO lbl18
        var5_5.add(new Piece(var7_7, true, true, var6_6));
        return;
lbl-1000:
        // 1 sources

        {
            var5_5.add(new Piece(var7_7, true, false, var6_6));
            ++var8_8;
lbl18:
            // 2 sources

            ** while (var8_8 <= var3_3)
        }
lbl19:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    private void createRegExpPieces(RegExp var1_1, int var2_2, int var3_3, boolean var4_4, ArrayList var5_5, SymbolTable var6_6) {
        var7_7 = 1;
        while (var7_7 <= var2_2) {
            var8_8 = this.expandRegExp(var1_1, false, false, var6_6);
            var5_5.add(var8_8);
            ++var7_7;
        }
        if (!var4_4) ** GOTO lbl17
        var8_8 = this.expandRegExp(var1_1, true, true, var6_6);
        var5_5.add(var8_8);
        return;
lbl-1000:
        // 1 sources

        {
            var8_8 = this.expandRegExp(var1_1, true, false, var6_6);
            var5_5.add(var8_8);
            ++var7_7;
lbl17:
            // 2 sources

            ** while (var7_7 <= var3_3)
        }
lbl18:
        // 1 sources

    }

    protected RegExp expandRegExp(RegExp regExp, boolean bl, boolean bl2, SymbolTable symbolTable) {
        RegExp regExp2 = new RegExp(bl || regExp.isNullable(), bl2, symbolTable);
        Iterator iterator = regExp.expansions();
        while (iterator.hasNext()) {
            ProductionImpl productionImpl = (ProductionImpl)iterator.next();
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
            Object[] objectArray = productionImpl.expansion();
            int n2 = 0;
            while (n2 < objectArray.length) {
                Symbol symbol;
                Symbol symbol2 = (Symbol)objectArray[n2];
                if (symbol2 instanceof EOF) {
                    symbol = symbol2;
                } else if (symbol2 instanceof Piece) {
                    Piece piece = (Piece)symbol2;
                    symbol = new Piece(piece, piece.getAtom(), symbolTable);
                } else {
                    if (!(symbol2 instanceof RegExp)) {
                        throw new CompilerError();
                    }
                    symbol = this.cloneRegEx((RegExp)symbol2, symbolTable);
                }
                arrayList.add(symbol);
                ++n2;
            }
            regExp2.addProduction(new ProductionImpl(arrayList));
        }
        return regExp2;
    }

    protected RegExp cloneRegEx(RegExp regExp, SymbolTable symbolTable) {
        RegExp regExp2 = new RegExp(regExp.isNullable(), regExp.isUnboundedLoopSymbol(), symbolTable);
        regExp2.setProductions(regExp.getProductions());
        return regExp2;
    }

    private int parseInt() {
        int n2 = 0;
        char c;
        while ((c = this.fInput[this.fIndex]) >= '0' && c <= '9') {
            n2 = n2 * 10 + (c - 48);
            ++this.fIndex;
        }
        return n2;
    }

    private boolean isMetaCharacter(char c) {
        switch (c) {
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private boolean isNormalCharacter(char c) {
        return !this.isMetaCharacter(c);
    }

    private Object parseAtom() {
        if (this.isNormalCharacter(this.fInput[this.fIndex])) {
            return new CharAtomImpl(this.fInput[this.fIndex++], this.fSymbolTable);
        }
        if (this.fInput[this.fIndex] == '(') {
            ++this.fIndex;
            RegExp regExp = this.parseRegEx(false);
            this.expect(')');
            return regExp;
        }
        return this.parseCharClass();
    }

    private Atom parseCharClass() {
        if (this.fInput[this.fIndex] == '[') {
            return this.parseCharClassExpr();
        }
        if (this.fInput[this.fIndex] == '.') {
            ++this.fIndex;
            return new Dot(this.fSymbolTable);
        }
        return this.parseCharClassEsc();
    }

    private Atom parseCharClassExpr() {
        this.expect('[');
        Atom atom2 = this.parseCharGroup();
        this.expect(']');
        return atom2;
    }

    private Atom parseCharGroup() {
        Atom atom2;
        if (this.fInput[this.fIndex] == '^') {
            ++this.fIndex;
            atom2 = new NegCharGroupImpl(this.parsePosCharGroup(), this.fSymbolTable);
        } else {
            atom2 = this.parsePosCharGroup();
        }
        if (this.fInput[this.fIndex] == '-') {
            ++this.fIndex;
            Atom atom3 = this.parseCharClassExpr();
            atom2 = new CharClassSub(atom2, atom3, this.fSymbolTable);
        }
        return atom2;
    }

    private boolean endOfPosCharGroup() {
        char c = this.fInput[this.fIndex];
        return c == ']' || c == '-';
    }

    private PosCharGroup parsePosCharGroup() {
        PosCharGroupImpl posCharGroupImpl = new PosCharGroupImpl(this.fSymbolTable);
        boolean bl = true;
        while (!this.endOfPosCharGroup()) {
            PosCharGroupMember posCharGroupMember = this.parseCharRange(bl);
            if (posCharGroupMember == null) {
                posCharGroupMember = this.parseCharClassEsc();
            }
            bl = false;
            posCharGroupImpl.append(posCharGroupMember);
        }
        return posCharGroupImpl;
    }

    private PosCharGroupMember parseCharRange(boolean bl) {
        int n2 = this.fIndex;
        PosCharGroupMember posCharGroupMember = this.parseSeRange();
        if (posCharGroupMember != null) {
            return posCharGroupMember;
        }
        this.fIndex = n2;
        char c = this.fInput[this.fIndex];
        if (c == '\\' || c == '[' || c == ']') {
            return null;
        }
        if (c == '-') {
            if (!bl) {
                return null;
            }
            char c2 = this.fInput[this.fIndex + 1];
            if (c2 != ']' && c2 != '-') {
                return null;
            }
        }
        ++this.fIndex;
        return new CharAtomImpl(c, this.fSymbolTable);
    }

    private PosCharGroupMember parseSeRange() {
        CharAtom charAtom = this.parseCharOrEsc();
        if (charAtom == null) {
            return null;
        }
        if (this.fInput[this.fIndex] == '-') {
            char c;
            ++this.fIndex;
            CharAtom charAtom2 = this.parseCharOrEsc();
            if (charAtom2 == null) {
                --this.fIndex;
                return charAtom;
            }
            char c2 = charAtom.getChar();
            if (c2 == (c = charAtom2.getChar())) {
                return charAtom;
            }
            if (c2 > c) {
                return this.fNullCharacterRange;
            }
            return new CharacterRange(charAtom, charAtom2, this.fSymbolTable);
        }
        return charAtom;
    }

    private CharAtom parseCharOrEsc() {
        switch (this.fInput[this.fIndex]) {
            case '-': 
            case '[': 
            case ']': {
                return null;
            }
            case '\\': {
                return this.parseSingleCharEsc();
            }
        }
        return new CharAtomImpl(this.fInput[this.fIndex++], this.fSymbolTable);
    }

    private CharAtom parseSingleCharEsc() {
        this.expect('\\');
        return this.parseSingleCharEscTail();
    }

    private CharAtom parseSingleCharEscTail() {
        if (this.fInput[this.fIndex - 1] != '\\') {
            throw new CompilerError();
        }
        switch (this.fInput[this.fIndex]) {
            case 'n': {
                ++this.fIndex;
                return new CharAtomImpl('\n', this.fSymbolTable);
            }
            case 'r': {
                ++this.fIndex;
                return new CharAtomImpl('\r', this.fSymbolTable);
            }
            case 't': {
                ++this.fIndex;
                return new CharAtomImpl('\t', this.fSymbolTable);
            }
            case '\\': {
                ++this.fIndex;
                return new CharAtomImpl('\\', this.fSymbolTable);
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                CharAtomImpl charAtomImpl = new CharAtomImpl(this.fInput[this.fIndex], this.fSymbolTable);
                ++this.fIndex;
                return charAtomImpl;
            }
        }
        return null;
    }

    private PosCharGroupMember parseCharClassEsc() {
        this.expect('\\');
        switch (this.fInput[this.fIndex]) {
            case 'p': {
                ++this.fIndex;
                this.expect('{');
                PosCharGroupMember posCharGroupMember = this.parseCharProp(false);
                this.expect('}');
                return posCharGroupMember;
            }
            case 'P': {
                ++this.fIndex;
                this.expect('{');
                PosCharGroupMember posCharGroupMember = this.parseCharProp(true);
                this.expect('}');
                return posCharGroupMember;
            }
            case 's': {
                ++this.fIndex;
                return new SpaceString(false, this.fSymbolTable);
            }
            case 'S': {
                ++this.fIndex;
                return new SpaceString(true, this.fSymbolTable);
            }
            case 'i': {
                ++this.fIndex;
                return new InitialNameCharsString(false, this.fSymbolTable);
            }
            case 'I': {
                ++this.fIndex;
                return new InitialNameCharsString(true, this.fSymbolTable);
            }
            case 'c': {
                ++this.fIndex;
                return new NameCharsString(false, this.fSymbolTable);
            }
            case 'C': {
                ++this.fIndex;
                return new NameCharsString(true, this.fSymbolTable);
            }
            case 'd': {
                ++this.fIndex;
                return new DecimalDigit(false, this.fSymbolTable);
            }
            case 'D': {
                ++this.fIndex;
                return new DecimalDigit(true, this.fSymbolTable);
            }
            case 'w': {
                ++this.fIndex;
                return new WhatEver(false, this.fSymbolTable);
            }
            case 'W': {
                ++this.fIndex;
                return new WhatEver(true, this.fSymbolTable);
            }
        }
        CharAtom charAtom = this.parseSingleCharEscTail();
        if (charAtom == null) {
            throw new CompilerError();
        }
        return charAtom;
    }

    private PosCharGroupMember parseCharProp(boolean bl) {
        switch (this.fInput[this.fIndex++]) {
            case 'L': {
                return this.parseLetters(bl);
            }
            case 'M': {
                return this.parseMarks(bl);
            }
            case 'N': {
                return this.parseNumbers(bl);
            }
            case 'P': {
                return this.parsePunctuation(bl);
            }
            case 'Z': {
                return this.parseSeparators(bl);
            }
            case 'S': {
                return this.parseSymbols(bl);
            }
            case 'C': {
                return this.parseOthers(bl);
            }
            case 'I': {
                this.expect('s');
                return this.parseBlock(bl);
            }
        }
        throw new CompilerError();
    }

    private PosCharGroupMember parseLetters(boolean bl) {
        switch (this.fInput[this.fIndex]) {
            case 'u': {
                ++this.fIndex;
                return new Uppercase(bl, this.fSymbolTable);
            }
            case 'l': {
                ++this.fIndex;
                return new Lowercase(bl, this.fSymbolTable);
            }
            case 't': {
                ++this.fIndex;
                return new Titlecase(bl, this.fSymbolTable);
            }
            case 'm': {
                ++this.fIndex;
                return new Modifier(bl, this.fSymbolTable);
            }
            case 'o': {
                ++this.fIndex;
                return new OtherLetters(bl, this.fSymbolTable);
            }
        }
        return new AllLetters(bl, this.fSymbolTable);
    }

    private PosCharGroupMember parseMarks(boolean bl) {
        switch (this.fInput[this.fIndex]) {
            case 'n': {
                ++this.fIndex;
                return new Nonspacing(bl, this.fSymbolTable);
            }
            case 'c': {
                ++this.fIndex;
                return new SpaceCombining(bl, this.fSymbolTable);
            }
            case 'e': {
                ++this.fIndex;
                return new Enclosing(bl, this.fSymbolTable);
            }
        }
        return new AllMarks(bl, this.fSymbolTable);
    }

    private PosCharGroupMember parseNumbers(boolean bl) {
        switch (this.fInput[this.fIndex]) {
            case 'd': {
                ++this.fIndex;
                return new DecimalDigit(bl, this.fSymbolTable);
            }
            case 'l': {
                ++this.fIndex;
                return new Letter(bl, this.fSymbolTable);
            }
            case 'o': {
                ++this.fIndex;
                return new OtherNumbers(bl, this.fSymbolTable);
            }
        }
        return new AllNumbers(bl, this.fSymbolTable);
    }

    private PosCharGroupMember parsePunctuation(boolean bl) {
        switch (this.fInput[this.fIndex]) {
            case 'c': {
                ++this.fIndex;
                return new Connector(bl, this.fSymbolTable);
            }
            case 'd': {
                ++this.fIndex;
                return new Dash(bl, this.fSymbolTable);
            }
            case 's': {
                ++this.fIndex;
                return new Open(bl, this.fSymbolTable);
            }
            case 'e': {
                ++this.fIndex;
                return new Close(bl, this.fSymbolTable);
            }
            case 'i': {
                ++this.fIndex;
                return new InitialQuote(bl, this.fSymbolTable);
            }
            case 'f': {
                ++this.fIndex;
                return new FinalQuote(bl, this.fSymbolTable);
            }
            case 'o': {
                ++this.fIndex;
                return new OtherPunctuation(bl, this.fSymbolTable);
            }
        }
        return new AllPunctuation(bl, this.fSymbolTable);
    }

    private PosCharGroupMember parseSeparators(boolean bl) {
        switch (this.fInput[this.fIndex]) {
            case 's': {
                ++this.fIndex;
                return new Space(bl, this.fSymbolTable);
            }
            case 'l': {
                ++this.fIndex;
                return new Line(bl, this.fSymbolTable);
            }
            case 'p': {
                ++this.fIndex;
                return new Paragraph(bl, this.fSymbolTable);
            }
        }
        return new AllSeparators(bl, this.fSymbolTable);
    }

    private PosCharGroupMember parseSymbols(boolean bl) {
        switch (this.fInput[this.fIndex]) {
            case 'm': {
                ++this.fIndex;
                return new Math(bl, this.fSymbolTable);
            }
            case 'c': {
                ++this.fIndex;
                return new Currency(bl, this.fSymbolTable);
            }
            case 'k': {
                ++this.fIndex;
                return new Modifier(bl, this.fSymbolTable);
            }
            case 'o': {
                ++this.fIndex;
                return new OtherSymbols(bl, this.fSymbolTable);
            }
        }
        return new AllSymbols(bl, this.fSymbolTable);
    }

    private PosCharGroupMember parseOthers(boolean bl) {
        switch (this.fInput[this.fIndex]) {
            case 'c': {
                ++this.fIndex;
                return new Control(bl, this.fSymbolTable);
            }
            case 'f': {
                ++this.fIndex;
                return new Format(bl, this.fSymbolTable);
            }
            case 'o': {
                ++this.fIndex;
                return new PrivateUse(bl, this.fSymbolTable);
            }
            case 'n': {
                ++this.fIndex;
                return new NotAssigned(bl, this.fSymbolTable);
            }
        }
        return new AllOthers(bl, this.fSymbolTable);
    }

    private PosCharGroupMember parseBlock(boolean bl) {
        int n2 = this.fIndex;
        int n3 = 0;
        while (this.isBlockCharacter(this.fInput[this.fIndex])) {
            ++this.fIndex;
            ++n3;
        }
        if (n3 == 0) {
            throw new CompilerError();
        }
        String string2 = new String(this.fInput, n2, n3);
        return new BlockEscape(string2, bl, this.fSymbolTable);
    }

    private boolean isBlockCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-';
    }

    public RegularExpressionTable table(CodeGenerator codeGenerator) {
        if (this.fTable == null) {
            GrammarSymbolImpl.computeFirstSets(this.fSymbolTable);
            if (this.fRegEx == null) {
                return null;
            }
            this.fRegEx.handleFollowSet(this.fSymbolTable.newBitSet());
            RegularExpressionFSM regularExpressionFSM = new RegularExpressionFSM(this.fSymbolTable, this.fRegEx.firstSet());
            this.fTable = new RegularExpressionTableImpl(regularExpressionFSM, this.fSymbolTable, codeGenerator);
        }
        return this.fTable;
    }
}

