/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.finiteStateMachine.impl;

import com.ibm.xml.xlxp.compiler.CompilerError;
import com.ibm.xml.xlxp.finiteStateMachine.ActualTransitionSymbol;
import com.ibm.xml.xlxp.finiteStateMachine.Factory;
import com.ibm.xml.xlxp.finiteStateMachine.FiniteStateMachine;
import com.ibm.xml.xlxp.finiteStateMachine.State;
import com.ibm.xml.xlxp.finiteStateMachine.Transition;
import com.ibm.xml.xlxp.finiteStateMachine.TransitionSymbol;
import com.ibm.xml.xlxp.finiteStateMachine.impl.CoalesceMapEntry;
import com.ibm.xml.xlxp.finiteStateMachine.impl.StateImpl;
import com.ibm.xml.xlxp.finiteStateMachine.impl.TransitionImpl;
import com.ibm.xml.xlxp.util.BitSet;
import com.ibm.xml.xlxp.util.FreeList;
import com.ibm.xml.xlxp.util.SymbolTable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FiniteStateMachineImpl
implements FiniteStateMachine {
    protected ArrayList fStates = new ArrayList(128);
    private Map fStateMap = new TreeMap();
    private final FreeList fFreedStates = new FreeList(256);
    private final FreeList fFreedTransitions = new FreeList(1024);
    private final FreeList fFreedCoalesceMapEntries = new FreeList(1024);
    protected final Map fCoalesceMap = new TreeMap();
    protected int[] fWorkList = new int[128];
    protected SymbolTable fSymbolTable = null;
    protected final Factory fFactory;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public FiniteStateMachineImpl(Factory factory) {
        this.fFactory = factory;
    }

    public void generate(BitSet bitSet) {
        StateImpl stateImpl = (StateImpl)this.createState(bitSet, 0);
        this.addToMachine(stateImpl);
        int n2 = 0;
        while (n2 < this.fStates.size()) {
            StateImpl stateImpl2 = (StateImpl)this.fStates.get(n2++);
            this.generate(stateImpl2);
            this.resetCoalesceMap();
        }
    }

    public void initialise(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        if (this.fCoalesceMap.size() != 0) {
            throw new CompilerError();
        }
        int n2 = symbolTable.maxId();
        if (n2 >= this.fWorkList.length) {
            this.fWorkList = new int[n2];
        }
    }

    public void releaseObjects() {
        this.fFreedStates.freeObjects(this.fStates);
        this.fStates.clear();
        this.fStateMap.clear();
        this.fSymbolTable = null;
    }

    protected final State createState(BitSet bitSet, int n2) {
        StateImpl stateImpl = (StateImpl)this.fFreedStates.getObject();
        if (stateImpl == null) {
            stateImpl = new StateImpl(this, this.fSymbolTable);
        }
        Object object2 = this.fFactory.createStateInfo();
        stateImpl.initialise(bitSet, n2, object2);
        this.fFactory.initialiseStateInfo(stateImpl);
        return stateImpl;
    }

    public final Transition createTransition(ActualTransitionSymbol actualTransitionSymbol, int n2) {
        TransitionImpl transitionImpl = (TransitionImpl)this.fFreedTransitions.getObject();
        if (transitionImpl == null) {
            Object object2 = this.fFactory.createTransitionInfo();
            transitionImpl = new TransitionImpl(this, object2);
        }
        transitionImpl.initialise(actualTransitionSymbol, (StateImpl)this.fStates.get(n2));
        this.fFactory.initialiseTransitionInfo(transitionImpl);
        return transitionImpl;
    }

    public final void releaseTransitions(Collection collection2) {
        this.fFreedTransitions.freeObjects(collection2);
    }

    protected void generate(StateImpl stateImpl) {
        BitSet bitSet = stateImpl.getWrapperTransitions();
        this.coalesceTransitions(bitSet);
        Iterator iterator = this.fCoalesceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CoalesceMapEntry coalesceMapEntry = (CoalesceMapEntry)entry.getValue();
            ActualTransitionSymbol actualTransitionSymbol = (ActualTransitionSymbol)entry.getKey();
            if (actualTransitionSymbol.isEOF()) {
                stateImpl.markIsFinalState();
                continue;
            }
            BitSet bitSet2 = coalesceMapEntry.followSet();
            int n2 = this.findPreviousMatchingState(bitSet2);
            if (n2 == -1) {
                n2 = this.fStates.size();
                StateImpl stateImpl2 = (StateImpl)this.createState(bitSet2, n2);
                this.addToMachine(stateImpl2);
            }
            stateImpl.setTransition(actualTransitionSymbol, n2);
        }
    }

    protected void resetCoalesceMap() {
        this.fFreedCoalesceMapEntries.freeObjects(this.fCoalesceMap.values());
        this.fCoalesceMap.clear();
    }

    protected void coalesceTransitions(BitSet bitSet) {
        Iterator iterator = this.fSymbolTable.memberIterator(bitSet, this.fWorkList);
        while (iterator.hasNext()) {
            TransitionSymbol transitionSymbol = (TransitionSymbol)iterator.next();
            ActualTransitionSymbol actualTransitionSymbol = transitionSymbol.wrappedSymbol();
            CoalesceMapEntry coalesceMapEntry = (CoalesceMapEntry)this.fCoalesceMap.get(actualTransitionSymbol);
            if (coalesceMapEntry == null) {
                coalesceMapEntry = (CoalesceMapEntry)this.fFreedCoalesceMapEntries.getObject();
                if (coalesceMapEntry != null) {
                    coalesceMapEntry.initialise(this.fSymbolTable);
                } else {
                    coalesceMapEntry = new CoalesceMapEntry(this.fSymbolTable);
                }
                this.fCoalesceMap.put(actualTransitionSymbol, coalesceMapEntry);
            }
            BitSet bitSet2 = coalesceMapEntry.firstSet();
            BitSet bitSet3 = coalesceMapEntry.followSet();
            transitionSymbol.setInBitSet(bitSet2);
            bitSet3.setBits(transitionSymbol.followSet());
        }
    }

    private int findPreviousMatchingState(BitSet bitSet) {
        Integer n2 = (Integer)this.fStateMap.get(bitSet);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.fStates).iterator();
        while (iterator.hasNext()) {
            StateImpl stateImpl = (StateImpl)iterator.next();
            stringBuffer.append("\nstate ").append(stateImpl.index());
            if (stateImpl.isFinalState()) {
                stringBuffer.append("*");
            }
            stringBuffer.append(":").append(stateImpl.toString());
        }
        return stringBuffer.toString();
    }

    public List states() {
        return this.fStates;
    }

    private void addToMachine(StateImpl stateImpl) {
        this.fStates.add(stateImpl);
        this.fStateMap.put(stateImpl.differentiator(), new Integer(stateImpl.index()));
    }
}

