/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.dtm;

import com.ibm.xml.xlxp.internal.s1.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.ByteConversionHandler;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionHandler;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.io.CharConversionException;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XLXPContentBuffer {
    private ArrayList<DataBuffer> m_buffers = new ArrayList();
    private int m_bufferCount;
    private int[] m_offsets;
    private int m_index;
    private int m_textPendingStart = -1;

    public XLXPContentBuffer(int n2, int n3) {
        this.m_buffers.add(null);
        this.m_bufferCount = 1;
        this.m_offsets = ArrayAllocator.newIntArray(1 << n2);
        this.m_index = 1;
    }

    public int charactersFlush(boolean bl, int[] nArray) {
        if (this.m_textPendingStart >= 0) {
            int n2 = this.m_index - this.m_textPendingStart;
            boolean bl2 = false;
            if (bl) {
                bl2 = this.isAllWhitespace(this.m_textPendingStart, n2);
            }
            if (bl2) {
                this.m_index = this.m_textPendingStart;
            } else {
                nArray[0] = this.m_textPendingStart;
                nArray[1] = n2;
            }
            this.m_textPendingStart = -1;
            return bl2 ? 1 : 2;
        }
        return 0;
    }

    public void appendChar32(int n2) {
        if (this.m_textPendingStart == -1) {
            this.m_textPendingStart = this.m_index;
        }
        if (this.m_index + 2 > this.m_offsets.length) {
            this.m_offsets = ArrayAllocator.resizeIntArray(this.m_offsets, this.m_offsets.length << 1);
        }
        if (n2 < 65536) {
            this.m_offsets[this.m_index++] = -1;
            this.m_offsets[this.m_index++] = n2;
        } else {
            this.m_offsets[this.m_index++] = -2;
            this.m_offsets[this.m_index++] = 55296 + ((n2 -= 65536) >> 10) << 16 | 56320 + (n2 & 0x3FF);
        }
    }

    public void appendXMLString(XMLString xMLString) {
        if (this.m_textPendingStart == -1) {
            this.m_textPendingStart = this.m_index;
        }
        if (this.m_index + 5 > this.m_offsets.length) {
            this.m_offsets = ArrayAllocator.resizeIntArray(this.m_offsets, this.m_offsets.length << 1);
        }
        this.m_offsets[this.m_index++] = 0;
        this.m_offsets[this.m_index++] = this.getIndexOfBuffer(xMLString.firstBuffer);
        this.m_offsets[this.m_index++] = xMLString.startOffset;
        this.m_offsets[this.m_index++] = xMLString.length;
        this.m_offsets[this.m_index++] = xMLString.flags;
    }

    private int getIndexOfBuffer(DataBuffer dataBuffer) {
        if (dataBuffer == this.m_buffers.get(this.m_bufferCount - 1)) {
            return this.m_bufferCount - 1;
        }
        for (int i = 1; i < this.m_bufferCount; ++i) {
            if (dataBuffer != this.m_buffers.get(i)) continue;
            return i;
        }
        this.m_buffers.add(dataBuffer);
        return this.m_bufferCount++;
    }

    public void sendBytes(int n2, int n3, ByteConversionHandler byteConversionHandler) {
        int n4 = n2;
        int n5 = n2 + n3;
        while (n4 < n5) {
            int n6;
            int n7;
            int n8 = this.m_offsets[n4];
            if (n8 < 0) {
                int n9;
                if ((n8 = -n8) == 1) {
                    n9 = this.m_offsets[n4 + 1];
                    if (n9 < 128) {
                        byteConversionHandler.receiveByte((byte)n9);
                    } else if (n9 < 2048) {
                        byteConversionHandler.receiveByte((byte)(0xC0 | n9 >> 6));
                        byteConversionHandler.receiveByte((byte)(0x80 | 0x3F & n9));
                    } else {
                        byteConversionHandler.receiveByte((byte)(0xE0 | n9 >> 12));
                        byteConversionHandler.receiveByte((byte)(0x80 | 0x3F & n9 >> 6));
                        byteConversionHandler.receiveByte((byte)(0x80 | 0x3F & n9));
                    }
                } else {
                    assert (n8 == 2);
                    n9 = this.m_offsets[n4 + 1] >> 16;
                    n7 = this.m_offsets[n4 + 1] & 0xFFFF;
                    n6 = (n9 << 10) + n7 + 65536 - 0x3600000 - 56320;
                    byteConversionHandler.receiveByte((byte)(0xF0 | n6 >> 18));
                    byteConversionHandler.receiveByte((byte)(0x80 | 0x3F & n6 >> 12));
                    byteConversionHandler.receiveByte((byte)(0x80 | 0x3F & n6 >> 6));
                    byteConversionHandler.receiveByte((byte)(0x80 | 0x3F & n6));
                }
                n4 += 2;
                continue;
            }
            DataBuffer dataBuffer = this.m_buffers.get(this.m_offsets[n4 + 1]);
            n7 = this.m_offsets[n4 + 2];
            n6 = this.m_offsets[n4 + 3];
            int n10 = this.m_offsets[n4 + 4];
            UTF8Support.sendBytes(dataBuffer, n7, n6, n10, byteConversionHandler);
            n4 += 5;
        }
    }

    public int lengthAsUTF16(int n2, int n3) {
        int n4 = 0;
        int n5 = n2;
        int n6 = n2 + n3;
        while (n5 < n6) {
            int n7 = this.m_offsets[n5];
            if (n7 < 0) {
                n7 = -n7;
                n4 += n7;
                n5 += 2;
                continue;
            }
            if (n7 > 0) {
                n4 += n7;
                n5 += 5;
                continue;
            }
            DataBuffer dataBuffer = this.m_buffers.get(this.m_offsets[n5 + 1]);
            int n8 = this.m_offsets[n5 + 2];
            int n9 = this.m_offsets[n5 + 3];
            int n10 = this.m_offsets[n5 + 4];
            int[] nArray = new int[1];
            try {
                n7 = UTF8Support.lengthAsCharacters(dataBuffer, n8, n9, n10, nArray);
                this.m_offsets[n5] = n7 += nArray[0];
                n4 += n7;
            }
            catch (CharConversionException charConversionException) {
                throw new IOExceptionWrapper(charConversionException);
            }
            n5 += 5;
        }
        return n4;
    }

    public void convertToChars(int n2, int n3, CharConversionHandler charConversionHandler) {
        int n4 = n2;
        int n5 = n2 + n3;
        while (n4 < n5) {
            int n6 = this.m_offsets[n4];
            if (n6 < 0) {
                if ((n6 = -n6) == 1) {
                    charConversionHandler.receiveChar((char)this.m_offsets[n4 + 1]);
                } else {
                    assert (n6 == 2);
                    charConversionHandler.receiveChar((char)(this.m_offsets[n4 + 1] >> 16));
                    charConversionHandler.receiveChar((char)(this.m_offsets[n4 + 1] & 0xFFFF));
                }
                n4 += 2;
                continue;
            }
            DataBuffer dataBuffer = this.m_buffers.get(this.m_offsets[n4 + 1]);
            int n7 = this.m_offsets[n4 + 2];
            int n8 = this.m_offsets[n4 + 3];
            int n9 = this.m_offsets[n4 + 4];
            try {
                UTF8Support.convertBytesToChars(dataBuffer, n7, n8, n9, charConversionHandler);
            }
            catch (CharConversionException charConversionException) {
                throw new IOExceptionWrapper(charConversionException);
            }
            n4 += 5;
        }
    }

    public char[] toCharArray(int n2, int n3) {
        int n4 = this.lengthAsUTF16(n2, n3);
        char[] cArray = ArrayAllocator.newCharArray(n4);
        CharConversionHandler.FixedLengthCharArrayHandler fixedLengthCharArrayHandler = new CharConversionHandler.FixedLengthCharArrayHandler(cArray);
        this.convertToChars(n2, n3, fixedLengthCharArrayHandler);
        return cArray;
    }

    public boolean isAllWhitespace(int n2, int n3) {
        int n4 = n2;
        int n5 = n2 + n3;
        while (n4 < n5) {
            int n6 = this.m_offsets[n4];
            if (n6 < 0) {
                if ((n6 = -n6) == 1) {
                    int n7 = this.m_offsets[n4 + 1];
                    if (n7 != 32 && n7 != 10 && n7 != 9 && n7 != 13) {
                        return false;
                    }
                } else {
                    return false;
                }
                n4 += 2;
                continue;
            }
            DataBuffer dataBuffer = this.m_buffers.get(this.m_offsets[n4 + 1]);
            int n8 = this.m_offsets[n4 + 2];
            int n9 = this.m_offsets[n4 + 3];
            int n10 = this.m_offsets[n4 + 4];
            if ((n10 & 1) != 0) {
                return false;
            }
            if ((n10 & 2) == 0) {
                try {
                    if (!UTF8Support.isAllWhitespace(dataBuffer, n8, n9, n10)) {
                        int n11 = n4 + 4;
                        this.m_offsets[n11] = this.m_offsets[n11] | 1;
                        return false;
                    }
                    int n12 = n4 + 4;
                    this.m_offsets[n12] = this.m_offsets[n12] | 2;
                }
                catch (CharConversionException charConversionException) {
                    throw new IOExceptionWrapper(charConversionException);
                }
            }
            n4 += 5;
        }
        return true;
    }
}

