/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax;

import com.ibm.xml.xlxp.internal.s1.api.stax.EmptyLocation;
import com.ibm.xml.xlxp.internal.s1.api.stax.JavaXNamespaceContext;
import com.ibm.xml.xlxp.internal.s1.api.stax.StAXImplProperties;
import com.ibm.xml.xlxp.internal.s1.api.stax.XMLStreamReaderBase;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.EntityDeclarationImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.events.NotationDeclarationImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class DOMStreamReaderImpl
extends XMLStreamReaderBase {
    private StAXImplProperties fProperties;
    private JavaXNamespaceContext fNamespaceContext = new JavaXNamespaceContext();
    private ArrayList<Node> fAttributes;
    private String fDocumentSystemId;
    private String fTextContent;
    private Text fCoalescedCharacters;
    private StringBuilder fCoalescedBuffer;
    private Node fRoot;
    private Node fCurrent;
    private boolean fCurrentDone;
    private boolean fNextDone;
    private boolean fIsLevel3;

    DOMStreamReaderImpl(Node node2, String string2, StAXImplProperties stAXImplProperties) throws XMLStreamException {
        this.fNSContext = this.fNamespaceContext;
        this.fAttributes = new ArrayList();
        this.fCoalescedCharacters = null;
        this.fCoalescedBuffer = new StringBuilder();
        this.setNode(node2, string2, stAXImplProperties);
    }

    void setNode(Node node2, String string2, StAXImplProperties stAXImplProperties) throws XMLStreamException {
        this.fProperties = stAXImplProperties;
        this.fNamespaceContext.reset();
        this.fCurrentDone = false;
        this.fRoot = node2;
        short s = this.fRoot.getNodeType();
        this.fCurrent = s == 9 ? node2 : node2.getOwnerDocument();
        this.fIsLevel3 = ((Document)this.fCurrent).getImplementation().hasFeature("Core", "3.0");
        if (!this.fIsLevel3) {
            this.fCoalescedBuffer.setLength(0);
        }
        Document document2 = (Document)this.fCurrent;
        this.fDocumentSystemId = string2;
        if (this.fIsLevel3) {
            this.fVersion = document2.getXmlVersion();
            this.fXMLEncoding = document2.getXmlEncoding();
            this.fStandalone = document2.getXmlStandalone();
            this.fInputEncoding = document2.getInputEncoding();
            if (string2 == null) {
                this.fDocumentSystemId = document2.getDocumentURI();
            }
        } else {
            this.fVersion = null;
            this.fXMLEncoding = null;
            this.fInputEncoding = null;
            this.fStandalone = false;
        }
        this.enterCurrentNode();
    }

    private boolean enterCurrentNode() throws XMLStreamException {
        short s = this.fCurrent.getNodeType();
        switch (s) {
            case 1: {
                if (this.fCurrentDone) {
                    this.fEventType = 2;
                    break;
                }
                this.fNamespaceContext.startScope();
                this.fAttributes.clear();
                NamedNodeMap namedNodeMap = this.fCurrent.getAttributes();
                int n2 = namedNodeMap == null ? 0 : namedNodeMap.getLength();
                for (int i = 0; i < n2; ++i) {
                    Node node2 = namedNodeMap.item(i);
                    if ("http://www.w3.org/2000/xmlns/".equals(node2.getNamespaceURI())) {
                        String string2 = node2.getNodeName().length() == "xmlns".length() ? "" : node2.getLocalName();
                        this.fNamespaceContext.declareNamespace(string2, node2.getNodeValue());
                        continue;
                    }
                    this.fAttributes.add(node2);
                }
                if (this.fCurrent == this.fRoot) {
                    this.processAncestorNamespaceDeclarations();
                }
                this.fEventType = 1;
                break;
            }
            case 3: {
                if (this.fProperties.isCoalescing) {
                    this.coalesceCharacters();
                    this.fEventType = 4;
                    break;
                }
                if (this.fIsLevel3) {
                    this.fEventType = ((Text)this.fCurrent).isElementContentWhitespace() ? 6 : 4;
                    break;
                }
                this.fEventType = 4;
                break;
            }
            case 4: {
                if (this.fProperties.isCoalescing) {
                    this.coalesceCharacters();
                    this.fEventType = 4;
                    break;
                }
                this.fEventType = 12;
                break;
            }
            case 5: {
                if (this.fProperties.isReplacingEntityReferences) {
                    return false;
                }
                this.fEventType = 9;
                this.coalesceChildText(this.fCurrent);
                this.fCurrentDone = true;
                break;
            }
            case 7: {
                this.fEventType = 3;
                break;
            }
            case 8: {
                this.fEventType = 5;
                break;
            }
            case 11: {
                return false;
            }
            case 9: {
                this.fEventType = this.fCurrentDone ? 8 : 7;
                break;
            }
            case 10: {
                Object object2;
                this.fEventType = 11;
                DocumentType documentType = (DocumentType)this.fCurrent;
                this.fRootName = documentType.getName();
                this.fPubId = documentType.getPublicId();
                this.fSysId = documentType.getSystemId();
                NamedNodeMap namedNodeMap = documentType.getEntities();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    EntityDeclarationImpl entityDeclarationImpl;
                    Entity entity2 = (Entity)namedNodeMap.item(i);
                    if (entity2.getNotationName() == null) {
                        if (entity2.getSystemId() == null) {
                            if (this.fIsLevel3) {
                                object2 = entity2.getTextContent();
                            } else {
                                this.coalesceChildText(entity2);
                                object2 = this.fCoalescedBuffer.toString();
                            }
                            entityDeclarationImpl = new EntityDeclarationImpl(entity2.getNodeName(), (String)object2);
                            this.fEntityDecls.add(entityDeclarationImpl);
                            continue;
                        }
                        entityDeclarationImpl = new EntityDeclarationImpl(entity2.getNodeName(), entity2.getPublicId(), entity2.getSystemId());
                        this.fEntityDecls.add(entityDeclarationImpl);
                        continue;
                    }
                    entityDeclarationImpl = new EntityDeclarationImpl(entity2.getNodeName(), entity2.getPublicId(), entity2.getSystemId(), entity2.getNotationName());
                    this.fEntityDecls.add(entityDeclarationImpl);
                }
                NamedNodeMap namedNodeMap2 = documentType.getNotations();
                for (int i = 0; i < namedNodeMap2.getLength(); ++i) {
                    object2 = (Notation)namedNodeMap2.item(i);
                    NotationDeclarationImpl notationDeclarationImpl = new NotationDeclarationImpl(object2.getNodeName(), object2.getPublicId(), object2.getSystemId());
                    this.fNotationDecls.add(notationDeclarationImpl);
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void processAncestorNamespaceDeclarations() {
        HashSet<String> hashSet = null;
        for (Node node2 = this.fRoot.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            if (1 != node2.getNodeType()) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            int n2 = namedNodeMap == null ? 0 : namedNodeMap.getLength();
            block1: for (int i = 0; i < n2; ++i) {
                Node node3 = namedNodeMap.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(node3.getNamespaceURI())) continue;
                String string2 = node3.getNodeName().length() == "xmlns".length() ? "" : node3.getLocalName();
                String string3 = node3.getNodeValue();
                if (!"".equals(string3)) {
                    if (hashSet != null && hashSet.contains(string2)) continue;
                    int n3 = this.fNamespaceContext.getNamespaceCount();
                    for (int j = 0; j < n3; ++j) {
                        if (string2.equals(this.fNamespaceContext.getNamespacePrefix(j))) continue block1;
                    }
                    this.fNamespaceContext.declareNamespace(string2, string3);
                    continue;
                }
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(string2);
            }
        }
    }

    private void coalesceCharacters() {
        this.fCoalescedCharacters = (Text)this.fCurrent;
        if (!this.fProperties.isReplacingEntityReferences || !this.fIsLevel3) {
            this.fCoalescedBuffer.setLength(0);
            this.fCoalescedBuffer.append(((Text)this.fCurrent).getNodeValue());
        }
        boolean bl = false;
        while (!bl) {
            Node node2 = this.nextNode();
            if (node2 != null) {
                short s = node2.getNodeType();
                if (s == 5) {
                    if (this.fProperties.isReplacingEntityReferences) {
                        this.fCurrent = node2;
                        this.fCurrentDone = this.fNextDone;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (s == 3 || s == 4) {
                    this.fCurrent = node2;
                    this.fCurrentDone = this.fNextDone;
                    if (this.fProperties.isReplacingEntityReferences && this.fIsLevel3) continue;
                    this.fCoalescedBuffer.append(((Text)this.fCurrent).getNodeValue());
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
    }

    private void coalesceChildText(Node node2) {
        this.fCoalescedBuffer.setLength(0);
        boolean bl = true;
        for (Node node3 = node2.getFirstChild(); bl && node3 != null; node3 = node3.getNextSibling()) {
            short s = node3.getNodeType();
            if (s == 3 || s == 4) {
                this.fCoalescedBuffer.append(((Text)node3).getNodeValue());
                continue;
            }
            bl = false;
        }
        if (!bl) {
            this.fCoalescedBuffer.setLength(0);
        }
    }

    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
        }
        if (this.fEventType == 2) {
            this.fNamespaceContext.endScope();
        }
        this.fTextContent = null;
        do {
            this.fCurrent = this.nextNode();
            this.fCurrentDone = this.fNextDone;
        } while (!this.enterCurrentNode());
        return this.fEventType;
    }

    private Node nextNode() {
        if (this.fEventType == 8) {
            return null;
        }
        Node node2 = null;
        this.fNextDone = false;
        if (this.fCurrent == this.fRoot && this.fCurrentDone) {
            if (this.fCurrent.getNodeType() != 9) {
                this.fNextDone = true;
                return this.fRoot.getOwnerDocument();
            }
            return null;
        }
        if (this.fCurrent.getNodeType() == 9 && this.fRoot.getNodeType() != 9) {
            node2 = ((Document)this.fCurrent).getDoctype();
            if (node2 != null) {
                return node2;
            }
            return this.fRoot;
        }
        if (this.fCurrent.getNodeType() == 10 && this.fRoot.getNodeType() != 9) {
            return this.fRoot;
        }
        short s = this.fCurrent.getNodeType();
        if (!this.fCurrentDone) {
            node2 = this.fCurrent.getFirstChild();
            if (node2 != null) {
                return node2;
            }
            if (this.isNotifyOnLeavingType(s)) {
                this.fNextDone = true;
                return this.fCurrent;
            }
        }
        Node node3 = this.fCurrent;
        while (node3 != this.fRoot) {
            node2 = node3.getNextSibling();
            if (node2 != null) {
                return node2;
            }
            if (!this.isNotifyOnLeavingType((node3 = node3.getParentNode()).getNodeType())) continue;
            this.fNextDone = true;
            return node3;
        }
        this.fNextDone = true;
        return this.fRoot.getOwnerDocument();
    }

    private boolean isNotifyOnLeavingType(int n2) {
        return n2 == 1 || n2 == 9;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.fEventType != 8;
    }

    public void close() {
        super.close();
        this.fCurrent = null;
        this.fRoot = null;
        this.fNamespaceContext.reset();
        this.fAttributes.clear();
        this.fCoalescedCharacters = null;
        this.fTextContent = null;
        this.fCurrentDone = false;
        this.fPoolableHelper.returnToPool();
    }

    public boolean isWhiteSpace() {
        if (this.fEventType == 4) {
            String string2 = this.getText();
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == ' ' || c == '\n' || c == '\t' || c == '\r') continue;
                return false;
            }
            return true;
        }
        return this.fEventType == 6;
    }

    public String getAttributeValue(String string2, String string3) {
        super.getAttributeValue(string2, string3);
        Element element2 = (Element)this.fCurrent;
        Attr attr2 = this.fProperties.isNamespaceAware ? element2.getAttributeNodeNS(string2, string3) : element2.getAttributeNode(string3);
        return attr2 == null ? null : attr2.getNodeValue();
    }

    public int getAttributeCount() {
        super.getAttributeCount();
        return this.fAttributes.size();
    }

    public QName getAttributeName(int n2) {
        super.getAttributeName(n2);
        if (n2 >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Attr attr2 = (Attr)this.fAttributes.get(n2);
        return this.createQName(attr2);
    }

    public String getAttributeNamespace(int n2) {
        super.getAttributeNamespace(n2);
        if (n2 >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.fProperties.isNamespaceAware) {
            return null;
        }
        Attr attr2 = (Attr)this.fAttributes.get(n2);
        return attr2.getNamespaceURI();
    }

    public String getAttributeLocalName(int n2) {
        super.getAttributeLocalName(n2);
        if (n2 >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Attr attr2 = (Attr)this.fAttributes.get(n2);
        if (this.fProperties.isNamespaceAware) {
            return attr2.getLocalName();
        }
        return attr2.getName();
    }

    public String getAttributePrefix(int n2) {
        super.getAttributePrefix(n2);
        if (n2 >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.fProperties.isNamespaceAware) {
            return null;
        }
        Attr attr2 = (Attr)this.fAttributes.get(n2);
        return attr2.getPrefix();
    }

    public String getAttributeType(int n2) {
        TypeInfo typeInfo;
        super.getAttributeType(n2);
        if (n2 >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Attr attr2 = (Attr)this.fAttributes.get(n2);
        String string2 = this.fIsLevel3 ? ((typeInfo = attr2.getSchemaTypeInfo()) != null && "http://www.w3.org/TR/REC-xml".equals(typeInfo.getTypeNamespace()) ? typeInfo.getTypeName() : "CDATA") : "CDATA";
        return string2;
    }

    public String getAttributeValue(int n2) {
        super.getAttributeValue(n2);
        if (n2 >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Attr attr2 = (Attr)this.fAttributes.get(n2);
        return attr2.getNodeValue();
    }

    public boolean isAttributeSpecified(int n2) {
        super.isAttributeSpecified(n2);
        if (n2 >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        Attr attr2 = (Attr)this.fAttributes.get(n2);
        return attr2.getSpecified();
    }

    public int getNamespaceCount() {
        super.getNamespaceCount();
        return this.fNamespaceContext.getNamespaceCount();
    }

    public String getNamespacePrefix(int n2) {
        super.getNamespacePrefix(n2);
        if (n2 >= this.getNamespaceCount()) {
            throw new IndexOutOfBoundsException();
        }
        String string2 = this.fNamespaceContext.getNamespacePrefix(n2);
        return "".equals(string2) ? null : string2;
    }

    public String getNamespaceURI(int n2) {
        super.getNamespaceURI(n2);
        if (n2 >= this.getNamespaceCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.fNamespaceContext.getNamespaceURI(n2);
    }

    public String getText() {
        if (this.fTextContent != null) {
            return this.fTextContent;
        }
        this.fTextContent = this.prepareText();
        return this.fTextContent;
    }

    private String prepareText() {
        if (this.fEventType == 4) {
            if (this.fProperties.isCoalescing) {
                if (this.fProperties.isReplacingEntityReferences && this.fIsLevel3) {
                    return this.fCoalescedCharacters.getWholeText();
                }
                return this.fCoalescedBuffer.toString();
            }
            return this.fCurrent.getNodeValue();
        }
        if (this.fEventType == 11) {
            DocumentType documentType = (DocumentType)this.fCurrent;
            return documentType.getInternalSubset();
        }
        if (this.fEventType == 9) {
            if (this.fCoalescedBuffer.length() > 0) {
                return this.fCoalescedBuffer.toString();
            }
            return null;
        }
        if (this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fCurrent.getNodeValue();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return null;
    }

    public char[] getTextCharacters() {
        super.getTextCharacters();
        return this.getText().toCharArray();
    }

    public int getTextCharacters(int n2, char[] cArray, int n3, int n4) throws XMLStreamException {
        super.getTextCharacters(n2, cArray, n3, n4);
        String string2 = this.getText();
        int n5 = string2.length();
        if (n5 < n2 + n4) {
            n4 = n5 - n2;
        }
        string2.getChars(n2, n2 + n4, cArray, n3);
        return n4;
    }

    public int getTextLength() {
        super.getTextLength();
        return this.getText().length();
    }

    public Location getLocation() {
        if (this.fLocation != null) {
            return this.fLocation;
        }
        this.fLocation = new EmptyLocation(){

            public String getSystemId() {
                return DOMStreamReaderImpl.this.fDocumentSystemId;
            }
        };
        return this.fLocation;
    }

    public QName getName() {
        super.getName();
        return this.createQName(this.fCurrent);
    }

    public String getLocalName() {
        super.getLocalName();
        if (this.fEventType == 9) {
            return this.fCurrent.getNodeName();
        }
        return this.fCurrent.getLocalName();
    }

    public String getNamespaceURI() {
        super.getNamespaceURI();
        if (this.fProperties.isNamespaceAware) {
            return this.fCurrent.getNamespaceURI();
        }
        return null;
    }

    public String getPrefix() {
        super.getPrefix();
        if (this.fProperties.isNamespaceAware) {
            return this.fCurrent.getPrefix();
        }
        return null;
    }

    public boolean standaloneSet() {
        super.standaloneSet();
        return this.fStandalone;
    }

    public String getPITarget() {
        super.getPITarget();
        return this.fCurrent.getNodeName();
    }

    public String getPIData() {
        super.getPIData();
        return this.fCurrent.getNodeValue();
    }

    private QName createQName(Node node2) {
        QName qName;
        if (this.fProperties.isNamespaceAware) {
            String string2 = node2.getPrefix();
            if (string2 == null) {
                string2 = "";
            }
            qName = new QName(node2.getNamespaceURI(), node2.getLocalName(), string2);
        } else {
            qName = new QName(node2.getLocalName());
        }
        return qName;
    }
}

