/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax;

import com.ibm.xml.xlxp.internal.s1.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.util.ArrayList;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.XMLEvent;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
class XMLFilteredEventReaderImpl
implements XMLEventReader,
XMLStreamConstants {
    private XMLEventReader fSourceEventReader;
    private EventFilter fEventFilter;
    private XMLEvent fXMLEvent;
    private ArrayList<XMLEvent> fEventCache;

    XMLFilteredEventReaderImpl(XMLEventReader xMLEventReader, EventFilter eventFilter) throws XMLStreamException {
        this.fSourceEventReader = xMLEventReader;
        this.fEventFilter = eventFilter;
        this.fEventCache = new ArrayList();
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent xMLEvent;
        do {
            if (this.fEventCache.size() > 0) {
                xMLEvent = this.fEventCache.get(0);
                this.fEventCache.remove(0);
                continue;
            }
            xMLEvent = this.fSourceEventReader.nextEvent();
        } while (this.fEventFilter != null && !this.fEventFilter.accept(xMLEvent));
        this.fXMLEvent = xMLEvent;
        return this.fXMLEvent;
    }

    public boolean hasNext() {
        if (this.fEventCache.size() > 0) {
            return true;
        }
        while (this.fSourceEventReader.hasNext()) {
            try {
                XMLEvent xMLEvent = this.fSourceEventReader.nextEvent();
                if (this.fEventFilter != null && !this.fEventFilter.accept(xMLEvent)) continue;
                this.fEventCache.add(xMLEvent);
                return true;
            }
            catch (XMLStreamException xMLStreamException) {
                return false;
            }
        }
        return false;
    }

    public XMLEvent peek() throws XMLStreamException {
        XMLEvent xMLEvent;
        int n2 = 0;
        int n3 = this.fEventCache.size();
        do {
            if (n2 < n3) {
                xMLEvent = this.fEventCache.get(n2++);
                continue;
            }
            if (!this.fSourceEventReader.hasNext()) {
                return null;
            }
            xMLEvent = this.fSourceEventReader.nextEvent();
            this.fEventCache.add(xMLEvent);
        } while (this.fEventFilter != null && !this.fEventFilter.accept(xMLEvent));
        return xMLEvent;
    }

    public String getElementText() throws XMLStreamException {
        if (this.fXMLEvent == null || this.fXMLEvent.getEventType() != 1) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 14));
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            XMLEvent xMLEvent;
            if (this.fEventCache.size() > 0) {
                xMLEvent = this.fEventCache.get(0);
                this.fEventCache.remove(0);
            } else {
                xMLEvent = this.fSourceEventReader.nextEvent();
            }
            int n2 = xMLEvent.getEventType();
            if (n2 == 4 || n2 == 12 || n2 == 6) {
                stringBuilder.append(xMLEvent.asCharacters().getData());
                continue;
            }
            if (n2 == 9) {
                String string2;
                EntityDeclaration entityDeclaration = ((EntityReference)xMLEvent).getDeclaration();
                if (entityDeclaration == null || (string2 = entityDeclaration.getReplacementText()) == null) continue;
                stringBuilder.append(string2);
                continue;
            }
            if (n2 == 5 || n2 == 3) continue;
            this.fXMLEvent = xMLEvent;
            if (n2 == 2) {
                return stringBuilder.toString();
            }
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 15));
        }
    }

    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent xMLEvent;
        while (this.fEventCache.size() > 0) {
            xMLEvent = this.fEventCache.get(0);
            this.fEventCache.remove(0);
            int n2 = xMLEvent.getEventType();
            if (!(n2 != 1 && n2 != 2 || this.fEventFilter != null && !this.fEventFilter.accept(xMLEvent))) {
                this.fXMLEvent = xMLEvent;
                return this.fXMLEvent;
            }
            if (n2 == 5 || n2 == 3 || n2 == 6 || (n2 == 4 || n2 == 12) && xMLEvent.asCharacters().isWhiteSpace()) continue;
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 16));
        }
        do {
            xMLEvent = this.fSourceEventReader.nextTag();
        } while (this.fEventFilter != null && !this.fEventFilter.accept(xMLEvent));
        this.fXMLEvent = xMLEvent;
        return this.fXMLEvent;
    }

    public Object getProperty(String string2) throws IllegalArgumentException {
        if (this.fXMLEvent != null && this.fXMLEvent.getEventType() == 11) {
            if ("javax.xml.stream.entities".equals(string2)) {
                return ((DTD)this.fXMLEvent).getEntities();
            }
            if ("javax.xml.stream.notations".equals(string2)) {
                return ((DTD)this.fXMLEvent).getNotations();
            }
        }
        return this.fSourceEventReader.getProperty(string2);
    }

    public void close() throws XMLStreamException {
        this.fSourceEventReader.close();
        this.fEventCache.clear();
        this.fXMLEvent = null;
    }

    public void remove() {
        StAXMessageProvider.throwUnsupportedOperationException(StAXMessageProvider.createMessage(null, 34, "remove()"));
    }

    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException xMLStreamException) {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
            return null;
        }
    }
}

