/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax;

import com.ibm.xml.xlxp.internal.s1.api.stax.DOMStreamReaderImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.EmptyLocation;
import com.ibm.xml.xlxp.internal.s1.api.stax.JavaXNamespaceContext;
import com.ibm.xml.xlxp.internal.s1.api.stax.SAXStreamReaderImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.StAXImplProperties;
import com.ibm.xml.xlxp.internal.s1.api.stax.StAXLogger;
import com.ibm.xml.xlxp.internal.s1.api.stax.XMLEventReaderImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.XMLFilteredEventReaderImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.XMLFilteredStreamReaderImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.XMLStreamReaderImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.XMLStreamReaderProxy;
import com.ibm.xml.xlxp.internal.s1.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.internal.s1.api.util.Pool;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.io.InputStream;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XMLInputFactoryImpl
extends XMLInputFactory {
    private static final String COPYRIGHT_YEARS = "Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final boolean USE_STREAM_FOR_SAX_SOURCE_WITHOUT_XML_READER = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("com.ibm.xml.xlxp.internal.s1.api.stax.XMLInputFactoryImpl.useStreamForSAXSourceWithoutXMLReader");
            }
            catch (SecurityException securityException) {
                return Boolean.FALSE;
            }
        }
    });
    protected static final boolean ENABLE_LOGGING = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("com.ibm.xml.xlxp.internal.s1.api.stax.XMLInputFactoryImpl.useXMLStreamReaderTracer");
            }
            catch (SecurityException securityException) {
                return Boolean.FALSE;
            }
        }
    });
    protected static final boolean TRACE_THREAD_ID_CHANGES = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("com.ibm.xml.xlxp.internal.s1.api.stax.XMLInputFactoryImpl.traceXMLStreamReaderThreadIdChanges");
            }
            catch (SecurityException securityException) {
                return Boolean.FALSE;
            }
        }
    });
    protected StAXImplProperties fProperties = new StAXImplProperties();
    protected static final ClosedXMLStreamReader fgClosedStreamReader = new ClosedXMLStreamReader();
    protected static final EndDocumentXMLStreamReader fgEndDocumentXMLStreamReader = new EndDocumentXMLStreamReader();
    protected static final EmptyLocation fgEmptyLocation = new EmptyLocation();
    protected static final NamespaceContext fgEmptyNSContext = new JavaXNamespaceContext();
    private static final Pool fgStreamReaders = new Pool();
    private static final Pool fgDOMReaders = new Pool();
    private static final Pool fgSAXReaders = new Pool();

    protected XMLStreamReader createProxyFor(XMLStreamReader xMLStreamReader) {
        if (ENABLE_LOGGING) {
            return new XMLStreamReaderTracer(xMLStreamReader);
        }
        return new XMLStreamReaderProxyImpl(xMLStreamReader);
    }

    protected Pool getStreamReadersPool() {
        return fgStreamReaders;
    }

    protected XMLStreamReaderImpl createNewXMLStreamReaderImpl(InputSource inputSource) throws XMLStreamException {
        return new XMLStreamReaderImpl(inputSource, this.fProperties);
    }

    protected void setDocumentEntity(XMLStreamReaderImpl xMLStreamReaderImpl, InputSource inputSource) throws XMLStreamException {
        xMLStreamReaderImpl.setDocumentEntity(inputSource, this.fProperties);
    }

    protected XMLStreamReaderImpl createXMLStreamReader(InputSource inputSource) throws XMLStreamException {
        this.fProperties.given = true;
        Pool pool = this.getStreamReadersPool();
        XMLStreamReaderImpl xMLStreamReaderImpl = (XMLStreamReaderImpl)pool.get();
        if (xMLStreamReaderImpl == null) {
            xMLStreamReaderImpl = this.createNewXMLStreamReaderImpl(inputSource);
            pool.assignToPool(xMLStreamReaderImpl);
        } else {
            try {
                this.setDocumentEntity(xMLStreamReaderImpl, inputSource);
            }
            catch (XMLStreamException xMLStreamException) {
                xMLStreamReaderImpl.close();
                throw xMLStreamException;
            }
        }
        return xMLStreamReaderImpl;
    }

    private XMLStreamReader createXMLStreamReader(Node node2, String string2) throws XMLStreamException {
        this.fProperties.given = true;
        DOMStreamReaderImpl dOMStreamReaderImpl = (DOMStreamReaderImpl)fgDOMReaders.get();
        if (dOMStreamReaderImpl == null) {
            dOMStreamReaderImpl = new DOMStreamReaderImpl(node2, string2, this.fProperties);
            fgDOMReaders.assignToPool(dOMStreamReaderImpl);
        } else {
            try {
                dOMStreamReaderImpl.setNode(node2, string2, this.fProperties);
            }
            catch (XMLStreamException xMLStreamException) {
                dOMStreamReaderImpl.close();
                throw xMLStreamException;
            }
        }
        return dOMStreamReaderImpl;
    }

    private XMLStreamReader createXMLStreamReader(InputSource inputSource, XMLReader xMLReader) throws XMLStreamException {
        this.fProperties.given = true;
        SAXStreamReaderImpl sAXStreamReaderImpl = (SAXStreamReaderImpl)fgSAXReaders.get();
        if (sAXStreamReaderImpl == null) {
            sAXStreamReaderImpl = new SAXStreamReaderImpl(inputSource, xMLReader, this.fProperties);
            fgSAXReaders.assignToPool(sAXStreamReaderImpl);
        } else {
            try {
                sAXStreamReaderImpl.setSource(inputSource, xMLReader, this.fProperties);
            }
            catch (XMLStreamException xMLStreamException) {
                sAXStreamReaderImpl.close();
                throw xMLStreamException;
            }
        }
        return sAXStreamReaderImpl;
    }

    private XMLStreamReader createXMLStreamReaderInternal(Reader reader) throws XMLStreamException {
        return this.createXMLStreamReader(new InputSource(reader));
    }

    private XMLStreamReader createXMLStreamReaderInternal(Source source) throws XMLStreamException {
        if (source instanceof StreamSource) {
            InputSource inputSource = SAXSource.sourceToInputSource(source);
            return this.createXMLStreamReader(inputSource);
        }
        if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            return this.createXMLStreamReader(dOMSource.getNode(), dOMSource.getSystemId());
        }
        if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            InputSource inputSource = sAXSource.getInputSource();
            XMLReader xMLReader = sAXSource.getXMLReader();
            if (xMLReader == null && USE_STREAM_FOR_SAX_SOURCE_WITHOUT_XML_READER) {
                return this.createXMLStreamReader(inputSource);
            }
            return this.createXMLStreamReader(inputSource, xMLReader);
        }
        StAXMessageProvider.throwUnsupportedOperationException(StAXMessageProvider.createMessage(null, 0, "createXMLStreamReader(Source)"));
        return null;
    }

    private XMLStreamReader createXMLStreamReaderInternal(InputStream inputStream) throws XMLStreamException {
        return this.createXMLStreamReader(new InputSource(inputStream));
    }

    private XMLStreamReader createXMLStreamReaderInternal(InputStream inputStream, String string2) throws XMLStreamException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setEncoding(string2);
        return this.createXMLStreamReader(inputSource);
    }

    private XMLStreamReader createXMLStreamReaderInternal(String string2, InputStream inputStream) throws XMLStreamException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string2);
        return this.createXMLStreamReader(inputSource);
    }

    private XMLStreamReader createXMLStreamReaderInternal(String string2, Reader reader) throws XMLStreamException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string2);
        return this.createXMLStreamReader(inputSource);
    }

    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(reader));
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(source));
    }

    public XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(inputStream));
    }

    public XMLStreamReader createXMLStreamReader(InputStream inputStream, String string2) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(inputStream, string2));
    }

    public XMLStreamReader createXMLStreamReader(String string2, InputStream inputStream) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(string2, inputStream));
    }

    public XMLStreamReader createXMLStreamReader(String string2, Reader reader) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamReaderInternal(string2, reader));
    }

    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReaderInternal(reader));
    }

    public XMLEventReader createXMLEventReader(String string2, Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReaderInternal(string2, reader));
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return new XMLEventReaderImpl(this, xMLStreamReader);
    }

    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(source));
    }

    public XMLEventReader createXMLEventReader(InputStream inputStream) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(inputStream));
    }

    public XMLEventReader createXMLEventReader(InputStream inputStream, String string2) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(inputStream, string2));
    }

    public XMLEventReader createXMLEventReader(String string2, InputStream inputStream) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(string2, inputStream));
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader xMLStreamReader, StreamFilter streamFilter) throws XMLStreamException {
        return new XMLFilteredStreamReaderImpl(xMLStreamReader, streamFilter);
    }

    public XMLEventReader createFilteredReader(XMLEventReader xMLEventReader, EventFilter eventFilter) throws XMLStreamException {
        return new XMLFilteredEventReaderImpl(xMLEventReader, eventFilter);
    }

    public XMLResolver getXMLResolver() {
        return this.fProperties.resolver;
    }

    public void setXMLResolver(XMLResolver xMLResolver) {
        if (this.fProperties.resolver != xMLResolver) {
            if (this.fProperties.given) {
                this.fProperties = this.fProperties.clone();
            }
            this.fProperties.resolver = xMLResolver;
        }
    }

    public XMLReporter getXMLReporter() {
        return this.fProperties.reporter;
    }

    public void setXMLReporter(XMLReporter xMLReporter) {
        if (this.fProperties.reporter != xMLReporter) {
            if (this.fProperties.given) {
                this.fProperties = this.fProperties.clone();
            }
            this.fProperties.reporter = xMLReporter;
        }
    }

    public void setProperty(String string2, Object object2) throws IllegalArgumentException {
        if (string2 == null) {
            StAXMessageProvider.throwNullPointerException(StAXMessageProvider.createMessage(null, 31));
        }
        if ("javax.xml.stream.isValidating".equals(string2)) {
            if (object2 instanceof Boolean) {
                if (((Boolean)object2).booleanValue()) {
                    StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 4, object2, "javax.xml.stream.isValidating"));
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.isValidating", "Boolean"));
            }
        } else if ("javax.xml.stream.isNamespaceAware".equals(string2)) {
            if (object2 instanceof Boolean) {
                boolean bl = (Boolean)object2;
                if (this.fProperties.isNamespaceAware != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = this.fProperties.clone();
                    }
                    this.fProperties.isNamespaceAware = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.isNamespaceAware", "Boolean"));
            }
        } else if ("javax.xml.stream.isCoalescing".equals(string2)) {
            if (object2 instanceof Boolean) {
                boolean bl = (Boolean)object2;
                if (this.fProperties.isCoalescing != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = this.fProperties.clone();
                    }
                    this.fProperties.isCoalescing = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.isCoalescing", "Boolean"));
            }
        } else if ("javax.xml.stream.isReplacingEntityReferences".equals(string2)) {
            if (object2 instanceof Boolean) {
                boolean bl = (Boolean)object2;
                if (this.fProperties.isReplacingEntityReferences != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = this.fProperties.clone();
                    }
                    this.fProperties.isReplacingEntityReferences = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.isReplacingEntityReferences", "Boolean"));
            }
        } else if ("javax.xml.stream.isSupportingExternalEntities".equals(string2)) {
            if (object2 instanceof Boolean) {
                boolean bl = (Boolean)object2;
                if (this.fProperties.isSupportingExternalEntities != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = this.fProperties.clone();
                    }
                    this.fProperties.isSupportingExternalEntities = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.isSupportingExternalEntities", "Boolean"));
            }
        } else if ("javax.xml.stream.isSupportingLocationCoordinates".equals(string2)) {
            if (object2 instanceof Boolean) {
                boolean bl = (Boolean)object2;
                if (this.fProperties.isSupportingLocationCoordinates != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = this.fProperties.clone();
                    }
                    this.fProperties.isSupportingLocationCoordinates = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.isSupportingLocationCoordinates", "Boolean"));
            }
        } else if ("javax.xml.stream.supportDTD".equals(string2)) {
            if (object2 instanceof Boolean) {
                boolean bl = (Boolean)object2;
                if (this.fProperties.supportDTD != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = this.fProperties.clone();
                    }
                    this.fProperties.supportDTD = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.supportDTD", "Boolean"));
            }
        } else if ("javax.xml.stream.reporter".equals(string2)) {
            if (object2 == null || object2 instanceof XMLReporter) {
                if (this.fProperties.reporter != object2) {
                    if (this.fProperties.given) {
                        this.fProperties = this.fProperties.clone();
                    }
                    this.fProperties.reporter = (XMLReporter)object2;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.reporter", "XMLReporter"));
            }
        } else if ("javax.xml.stream.resolver".equals(string2)) {
            if (object2 == null || object2 instanceof XMLResolver) {
                if (this.fProperties.resolver != object2) {
                    if (this.fProperties.given) {
                        this.fProperties = this.fProperties.clone();
                    }
                    this.fProperties.resolver = (XMLResolver)object2;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.resolver", "XMLResolver"));
            }
        } else if ("javax.xml.stream.allocator".equals(string2)) {
            if (object2 == null || object2 instanceof XMLEventAllocator) {
                if (this.fProperties.allocator != object2) {
                    if (this.fProperties.given) {
                        this.fProperties = this.fProperties.clone();
                    }
                    this.fProperties.allocator = (XMLEventAllocator)object2;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.allocator", "XMLEventAllocator"));
            }
        } else if ("javax.xml.stream.resolve.dtd.uris".equals(string2)) {
            if (object2 instanceof Boolean) {
                boolean bl = (Boolean)object2;
                if (this.fProperties.resolveDTDURIs != bl) {
                    if (this.fProperties.given) {
                        this.fProperties = this.fProperties.clone();
                    }
                    this.fProperties.resolveDTDURIs = bl;
                }
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 5, object2, "javax.xml.stream.resolve.dtd.uris", "Boolean"));
            }
        } else {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 3, string2));
        }
    }

    public Object getProperty(String string2) throws IllegalArgumentException {
        if ("javax.xml.stream.isValidating".equals(string2)) {
            return Boolean.FALSE;
        }
        if ("javax.xml.stream.isNamespaceAware".equals(string2)) {
            return this.fProperties.isNamespaceAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isCoalescing".equals(string2)) {
            return this.fProperties.isCoalescing ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isReplacingEntityReferences".equals(string2)) {
            return this.fProperties.isReplacingEntityReferences ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isSupportingExternalEntities".equals(string2)) {
            return this.fProperties.isSupportingExternalEntities ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.supportDTD".equals(string2)) {
            return this.fProperties.supportDTD ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.reporter".equals(string2)) {
            return this.fProperties.reporter;
        }
        if ("javax.xml.stream.resolver".equals(string2)) {
            return this.fProperties.resolver;
        }
        if ("javax.xml.stream.allocator".equals(string2)) {
            return this.fProperties.allocator;
        }
        if ("javax.xml.stream.resolve.dtd.uris".equals(string2)) {
            return this.fProperties.resolveDTDURIs ? Boolean.TRUE : Boolean.FALSE;
        }
        StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 3, string2));
        return null;
    }

    public boolean isPropertySupported(String string2) {
        if ("javax.xml.stream.isValidating".equals(string2)) {
            return true;
        }
        if ("javax.xml.stream.isNamespaceAware".equals(string2)) {
            return true;
        }
        if ("javax.xml.stream.isCoalescing".equals(string2)) {
            return true;
        }
        if ("javax.xml.stream.isReplacingEntityReferences".equals(string2)) {
            return true;
        }
        if ("javax.xml.stream.isSupportingExternalEntities".equals(string2)) {
            return true;
        }
        if ("javax.xml.stream.supportDTD".equals(string2)) {
            return true;
        }
        if ("javax.xml.stream.reporter".equals(string2)) {
            return true;
        }
        if ("javax.xml.stream.resolver".equals(string2)) {
            return true;
        }
        return "javax.xml.stream.allocator".equals(string2);
    }

    public void setEventAllocator(XMLEventAllocator xMLEventAllocator) {
        if (this.fProperties.allocator != xMLEventAllocator) {
            if (this.fProperties.given) {
                this.fProperties = this.fProperties.clone();
            }
            this.fProperties.allocator = xMLEventAllocator;
        }
    }

    public XMLEventAllocator getEventAllocator() {
        return this.fProperties.allocator;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class ClosedXMLStreamReader
    implements XMLStreamReader {
        public Object getProperty(String string2) throws IllegalArgumentException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public int next() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        public void require(int n2, String string2, String string3) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public String getElementText() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public int nextTag() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        public boolean hasNext() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        public void close() throws XMLStreamException {
        }

        public String getNamespaceURI(String string2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public boolean isStartElement() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        public boolean isEndElement() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        public boolean isCharacters() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        public boolean isWhiteSpace() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        public String getAttributeValue(String string2, String string3) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public int getAttributeCount() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        public QName getAttributeName(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getAttributeNamespace(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getAttributeLocalName(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getAttributePrefix(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getAttributeType(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getAttributeValue(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public boolean isAttributeSpecified(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        public int getNamespaceCount() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        public String getNamespacePrefix(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getNamespaceURI(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public NamespaceContext getNamespaceContext() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public int getEventType() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        public String getText() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public char[] getTextCharacters() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public int getTextCharacters(int n2, char[] cArray, int n3, int n4) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        public int getTextStart() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        public int getTextLength() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return 0;
        }

        public String getEncoding() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public boolean hasText() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        public Location getLocation() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public QName getName() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getLocalName() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public boolean hasName() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        public String getNamespaceURI() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getPrefix() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getVersion() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public boolean isStandalone() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        public boolean standaloneSet() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return false;
        }

        public String getCharacterEncodingScheme() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getPITarget() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public String getPIData() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class XMLStreamReaderTracer
    extends XMLStreamReaderProxyImpl {
        StAXLogger fLogger = new StAXLogger();

        public XMLStreamReaderTracer(XMLStreamReader xMLStreamReader) {
            super(xMLStreamReader);
        }

        public void writeStAXProfile(String string2) {
            this.fLogger.writeStAXProfile(string2);
        }

        public void writeReadableProfile(String string2) {
            this.fLogger.writeReadableProfile(string2);
        }

        public Object getProperty(String string2) throws IllegalArgumentException {
            this.fLogger.log(0, string2);
            Object object2 = super.getProperty(string2);
            this.fLogger.logReturn(object2);
            return object2;
        }

        public int next() throws XMLStreamException {
            int n2;
            this.fLogger.log(1);
            try {
                n2 = super.next();
            }
            catch (XMLStreamException xMLStreamException) {
                this.fLogger.logException(xMLStreamException);
                throw xMLStreamException;
            }
            catch (RuntimeException runtimeException) {
                this.fLogger.logException(runtimeException);
                throw runtimeException;
            }
            this.fLogger.logReturn(n2);
            return n2;
        }

        public void require(int n2, String string2, String string3) throws XMLStreamException {
            this.fLogger.log(2, new Object[]{n2, string2, string3});
            super.require(n2, string2, string3);
            this.fLogger.logReturn();
        }

        public String getElementText() throws XMLStreamException {
            this.fLogger.log(3);
            String string2 = super.getElementText();
            this.fLogger.logReturn(string2);
            return string2;
        }

        public int nextTag() throws XMLStreamException {
            this.fLogger.log(4);
            int n2 = super.nextTag();
            this.fLogger.logReturn(n2);
            return n2;
        }

        public boolean hasNext() throws XMLStreamException {
            this.fLogger.log(5);
            boolean bl = super.hasNext();
            this.fLogger.logReturn(bl);
            return bl;
        }

        public void close() throws XMLStreamException {
            this.fLogger.log(6);
            this.fLogger.logReturn();
            super.close();
        }

        public String getNamespaceURI(String string2) {
            this.fLogger.log(7, string2);
            String string3 = super.getNamespaceURI(string2);
            this.fLogger.logReturn(string3);
            return string3;
        }

        public boolean isStartElement() {
            this.fLogger.log(8);
            boolean bl = super.isStartElement();
            this.fLogger.logReturn(bl);
            return bl;
        }

        public boolean isEndElement() {
            this.fLogger.log(9);
            boolean bl = super.isEndElement();
            this.fLogger.logReturn(bl);
            return bl;
        }

        public boolean isCharacters() {
            this.fLogger.log(10);
            boolean bl = super.isCharacters();
            this.fLogger.logReturn(bl);
            return bl;
        }

        public boolean isWhiteSpace() {
            this.fLogger.log(11);
            boolean bl = super.isWhiteSpace();
            this.fLogger.logReturn(bl);
            return bl;
        }

        public String getAttributeValue(String string2, String string3) {
            this.fLogger.log(12, string2, string3);
            String string4 = super.getAttributeValue(string2, string3);
            this.fLogger.logReturn(string4);
            return string4;
        }

        public int getAttributeCount() {
            this.fLogger.log(13);
            int n2 = super.getAttributeCount();
            this.fLogger.logReturn(n2);
            return n2;
        }

        public QName getAttributeName(int n2) {
            this.fLogger.log(14, n2);
            QName qName = super.getAttributeName(n2);
            this.fLogger.logReturn(qName);
            return qName;
        }

        public String getAttributeNamespace(int n2) {
            this.fLogger.log(15, n2);
            String string2 = super.getAttributeNamespace(n2);
            this.fLogger.logReturn(string2);
            return string2;
        }

        public String getAttributeLocalName(int n2) {
            this.fLogger.log(16, n2);
            String string2 = super.getAttributeLocalName(n2);
            this.fLogger.logReturn(string2);
            return string2;
        }

        public String getAttributePrefix(int n2) {
            this.fLogger.log(17, n2);
            String string2 = super.getAttributePrefix(n2);
            this.fLogger.logReturn(string2);
            return string2;
        }

        public String getAttributeType(int n2) {
            this.fLogger.log(18, n2);
            String string2 = super.getAttributeType(n2);
            this.fLogger.logReturn(string2);
            return string2;
        }

        public String getAttributeValue(int n2) {
            this.fLogger.log(19, n2);
            String string2 = super.getAttributeValue(n2);
            this.fLogger.logReturn(string2);
            return string2;
        }

        public boolean isAttributeSpecified(int n2) {
            this.fLogger.log(20, n2);
            boolean bl = super.isAttributeSpecified(n2);
            this.fLogger.logReturn(bl);
            return bl;
        }

        public int getNamespaceCount() {
            this.fLogger.log(21);
            int n2 = super.getNamespaceCount();
            this.fLogger.logReturn(n2);
            return n2;
        }

        public String getNamespacePrefix(int n2) {
            this.fLogger.log(22, n2);
            String string2 = super.getNamespacePrefix(n2);
            this.fLogger.logReturn(string2);
            return string2;
        }

        public String getNamespaceURI(int n2) {
            this.fLogger.log(23, n2);
            String string2 = super.getNamespaceURI(n2);
            this.fLogger.logReturn(string2);
            return string2;
        }

        public NamespaceContext getNamespaceContext() {
            this.fLogger.log(25);
            NamespaceContext namespaceContext = super.getNamespaceContext();
            this.fLogger.logReturn(namespaceContext);
            return namespaceContext;
        }

        public int getEventType() {
            int n2;
            this.fLogger.log(24);
            try {
                n2 = super.getEventType();
            }
            catch (RuntimeException runtimeException) {
                this.fLogger.logException(runtimeException);
                throw runtimeException;
            }
            this.fLogger.logReturn(n2);
            return n2;
        }

        public String getText() {
            this.fLogger.log(26);
            String string2 = super.getText();
            this.fLogger.logReturn(string2);
            return string2;
        }

        public char[] getTextCharacters() {
            this.fLogger.log(27);
            char[] cArray = super.getTextCharacters();
            int n2 = super.getTextStart();
            int n3 = super.getTextLength();
            this.fLogger.logReturn(new String(cArray, n2, n3));
            return cArray;
        }

        public int getTextCharacters(int n2, char[] cArray, int n3, int n4) throws XMLStreamException {
            this.fLogger.log(28, new Object[]{n2, "[charArray]", n3, n4});
            int n5 = super.getTextCharacters(n2, cArray, n3, n4);
            this.fLogger.logReturn(n5);
            return n5;
        }

        public int getTextStart() {
            this.fLogger.log(29);
            int n2 = super.getTextStart();
            this.fLogger.logReturn(n2);
            return n2;
        }

        public int getTextLength() {
            this.fLogger.log(30);
            int n2 = super.getTextLength();
            this.fLogger.logReturn(n2);
            return n2;
        }

        public String getEncoding() {
            this.fLogger.log(31);
            String string2 = super.getEncoding();
            this.fLogger.logReturn(string2);
            return string2;
        }

        public boolean hasText() {
            this.fLogger.log(32);
            boolean bl = super.hasText();
            this.fLogger.logReturn(bl);
            return bl;
        }

        public Location getLocation() {
            this.fLogger.log(33);
            Location location = super.getLocation();
            this.fLogger.logReturn(location);
            return location;
        }

        public QName getName() {
            this.fLogger.log(34);
            QName qName = super.getName();
            this.fLogger.logReturn(qName);
            return qName;
        }

        public String getLocalName() {
            this.fLogger.log(35);
            String string2 = super.getLocalName();
            this.fLogger.logReturn(string2);
            return string2;
        }

        public boolean hasName() {
            this.fLogger.log(36);
            boolean bl = super.hasName();
            this.fLogger.logReturn(bl);
            return bl;
        }

        public String getNamespaceURI() {
            this.fLogger.log(37);
            String string2 = super.getNamespaceURI();
            this.fLogger.logReturn(string2);
            return string2;
        }

        public String getPrefix() {
            this.fLogger.log(38);
            String string2 = super.getPrefix();
            this.fLogger.logReturn(string2);
            return string2;
        }

        public String getVersion() {
            this.fLogger.log(39);
            String string2 = super.getVersion();
            this.fLogger.logReturn(string2);
            return string2;
        }

        public boolean isStandalone() {
            this.fLogger.log(40);
            boolean bl = super.isStandalone();
            this.fLogger.logReturn(bl);
            return bl;
        }

        public boolean standaloneSet() {
            this.fLogger.log(41);
            boolean bl = super.standaloneSet();
            this.fLogger.logReturn(bl);
            return bl;
        }

        public String getCharacterEncodingScheme() {
            this.fLogger.log(42);
            String string2 = super.getCharacterEncodingScheme();
            this.fLogger.logReturn(string2);
            return string2;
        }

        public String getPITarget() {
            this.fLogger.log(43);
            String string2 = super.getPITarget();
            this.fLogger.logReturn(string2);
            return string2;
        }

        public String getPIData() {
            this.fLogger.log(44);
            String string2 = super.getPIData();
            this.fLogger.logReturn(string2);
            return string2;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class EndDocumentXMLStreamReader
    implements XMLStreamReader {
        private EndDocumentXMLStreamReader() {
        }

        public Object getProperty(String string2) throws IllegalArgumentException {
            if (string2 == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 9));
            }
            return null;
        }

        public int next() throws XMLStreamException {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
            return 0;
        }

        public void require(int n2, String string2, String string3) throws XMLStreamException {
            if (n2 == 8) {
                if (string2 != null) {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string2, ""));
                } else if (string3 != null) {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 13, string3, ""));
                }
            } else {
                StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 11, n2, 8));
            }
        }

        public String getElementText() throws XMLStreamException {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 14));
            return null;
        }

        public int nextTag() throws XMLStreamException {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
            return 0;
        }

        public boolean hasNext() throws XMLStreamException {
            return false;
        }

        public void close() throws XMLStreamException {
        }

        public String getNamespaceURI(String string2) {
            if (string2 == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
                return null;
            }
            if ("xml".equals(string2)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if ("xmlns".equals(string2)) {
                return "http://www.w3.org/2000/xmlns/";
            }
            return null;
        }

        public boolean isStartElement() {
            return false;
        }

        public boolean isEndElement() {
            return false;
        }

        public boolean isCharacters() {
            return false;
        }

        public boolean isWhiteSpace() {
            return false;
        }

        public String getAttributeValue(String string2, String string3) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        public int getAttributeCount() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return 0;
        }

        public QName getAttributeName(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        public String getAttributeNamespace(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        public String getAttributeLocalName(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        public String getAttributePrefix(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        public String getAttributeType(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        public String getAttributeValue(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }

        public boolean isAttributeSpecified(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return false;
        }

        public int getNamespaceCount() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
            return 0;
        }

        public String getNamespacePrefix(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
            return null;
        }

        public String getNamespaceURI(int n2) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
            return null;
        }

        public NamespaceContext getNamespaceContext() {
            return fgEmptyNSContext;
        }

        public int getEventType() {
            return 8;
        }

        public String getText() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
            return null;
        }

        public char[] getTextCharacters() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
            return null;
        }

        public int getTextCharacters(int n2, char[] cArray, int n3, int n4) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
            return 0;
        }

        public int getTextStart() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
            return 0;
        }

        public int getTextLength() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
            return 0;
        }

        public String getEncoding() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
            return null;
        }

        public boolean hasText() {
            return false;
        }

        public Location getLocation() {
            return fgEmptyLocation;
        }

        public QName getName() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
            return null;
        }

        public String getLocalName() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 22));
            return null;
        }

        public boolean hasName() {
            return false;
        }

        public String getNamespaceURI() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
            return null;
        }

        public String getPrefix() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
            return null;
        }

        public String getVersion() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
            return null;
        }

        public boolean isStandalone() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
            return false;
        }

        public boolean standaloneSet() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
            return false;
        }

        public String getCharacterEncodingScheme() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
            return null;
        }

        public String getPITarget() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 23));
            return null;
        }

        public String getPIData() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 23));
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    protected static class XMLStreamReaderProxyImpl
    implements XMLStreamReaderProxy {
        protected XMLStreamReader fStreamReader;
        private final long fInitialThreadId;
        private long fLastThreadId = -1L;
        private int fEventType;
        protected Object fUserData;

        public XMLStreamReaderProxyImpl(XMLStreamReader xMLStreamReader) {
            this.fStreamReader = xMLStreamReader;
            this.fLastThreadId = this.fInitialThreadId = Thread.currentThread().getId();
            this.fEventType = -1;
        }

        private void checkThreadId() {
            if (TRACE_THREAD_ID_CHANGES && Thread.currentThread().getId() != this.fLastThreadId) {
                long l = this.fLastThreadId;
                this.fLastThreadId = Thread.currentThread().getId();
                System.out.println("XMLStreamReaderProxyImpl[" + this.fInitialThreadId + "]: Thread.currentThread().getId(): " + l + " -> " + this.fLastThreadId);
            }
        }

        public XMLStreamReader getReader() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader;
        }

        public void setReader(XMLStreamReader xMLStreamReader) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            this.fStreamReader = xMLStreamReader;
        }

        public Object getUserData() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fUserData;
        }

        public Object setUserData(Object object2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            Object object3 = this.fUserData;
            this.fUserData = object2;
            return object3;
        }

        public Object getProperty(String string2) throws IllegalArgumentException {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getProperty(string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int next() throws XMLStreamException {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            this.fEventType = this.fStreamReader.next();
            if (this.fEventType == 8) {
                XMLStreamReader xMLStreamReader = null;
                XMLStreamReaderProxyImpl xMLStreamReaderProxyImpl = this;
                synchronized (xMLStreamReaderProxyImpl) {
                    if (this.fEventType == 8) {
                        xMLStreamReader = this.fStreamReader;
                        this.fStreamReader = fgEndDocumentXMLStreamReader;
                    }
                }
                if (xMLStreamReader != null) {
                    xMLStreamReader.close();
                }
            }
            return this.fEventType;
        }

        public void require(int n2, String string2, String string3) throws XMLStreamException {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            this.fStreamReader.require(n2, string2, string3);
        }

        public String getElementText() throws XMLStreamException {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            String string2 = this.fStreamReader.getElementText();
            this.fEventType = this.fStreamReader.getEventType();
            return string2;
        }

        public int nextTag() throws XMLStreamException {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            try {
                this.fEventType = this.fStreamReader.nextTag();
                return this.fEventType;
            }
            catch (XMLStreamException xMLStreamException) {
                this.fEventType = this.fStreamReader.getEventType();
                throw xMLStreamException;
            }
        }

        public boolean hasNext() throws XMLStreamException {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            if (this.fEventType >= 0) {
                return this.fEventType != 8;
            }
            return this.fStreamReader.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws XMLStreamException {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            if (this.fStreamReader != fgClosedStreamReader) {
                XMLStreamReader xMLStreamReader = null;
                XMLStreamReaderProxyImpl xMLStreamReaderProxyImpl = this;
                synchronized (xMLStreamReaderProxyImpl) {
                    if (this.fStreamReader != fgClosedStreamReader) {
                        xMLStreamReader = this.fStreamReader;
                        this.fStreamReader = fgClosedStreamReader;
                        this.fEventType = -1;
                    }
                }
                if (xMLStreamReader != null) {
                    xMLStreamReader.close();
                }
            }
        }

        public String getNamespaceURI(String string2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getNamespaceURI(string2);
        }

        public boolean isStartElement() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            if (this.fEventType == 1) {
                return true;
            }
            if (this.fEventType >= 0) {
                return false;
            }
            return this.fStreamReader.isStartElement();
        }

        public boolean isEndElement() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            if (this.fEventType == 2) {
                return true;
            }
            if (this.fEventType >= 0) {
                return false;
            }
            return this.fStreamReader.isEndElement();
        }

        public boolean isCharacters() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            if (this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6) {
                return true;
            }
            if (this.fEventType >= 0) {
                return false;
            }
            return this.fStreamReader.isCharacters();
        }

        public boolean isWhiteSpace() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            if (this.fEventType == 6) {
                return true;
            }
            return this.fStreamReader.isWhiteSpace();
        }

        public String getAttributeValue(String string2, String string3) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getAttributeValue(string2, string3);
        }

        public int getAttributeCount() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getAttributeCount();
        }

        public QName getAttributeName(int n2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getAttributeName(n2);
        }

        public String getAttributeNamespace(int n2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getAttributeNamespace(n2);
        }

        public String getAttributeLocalName(int n2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getAttributeLocalName(n2);
        }

        public String getAttributePrefix(int n2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getAttributePrefix(n2);
        }

        public String getAttributeType(int n2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getAttributeType(n2);
        }

        public String getAttributeValue(int n2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getAttributeValue(n2);
        }

        public boolean isAttributeSpecified(int n2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.isAttributeSpecified(n2);
        }

        public int getNamespaceCount() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getNamespaceCount();
        }

        public String getNamespacePrefix(int n2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getNamespacePrefix(n2);
        }

        public String getNamespaceURI(int n2) {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getNamespaceURI(n2);
        }

        public NamespaceContext getNamespaceContext() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getNamespaceContext();
        }

        public int getEventType() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            if (this.fEventType >= 0) {
                return this.fEventType;
            }
            return this.fStreamReader.getEventType();
        }

        public String getText() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getText();
        }

        public char[] getTextCharacters() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getTextCharacters();
        }

        public int getTextCharacters(int n2, char[] cArray, int n3, int n4) throws XMLStreamException {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getTextCharacters(n2, cArray, n3, n4);
        }

        public int getTextStart() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getTextStart();
        }

        public int getTextLength() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getTextLength();
        }

        public String getEncoding() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getEncoding();
        }

        public boolean hasText() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.hasText();
        }

        public Location getLocation() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getLocation();
        }

        public QName getName() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getName();
        }

        public String getLocalName() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getLocalName();
        }

        public boolean hasName() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.hasName();
        }

        public String getNamespaceURI() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getNamespaceURI();
        }

        public String getPrefix() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getPrefix();
        }

        public String getVersion() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getVersion();
        }

        public boolean isStandalone() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.isStandalone();
        }

        public boolean standaloneSet() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.standaloneSet();
        }

        public String getCharacterEncodingScheme() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getCharacterEncodingScheme();
        }

        public String getPITarget() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getPITarget();
        }

        public String getPIData() {
            if (TRACE_THREAD_ID_CHANGES) {
                this.checkThreadId();
            }
            return this.fStreamReader.getPIData();
        }

        protected void finalize() throws Throwable {
            if (this.fStreamReader instanceof SAXStreamReaderImpl) {
                ((SAXStreamReaderImpl)this.fStreamReader).endParsing();
            }
            super.finalize();
        }
    }
}

