/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax;

import com.ibm.xml.xlxp.internal.s1.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.internal.s1.api.util.Pool;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
abstract class XMLStreamWriterBase
implements XMLStreamWriter,
Pool.Poolable {
    private static final String PREFIX_PREFIX = "sp_";
    private static final short STATE_BAD = 0;
    private static final short STATE_START = 1;
    private static final short STATE_EMPTY = 2;
    private short fStartElementState;
    private boolean fRepairingNamespaces;
    protected StAXNamespaceContext fNamespaceContext;
    protected StAXNamespaceContext fDeclaredNamespaces;
    private int fNextPrefixNum;
    private HashSet<String> fUsedPrefixes;
    protected boolean fIsEmptyState;
    protected Pool.PoolableHelper fPoolableHelper = new Pool.PoolableHelper(this);
    protected String fDTDRoot;
    protected String fDTDPubId;
    protected String fDTDSysId;
    private static final int DTD_STATE_NONE = 1;
    private static final int DTD_STATE_EXPECTING_ROOTNAME = 2;
    private static final int DTD_STATE_EXPECTING_PUBLIC_ID = 3;
    private static final int DTD_STATE_EXPECTING_SYSTEM_ID = 4;

    public XMLStreamWriterBase() throws XMLStreamException {
        this.fUsedPrefixes = new HashSet();
        this.fNamespaceContext = new StAXNamespaceContext();
    }

    public Pool.PoolableHelper getPoolableHelper() {
        return this.fPoolableHelper;
    }

    protected final void checkFinishStartElement() throws XMLStreamException {
        if (this.fStartElementState != 0) {
            this.doFinishStartElement();
        }
    }

    private final void doFinishStartElement() throws XMLStreamException {
        this.fStartElementState = 0;
        if (this.fRepairingNamespaces) {
            for (int i = this.fDeclaredNamespaces.fMappingSize; i > this.fDeclaredNamespaces.fScopes[this.fDeclaredNamespaces.fScope]; i -= 2) {
                String string2 = this.fDeclaredNamespaces.fMapping[i - 2];
                String string3 = this.fDeclaredNamespaces.fMapping[i - 1];
                this.handleNamespace(string2, string3);
            }
        }
        this.finishStartElement();
        if (this.fIsEmptyState) {
            this.writeEndElement();
            this.fIsEmptyState = false;
        }
        if (this.fRepairingNamespaces) {
            this.fUsedPrefixes.clear();
        }
    }

    protected abstract void handleStartElement(String var1, String var2, String var3) throws XMLStreamException;

    protected abstract void handleAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    protected abstract void handleNamespace(String var1, String var2) throws XMLStreamException;

    protected abstract void handleEndElement() throws XMLStreamException;

    protected abstract boolean atRootContext();

    protected abstract void finishStartElement() throws XMLStreamException;

    private void beginStartElement(short s, String string2, String string3, String string4) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string2 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
        }
        if (string4 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
        }
        if (string3 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 45));
        }
        if (string2.equals("")) {
            string2 = "";
        }
        this.fStartElementState = s;
        this.fIsEmptyState = this.fStartElementState == 2;
        this.fNamespaceContext.startScope();
        if (this.fRepairingNamespaces) {
            this.fDeclaredNamespaces.startScope();
            if (this.elementNamespaceNeedsRepair(string2, string4)) {
                string2 = this.repairNamespace(string2, string4, true);
            }
            this.fUsedPrefixes.add(string2);
        }
        this.handleStartElement(string2, string3, string4);
    }

    protected void reset(boolean bl) {
        this.fRepairingNamespaces = bl;
        if (this.fRepairingNamespaces) {
            if (this.fDeclaredNamespaces == null) {
                this.fDeclaredNamespaces = new StAXNamespaceContext();
            } else {
                this.fDeclaredNamespaces.reset();
            }
        }
        this.fNamespaceContext.reset();
        this.fNextPrefixNum = 0;
        this.fStartElementState = 0;
        this.fIsEmptyState = false;
        this.fUsedPrefixes.clear();
    }

    public void close() throws XMLStreamException {
        this.checkFinishStartElement();
        this.fNamespaceContext.reset();
    }

    private String generateNextPrefix() {
        String string2;
        String string3;
        do {
            string2 = PREFIX_PREFIX + this.fNextPrefixNum;
            ++this.fNextPrefixNum;
        } while ((string3 = this.fNamespaceContext.getNamespaceURI(string2)) != null);
        return string2;
    }

    public String getPrefix(String string2) throws XMLStreamException {
        if (string2 == null) {
            string2 = "";
        }
        return this.fNamespaceContext.getPrefix(string2);
    }

    public void setPrefix(String string2, String string3) throws XMLStreamException {
        if (string2 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
        }
        if (string3 == null) {
            string3 = "";
        }
        this.fNamespaceContext.setPrefix(string2, string3);
    }

    public void setDefaultNamespace(String string2) throws XMLStreamException {
        this.setPrefix("", string2);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        if (namespaceContext == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 51));
        }
        this.fNamespaceContext.setRootContext(namespaceContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public Object getProperty(String string2) throws IllegalArgumentException {
        if (string2 != null) {
            if (string2.equals("javax.xml.stream.isRepairingNamespaces")) {
                return this.fRepairingNamespaces ? Boolean.TRUE : Boolean.FALSE;
            }
            if (string2.equals("javax.xml.stream.XMLStreamWriter.isSetPrefixBeforeStartElement")) {
                return Boolean.FALSE;
            }
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 6, string2));
            return null;
        }
        StAXMessageProvider.throwNullPointerException(StAXMessageProvider.createMessage(null, 31));
        return null;
    }

    public void flush() throws XMLStreamException {
        this.checkFinishStartElement();
    }

    public void writeStartElement(String string2) throws XMLStreamException {
        this.writeStartElement("", string2, "");
    }

    public void writeStartElement(String string2, String string3) throws XMLStreamException {
        String string4 = this.fNamespaceContext.getPrefix(string2);
        if (string4 == null) {
            if (!this.fRepairingNamespaces) {
                StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 29, string2));
            } else {
                string4 = "";
            }
        }
        this.writeStartElement(string4, string3, string2);
    }

    public void writeStartElement(String string2, String string3, String string4) throws XMLStreamException {
        this.beginStartElement((short)1, string2, string3, string4);
    }

    public void writeEmptyElement(String string2) throws XMLStreamException {
        this.writeEmptyElement("", string2, "");
    }

    public void writeEmptyElement(String string2, String string3) throws XMLStreamException {
        String string4 = this.fNamespaceContext.getPrefix(string2);
        if (string4 == null) {
            if (!this.fRepairingNamespaces) {
                StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 29, string2));
            } else {
                string4 = "";
            }
        }
        this.writeEmptyElement(string4, string3, string2);
    }

    public void writeEmptyElement(String string2, String string3, String string4) throws XMLStreamException {
        this.beginStartElement((short)2, string2, string3, string4);
    }

    public void writeAttribute(String string2, String string3) throws XMLStreamException {
        this.writeAttribute("", "", string2, string3);
    }

    public void writeAttribute(String string2, String string3, String string4) throws XMLStreamException {
        this.writeAttribute(this.fNamespaceContext.getPrefix(string2), string2, string3, string4);
    }

    public void writeAttribute(String string2, String string3, String string4, String string5) throws XMLStreamException {
        if (this.fStartElementState == 0) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 42));
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.fRepairingNamespaces) {
            if (this.attributeNamespaceNeedsRepair(string2, string3)) {
                string2 = this.repairNamespace(string2, string3, false);
            }
            this.fUsedPrefixes.add(string2);
        } else if (!string3.equals("") && this.fNamespaceContext.getPrefix(string3) == null) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 29, string3));
        }
        this.handleAttribute(string2, string3, string4, string5);
    }

    public void writeDefaultNamespace(String string2) throws XMLStreamException {
        this.writeNamespace("", string2);
    }

    public void writeNamespace(String string2, String string3) throws XMLStreamException {
        if (this.fStartElementState == 0) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 43));
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string2 == null || string2.equals("xmlns")) {
            string2 = "";
        }
        if (this.fRepairingNamespaces) {
            if (!this.fUsedPrefixes.contains(string2)) {
                this.fNamespaceContext.setPrefix(string2, string3);
                this.fDeclaredNamespaces.declareNamespace(string2, string3);
            }
        } else {
            this.fNamespaceContext.declareNamespace(string2, string3);
            this.handleNamespace(string2, string3);
        }
    }

    public void writeProcessingInstruction(String string2) throws XMLStreamException {
        this.writeProcessingInstruction(string2, "");
    }

    public void writeEndElement() throws XMLStreamException {
        this.checkFinishStartElement();
        this.handleEndElement();
        this.fNamespaceContext.endScope();
        if (this.fRepairingNamespaces) {
            this.fDeclaredNamespaces.endScope();
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        this.checkFinishStartElement();
        while (!this.atRootContext()) {
            this.writeEndElement();
        }
    }

    private boolean elementNamespaceNeedsRepair(String string2, String string3) {
        if (string3.equals(this.fNamespaceContext.getNamespaceURI(string2))) {
            if (!string3.equals(this.fDeclaredNamespaces.getNamespaceURI(string2))) {
                this.fDeclaredNamespaces.declareNamespace(string2, string3);
            }
            return false;
        }
        return true;
    }

    private boolean attributeNamespaceNeedsRepair(String string2, String string3) {
        if (string2.equals("")) {
            return !string3.equals("");
        }
        if (string3.equals(this.fNamespaceContext.getNamespaceURI(string2))) {
            if (!string3.equals(this.fDeclaredNamespaces.getNamespaceURI(string2))) {
                this.fDeclaredNamespaces.declareNamespace(string2, string3);
            }
            return false;
        }
        return true;
    }

    private String repairNamespace(String string2, String string3, boolean bl) throws XMLStreamException {
        String string4;
        if (string3.equals("")) {
            String string5;
            String string6 = "";
            if (bl && !(string5 = this.fNamespaceContext.getNamespaceURI("")).equals("")) {
                boolean bl2 = "".equals(this.fNamespaceContext.getNamespaceURIPrevious(""));
                if (bl2) {
                    this.fNamespaceContext.removeCurrentMapping("");
                } else {
                    this.fNamespaceContext.setPrefix(string6, string3);
                    this.fDeclaredNamespaces.declareNamespace(string6, string3);
                }
            }
            return string6;
        }
        if (string2.equals("")) {
            String string7;
            if (bl && string3.equals(string7 = this.fNamespaceContext.getNamespaceURI(""))) {
                return "";
            }
            String string8 = this.fNamespaceContext.getNonNullPrefix(string3);
            if (string8 == null) {
                string8 = this.generateNextPrefix();
                this.fNamespaceContext.setPrefix(string8, string3);
                this.fDeclaredNamespaces.declareNamespace(string8, string3);
            }
            return string8;
        }
        if (this.fUsedPrefixes.contains(string2)) {
            string4 = this.generateNextPrefix();
            this.fNamespaceContext.setPrefix(string4, string3);
            this.fDeclaredNamespaces.declareNamespace(string4, string3);
        } else {
            string4 = string2;
            boolean bl3 = string3.equals(this.fNamespaceContext.getNamespaceURIPrevious(string2));
            if (bl3) {
                this.fNamespaceContext.removeCurrentMapping(string2);
            } else {
                this.fNamespaceContext.setPrefix(string4, string3);
                this.fDeclaredNamespaces.declareNamespace(string4, string3);
            }
        }
        return string4;
    }

    protected void parseDTD(String string2) throws XMLStreamException {
        int n2;
        this.fDTDRoot = null;
        this.fDTDPubId = null;
        this.fDTDSysId = null;
        if (string2 == null || string2.length() == 0) {
            return;
        }
        int n3 = 0;
        char c = string2.charAt(n3);
        while (n3 < string2.length() && this.isWhitespace(c)) {
            c = string2.charAt(++n3);
        }
        if (string2.regionMatches(false, n3, "<!DOCTYPE", 0, 9)) {
            n2 = 2;
            n3 += 8;
            if (!this.isWhitespace(string2.charAt(++n3))) {
                return;
            }
        } else {
            return;
        }
        while (n3 < string2.length()) {
            c = string2.charAt(n3);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                case '>': 
                case '[': {
                    return;
                }
                case '\"': 
                case '\'': {
                    int n4 = ++n3;
                    char c2 = c;
                    while ((c = string2.charAt(++n3)) != c2 && n3 < string2.length() - 1) {
                    }
                    if (n2 == 3) {
                        this.fDTDPubId = string2.substring(n4, n3);
                        n2 = 4;
                        break;
                    }
                    if (n2 == 4) {
                        this.fDTDSysId = string2.substring(n4, n3);
                        return;
                    }
                    return;
                }
                default: {
                    int n4;
                    if (n2 == 2) {
                        n4 = n3;
                        while (!this.isWhitespace(c = string2.charAt(++n3)) && c != '[' && c != '>' && n3 < string2.length() - 1) {
                        }
                        this.fDTDRoot = string2.substring(n4, n3);
                        n2 = 1;
                        break;
                    }
                    if (string2.regionMatches(false, n3, "PUBLIC", 0, 6)) {
                        n2 = 3;
                        n3 += 5;
                        if (this.isWhitespace(string2.charAt(++n3))) break;
                        return;
                    }
                    if (!string2.regionMatches(false, n3, "SYSTEM", 0, 6)) break;
                    n2 = 4;
                    n3 += 5;
                    if (this.isWhitespace(string2.charAt(++n3))) break;
                    return;
                }
            }
            ++n3;
        }
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class StAXNamespaceContext
    implements NamespaceContext {
        protected String[] fMapping = ArrayAllocator.newStringArray(32);
        protected int fMappingSize = 0;
        protected int[] fScopes = ArrayAllocator.newIntArray(8);
        protected int fScope = 0;
        private NamespaceContext fRootContext;
        private boolean fDocumentStarted;

        public StAXNamespaceContext() {
            this.fMapping[this.fMappingSize++] = "xml";
            this.fMapping[this.fMappingSize++] = "http://www.w3.org/XML/1998/namespace";
            this.fMapping[this.fMappingSize++] = "xmlns";
            this.fMapping[this.fMappingSize++] = "http://www.w3.org/2000/xmlns/";
            this.fMapping[this.fMappingSize++] = "";
            this.fMapping[this.fMappingSize++] = "";
        }

        public StAXNamespaceContext(StAXNamespaceContext stAXNamespaceContext, boolean bl) {
            this.fMappingSize = stAXNamespaceContext.fMappingSize;
            this.fRootContext = stAXNamespaceContext.fRootContext;
            if (bl) {
                this.fMapping = ArrayAllocator.copyStringArray(stAXNamespaceContext.fMapping);
                this.fScope = stAXNamespaceContext.fScope;
                this.fScopes = ArrayAllocator.copyIntArray(stAXNamespaceContext.fScopes);
            } else {
                this.fMapping = ArrayAllocator.newStringArray(this.fMappingSize);
                System.arraycopy(stAXNamespaceContext.fMapping, 0, this.fMapping, 0, this.fMappingSize);
            }
        }

        public void reset() {
            this.fMappingSize = 6;
            this.fScope = 1;
            this.fScopes[this.fScope] = this.fMappingSize;
            this.fRootContext = null;
            this.fDocumentStarted = false;
        }

        public void startScope() {
            ++this.fScope;
            if (this.fScope == this.fScopes.length) {
                this.fScopes = ArrayAllocator.resizeIntArray(this.fScopes, this.fScope << 1);
            }
            this.fScopes[this.fScope] = this.fMappingSize;
            this.fDocumentStarted = true;
        }

        public void endScope() {
            this.fMappingSize = this.fScopes[this.fScope--];
        }

        @Override
        public String getNamespaceURI(String string2) {
            if (string2 == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
            }
            for (int i = this.fMappingSize - 2; i >= 0; i -= 2) {
                if (!this.fMapping[i].equals(string2)) continue;
                return this.fMapping[i + 1];
            }
            if (this.fRootContext != null) {
                return this.fRootContext.getNamespaceURI(string2);
            }
            return null;
        }

        @Override
        public String getPrefix(String string2) {
            if (string2 == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
            }
            for (int i = this.fMappingSize - 2; i >= 0; i -= 2) {
                if (!this.fMapping[i + 1].equals(string2) || !this.getNamespaceURI(this.fMapping[i]).equals(string2)) continue;
                return this.fMapping[i];
            }
            if (this.fRootContext != null) {
                return this.fRootContext.getPrefix(string2);
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String string2) {
            if (string2 == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = this.fMappingSize - 2; i >= 0; i -= 2) {
                if (!this.fMapping[i + 1].equals(string2) || !this.getNamespaceURI(this.fMapping[i]).equals(string2)) continue;
                hashSet.add(this.fMapping[i]);
            }
            return hashSet.iterator();
        }

        protected void declareNamespace(String string2, String string3) {
            if (this.fMappingSize == this.fMapping.length) {
                this.fMapping = ArrayAllocator.resizeStringArray(this.fMapping, this.fMappingSize << 1);
            }
            if (string2 == null) {
                string2 = "";
            }
            this.fMapping[this.fMappingSize++] = string2;
            this.fMapping[this.fMappingSize++] = string3;
        }

        protected void setRootContext(NamespaceContext namespaceContext) {
            if (this.fRootContext != null) {
                StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 40));
            } else if (this.fDocumentStarted) {
                StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 41));
            }
            this.fRootContext = namespaceContext;
        }

        protected String getNamespaceURICurrent(String string2) {
            int n2 = this.getIndexURICurrent(string2);
            if (n2 == -1) {
                return null;
            }
            return this.fMapping[n2];
        }

        protected String getNamespaceURIPrevious(String string2) {
            int n2 = this.getIndexURIPrevious(string2);
            if (n2 == -1) {
                if (this.fRootContext != null) {
                    return this.fRootContext.getNamespaceURI(string2);
                }
                return null;
            }
            return this.fMapping[n2];
        }

        protected void removeCurrentMapping(String string2) {
            int n2;
            if (string2 == null) {
                string2 = "";
            }
            if ((n2 = this.getIndexURICurrent(string2)) != -1) {
                for (int i = n2 + 1; i < this.fMappingSize; ++i) {
                    this.fMapping[i - 2] = this.fMapping[i];
                }
                this.fMappingSize -= 2;
            }
        }

        protected String getNonNullPrefix(String string2) {
            String string3;
            for (int i = this.fMappingSize - 2; i >= 0; i -= 2) {
                if (!this.fMapping[i + 1].equals(string2) || this.fMapping[i].equals("") || !this.getNamespaceURI(this.fMapping[i]).equals(string2)) continue;
                return this.fMapping[i];
            }
            if (this.fRootContext != null && !(string3 = this.fRootContext.getPrefix(string2)).equals("")) {
                return string3;
            }
            return null;
        }

        protected void setPrefix(String string2, String string3) {
            int n2 = this.getIndexURICurrent(string2);
            if (n2 == -1) {
                this.declareNamespace(string2, string3);
            } else {
                this.fMapping[n2] = string3;
            }
        }

        private int getIndexURICurrent(String string2) {
            return this.getIndexInRange(string2, this.fMappingSize, this.fScopes[this.fScope]);
        }

        private int getIndexURIPrevious(String string2) {
            return this.getIndexInRange(string2, this.fScopes[this.fScope], 0);
        }

        private int getIndexInRange(String string2, int n2, int n3) {
            for (int i = n2; i > n3; i -= 2) {
                if (!this.fMapping[i - 2].equals(string2)) continue;
                return i - 1;
            }
            return -1;
        }
    }
}

