/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax.events;

import com.ibm.xml.xlxp.internal.s1.api.stax.events.XMLEventImpl;
import com.ibm.xml.xlxp.internal.s1.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.internal.s1.api.util.ImmutableArrayList;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class AttributeImpl
extends XMLEventImpl
implements Attribute {
    static List<Attribute> EMPTY_LIST = ImmutableArrayList.emptyList();
    private final QName fQName;
    private final String fValue;
    private final String fDTDType;
    private final boolean fIsSpecified;

    public AttributeImpl(QName qName, String string2) {
        this(qName, string2, null);
    }

    public AttributeImpl(QName qName, String string2, Location location) {
        this(qName, string2, "CDATA", true, location);
    }

    public AttributeImpl(QName qName, String string2, String string3, boolean bl) {
        this(qName, string2, string3, bl, null);
    }

    public AttributeImpl(QName qName, String string2, String string3, boolean bl, Location location) {
        super(10, location);
        this.fQName = qName;
        this.fValue = string2;
        this.fDTDType = string3;
        this.fIsSpecified = bl;
    }

    public QName getName() {
        return this.fQName;
    }

    public String getValue() {
        return this.fValue;
    }

    public String getDTDType() {
        return this.fDTDType;
    }

    public boolean isSpecified() {
        return this.fIsSpecified;
    }

    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            String string2 = this.fQName.getPrefix();
            if (string2.length() > 0) {
                writer.write(string2);
                writer.write(58);
            }
            writer.write(this.fQName.getLocalPart());
            writer.write("=\"");
            writer.write(AttributeImpl.escape(this.fValue, 10));
            writer.write(34);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }
}

