/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.stax.serializer;

import com.ibm.xml.xlxp.internal.s1.api.stax.serializer.StAXWriter;
import com.ibm.xml.xlxp.internal.s1.api.util.Pool;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class SingleByteWriter
extends StAXWriter {
    private static final Pool fPool = new Pool();

    public static final SingleByteWriter getInstance() {
        SingleByteWriter singleByteWriter = (SingleByteWriter)fPool.get();
        if (singleByteWriter == null) {
            singleByteWriter = new SingleByteWriter();
            fPool.assignToPool(singleByteWriter);
        }
        return singleByteWriter;
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.fNumBytes + n3 < this.fBuffer.length) {
            this.encodeAndWrite(cArray, n2, n3);
        } else {
            this.write0(cArray, n2, n3);
        }
    }

    private void write0(char[] cArray, int n2, int n3) throws IOException {
        this.flushInternal();
        int n4 = n2 + n3;
        while (n2 + this.fBuffer.length < n4) {
            this.encodeAndWrite(cArray, n2, this.fBuffer.length);
            n2 += this.fBuffer.length;
            this.flushInternal();
        }
        this.encodeAndWrite(cArray, n2, n4 - n2);
    }

    public void write(String string2, int n2, int n3) throws IOException {
        if (this.fNumBytes + n3 < this.fBuffer.length) {
            this.encodeAndWrite(string2, n2, n3);
        } else {
            this.write0(string2, n2, n3);
        }
    }

    private void write0(String string2, int n2, int n3) throws IOException {
        this.flushInternal();
        int n4 = n2 + n3;
        while (n2 + this.fBuffer.length < n4) {
            this.encodeAndWrite(string2, n2, this.fBuffer.length);
            n2 += this.fBuffer.length;
            this.flushInternal();
        }
        this.encodeAndWrite(string2, n2, n4 - n2);
    }

    public void write(int n2) throws IOException {
        if (this.fNumBytes == this.fBuffer.length) {
            this.flushInternal();
        }
        this.fBuffer[this.fNumBytes++] = (byte)n2;
    }

    private void encodeAndWrite(char[] cArray, int n2, int n3) throws IOException {
        int n4 = n2 + n3;
        int n5 = this.fNumBytes;
        for (int i = n2; i < n4; ++i) {
            this.fBuffer[n5++] = (byte)cArray[i];
        }
        this.fNumBytes = n5;
    }

    private void encodeAndWrite(String string2, int n2, int n3) throws IOException {
        int n4 = n2 + n3;
        int n5 = this.fNumBytes;
        for (int i = n2; i < n4; ++i) {
            this.fBuffer[n5++] = (byte)string2.charAt(i);
        }
        this.fNumBytes = n5;
    }
}

