/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util;

import com.ibm.xml.xlxp.internal.s1.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.api.util.URI;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingDeclReader;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.IANACharset;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.PlatformEncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.UCSEncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.UTF8EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class SimpleParsedEntityFactory
implements ParsedEntityFactory {
    public static final boolean REQUIRE_IANA_ENCODING_NAMES = false;
    protected final DataBufferFactory fBufferFactory;
    protected String[] fInOutEncodingName;
    protected boolean fCoordinatesAware;
    protected URI fURI;
    protected boolean fIsXML10;
    private final EncodingSupport fUTF8EncodingSupport;
    private final EncodingDeclReader fEncodingDeclReader;

    public SimpleParsedEntityFactory(DataBufferFactory dataBufferFactory) {
        this.fBufferFactory = dataBufferFactory;
        this.fUTF8EncodingSupport = UTF8EncodingSupport.getInstance();
        this.fInOutEncodingName = ArrayAllocator.newStringArray(1);
        this.fEncodingDeclReader = new EncodingDeclReader();
        this.fCoordinatesAware = false;
    }

    public void setBufferLength(int n2) {
    }

    public void reset(boolean bl) {
    }

    public ParsedEntity createParsedEntity(InputStream inputStream, String string2) {
        try {
            ParsedEntity parsedEntity = new ParsedEntity(this, this.fBufferFactory);
            parsedEntity.isCoordinatesAware = this.fCoordinatesAware;
            this.setByteStreamSource(parsedEntity, inputStream, string2, this.fInOutEncodingName);
            return parsedEntity;
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
    }

    public ParsedEntity createParsedEntityFromXMLString(XMLString xMLString, String string2, boolean bl) {
        ParsedEntity parsedEntity = new ParsedEntity(this, this.fBufferFactory);
        parsedEntity.lineBreaksNormalized = (xMLString.flags & 0xC) == 0;
        parsedEntity.isXML10 = bl;
        parsedEntity.isInternal = true;
        parsedEntity.baseURI = string2;
        parsedEntity.isCoordinatesAware = this.fCoordinatesAware;
        parsedEntity.setContent(xMLString);
        return parsedEntity;
    }

    public String expandSystemID(String string2, String string3) {
        if (string2 != null && string3 != null) {
            URI uRI = this.fURI;
            if (uRI == null) {
                uRI = this.fURI = new URI();
            }
            return uRI.expand(string2, string3);
        }
        return string2;
    }

    protected boolean resolvedExternalID(ParsedEntity parsedEntity, XMLString xMLString, String string2) {
        return false;
    }

    public final ParsedEntity createParsedEntityFromExternalID(XMLString xMLString, XMLString xMLString2, String string2, boolean bl) {
        ParsedEntity parsedEntity = new ParsedEntity(this, this.fBufferFactory);
        parsedEntity.isXML10 = bl;
        parsedEntity.baseURI = xMLString2.toString();
        parsedEntity.baseURI = this.expandSystemID(parsedEntity.baseURI, string2);
        parsedEntity.isCoordinatesAware = this.fCoordinatesAware;
        if (this.resolvedExternalID(parsedEntity, xMLString, string2)) {
            return parsedEntity;
        }
        try {
            InputStream inputStream = URI.openStream(parsedEntity.baseURI);
            this.setByteStreamSource(parsedEntity, inputStream, null, null);
            return parsedEntity;
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
    }

    public void releaseParsedEntity(ParsedEntity parsedEntity) {
    }

    public final void setCoordinatesAware(boolean bl) {
        this.fCoordinatesAware = bl;
    }

    public final boolean getCoordinatesAware() {
        return this.fCoordinatesAware;
    }

    protected final CharConversionError setByteStreamSource(ParsedEntity parsedEntity, InputStream inputStream, String string2, String[] stringArray) throws IOException {
        ByteStreamDataSource byteStreamDataSource = new ByteStreamDataSource(this.fBufferFactory, inputStream, string2);
        return this.detectEncodingSetSource(parsedEntity, byteStreamDataSource, stringArray);
    }

    protected final CharConversionError setCharacterStreamSource(ParsedEntity parsedEntity, Reader reader, boolean bl) throws IOException {
        CharacterStreamDataSource characterStreamDataSource = new CharacterStreamDataSource(this.fBufferFactory, reader);
        this.fEncodingDeclReader.getVersionNumber(characterStreamDataSource, bl);
        return characterStreamDataSource.loadFromCharacterStream(parsedEntity, bl);
    }

    private CharConversionError detectEncodingSetSource(ParsedEntity parsedEntity, ByteStreamDataSource byteStreamDataSource, String[] stringArray) throws IOException {
        boolean bl = stringArray != null;
        String string2 = byteStreamDataSource.getEncodingName();
        EncodingSupport encodingSupport = null;
        int n2 = this.fEncodingDeclReader.detectEncoding(byteStreamDataSource, bl);
        switch (n2) {
            default: {
                if (string2 == null) {
                    encodingSupport = this.fUTF8EncodingSupport;
                    string2 = "UTF-8";
                    byteStreamDataSource.setEncodingName("UTF-8");
                }
                if (!bl) break;
                stringArray[0] = string2;
                break;
            }
            case 1: {
                encodingSupport = this.fUTF8EncodingSupport;
                if (this.fEncodingDeclReader.getLatinEncoding() && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 == null) {
                    string2 = "UTF-8";
                    byteStreamDataSource.setEncodingName("UTF-8");
                }
                if (!bl) break;
                stringArray[0] = string2;
                break;
            }
            case 2: {
                encodingSupport = UCSEncodingSupport.getInstance(1);
                if (this.fEncodingDeclReader.getUCSEncoding(2, true) && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 == null) {
                    string2 = "UTF-16BE";
                    byteStreamDataSource.setEncodingName("UTF-16BE");
                }
                if (!bl) break;
                stringArray[0] = "UTF-16";
                break;
            }
            case 3: {
                encodingSupport = UCSEncodingSupport.getInstance(2);
                if (this.fEncodingDeclReader.getUCSEncoding(2, false) && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 != null) {
                    // empty if block
                }
                string2 = "UTF-16LE";
                byteStreamDataSource.setEncodingName("UTF-16LE");
                if (!bl) break;
                stringArray[0] = "UTF-16";
                break;
            }
            case 4: {
                encodingSupport = UCSEncodingSupport.getInstance(3);
                if (this.fEncodingDeclReader.getUCSEncoding(4, true) && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 != null) {
                    // empty if block
                }
                string2 = "UTF-32BE";
                byteStreamDataSource.setEncodingName("UTF-32BE");
                if (!bl) break;
                stringArray[0] = "UTF-32";
                break;
            }
            case 5: {
                encodingSupport = UCSEncodingSupport.getInstance(4);
                if (this.fEncodingDeclReader.getUCSEncoding(4, false) && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 != null) {
                    // empty if block
                }
                string2 = "UTF-32LE";
                byteStreamDataSource.setEncodingName("UTF-32LE");
                if (!bl) break;
                stringArray[0] = "UTF-32";
                break;
            }
            case 6: {
                if (this.fEncodingDeclReader.getLatinEncoding() && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 == null) {
                    encodingSupport = this.fUTF8EncodingSupport;
                    string2 = "UTF-8";
                    byteStreamDataSource.setEncodingName("UTF-8");
                }
                if (!bl) break;
                stringArray[0] = string2;
                break;
            }
            case 7: {
                if (this.fEncodingDeclReader.getEBCDICEncoding() && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 == null) {
                    this.fEncodingDeclReader.reset();
                    parsedEntity.error = CharConversionError.inconsistentEncoding();
                    return parsedEntity.error;
                }
                if (!bl) break;
                stringArray[0] = string2;
                break;
            }
            case 8: {
                if (this.fEncodingDeclReader.getUCSEncoding(2, true) && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 == null) {
                    this.fEncodingDeclReader.reset();
                    parsedEntity.error = CharConversionError.inconsistentEncoding();
                    return parsedEntity.error;
                }
                if (!bl) break;
                stringArray[0] = string2;
                break;
            }
            case 9: {
                if (this.fEncodingDeclReader.getUCSEncoding(2, false) && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 == null) {
                    this.fEncodingDeclReader.reset();
                    parsedEntity.error = CharConversionError.inconsistentEncoding();
                    return parsedEntity.error;
                }
                if (!bl) break;
                stringArray[0] = string2;
                break;
            }
            case 10: {
                if (this.fEncodingDeclReader.getUCSEncoding(4, true) && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 == null) {
                    this.fEncodingDeclReader.reset();
                    parsedEntity.error = CharConversionError.inconsistentEncoding();
                    return parsedEntity.error;
                }
                if (!bl) break;
                stringArray[0] = string2;
                break;
            }
            case 11: {
                if (this.fEncodingDeclReader.getUCSEncoding(4, false) && string2 == null) {
                    string2 = byteStreamDataSource.getEncodingName();
                } else if (string2 == null) {
                    this.fEncodingDeclReader.reset();
                    parsedEntity.error = CharConversionError.inconsistentEncoding();
                    return parsedEntity.error;
                }
                if (!bl) break;
                stringArray[0] = string2;
            }
        }
        this.fEncodingDeclReader.reset();
        if (encodingSupport == null) {
            this.fInOutEncodingName[0] = string2;
            encodingSupport = IANACharset.getEncodingSupport(this.fInOutEncodingName);
            byteStreamDataSource.setEncodingName(this.fInOutEncodingName[0]);
            if (encodingSupport == null) {
                encodingSupport = PlatformEncodingSupport.getInstance();
            }
        }
        return encodingSupport.loadFromByteStream(parsedEntity, bl, byteStreamDataSource);
    }
}

