/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DocumentPosition;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.PositionHelper;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class SimplePositionHelper
implements PositionHelper {
    protected ParsedEntity fCurrentEntity;
    private static final short[] map = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final short[] map11 = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0, 0, 1, 4, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 5, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public void setCurrentExternalEntity(ParsedEntity parsedEntity) {
        this.fCurrentEntity = parsedEntity;
    }

    public void getCurrentPosition(DocumentPosition documentPosition) {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.offset == this.fCurrentEntity.startOffset) {
                this.getBufferPosition(documentPosition);
            } else {
                if (this.fCurrentEntity.isXML10) {
                    this.getCurrentPosition10(documentPosition);
                } else {
                    this.getCurrentPosition11(documentPosition);
                }
                int n2 = this.fCurrentEntity.buffer.byteOffset;
                if (n2 != -1) {
                    documentPosition.byteOffset = n2 + this.fCurrentEntity.offset - this.fCurrentEntity.buffer.startOffset;
                }
            }
        } else {
            this.clear(documentPosition);
        }
    }

    protected void getCurrentPosition10(DocumentPosition documentPosition) {
        DataBuffer dataBuffer = this.fCurrentEntity.buffer;
        byte[] byArray = dataBuffer.bytes;
        int n2 = dataBuffer.startOffset + dataBuffer.startPosIncrement;
        int n3 = this.fCurrentEntity.offset - 1;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (map[byArray[n3] & 0xFF] == 0 && --n3 >= n2) continue;
            if (n3 < n2) {
                documentPosition.columnNumber = dataBuffer.columnNumber + this.fCurrentEntity.offset - n2 - n5;
                documentPosition.lineNumber = dataBuffer.lineNumber;
                return;
            }
            if (map[byArray[n3] & 0xFF] > 7) break;
            ++n5;
            --n3;
        }
        documentPosition.columnNumber = this.fCurrentEntity.offset - n3 - n5;
        while (true) {
            if (map[byArray[n2] & 0xFF] < 8) {
                ++n2;
                continue;
            }
            ++n4;
            if (byArray[n2++] == 13) {
                if (n2 > n3) break;
                if (byArray[n2] == 10) {
                    ++n2;
                }
            }
            if (n2 > n3) break;
        }
        documentPosition.lineNumber = dataBuffer.lineNumber + n4;
    }

    protected void getCurrentPosition11(DocumentPosition documentPosition) {
        short s;
        DataBuffer dataBuffer = this.fCurrentEntity.buffer;
        byte[] byArray = dataBuffer.bytes;
        int n2 = dataBuffer.startOffset + dataBuffer.startPosIncrement;
        int n3 = this.fCurrentEntity.offset - 1;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int n6;
            if (map11[byArray[n3] & 0xFF] == 0 && --n3 >= n2) {
                continue;
            }
            if (n3 < n2) {
                documentPosition.lineNumber = dataBuffer.lineNumber;
                documentPosition.columnNumber = dataBuffer.columnNumber + this.fCurrentEntity.offset - n2 - n5;
                return;
            }
            s = map11[byArray[n3] & 0xFF];
            if (s > 7) {
                documentPosition.columnNumber = this.fCurrentEntity.offset - n3 - n5;
                break;
            }
            if (s > 2 && (n6 = this.checkNewLine11(s, byArray, n2, n3)) != n3) {
                documentPosition.columnNumber = this.fCurrentEntity.offset - n3 - n5;
                n3 = n6;
                if (n2 > n3) {
                    documentPosition.lineNumber = dataBuffer.lineNumber + 1;
                    return;
                }
                ++n4;
                break;
            }
            --n3;
            if (s > 5) continue;
            ++n5;
        }
        while (true) {
            if (map11[byArray[n2] & 0xFF] < 6 && ++n2 <= n3) {
                continue;
            }
            if (n2 > n3) break;
            s = map11[byArray[n2] & 0xFF];
            ++n2;
            if (s > 7) {
                ++n4;
                if (s == 9 && n2 <= n3) {
                    if (byArray[n2] == 10) {
                        ++n2;
                    } else if ((byArray[n2] & 0xFF) == 194 && n2 < n3 && (byArray[n2 + 1] & 0xFF) == 133) {
                        n2 += 2;
                    }
                }
            } else if (s == 6) {
                if (n2 <= n3 && (byArray[n2] & 0xFF) == 133) {
                    ++n4;
                    ++n2;
                }
            } else if (n2 < n3 && (byArray[n2] & 0xFF) == 128 && (byArray[n2 + 1] & 0xFF) == 168) {
                ++n4;
                n2 += 2;
            }
            if (n2 > n3) break;
        }
        documentPosition.lineNumber = dataBuffer.lineNumber + n4;
    }

    private int checkNewLine11(int n2, byte[] byArray, int n3, int n4) {
        switch (n2) {
            case 4: {
                if (n4 <= n3 || (byArray[n4 - 1] & 0xFF) != 194 || (n4 -= 2) < n3 || byArray[n4] != 13) break;
                --n4;
                break;
            }
            case 5: {
                if (n4 - 1 <= n3 || (byArray[n4 - 1] & 0xFF) != 128 || (byArray[n4 - 2] & 0xFF) != 226) break;
                n4 -= 3;
            }
        }
        return n4;
    }

    private void getBufferPosition(DocumentPosition documentPosition) {
        documentPosition.lineNumber = this.fCurrentEntity.buffer.lineNumber;
        documentPosition.columnNumber = this.fCurrentEntity.buffer.columnNumber;
        documentPosition.byteOffset = this.fCurrentEntity.buffer.byteOffset;
    }

    private void clear(DocumentPosition documentPosition) {
        documentPosition.lineNumber = -1;
        documentPosition.columnNumber = -1;
        documentPosition.byteOffset = -1;
    }
}

