/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class URI {
    private String fScheme = "";
    private String fAuthority;
    private String fPath = "";
    private String fQuery;
    private String fFragment;
    private URI fBaseURI;
    private char[] fChars;
    private static final boolean WORKAROUND_JIT_BUG = true;
    private static final byte[] fgSchemeCharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final byte[] fgURICharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 3, 2, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 0, 2, 0, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 2, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0};
    private static final byte[] fgHexCharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public boolean parse(String string2) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        return this.parseURI(string2, true);
    }

    public boolean parse(URI uRI, String string2) {
        if (uRI == null || string2 == null) {
            return false;
        }
        if (!this.parseURI(string2, false)) {
            return false;
        }
        if (this.fScheme.length() == 0) {
            this.resolveRelativeTo(uRI);
        }
        return true;
    }

    private boolean parseURI(String string2, boolean bl) {
        int n2;
        int n3 = 47;
        int n4 = string2.length();
        int n5 = n2;
        this.fScheme = "";
        this.fAuthority = null;
        this.fPath = "";
        this.fQuery = null;
        this.fFragment = null;
        for (n2 = 0; n2 < n4; ++n2) {
            n3 = string2.charAt(n2);
            if (n3 != 58) {
                if (n3 != 47 && n3 != 63 && n3 != 35) {
                    continue;
                }
                n2 = n5;
                n3 = string2.charAt(n2);
                break;
            }
            if (n2 <= n5) break;
            this.fScheme = string2.substring(n5, n2);
            if (this.parseScheme()) {
                if (++n2 < n4) {
                    n5 = n2;
                    n3 = string2.charAt(n2);
                    break;
                }
                this.fPath = "";
                return URI.checkComponent(this.fPath, false, true);
            }
            return false;
        }
        if (bl && this.fScheme.length() == 0) {
            return false;
        }
        if (n2 + 1 < n4 && n3 == 47 && string2.charAt(n2 + 1) == '/') {
            n5 = n2 += 2;
            while (n2 < n4 && (n3 = (int)string2.charAt(n2)) != 47 && n3 != 63 && n3 != 35) {
                ++n2;
            }
            this.fAuthority = string2.substring(n5, n2);
            if (!URI.checkComponent(this.fAuthority, true, true)) {
                return false;
            }
            n5 = n2;
        }
        while (n2 < n4 && (n3 = (int)string2.charAt(n2)) != 63 && n3 != 35) {
            ++n2;
        }
        this.fPath = string2.substring(n5, n2);
        if (!URI.checkComponent(this.fPath, false, true)) {
            return false;
        }
        if (n3 == 63) {
            n5 = ++n2;
            while (n2 < n4 && (n3 = (int)string2.charAt(n2)) != 35) {
                ++n2;
            }
            this.fQuery = string2.substring(n5, n2);
            if (!URI.checkComponent(this.fQuery, false, false)) {
                return false;
            }
        }
        if (n3 == 35) {
            n5 = ++n2;
            while (n2 < n4 && (n3 = (int)string2.charAt(n2)) != 35) {
                ++n2;
            }
            this.fFragment = string2.substring(n5, n2);
            if (!URI.checkComponent(this.fFragment, false, false)) {
                return false;
            }
        }
        return true;
    }

    private void resolveRelativeTo(URI uRI) {
        int n2;
        char c;
        int n3;
        int n4;
        int n5;
        block19: {
            int n6;
            int n7;
            this.fScheme = uRI.fScheme;
            if (this.fAuthority != null) {
                return;
            }
            if (uRI.fAuthority != null) {
                this.fAuthority = uRI.fAuthority;
            }
            if ((n7 = this.fPath.length()) == 0 && this.fQuery == null) {
                this.fPath = uRI.fPath;
                uRI.fQuery = null;
                if (this.fFragment == null && uRI.fFragment != null) {
                    this.fFragment = uRI.fFragment;
                }
                return;
            }
            if (n7 > 0 && this.fPath.charAt(0) == '/') {
                return;
            }
            String string2 = uRI.fPath;
            n5 = string2.length() + n7;
            if (this.fChars == null) {
                for (n6 = 32; n5 > n6; n6 <<= 1) {
                }
                this.fChars = ArrayAllocator.newCharArray(n6);
            } else if (n5 > this.fChars.length) {
                for (n6 = this.fChars.length << 1; n5 > n6; n6 <<= 1) {
                }
                this.fChars = ArrayAllocator.replaceCharArray(this.fChars, n6);
            }
            string2.getChars(0, n5, this.fChars, 0);
            for (n5 = string2.length(); n5 > 0 && this.fChars[n5 - 1] != '/'; --n5) {
            }
            if (n5 == 0) {
                n5 = string2.length();
            }
            this.fPath.getChars(0, n7, this.fChars, n5);
            n5 += n7;
            n4 = 0;
            n3 = 0;
            while (n4 < n5) {
                c = this.fChars[n4];
                if (c != '/' || ++n4 + 1 >= n5 || this.fChars[n4] != '.' || this.fChars[n4 + 1] != '/') continue;
                n3 = n4;
                n4 += 2;
                while (n4 < n5) {
                    c = this.fChars[n4];
                    this.fChars[n3] = c;
                    ++n3;
                    if (c != '/' || ++n4 + 1 >= n5 || this.fChars[n4] != '.' || this.fChars[n4 + 1] != '/') continue;
                    n4 += 2;
                }
                break block19;
            }
            n3 = n4;
        }
        if (n3 > 1 && this.fChars[n3 - 1] == '.' && this.fChars[n3 - 2] == '/') {
            --n3;
        }
        n5 = n3;
        n4 = 0;
        n3 = 0;
        while (n4 < n5) {
            c = this.fChars[n4];
            this.fChars[n3] = c;
            if (c != '/' || ++n3 == 1 || ++n4 + 2 >= n5 || this.fChars[n4] != '.' || this.fChars[n4 + 1] != '.' || this.fChars[n4 + 2] != '/' || (n2 = n3 - 4) >= 0 && this.fChars[n2] == '/' && this.fChars[n2 + 1] == '.' && this.fChars[n2 + 2] == '.') continue;
            n4 += 2;
            while (--n3 > 0 && this.fChars[n3 - 1] != '/') {
            }
            if (n3 <= 0 || this.fChars[n3 - 1] != '/') continue;
            --n3;
        }
        n5 = n3;
        n2 = n3 - 3;
        if (n2 >= 0 && this.fChars[n2] == '/' && this.fChars[n2 + 1] == '.' && this.fChars[n2 + 2] == '.' && ((n2 -= 3) < 0 || this.fChars[n2] != '/' || this.fChars[n2 + 1] != '.' || this.fChars[n2 + 2] != '.')) {
            n3 -= 3;
            while (n3 > 0 && this.fChars[n3 - 1] != '/') {
                --n3;
            }
        }
        n5 = n3;
        this.fPath = new String(this.fChars, 0, n5);
    }

    private boolean parseScheme() {
        String string2 = this.fScheme;
        int n2 = string2.length();
        boolean bl = false;
        int n3 = 0;
        if (n2 == 0) {
            return false;
        }
        char c = string2.charAt(n3);
        if (c >= '\u0080' || fgSchemeCharMap[c] != 1) {
            return false;
        }
        if (c >= 'A' && c <= 'Z') {
            bl = true;
        }
        while (++n3 < n2) {
            c = string2.charAt(n3);
            if (c >= '\u0080' || fgSchemeCharMap[c] == 0) {
                return false;
            }
            if (c < 'A' || c > 'Z') continue;
            bl = true;
        }
        if (bl) {
            this.fScheme = string2.toLowerCase(Locale.ENGLISH);
        }
        return true;
    }

    private static boolean checkComponent(String string2, boolean bl, boolean bl2) {
        int n2 = string2.length();
        block5: for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c >= '\u0080') {
                return false;
            }
            switch (fgURICharMap[c]) {
                case 1: {
                    continue block5;
                }
                case 2: {
                    if ((!bl || c != '/') && (!bl2 || c != '?')) continue block5;
                    return false;
                }
                case 3: {
                    if (i + 2 >= n2) {
                        return false;
                    }
                    if ((c = string2.charAt(++i)) >= '\u0080' || fgHexCharMap[c] == 0) {
                        return false;
                    }
                    if ((c = string2.charAt(++i)) < '\u0080' && fgHexCharMap[c] != 0) continue block5;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.fScheme.length() > 0) {
            stringBuilder.append(this.fScheme);
            stringBuilder.append(':');
        }
        if (this.fAuthority != null) {
            stringBuilder.append('/');
            stringBuilder.append('/');
            stringBuilder.append(this.fAuthority);
        }
        stringBuilder.append(this.fPath);
        if (this.fQuery != null) {
            stringBuilder.append('?');
            stringBuilder.append(this.fQuery);
        }
        if (this.fFragment != null) {
            stringBuilder.append('#');
            stringBuilder.append(this.fFragment);
        }
        return stringBuilder.toString();
    }

    public String expand(String string2, String string3) {
        if (!this.parse(string2)) {
            URI uRI = this.fBaseURI;
            if (uRI == null) {
                uRI = this.fBaseURI = new URI();
            }
            if (uRI.parse(string3) && this.parse(uRI, string2)) {
                return this.toString();
            }
        }
        return string2;
    }

    public static InputStream openStream(String string2) throws IOException {
        return new URL(string2).openStream();
    }

    public static boolean isAbsolute(String string2) {
        int n2 = string2.length();
        if (n2 == 0) {
            return false;
        }
        char c = string2.charAt(0);
        if (c >= '\u0080' || fgSchemeCharMap[c] != 1) {
            return false;
        }
        for (int i = 1; i < n2; ++i) {
            c = string2.charAt(i);
            if (c < '\u0080' && fgSchemeCharMap[c] != 0) continue;
            return c == ':';
        }
        return false;
    }
}

