/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.api.util.DataBufferHelper;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.RewindableInputStream;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.UTF8EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.ByteArrayPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferInputStream;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataSource;
import com.ibm.xml.xlxp.internal.s1.scan.util.InputStreamWrapper;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ByteStreamDataSource
implements DataSource {
    private static final String cn = ByteStreamDataSource.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(ByteStreamDataSource.class);
    private static final int SMALL_BUFFER_SIZE = ByteArrayPool.SMALL_BYTE_ARRAY_SIZE;
    private static final int LARGE_BUFFER_SIZE = ByteArrayPool.LARGE_BYTE_ARRAY_SIZE;
    private static final boolean CLEAR_TO_END_OF_BUFFER = false;
    private static final int DEFAULT_BUFFER_LOAD_FACTOR = 3;
    static final int BUFFER_LOAD_FACTOR = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            try {
                return Integer.getInteger("com.ibm.xml.xlxp.internal.s1.api.util.encoding.ByteStreamDataSource.bufferLoadFactor", 3);
            }
            catch (SecurityException securityException) {
                return 3;
            }
        }
    });
    private final DataBufferFactory fBufferFactory;
    private EncodingSupport fEncodingSupport;
    private InputStream fStream;
    private boolean fIsXML10;
    private DataBufferInputStream fDataBufferInputStream;
    private String fEncodingName;
    private char[] fEncodingBuffer;
    private int fEncodingLength;
    private boolean fReadIntoDataBuffer;
    private byte[] fReadAheadBytes;
    private int fReadAheadOffset;
    private int fReadAheadMark;
    private int fReadAheadCount;
    private int fReadAheadLength;
    private byte[] fRemainderBytes;
    private int fRemainderCount;
    private int fRemainderLength;

    public ByteStreamDataSource(DataBufferFactory dataBufferFactory, InputStream inputStream, String string2) {
        Object[] objectArray;
        if (LoggerUtil.isEntryLoggable(logger)) {
            objectArray = new Object[]{dataBufferFactory, inputStream, string2};
            logger.entering(cn, "ByteStreamDataSource", objectArray);
        }
        this.fBufferFactory = dataBufferFactory;
        this.fStream = inputStream;
        this.fDataBufferInputStream = this.fStream instanceof InputStreamWrapper ? ((objectArray = ((InputStreamWrapper)((Object)this.fStream)).wrappedStream()) instanceof DataBufferInputStream ? (DataBufferInputStream)objectArray : null) : (this.fStream instanceof DataBufferInputStream ? (DataBufferInputStream)this.fStream : null);
        this.fEncodingName = string2;
        this.fEncodingBuffer = ArrayAllocator.newCharArray(64);
        this.fIsXML10 = true;
    }

    public void setEncodingName(String string2) {
        this.fEncodingName = string2;
    }

    public String getEncodingName() {
        return this.fEncodingName;
    }

    boolean atEndOfStream() {
        return this.fStream == null;
    }

    boolean isXML10() {
        return this.fIsXML10;
    }

    void setIsXML11() {
        this.fIsXML10 = false;
    }

    void addEncodingChar(char c) {
        if (this.fEncodingLength == this.fEncodingBuffer.length) {
            this.fEncodingBuffer = ArrayAllocator.resizeCharArray(this.fEncodingBuffer, this.fEncodingLength << 1);
        }
        this.fEncodingBuffer[this.fEncodingLength++] = c;
    }

    boolean saveEncodingChars() {
        if (this.fEncodingLength > 0) {
            if (this.fEncodingName == null) {
                this.fEncodingName = new String(this.fEncodingBuffer, 0, this.fEncodingLength);
            }
            return true;
        }
        return false;
    }

    void removeBOM() {
        if (this.fDataBufferInputStream != null) {
            this.fDataBufferInputStream.removeBOM();
        } else {
            this.fReadAheadCount -= this.fReadAheadOffset;
            System.arraycopy(this.fReadAheadBytes, this.fReadAheadOffset, this.fReadAheadBytes, 0, this.fReadAheadCount);
            this.fReadAheadOffset = 0;
        }
    }

    void mark() {
        if (this.fDataBufferInputStream != null) {
            this.fStream.mark(-1);
        } else {
            this.fReadAheadMark = this.fReadAheadOffset;
        }
    }

    void reset() throws IOException {
        if (this.fDataBufferInputStream != null) {
            this.fStream.reset();
        } else {
            this.fReadAheadOffset = this.fReadAheadMark;
        }
    }

    void rewind() throws IOException {
        if (this.fDataBufferInputStream != null) {
            this.fDataBufferInputStream.rewind();
        } else {
            this.fReadAheadOffset = 0;
            this.fReadAheadMark = 0;
        }
    }

    int readByte() throws IOException {
        if (this.fDataBufferInputStream != null) {
            return this.fStream.read();
        }
        if (this.fReadAheadOffset < this.fReadAheadCount) {
            return this.fReadAheadBytes[this.fReadAheadOffset++] & 0xFF;
        }
        return this.readMoreBytes();
    }

    private int readFromStream(byte[] byArray, int n2, int n3) throws IOException {
        try {
            int n4 = this.fStream.read(byArray, n2, n3);
            if (n4 == -1) {
                this.handleEndOfStream();
                return -1;
            }
            if (LoggerUtil.isFinerLoggable(logger)) {
                this.logData(byArray, n2, n4);
            }
            int n5 = n3 >> BUFFER_LOAD_FACTOR;
            while (n4 < n5) {
                int n6 = n2 + n4;
                int n7 = this.fStream.read(byArray, n6, n3 - n4);
                if (n7 == -1) {
                    this.handleEndOfStream();
                    break;
                }
                if (LoggerUtil.isFinerLoggable(logger)) {
                    this.logData(byArray, n6, n7);
                }
                n4 += n7;
            }
            return n4;
        }
        catch (IOException iOException) {
            if (LoggerUtil.isFinerLoggable(logger)) {
                Object[] objectArray = new Object[]{this.fStream, iOException};
                logger.logp(Level.FINER, cn, "readFromStream", "exception thrown {0} {1}", objectArray);
            }
            if (this.fStream != null) {
                try {
                    this.fStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.fStream = null;
            }
            throw iOException;
        }
    }

    private void logData(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = ArrayAllocator.newByteArray(n3);
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        String string2 = Base64.encode(byArray2);
        Object[] objectArray = new Object[]{this.fStream, string2};
        logger.logp(Level.FINER, cn, "logData", "data {0} {1}", objectArray);
    }

    private void handleEndOfStream() throws IOException {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "handleEndOfStream", "end of stream {0}", this.fStream);
        }
        InputStream inputStream = this.fStream;
        this.fStream = null;
        inputStream.close();
    }

    private int readMoreBytes() throws IOException {
        int n2;
        int n3 = this.fReadAheadLength;
        if (this.fReadAheadOffset == n3) {
            if (this.fReadAheadBytes == null) {
                try {
                    n2 = this.fStream.available();
                }
                catch (IOException iOException) {
                    n2 = LARGE_BUFFER_SIZE;
                }
                if (n2 <= SMALL_BUFFER_SIZE) {
                    this.fReadAheadBytes = ByteArrayPool.allocateSmallByteArray();
                    this.fReadAheadLength = SMALL_BUFFER_SIZE;
                } else {
                    this.fReadAheadBytes = ByteArrayPool.allocateLargeByteArray();
                    this.fReadAheadLength = LARGE_BUFFER_SIZE;
                }
            } else {
                this.fReadAheadLength <<= 1;
                this.fReadAheadBytes = ArrayAllocator.resizeByteArray(this.fReadAheadBytes, this.fReadAheadLength + 1);
                if (LoggerUtil.isFineLoggable(logger)) {
                    logger.logp(Level.FINE, cn, "readMoreBytes", "fReadAheadLength=" + this.fReadAheadLength);
                }
            }
            n3 = this.fReadAheadLength;
        }
        if ((n2 = this.readFromStream(this.fReadAheadBytes, this.fReadAheadOffset, n3 - this.fReadAheadOffset)) == -1) {
            return -1;
        }
        this.fReadAheadCount += n2;
        return this.fReadAheadBytes[this.fReadAheadOffset++] & 0xFF;
    }

    private void readFromStreamIntoRemainder() throws IOException {
        if (this.fStream != null && this.fRemainderCount < this.fRemainderLength) {
            int n2 = this.readFromStream(this.fRemainderBytes, this.fRemainderCount, this.fRemainderLength - this.fRemainderCount);
            if (n2 != -1) {
                this.fRemainderCount += n2;
            }
        }
    }

    private void readFromStreamIntoBuffer(DataBuffer dataBuffer) throws IOException {
        int n2;
        int n3;
        byte[] byArray;
        int n4;
        if (this.fStream != null && (n4 = this.readFromStream(byArray = dataBuffer.bytes, n3 = dataBuffer.endOffset, (n2 = byArray.length - 1) - n3)) != -1) {
            dataBuffer.endOffset += n4;
        }
    }

    byte[] remainderBytes() {
        return this.fRemainderBytes;
    }

    int remainderCount() {
        return this.fRemainderCount;
    }

    void clearRemainder() {
        this.fRemainderBytes = null;
        this.fRemainderCount = 0;
        this.fRemainderLength = 0;
    }

    void saveRemainder(byte[] byArray, int n2, int n3) {
        this.fRemainderCount = n3;
        if (this.fRemainderCount > 0) {
            if (this.fRemainderCount <= SMALL_BUFFER_SIZE) {
                if (this.fRemainderBytes == null) {
                    this.fRemainderBytes = ByteArrayPool.allocateSmallByteArray();
                    this.fRemainderLength = SMALL_BUFFER_SIZE;
                } else if (this.fRemainderLength != SMALL_BUFFER_SIZE) {
                    ByteArrayPool.deallocateLargeByteArray(this.fRemainderBytes);
                    this.fRemainderBytes = ByteArrayPool.allocateSmallByteArray();
                    this.fRemainderLength = SMALL_BUFFER_SIZE;
                }
            } else if (this.fRemainderBytes == null) {
                this.fRemainderBytes = ByteArrayPool.allocateLargeByteArray();
                this.fRemainderLength = LARGE_BUFFER_SIZE;
            } else if (this.fRemainderLength != LARGE_BUFFER_SIZE) {
                ByteArrayPool.deallocateSmallByteArray(this.fRemainderBytes);
                this.fRemainderBytes = ByteArrayPool.allocateLargeByteArray();
                this.fRemainderLength = LARGE_BUFFER_SIZE;
            }
            System.arraycopy(byArray, n2, this.fRemainderBytes, 0, this.fRemainderCount);
        } else {
            this.clearRemainder();
        }
    }

    boolean updateRemainder(int n2, int n3, int n4) {
        this.fRemainderCount = n3;
        if (this.fRemainderCount > 0) {
            if (this.fRemainderCount < n4 && this.fStream == null) {
                return false;
            }
            if (this.fRemainderLength == LARGE_BUFFER_SIZE && this.fRemainderCount <= SMALL_BUFFER_SIZE) {
                byte[] byArray = this.fRemainderBytes;
                this.fRemainderBytes = ByteArrayPool.allocateSmallByteArray();
                System.arraycopy(byArray, n2, this.fRemainderBytes, 0, this.fRemainderCount);
                ByteArrayPool.deallocateLargeByteArray(byArray);
            } else if (n2 > 0) {
                System.arraycopy(this.fRemainderBytes, n2, this.fRemainderBytes, 0, this.fRemainderCount);
            }
        } else {
            this.clearRemainder();
        }
        return true;
    }

    CharConversionError loadFromByteStream(ParsedEntity parsedEntity, boolean bl, EncodingSupport encodingSupport, boolean bl2) {
        DataBuffer dataBuffer;
        if (bl) {
            parsedEntity.isXML10 = this.fIsXML10;
        } else {
            this.fIsXML10 = parsedEntity.isXML10;
        }
        this.fEncodingSupport = encodingSupport;
        this.fReadIntoDataBuffer = bl2;
        if (this.fDataBufferInputStream != null) {
            if (this.fReadIntoDataBuffer && this.fEncodingSupport instanceof UTF8EncodingSupport) {
                this.fDataBufferInputStream.setupParsedEntity(parsedEntity);
                return null;
            }
            try {
                this.readMoreBytes();
            }
            catch (IOException iOException) {
                parsedEntity.error = CharConversionError.runtimeIOError(iOException);
                return parsedEntity.error;
            }
        }
        if (this.fReadIntoDataBuffer) {
            if (this.fReadAheadCount <= SMALL_BUFFER_SIZE) {
                dataBuffer = this.fBufferFactory.createBuffer(this.fReadAheadBytes);
                if (LoggerUtil.isFineLoggable(logger)) {
                    logger.logp(Level.FINE, cn, "loadFromByteStream", "swapped small read ahead buffer, id=" + dataBuffer.id + ", buffer size=" + (dataBuffer.bytes.length - 1) + ", fReadAheadCount=" + this.fReadAheadCount);
                }
            } else {
                dataBuffer = this.fBufferFactory.createBuffer(this.fReadAheadBytes);
                if (LoggerUtil.isFineLoggable(logger)) {
                    logger.logp(Level.FINE, cn, "loadFromByteStream", "swapped large read ahead buffer, id=" + dataBuffer.id + ", buffer size=" + (dataBuffer.bytes.length - 1) + ", fReadAheadCount=" + this.fReadAheadCount);
                }
            }
            dataBuffer.startOffset = 0;
            dataBuffer.endOffset = this.fReadAheadCount;
            if (dataBuffer.endOffset > 0) {
                parsedEntity.error = this.fEncodingSupport.load(this, dataBuffer);
            }
        } else {
            this.fRemainderBytes = this.fReadAheadBytes;
            this.fRemainderCount = this.fReadAheadCount;
            this.fRemainderLength = this.fReadAheadLength;
            dataBuffer = this.fReadAheadCount <= SMALL_BUFFER_SIZE ? this.fBufferFactory.createBuffer(SMALL_BUFFER_SIZE + 1) : this.fBufferFactory.createBuffer(LARGE_BUFFER_SIZE + 1);
            if (LoggerUtil.isFineLoggable(logger)) {
                logger.logp(Level.FINE, cn, "loadFromByteStream", "created data buffer, id=" + dataBuffer.id + ", buffer size=" + (dataBuffer.bytes.length - 1) + ", fReadAheadCount=" + this.fReadAheadCount);
            }
            dataBuffer.startOffset = 0;
            dataBuffer.endOffset = 0;
            parsedEntity.error = this.fEncodingSupport.load(this, dataBuffer);
        }
        this.fReadAheadBytes = null;
        this.fReadAheadOffset = 0;
        this.fReadAheadCount = 0;
        this.fReadAheadLength = 0;
        return this.processLoadResult(parsedEntity, dataBuffer);
    }

    public CharConversionError load(ParsedEntity parsedEntity) {
        DataBuffer dataBuffer;
        int n2;
        if (this.fStream != null) {
            try {
                n2 = this.fStream.available();
                if (n2 == 0 && this.fRemainderCount == 0) {
                    int n3 = this.fStream.read();
                    if (n3 == -1) {
                        if (LoggerUtil.isFineLoggable(logger)) {
                            logger.logp(Level.FINE, cn, "load", "detected end of stream with no remainder");
                        }
                        parsedEntity.setAtEndOfEntity();
                        this.release();
                        return null;
                    }
                    n2 = this.fStream.available();
                    this.fRemainderBytes = n2 + 1 <= SMALL_BUFFER_SIZE ? ByteArrayPool.allocateSmallByteArray() : ByteArrayPool.allocateLargeByteArray();
                    this.fRemainderBytes[this.fRemainderCount++] = (byte)n3;
                    this.fRemainderLength = this.fRemainderBytes.length - 1;
                }
            }
            catch (IOException iOException) {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        if (this.fReadIntoDataBuffer) {
            if (n2 + this.fRemainderCount <= SMALL_BUFFER_SIZE) {
                dataBuffer = this.fRemainderCount > 0 ? this.fBufferFactory.createBuffer(this.fRemainderBytes) : this.fBufferFactory.createBuffer(SMALL_BUFFER_SIZE + 1);
                if (LoggerUtil.isFineLoggable(logger)) {
                    logger.logp(Level.FINE, cn, "load", "swapped remainder, id=" + dataBuffer.id + ", buffer size=" + SMALL_BUFFER_SIZE + ", fRemainderCount=" + this.fRemainderCount);
                }
            } else if (this.fRemainderCount > 0) {
                if (this.fRemainderLength == LARGE_BUFFER_SIZE) {
                    dataBuffer = this.fBufferFactory.createBuffer(this.fRemainderBytes);
                    if (LoggerUtil.isFineLoggable(logger)) {
                        logger.logp(Level.FINE, cn, "load", "swapped remainder, id=" + dataBuffer.id + ", buffer size=" + LARGE_BUFFER_SIZE + ", fRemainderCount=" + this.fRemainderCount);
                    }
                } else {
                    dataBuffer = this.fBufferFactory.createBuffer(LARGE_BUFFER_SIZE + 1);
                    System.arraycopy(this.fRemainderBytes, 0, dataBuffer.bytes, 0, this.fRemainderCount);
                    if (LoggerUtil.isFineLoggable(logger)) {
                        logger.logp(Level.FINE, cn, "load", "copied remainder, id=" + dataBuffer.id + ", buffer size=" + LARGE_BUFFER_SIZE + ", fRemainderCount=" + this.fRemainderCount);
                    }
                }
            } else {
                dataBuffer = this.fBufferFactory.createBuffer(LARGE_BUFFER_SIZE + 1);
                if (LoggerUtil.isFineLoggable(logger)) {
                    logger.logp(Level.FINE, cn, "load", "created data buffer, id=" + dataBuffer.id + ", buffer size=" + LARGE_BUFFER_SIZE + ", fRemainderCount=" + this.fRemainderCount);
                }
            }
            dataBuffer.startOffset = 0;
            dataBuffer.endOffset = this.fRemainderCount;
            this.fRemainderBytes = null;
            this.fRemainderCount = 0;
            this.fRemainderLength = 0;
            try {
                this.readFromStreamIntoBuffer(dataBuffer);
            }
            catch (IOException iOException) {
                parsedEntity.error = CharConversionError.runtimeIOError(iOException);
                return parsedEntity.error;
            }
            if (dataBuffer.endOffset > 0) {
                parsedEntity.error = this.fEncodingSupport.load(this, dataBuffer);
            }
        } else {
            if (this.fRemainderCount == 0) {
                if (n2 <= SMALL_BUFFER_SIZE) {
                    this.fRemainderBytes = ByteArrayPool.allocateSmallByteArray();
                    this.fRemainderLength = SMALL_BUFFER_SIZE;
                } else {
                    this.fRemainderBytes = ByteArrayPool.allocateLargeByteArray();
                    this.fRemainderLength = LARGE_BUFFER_SIZE;
                }
            } else if (this.fRemainderLength == SMALL_BUFFER_SIZE && n2 + this.fRemainderCount > SMALL_BUFFER_SIZE) {
                byte[] byArray = this.fRemainderBytes;
                this.fRemainderBytes = ByteArrayPool.allocateLargeByteArray();
                this.fRemainderLength = LARGE_BUFFER_SIZE;
                System.arraycopy(byArray, 0, this.fRemainderBytes, 0, this.fRemainderCount);
                ByteArrayPool.deallocateSmallByteArray(byArray);
            }
            try {
                this.readFromStreamIntoRemainder();
            }
            catch (IOException iOException) {
                parsedEntity.error = CharConversionError.runtimeIOError(iOException);
                return parsedEntity.error;
            }
            dataBuffer = this.fRemainderCount <= SMALL_BUFFER_SIZE ? this.fBufferFactory.createBuffer(SMALL_BUFFER_SIZE + 1) : this.fBufferFactory.createBuffer(LARGE_BUFFER_SIZE + 1);
            if (LoggerUtil.isFineLoggable(logger)) {
                logger.logp(Level.FINE, cn, "load", "created data buffer, id=" + dataBuffer.id + ", buffer size=" + (dataBuffer.bytes.length - 1) + ", fRemainderCount=" + this.fRemainderCount);
            }
            dataBuffer.endOffset = 0;
            parsedEntity.error = this.fEncodingSupport.load(this, dataBuffer);
        }
        return this.processLoadResult(parsedEntity, dataBuffer);
    }

    private CharConversionError processLoadResult(ParsedEntity parsedEntity, DataBuffer dataBuffer) {
        int n2 = dataBuffer.endOffset;
        dataBuffer.bytes[n2] = 0;
        dataBuffer.startOffset = 0;
        if (parsedEntity.isCoordinatesAware) {
            if (parsedEntity.buffer != null) {
                if (parsedEntity.isXML10) {
                    DataBufferHelper.computeCoords10(parsedEntity.buffer, dataBuffer);
                } else {
                    DataBufferHelper.computeCoords11(parsedEntity.buffer, dataBuffer);
                }
                dataBuffer.byteOffset = parsedEntity.buffer.byteOffset + parsedEntity.buffer.endOffset - parsedEntity.buffer.startOffset;
            } else {
                dataBuffer.byteOffset = 0;
            }
        }
        if (LoggerUtil.isFineLoggable(logger)) {
            logger.logp(Level.FINE, cn, "processLoadResult", "adding buffer to parsed entity, endOffset=" + n2 + ", fRemainderCount=" + this.fRemainderCount);
        }
        if (this.fStream == null && this.fRemainderCount == 0) {
            parsedEntity.setValues(dataBuffer, 0, n2, null);
            this.release();
        } else {
            parsedEntity.setValues(dataBuffer, 0, n2, this);
        }
        return parsedEntity.error;
    }

    public void release() {
        if (this.fStream != null) {
            try {
                this.fStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fStream = null;
        }
        this.fRemainderBytes = null;
        this.fRemainderCount = 0;
        this.fEncodingName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharConversionError convertToCharacterStream(ParsedEntity parsedEntity, boolean bl) {
        try {
            RewindableInputStream rewindableInputStream = new RewindableInputStream(this.fStream, this.fReadAheadBytes, this.fReadAheadCount);
            this.fStream = null;
            this.fReadAheadCount = 0;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)rewindableInputStream, Charset.forName(this.getEncodingName()).newDecoder());
            CharacterStreamDataSource characterStreamDataSource = new CharacterStreamDataSource(this.fBufferFactory, inputStreamReader);
            characterStreamDataSource.setIsXML10(this.fIsXML10);
            CharConversionError charConversionError = characterStreamDataSource.loadFromCharacterStream(parsedEntity, bl);
            return charConversionError;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(illegalArgumentException.getMessage());
            unsupportedEncodingException.initCause(illegalArgumentException);
            CharConversionError charConversionError = parsedEntity.error = CharConversionError.runtimeIOError(unsupportedEncodingException);
            return charConversionError;
        }
        finally {
            this.release();
        }
    }
}

