/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.api.util.DataBufferHelper;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.ByteArrayPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataSource;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.Pool;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.Base64;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class CharacterStreamDataSource
implements DataSource {
    private static final String cn = CharacterStreamDataSource.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(CharacterStreamDataSource.class);
    private static final int SMALL_BUFFER_SIZE = ByteArrayPool.SMALL_BYTE_ARRAY_SIZE;
    private static final int LARGE_BUFFER_SIZE = ByteArrayPool.LARGE_BYTE_ARRAY_SIZE;
    private static final boolean CLEAR_TO_END_OF_BUFFER = false;
    private static final int BUFFER_LOAD_FACTOR = ByteStreamDataSource.BUFFER_LOAD_FACTOR;
    private final DataBufferFactory fBufferFactory;
    private Reader fReader;
    private boolean fIsXML10;
    private static final Pool<char[]> fgReadBufferPool = new Pool("char[]");
    private char[] fReadBuffer;
    private int fReadOffset;
    private int fReadLimit;
    private int fReadLength;

    public CharacterStreamDataSource(DataBufferFactory dataBufferFactory, Reader reader) {
        this.fBufferFactory = dataBufferFactory;
        this.fReader = reader;
        this.fIsXML10 = true;
    }

    public void setIsXML10(boolean bl) {
        this.fIsXML10 = bl;
    }

    public int readFromReader(char[] cArray, int n2, int n3) throws IOException {
        try {
            int n4 = this.fReader.read(cArray, n2, n3);
            if (n4 == -1) {
                this.handleEndOfStream();
                return -1;
            }
            if (LoggerUtil.isFinerLoggable(logger)) {
                this.logData(cArray, n2, n4);
            }
            int n5 = n3 >> BUFFER_LOAD_FACTOR;
            while (n4 < n5) {
                int n6 = n2 + n4;
                int n7 = this.fReader.read(cArray, n6, n3 - n4);
                if (n7 == -1) {
                    this.handleEndOfStream();
                    break;
                }
                if (LoggerUtil.isFinerLoggable(logger)) {
                    this.logData(cArray, n6, n7);
                }
                n4 += n7;
            }
            return n4;
        }
        catch (IOException iOException) {
            if (LoggerUtil.isFinerLoggable(logger)) {
                Object[] objectArray = new Object[]{this.fReader, iOException};
                logger.logp(Level.FINER, cn, "readFromReader", "exception thrown {0} {1}", objectArray);
            }
            this.safeClose();
            throw iOException;
        }
    }

    private void logData(char[] cArray, int n2, int n3) {
        int n4 = n3 * 2;
        byte[] byArray = ArrayAllocator.newByteArray(n4);
        for (int i = 0; i < n4; i += 2) {
            char c = cArray[n2++];
            byArray[i] = (byte)(c >> 8);
            byArray[i + 1] = (byte)(c & 0xFF);
        }
        String string2 = Base64.encode(byArray);
        Object[] objectArray = new Object[]{this.fReader, string2};
        logger.logp(Level.FINER, cn, "logData", "data {0} {1}", objectArray);
    }

    private void handleEndOfStream() throws IOException {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "handleEndOfStream", "end of reader {0}", this.fReader);
        }
        Reader reader = this.fReader;
        this.fReader = null;
        reader.close();
    }

    private int readMoreChars() throws IOException {
        int n2;
        int n3 = this.fReadLength;
        if (this.fReadOffset == n3) {
            if (this.fReadBuffer == null) {
                this.fReadBuffer = fgReadBufferPool.get();
                if (this.fReadBuffer == null) {
                    this.fReadBuffer = ArrayAllocator.newCharArray(LARGE_BUFFER_SIZE);
                }
                this.fReadLength = this.fReadBuffer.length;
            } else {
                this.fReadLength <<= 1;
                this.fReadBuffer = ArrayAllocator.resizeCharArray(this.fReadBuffer, this.fReadLength);
            }
            n3 = this.fReadLength;
        }
        if ((n2 = this.readFromReader(this.fReadBuffer, this.fReadOffset, n3 - this.fReadOffset)) == -1) {
            return -1;
        }
        this.fReadLimit += n2;
        return this.fReadBuffer[this.fReadOffset++];
    }

    public int readChar() throws IOException {
        if (this.fReadOffset < this.fReadLimit) {
            return this.fReadBuffer[this.fReadOffset++];
        }
        return this.readMoreChars();
    }

    public CharConversionError loadFromCharacterStream(ParsedEntity parsedEntity, boolean bl) {
        if (bl) {
            parsedEntity.isXML10 = this.fIsXML10;
        } else {
            this.fIsXML10 = parsedEntity.isXML10;
        }
        this.fReadOffset = this.fReadLimit;
        this.fReadLimit = 0;
        return this.load(parsedEntity);
    }

    public CharConversionError load(ParsedEntity parsedEntity) {
        DataBuffer dataBuffer;
        if (this.fReadBuffer == null) {
            if (this.fReader == null) {
                parsedEntity.setAtEndOfEntity();
                return null;
            }
            this.fReadBuffer = fgReadBufferPool.get();
            if (this.fReadBuffer == null) {
                this.fReadBuffer = ArrayAllocator.newCharArray(LARGE_BUFFER_SIZE);
            }
            this.fReadLength = this.fReadBuffer.length;
        }
        if (this.fReader != null && this.fReadOffset < this.fReadLength) {
            try {
                int n2 = this.readFromReader(this.fReadBuffer, this.fReadOffset, this.fReadLength - this.fReadOffset);
                if (n2 == -1) {
                    if (this.fReadOffset == 0) {
                        fgReadBufferPool.put(this.fReadBuffer);
                        this.fReadBuffer = null;
                        parsedEntity.setAtEndOfEntity();
                        this.release();
                        return null;
                    }
                } else {
                    this.fReadOffset += n2;
                }
            }
            catch (IOException iOException) {
                fgReadBufferPool.put(this.fReadBuffer);
                this.fReadBuffer = null;
                this.fReadOffset = 0;
                parsedEntity.setAtEndOfEntity();
                this.release();
                return CharConversionError.runtimeIOError(iOException);
            }
        }
        if (this.fReadOffset > 0) {
            if (this.fReadOffset * 3 < SMALL_BUFFER_SIZE) {
                dataBuffer = this.fBufferFactory.createBuffer(SMALL_BUFFER_SIZE + 1);
                dataBuffer.endOffset = SMALL_BUFFER_SIZE;
            } else {
                dataBuffer = this.fBufferFactory.createBuffer(LARGE_BUFFER_SIZE + 1);
                dataBuffer.endOffset = LARGE_BUFFER_SIZE;
            }
            parsedEntity.error = this.load(dataBuffer);
        } else {
            dataBuffer = null;
            dataBuffer.endOffset = 0;
        }
        int n3 = dataBuffer.endOffset;
        dataBuffer.bytes[n3] = 0;
        dataBuffer.startOffset = 0;
        if (parsedEntity.isCoordinatesAware) {
            if (parsedEntity.buffer != null) {
                if (parsedEntity.isXML10) {
                    DataBufferHelper.computeCoords10(parsedEntity.buffer, dataBuffer);
                } else {
                    DataBufferHelper.computeCoords11(parsedEntity.buffer, dataBuffer);
                }
            } else {
                dataBuffer.byteOffset = 0;
            }
        }
        if (this.fReader == null && this.fReadOffset == 0) {
            parsedEntity.setValues(dataBuffer, 0, n3, null);
            this.release();
            if (this.fReadBuffer != null) {
                fgReadBufferPool.put(this.fReadBuffer);
                this.fReadBuffer = null;
            }
        } else {
            parsedEntity.setValues(dataBuffer, 0, n3, this);
        }
        return parsedEntity.error;
    }

    public void release() {
        this.safeClose();
    }

    private void safeClose() {
        if (this.fReader != null) {
            try {
                this.fReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fReader = null;
        }
    }

    private CharConversionError load(DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n2 = dataBuffer.endOffset;
        int n3 = 0;
        int n4 = this.fReadOffset;
        this.fReadOffset = 0;
        while (this.fReadOffset < n4 && n3 < n2) {
            int n5;
            if ((n5 = this.fReadBuffer[this.fReadOffset++]) < 128) {
                if (n5 != 13) {
                    byArray[n3++] = (byte)n5;
                    continue;
                }
                if (this.fReadOffset < n4) {
                    byArray[n3++] = 10;
                    if ((n5 = this.fReadBuffer[this.fReadOffset++]) == 10 || !this.fIsXML10 && n5 == 133) continue;
                    --this.fReadOffset;
                    continue;
                }
                if (this.fReader == null) {
                    byArray[n3++] = 10;
                    break;
                }
                --this.fReadOffset;
                break;
            }
            if (!(this.fIsXML10 || n5 != 133 && n5 != 8232)) {
                byArray[n3++] = 10;
                continue;
            }
            if (n5 < 2048) {
                if (n3 + 1 < n2) {
                    byArray[n3++] = (byte)(0xC0 | n5 >> 6);
                    byArray[n3++] = (byte)(0x80 | 0x3F & n5);
                    continue;
                }
                --this.fReadOffset;
                break;
            }
            if (n5 < 55296 || n5 >= 57344) {
                if (n3 + 2 < n2) {
                    byArray[n3++] = (byte)(0xE0 | n5 >> 12);
                    byArray[n3++] = (byte)(0x80 | 0x3F & n5 >> 6);
                    byArray[n3++] = (byte)(0x80 | 0x3F & n5);
                    continue;
                }
                --this.fReadOffset;
                break;
            }
            if (n5 < 56320) {
                if (this.fReadOffset < n4 && n3 + 3 < n2) {
                    char c;
                    if ((c = this.fReadBuffer[this.fReadOffset++]) >= '\udc00' && c < '\ue000') {
                        n5 = 65536 + (n5 - 55296 << 10) + (c - 56320);
                        byArray[n3++] = (byte)(0xF0 | n5 >> 18);
                        byArray[n3++] = (byte)(0x80 | 0x3F & n5 >> 12);
                        byArray[n3++] = (byte)(0x80 | 0x3F & n5 >> 6);
                        byArray[n3++] = (byte)(0x80 | 0x3F & n5);
                        continue;
                    }
                    --this.fReadOffset;
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                --this.fReadOffset;
                break;
            }
            --this.fReadOffset;
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
        }
        if (this.fReadOffset < n4) {
            System.arraycopy(this.fReadBuffer, this.fReadOffset, this.fReadBuffer, 0, n4 -= this.fReadOffset);
            this.fReadOffset = n4;
        } else {
            fgReadBufferPool.put(this.fReadBuffer);
            this.fReadBuffer = null;
            this.fReadOffset = 0;
        }
        dataBuffer.endOffset = n3;
        return null;
    }
}

