/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.xlxp.internal.s1.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.SingleByteEncodingSupport;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class Latin1EncodingSupport
extends SingleByteEncodingSupport {
    private static final EncodingSupport fgSingleton = new Latin1EncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    private Latin1EncodingSupport() {
    }

    /*
     * Enabled aggressive block sorting
     */
    protected CharConversionError normalizeLineBreaks(DataBuffer dataBuffer, ByteStreamDataSource byteStreamDataSource) {
        byte by2;
        byte[] byArray = dataBuffer.bytes;
        int n2 = dataBuffer.endOffset;
        boolean bl = byteStreamDataSource.isXML10();
        int n3 = 0;
        byArray[n2] = 13;
        while ((by2 = byArray[n3]) != 13 && by2 >= 0) {
            ++n3;
        }
        if (n3 == n2) {
            byArray[n2] = 0;
            byteStreamDataSource.clearRemainder();
            dataBuffer.endOffset = n2;
            return null;
        }
        int n4 = n3;
        while (n3 < n2) {
            int n5;
            block13: {
                if (by2 == 13) {
                    if (++n3 < n2) {
                        by2 = byArray[n3];
                        if (by2 == 10 || !bl && (by2 & 0xFF) == 133) {
                            ++n3;
                        }
                        byArray[n4++] = 10;
                        break block13;
                    } else {
                        if (byteStreamDataSource.atEndOfStream()) {
                            byArray[n4++] = 10;
                            break;
                        }
                        --n3;
                        break;
                    }
                }
                n5 = by2 & 0xFF;
                if (!bl && n5 == 133) {
                    ++n3;
                    byArray[n4++] = 10;
                } else {
                    if (n4 >= n3) {
                        byteStreamDataSource.saveRemainder(byArray, n3, n2 - n3);
                        return this.normalizeLineBreaksDoubleBuffered(dataBuffer, n4, byteStreamDataSource);
                    }
                    ++n3;
                    byArray[n4++] = (byte)(0xC0 | n5 >> 6);
                    byArray[n4++] = (byte)(0x80 | 0x3F & n5);
                }
            }
            if ((by2 = byArray[n3]) == 13 || by2 < 0) continue;
            n5 = n3++;
            while ((by2 = byArray[n3]) != 13 && by2 >= 0) {
                ++n3;
            }
            if (n5 != n4) {
                System.arraycopy(byArray, n5, byArray, n4, n3 - n5);
            }
            n4 += n3 - n5;
        }
        byArray[n2] = 0;
        dataBuffer.endOffset = n4;
        byteStreamDataSource.saveRemainder(byArray, n3, n2 - n3);
        return null;
    }

    private CharConversionError normalizeLineBreaksDoubleBuffered(DataBuffer dataBuffer, int n2, ByteStreamDataSource byteStreamDataSource) {
        boolean bl = byteStreamDataSource.isXML10();
        byte[] byArray = byteStreamDataSource.remainderBytes();
        int n3 = byteStreamDataSource.remainderCount();
        byte[] byArray2 = dataBuffer.bytes;
        int n4 = byArray2.length - 1;
        int n5 = 0;
        byArray[n3] = 13;
        while (true) {
            int n6;
            byte by2;
            if ((by2 = byArray[n5]) >= 0 && by2 != 13) {
                int n7;
                n6 = n5++;
                while ((by2 = byArray[n5]) >= 0 && by2 != 13) {
                    ++n5;
                }
                if (n5 - n6 <= n4 - n2) {
                    n7 = n5 - n6;
                } else {
                    n7 = n4 - n2;
                    n5 = n6 + n7;
                }
                System.arraycopy(byArray, n6, byArray2, n2, n7);
                n2 += n7;
            }
            if (n5 == n3 || n2 == n4) break;
            if (by2 >= 0) {
                if (++n5 < n3) {
                    by2 = byArray[n5];
                    if (by2 == 10 || !bl && (by2 & 0xFF) == 133) {
                        ++n5;
                    }
                    byArray2[n2++] = 10;
                    continue;
                }
                if (byteStreamDataSource.atEndOfStream()) {
                    byArray2[n2++] = 10;
                    break;
                }
                --n5;
                break;
            }
            n6 = (char)(by2 & 0xFF);
            if (!bl && n6 == 133) {
                ++n5;
                byArray2[n2++] = 10;
                continue;
            }
            if (n2 + 1 >= n4) break;
            ++n5;
            byArray2[n2++] = (byte)(0xC0 | n6 >> 6);
            byArray2[n2++] = (byte)(0x80 | 0x3F & n6);
        }
        dataBuffer.endOffset = n2;
        byArray2[n2] = 0;
        byteStreamDataSource.updateRemainder(n5, n3 - n5, 0);
        return null;
    }
}

