/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.xlxp.internal.s1.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class UCSEncodingSupport
implements EncodingSupport {
    private static final String COPYRIGHT_YEARS = "Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int UTF_16 = 0;
    public static final int UTF_16BE = 1;
    public static final int UTF_16LE = 2;
    public static final int UTF_32BE = 3;
    public static final int UTF_32LE = 4;
    private static final int ENCODINGS_COUNT = 5;
    private static EncodingSupport[] fgSingletons;

    public static EncodingSupport getInstance(int n2) {
        if (n2 < 0 || n2 > 5) {
            return null;
        }
        if (fgSingletons == null) {
            fgSingletons = ArrayAllocator.newObjectArray(EncodingSupport.class, 5);
        } else if (fgSingletons[n2] != null) {
            return fgSingletons[n2];
        }
        switch (n2) {
            case 0: {
                UCSEncodingSupport.fgSingletons[n2] = new UTF16();
                return UCSEncodingSupport.fgSingletons[n2];
            }
            case 1: {
                UCSEncodingSupport.fgSingletons[n2] = new UTF16BE();
                return UCSEncodingSupport.fgSingletons[n2];
            }
            case 2: {
                UCSEncodingSupport.fgSingletons[n2] = new UTF16LE();
                return UCSEncodingSupport.fgSingletons[n2];
            }
            case 3: {
                UCSEncodingSupport.fgSingletons[n2] = new UTF32BE();
                return UCSEncodingSupport.fgSingletons[n2];
            }
            case 4: {
                UCSEncodingSupport.fgSingletons[n2] = new UTF32LE();
                return UCSEncodingSupport.fgSingletons[n2];
            }
        }
        return null;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, boolean bl, ByteStreamDataSource byteStreamDataSource) {
        return byteStreamDataSource.loadFromByteStream(parsedEntity, bl, this, false);
    }

    protected UCSEncodingSupport() {
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF32LE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n2 = byArray.length - 1;
            boolean bl = byteStreamDataSource.isXML10();
            byte[] byArray2 = byteStreamDataSource.remainderBytes();
            int n3 = byteStreamDataSource.remainderCount();
            int n4 = 0;
            int n5 = 0;
            while (n4 + 3 < n3 && n5 < n2) {
                int n6;
                int n7;
                int n8 = byArray2[n4++] & 0xFF;
                int n9 = byArray2[n4++] & 0xFF;
                int n10 = byArray2[n4++] & 0xFF;
                if ((n7 = byArray2[n4++] & 0xFF) == 0 && n10 == 0) {
                    if (n9 == 0 && n8 < 128) {
                        if (n8 != 13) {
                            byArray[n5++] = (byte)n8;
                            continue;
                        }
                        if (n4 + 3 < n3) {
                            byArray[n5++] = 10;
                            n8 = byArray2[n4++] & 0xFF;
                            n9 = byArray2[n4++] & 0xFF;
                            n10 = byArray2[n4++] & 0xFF;
                            if ((n7 = byArray2[n4++] & 0xFF) == 0 && n10 == 0 && n9 == 0 && (n8 == 10 || !bl && n8 == 133)) continue;
                            n4 -= 4;
                            continue;
                        }
                        if (byteStreamDataSource.atEndOfStream()) {
                            byArray[n5++] = 10;
                            break;
                        }
                        n4 -= 4;
                        break;
                    }
                    n6 = (n9 << 8) + n8;
                    if (!(bl || n6 != 133 && n6 != 8232)) {
                        byArray[n5++] = 10;
                        continue;
                    }
                    if (n6 < 2048) {
                        if (n5 + 1 < n2) {
                            byArray[n5++] = (byte)(0xC0 | n6 >> 6);
                            byArray[n5++] = (byte)(0x80 | 0x3F & n6);
                            continue;
                        }
                        n4 -= 4;
                        break;
                    }
                    if (n5 + 2 < n2) {
                        byArray[n5++] = (byte)(0xE0 | n6 >> 12);
                        byArray[n5++] = (byte)(0x80 | 0x3F & n6 >> 6);
                        byArray[n5++] = (byte)(0x80 | 0x3F & n6);
                        continue;
                    }
                    n4 -= 4;
                    break;
                }
                if (n5 + 3 < n2) {
                    n6 = (n7 << 24) + (n10 << 16) + (n9 << 8) + n8;
                    byArray[n5++] = (byte)(0xF0 | n6 >> 18);
                    byArray[n5++] = (byte)(0x80 | 0x3F & n6 >> 12);
                    byArray[n5++] = (byte)(0x80 | 0x3F & n6 >> 6);
                    byArray[n5++] = (byte)(0x80 | 0x3F & n6);
                    continue;
                }
                n4 -= 4;
                break;
            }
            if (!byteStreamDataSource.updateRemainder(n4, n3 - n4, 4)) {
                return CharConversionError.insufficientInputToDecodeCharacter();
            }
            dataBuffer.endOffset = n5;
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF32BE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n2 = byArray.length - 1;
            boolean bl = byteStreamDataSource.isXML10();
            byte[] byArray2 = byteStreamDataSource.remainderBytes();
            int n3 = byteStreamDataSource.remainderCount();
            int n4 = 0;
            int n5 = 0;
            while (n4 + 3 < n3 && n5 < n2) {
                int n6;
                int n7 = byArray2[n4++] & 0xFF;
                int n8 = byArray2[n4++] & 0xFF;
                int n9 = byArray2[n4++] & 0xFF;
                int n10 = byArray2[n4++] & 0xFF;
                if (n7 == 0 && n8 == 0) {
                    if (n9 == 0 && n10 < 128) {
                        if (n10 != 13) {
                            byArray[n5++] = (byte)n10;
                            continue;
                        }
                        if (n4 + 3 < n3) {
                            byArray[n5++] = 10;
                            n7 = byArray2[n4++] & 0xFF;
                            n8 = byArray2[n4++] & 0xFF;
                            n9 = byArray2[n4++] & 0xFF;
                            n10 = byArray2[n4++] & 0xFF;
                            if (n7 == 0 && n8 == 0 && n9 == 0 && (n10 == 10 || !bl && n10 == 133)) continue;
                            n4 -= 4;
                            continue;
                        }
                        if (byteStreamDataSource.atEndOfStream()) {
                            byArray[n5++] = 10;
                            break;
                        }
                        n4 -= 4;
                        break;
                    }
                    n6 = (n9 << 8) + n10;
                    if (!(bl || n6 != 133 && n6 != 8232)) {
                        byArray[n5++] = 10;
                        continue;
                    }
                    if (n6 < 2048) {
                        if (n5 + 1 < n2) {
                            byArray[n5++] = (byte)(0xC0 | n6 >> 6);
                            byArray[n5++] = (byte)(0x80 | 0x3F & n6);
                            continue;
                        }
                        n4 -= 4;
                        break;
                    }
                    if (n5 + 2 < n2) {
                        byArray[n5++] = (byte)(0xE0 | n6 >> 12);
                        byArray[n5++] = (byte)(0x80 | 0x3F & n6 >> 6);
                        byArray[n5++] = (byte)(0x80 | 0x3F & n6);
                        continue;
                    }
                    n4 -= 4;
                    break;
                }
                if (n5 + 3 < n2) {
                    n6 = (n7 << 24) + (n8 << 16) + (n9 << 8) + n10;
                    byArray[n5++] = (byte)(0xF0 | n6 >> 18);
                    byArray[n5++] = (byte)(0x80 | 0x3F & n6 >> 12);
                    byArray[n5++] = (byte)(0x80 | 0x3F & n6 >> 6);
                    byArray[n5++] = (byte)(0x80 | 0x3F & n6);
                    continue;
                }
                n4 -= 4;
                break;
            }
            if (!byteStreamDataSource.updateRemainder(n4, n3 - n4, 4)) {
                return CharConversionError.insufficientInputToDecodeCharacter();
            }
            dataBuffer.endOffset = n5;
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF16LE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n2 = byArray.length - 1;
            boolean bl = byteStreamDataSource.isXML10();
            byte[] byArray2 = byteStreamDataSource.remainderBytes();
            int n3 = byteStreamDataSource.remainderCount();
            int n4 = 0;
            int n5 = 0;
            while (n4 + 1 < n3 && n5 < n2) {
                int n6;
                int n7 = byArray2[n4++] & 0xFF;
                if ((n6 = byArray2[n4++] & 0xFF) == 0 && n7 < 128) {
                    if (n7 != 13) {
                        byArray[n5++] = (byte)n7;
                        continue;
                    }
                    if (n4 + 1 < n3) {
                        byArray[n5++] = 10;
                        n7 = byArray2[n4++] & 0xFF;
                        if ((n6 = byArray2[n4++] & 0xFF) == 0 && (n7 == 10 || !bl && n7 == 133)) continue;
                        n4 -= 2;
                        continue;
                    }
                    if (byteStreamDataSource.atEndOfStream()) {
                        byArray[n5++] = 10;
                        break;
                    }
                    n4 -= 2;
                    break;
                }
                int n8 = (n6 << 8) + n7;
                if (!(bl || n8 != 133 && n8 != 8232)) {
                    byArray[n5++] = 10;
                    continue;
                }
                if (n8 < 2048) {
                    if (n5 + 1 < n2) {
                        byArray[n5++] = (byte)(0xC0 | n8 >> 6);
                        byArray[n5++] = (byte)(0x80 | 0x3F & n8);
                        continue;
                    }
                    n4 -= 2;
                    break;
                }
                if (n8 < 55296 || n8 >= 57344) {
                    if (n5 + 2 < n2) {
                        byArray[n5++] = (byte)(0xE0 | n8 >> 12);
                        byArray[n5++] = (byte)(0x80 | 0x3F & n8 >> 6);
                        byArray[n5++] = (byte)(0x80 | 0x3F & n8);
                        continue;
                    }
                    n4 -= 2;
                    break;
                }
                if (n8 < 56320) {
                    if (n4 < n3 && n5 + 3 < n2) {
                        int n9;
                        if ((n9 = ((n6 = byArray2[n4++] & 0xFF) << 8) + (n7 = byArray2[n4++] & 0xFF)) >= 56320 && n9 < 57344) {
                            n8 = 65536 + (n8 - 55296 << 10) + (n9 - 56320);
                            byArray[n5++] = (byte)(0xF0 | n8 >> 18);
                            byArray[n5++] = (byte)(0x80 | 0x3F & n8 >> 12);
                            byArray[n5++] = (byte)(0x80 | 0x3F & n8 >> 6);
                            byArray[n5++] = (byte)(0x80 | 0x3F & n8);
                            continue;
                        }
                        return CharConversionError.invalidSecondHalfOfSurrogatePair();
                    }
                    n4 -= 2;
                    break;
                }
                return CharConversionError.invalidFirstHalfOfSurrogatePair();
            }
            if (!byteStreamDataSource.updateRemainder(n4, n3 - n4, 2)) {
                return CharConversionError.insufficientInputToDecodeCharacter();
            }
            dataBuffer.endOffset = n5;
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF16BE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n2 = byArray.length - 1;
            boolean bl = byteStreamDataSource.isXML10();
            byte[] byArray2 = byteStreamDataSource.remainderBytes();
            int n3 = byteStreamDataSource.remainderCount();
            int n4 = 0;
            int n5 = 0;
            while (n4 + 1 < n3 && n5 < n2) {
                int n6 = byArray2[n4++] & 0xFF;
                int n7 = byArray2[n4++] & 0xFF;
                if (n6 == 0 && n7 < 128) {
                    if (n7 != 13) {
                        byArray[n5++] = (byte)n7;
                        continue;
                    }
                    if (n4 + 1 < n3) {
                        byArray[n5++] = 10;
                        n6 = byArray2[n4++] & 0xFF;
                        n7 = byArray2[n4++] & 0xFF;
                        if (n6 == 0 && (n7 == 10 || !bl && n7 == 133)) continue;
                        n4 -= 2;
                        continue;
                    }
                    if (byteStreamDataSource.atEndOfStream()) {
                        byArray[n5++] = 10;
                        break;
                    }
                    n4 -= 2;
                    break;
                }
                int n8 = (n6 << 8) + n7;
                if (!(bl || n8 != 133 && n8 != 8232)) {
                    byArray[n5++] = 10;
                    continue;
                }
                if (n8 < 2048) {
                    if (n5 + 1 < n2) {
                        byArray[n5++] = (byte)(0xC0 | n8 >> 6);
                        byArray[n5++] = (byte)(0x80 | 0x3F & n8);
                        continue;
                    }
                    n4 -= 2;
                    break;
                }
                if (n8 < 55296 || n8 >= 57344) {
                    if (n5 + 2 < n2) {
                        byArray[n5++] = (byte)(0xE0 | n8 >> 12);
                        byArray[n5++] = (byte)(0x80 | 0x3F & n8 >> 6);
                        byArray[n5++] = (byte)(0x80 | 0x3F & n8);
                        continue;
                    }
                    n4 -= 2;
                    break;
                }
                if (n8 < 56320) {
                    if (n4 < n3 && n5 + 3 < n2) {
                        int n9;
                        if ((n9 = ((n6 = byArray2[n4++] & 0xFF) << 8) + (n7 = byArray2[n4++] & 0xFF)) >= 56320 && n9 < 57344) {
                            n8 = 65536 + (n8 - 55296 << 10) + (n9 - 56320);
                            byArray[n5++] = (byte)(0xF0 | n8 >> 18);
                            byArray[n5++] = (byte)(0x80 | 0x3F & n8 >> 12);
                            byArray[n5++] = (byte)(0x80 | 0x3F & n8 >> 6);
                            byArray[n5++] = (byte)(0x80 | 0x3F & n8);
                            continue;
                        }
                        return CharConversionError.invalidSecondHalfOfSurrogatePair();
                    }
                    n4 -= 2;
                    break;
                }
                return CharConversionError.invalidFirstHalfOfSurrogatePair();
            }
            if (!byteStreamDataSource.updateRemainder(n4, n3 - n4, 2)) {
                return CharConversionError.insufficientInputToDecodeCharacter();
            }
            dataBuffer.endOffset = n5;
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class UTF16
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            return CharConversionError.inconsistentEncoding();
        }
    }
}

