/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.api.util.encoding;

import com.ibm.xml.xlxp.internal.s1.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.internal.s1.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import java.security.AccessController;
import java.security.PrivilegedAction;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UTF8EncodingSupport
implements EncodingSupport {
    private static final boolean normalizeLineBreaks = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("com.ibm.xml.xlxp.internal.s1.api.util.encoding.UTF8EncodingSupport.normalizeLineBreaks");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });
    private static final EncodingSupport fgSingleton = new UTF8EncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, boolean bl, ByteStreamDataSource byteStreamDataSource) {
        return byteStreamDataSource.loadFromByteStream(parsedEntity, bl, this, true);
    }

    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        if (!normalizeLineBreaks) {
            byteStreamDataSource.clearRemainder();
            return null;
        }
        if (byteStreamDataSource.isXML10()) {
            return this.normalizeLineBreaksXML10(dataBuffer, byteStreamDataSource);
        }
        return this.normalizeLineBreaksXML11(dataBuffer, byteStreamDataSource);
    }

    private UTF8EncodingSupport() {
    }

    private CharConversionError normalizeLineBreaksXML10(DataBuffer dataBuffer, ByteStreamDataSource byteStreamDataSource) {
        byte[] byArray = dataBuffer.bytes;
        int n2 = dataBuffer.endOffset;
        int n3 = 0;
        byArray[n2] = 13;
        while (byArray[n3] != 13) {
            ++n3;
        }
        if (n3 == n2) {
            byArray[n2] = 0;
            byteStreamDataSource.clearRemainder();
            dataBuffer.endOffset = n2;
            return null;
        }
        int n4 = n3;
        while (n3 < n2) {
            if (++n3 < n2) {
                if (byArray[n3] == 10) {
                    ++n3;
                }
            } else {
                if (byteStreamDataSource.atEndOfStream()) {
                    byArray[n4++] = 10;
                    break;
                }
                --n3;
                break;
            }
            byArray[n4++] = 10;
            if (byArray[n3] == 13) continue;
            int n5 = n3++;
            while (byArray[n3] != 13) {
                ++n3;
            }
            if (n5 != n4) {
                System.arraycopy(byArray, n5, byArray, n4, n3 - n5);
            }
            n4 += n3 - n5;
        }
        byArray[n2] = 0;
        dataBuffer.endOffset = n4;
        byteStreamDataSource.saveRemainder(byArray, n3, n2 - n3);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CharConversionError normalizeLineBreaksXML11(DataBuffer dataBuffer, ByteStreamDataSource byteStreamDataSource) {
        byte by2;
        byte[] byArray = dataBuffer.bytes;
        int n2 = dataBuffer.endOffset;
        int n3 = 0;
        byArray[n2] = 13;
        while ((by2 = byArray[n3]) != 13 && by2 >= 0) {
            ++n3;
        }
        if (by2 != 13 && (by2 & 0xDF) != 194) {
            ++n3;
            while ((by2 = byArray[n3]) != 13 && (by2 & 0xDF) != 194) {
                ++n3;
            }
        }
        if (n3 == n2) {
            byArray[n2] = 0;
            byteStreamDataSource.clearRemainder();
            dataBuffer.endOffset = n2;
            return null;
        }
        int n4 = n3;
        while (n3 < n2) {
            int n5;
            block28: {
                block29: {
                    block31: {
                        block30: {
                            if (by2 == 13) {
                                if (++n3 < n2) {
                                    by2 = byArray[n3];
                                    if (by2 == 10) {
                                        ++n3;
                                    } else if ((by2 & 0xFF) == 194) {
                                        if (n3 + 1 < n2) {
                                            by2 = byArray[n3 + 1];
                                            if ((by2 & 0xFF) == 133) {
                                                n3 += 2;
                                            }
                                        } else {
                                            if (byteStreamDataSource.atEndOfStream()) {
                                                byArray[n4++] = 13;
                                                byArray[n4++] = by2;
                                                break;
                                            }
                                            --n3;
                                            break;
                                        }
                                    }
                                    byArray[n4++] = 10;
                                    break block28;
                                } else {
                                    if (byteStreamDataSource.atEndOfStream()) {
                                        byArray[n4++] = 10;
                                        break;
                                    }
                                    --n3;
                                    break;
                                }
                            }
                            if (++n3 >= n2) break block29;
                            n5 = byArray[n3++];
                            if ((by2 & 0xFF) != 194) break block30;
                            if ((n5 & 0xFF) == 133) {
                                byArray[n4++] = 10;
                                break block28;
                            } else if (n4 + 2 == n3) {
                                n4 = n3;
                                break block28;
                            } else {
                                byArray[n4++] = by2;
                                byArray[n4++] = n5;
                            }
                            break block28;
                        }
                        if (n3 >= n2) break block31;
                        byte by3 = byArray[n3++];
                        if ((n5 & 0xFF) == 128 && (by3 & 0xFF) == 168) {
                            byArray[n4++] = 10;
                            break block28;
                        } else if (n4 + 3 == n3) {
                            n4 = n3;
                            break block28;
                        } else {
                            byArray[n4++] = by2;
                            byArray[n4++] = n5;
                            byArray[n4++] = by3;
                        }
                        break block28;
                    }
                    if (byteStreamDataSource.atEndOfStream()) {
                        byArray[n4++] = by2;
                        byArray[n4++] = n5;
                        break;
                    }
                    n3 -= 2;
                    break;
                }
                if (byteStreamDataSource.atEndOfStream()) {
                    byArray[n4++] = by2;
                    break;
                }
                --n3;
                break;
            }
            if ((by2 = byArray[n3]) == 13 || (by2 & 0xDF) == 194) continue;
            n5 = n3++;
            while ((by2 = byArray[n3]) != 13 && (by2 & 0xDF) != 194) {
                ++n3;
            }
            if (n5 != n4) {
                System.arraycopy(byArray, n5, byArray, n4, n3 - n5);
            }
            n4 += n3 - n5;
        }
        byArray[n2] = 0;
        dataBuffer.endOffset = n4;
        byteStreamDataSource.saveRemainder(byArray, n3, n2 - n3);
        return null;
    }
}

