/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.converter;

import com.ibm.xml.xlxp.idc.XPathAttributeInfo;
import com.ibm.xml.xlxp.idc.XPathDFA;
import com.ibm.xml.xlxp.internal.s1.converter.SimpleTypeUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.util.BitSet;
import com.ibm.xml.xlxp.internal.s1.validation.idc.QNameKey;
import com.ibm.xml.xlxp.internal.s1.validation.idc.StartIDC;
import com.ibm.xml.xlxp.internal.s1.validation.idc.XPathAction;
import com.ibm.xml.xlxp.internal.s1.validation.idc.XPathAttribute;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class IDCInstructionBuilder {
    private int fTypeOwnedAttrsSize;
    private int fFinalKeyUniqueStartActionsSize;
    private int fFinalMatchActionsSize;
    private int fFinalKeyrefStartActionsSize;
    private ArrayList<com.ibm.xml.xlxp.idc.XPathAction> fKeyrefStartActions;
    private ArrayList<com.ibm.xml.xlxp.idc.XPathAction> fKeyUniqueStartActions;
    private ArrayList<com.ibm.xml.xlxp.idc.XPathAction> fMatchActions;
    private ArrayList<com.ibm.xml.xlxp.idc.XPathAction> fKeyUniqueStartNilActions;
    private ArrayList<com.ibm.xml.xlxp.idc.XPathAction> fKeyrefStartNilActions;
    private ArrayList<com.ibm.xml.xlxp.idc.XPathAction> fMatchNilActions;
    private ArrayList<com.ibm.xml.xlxp.idc.XPathAction> fEndActions;

    public IDCInstructionBuilder(int n2) {
        this.fTypeOwnedAttrsSize = n2;
    }

    public void addAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (xPathAction.action() == 1) {
            this.addStartAction(xPathAction);
        } else {
            this.addMatchAction(xPathAction);
        }
    }

    public void addEndAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (this.fEndActions == null) {
            this.fEndActions = new ArrayList();
        }
        this.fEndActions.add(xPathAction);
    }

    public void addNilAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (xPathAction.action() == 1) {
            this.addNilStartAction(xPathAction);
        } else {
            this.addNilMatchAction(xPathAction);
        }
    }

    public StartIDC createStartIDCInstruction(SimpleTypeUtil simpleTypeUtil, boolean bl) {
        if (bl) {
            return this.createStartIDCInstruction(simpleTypeUtil, this.fKeyrefStartNilActions, this.fKeyrefStartNilActions.size(), this.fKeyUniqueStartNilActions, this.fKeyUniqueStartNilActions.size(), this.fMatchNilActions, this.fMatchNilActions.size(), this.fTypeOwnedAttrsSize);
        }
        return this.createStartIDCInstruction(simpleTypeUtil, this.fKeyrefStartActions, this.fFinalKeyrefStartActionsSize, this.fKeyUniqueStartActions, this.fFinalKeyUniqueStartActionsSize, this.fMatchActions, this.fFinalMatchActionsSize, this.fTypeOwnedAttrsSize);
    }

    private StartIDC createStartIDCInstruction(SimpleTypeUtil simpleTypeUtil, List<com.ibm.xml.xlxp.idc.XPathAction> list, int n2, List<com.ibm.xml.xlxp.idc.XPathAction> list2, int n3, List<com.ibm.xml.xlxp.idc.XPathAction> list3, int n4, int n5) {
        StartIDC startIDC = new StartIDC();
        startIDC.startKeyrefActions = IDCInstructionBuilder.convertIDCActions(list, simpleTypeUtil, n5);
        startIDC.finalKeyrefStartSize = n2;
        startIDC.startKeyOrUniqueActions = IDCInstructionBuilder.convertIDCActions(list2, simpleTypeUtil, n5);
        startIDC.finalKeyOrUniqueStartSize = n3;
        startIDC.matchActions = IDCInstructionBuilder.convertIDCActions(list3, simpleTypeUtil, n5);
        startIDC.finalMatchSize = n4;
        return startIDC;
    }

    public boolean hasActions(boolean bl) {
        if (bl) {
            return this.fKeyUniqueStartNilActions != null || this.fKeyrefStartNilActions != null || this.fMatchNilActions != null;
        }
        return this.fKeyrefStartActions != null || this.fKeyUniqueStartActions != null || this.fMatchActions != null;
    }

    private void addStartAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (xPathAction.idcCategory() == 2) {
            this.addKeyrefStartAction(xPathAction);
        } else {
            this.addKeyUniqueStartAction(xPathAction);
        }
    }

    private void addKeyUniqueStartAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (this.fKeyUniqueStartActions == null) {
            this.fKeyUniqueStartActions = new ArrayList();
        }
        if (xPathAction.isNewStateFinal()) {
            ++this.fFinalKeyUniqueStartActionsSize;
            if (this.fFinalKeyUniqueStartActionsSize <= this.fKeyUniqueStartActions.size()) {
                this.fKeyUniqueStartActions.add(this.fFinalKeyUniqueStartActionsSize - 1, xPathAction);
                return;
            }
        }
        this.fKeyUniqueStartActions.add(xPathAction);
    }

    private void addKeyrefStartAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (this.fKeyrefStartActions == null) {
            this.fKeyrefStartActions = new ArrayList();
        }
        if (xPathAction.isNewStateFinal()) {
            ++this.fFinalKeyrefStartActionsSize;
            if (this.fFinalKeyrefStartActionsSize <= this.fKeyrefStartActions.size()) {
                this.fKeyrefStartActions.add(this.fFinalKeyrefStartActionsSize - 1, xPathAction);
                return;
            }
        }
        this.fKeyrefStartActions.add(xPathAction);
    }

    private void addMatchAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (this.fMatchActions == null) {
            this.fMatchActions = new ArrayList();
        }
        if (xPathAction.isNewStateFinal()) {
            ++this.fFinalMatchActionsSize;
            if (this.fFinalMatchActionsSize <= this.fMatchActions.size()) {
                this.fMatchActions.add(this.fFinalMatchActionsSize - 1, xPathAction);
                return;
            }
        }
        this.fMatchActions.add(xPathAction);
    }

    private void addNilStartAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (xPathAction.idcCategory() == 2) {
            this.addNilKeyrefAction(xPathAction);
        } else {
            this.addNilKeyUniqueAction(xPathAction);
        }
    }

    private void addNilKeyrefAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (this.fKeyrefStartNilActions == null) {
            this.fKeyrefStartNilActions = new ArrayList();
        }
        this.fKeyrefStartNilActions.add(xPathAction);
    }

    private void addNilKeyUniqueAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (this.fKeyUniqueStartNilActions == null) {
            this.fKeyUniqueStartNilActions = new ArrayList();
        }
        this.fKeyUniqueStartNilActions.add(xPathAction);
    }

    private void addNilMatchAction(com.ibm.xml.xlxp.idc.XPathAction xPathAction) {
        if (this.fMatchNilActions == null) {
            this.fMatchNilActions = new ArrayList();
        }
        this.fMatchNilActions.add(xPathAction);
    }

    static com.ibm.xml.xlxp.internal.s1.validation.idc.XPathDFA[] createXPathDFAs(List list, SimpleTypeUtil simpleTypeUtil, int n2) {
        int n3 = list.size();
        com.ibm.xml.xlxp.internal.s1.validation.idc.XPathDFA[] xPathDFAArray = new com.ibm.xml.xlxp.internal.s1.validation.idc.XPathDFA[n3];
        for (int i = 0; i < n3; ++i) {
            XPathAttributeInfo[][] xPathAttributeInfoArray;
            int n4;
            XPathDFA xPathDFA = (XPathDFA)list.get(i);
            com.ibm.xml.xlxp.internal.s1.validation.idc.XPathDFA xPathDFA2 = new com.ibm.xml.xlxp.internal.s1.validation.idc.XPathDFA();
            xPathDFA2.idcID = xPathDFA.idcId();
            xPathDFA2.xpathID = xPathDFA.id();
            xPathDFA2.isSelector = xPathDFA2.xpathID < n2;
            xPathDFA2.transitionTable = xPathDFA.transitionTable();
            String[] stringArray = xPathDFA.transitionSymbols();
            if (stringArray != null && stringArray.length > 0) {
                int n5 = stringArray.length / 2;
                xPathDFA2.transitionSymbols = new QNameKey[n5];
                for (n4 = 0; n4 < n5; ++n4) {
                    String string2 = stringArray[n4 * 2];
                    String string3 = stringArray[n4 * 2 + 1];
                    string2 = string2 != null ? simpleTypeUtil.internString(string2) : null;
                    string3 = string3 != null ? simpleTypeUtil.internString(string3) : null;
                    xPathDFA2.transitionSymbols[n4] = new QNameKey();
                    xPathDFA2.transitionSymbols[n4].fill(string2, string3);
                }
            }
            int n6 = n4 = (xPathAttributeInfoArray = xPathDFA.finalAttrDecls()) == null ? 0 : xPathAttributeInfoArray.length;
            if (n4 > 0) {
                xPathDFA2.finalAttrDecls = new XPathAttribute[n4][];
            }
            for (int j = 0; j < n4; ++j) {
                int n7;
                int n8 = n7 = xPathAttributeInfoArray[j] == null ? 0 : xPathAttributeInfoArray[j].length;
                if (n7 > 0) {
                    xPathDFA2.finalAttrDecls[j] = new XPathAttribute[n7];
                }
                for (int k = 0; k < n7; ++k) {
                    String string4 = xPathAttributeInfoArray[j][k].namespace();
                    String string5 = xPathAttributeInfoArray[j][k].name();
                    xPathDFA2.finalAttrDecls[j][k] = new XPathAttribute();
                    string4 = string4 != null ? simpleTypeUtil.internString(string4) : null;
                    string5 = string5 != null ? simpleTypeUtil.internString(string5) : null;
                    xPathDFA2.finalAttrDecls[j][k].nsURI = string4;
                    xPathDFA2.finalAttrDecls[j][k].localName = string5;
                    xPathDFA2.finalAttrDecls[j][k].index = xPathAttributeInfoArray[j][k].index();
                }
            }
            xPathDFA2.allowMoreInput = xPathDFA.allowMoreInput();
            xPathDFA2.startFieldActions = IDCInstructionBuilder.convertIDCActions(xPathDFA.startFieldActions(), simpleTypeUtil, 0);
            xPathDFA2.finalFieldsStartSize = xPathDFA.finalFieldsStartSize();
            xPathDFAArray[i] = xPathDFA2;
        }
        return xPathDFAArray;
    }

    private static XPathAction[] convertIDCActions(List list, SimpleTypeUtil simpleTypeUtil, int n2) {
        if (list == null || list.size() == 0) {
            return null;
        }
        XPathAction[] xPathActionArray = new XPathAction[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int n3;
            com.ibm.xml.xlxp.idc.XPathAction xPathAction = (com.ibm.xml.xlxp.idc.XPathAction)list.get(i);
            XPathAction xPathAction2 = new XPathAction();
            xPathAction2.isSelector = xPathAction.isSelector();
            xPathAction2.xpathID = xPathAction.xpathId();
            xPathAction2.oldState = xPathAction.oldState();
            xPathAction2.newState = xPathAction.newState();
            xPathAction2.isNewStateFinal = xPathAction.isNewStateFinal();
            xPathAction2.allowMoreInput = xPathAction.allowMoreInput();
            xPathAction2.idcID = xPathAction.idcId();
            xPathAction2.idcCategory = xPathAction.idcCategory();
            xPathAction2.idcID4Key = xPathAction.idcId4Key();
            xPathAction2.fieldIndex = xPathAction.fieldIndex();
            xPathAction2.fieldCount = xPathAction.fieldCount();
            XPathAttributeInfo[] xPathAttributeInfoArray = xPathAction.attributes();
            int n4 = n3 = xPathAttributeInfoArray == null ? 0 : xPathAttributeInfoArray.length;
            if (n3 > 0) {
                int n5;
                boolean bl = true;
                if (n2 <= 0) {
                    bl = false;
                } else {
                    for (n5 = 0; n5 < n3; ++n5) {
                        if (xPathAttributeInfoArray[n5].index() > 0) continue;
                        bl = false;
                    }
                }
                xPathAction2.finalAttrDecls = new XPathAttribute[n3];
                if (bl) {
                    xPathAction2.finalAttrs = new BitSet(n2);
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    String string2 = xPathAttributeInfoArray[n5].namespace();
                    String string3 = xPathAttributeInfoArray[n5].name();
                    xPathAction2.finalAttrDecls[n5] = new XPathAttribute();
                    xPathAction2.finalAttrDecls[n5].nsURI = string2 != null ? simpleTypeUtil.internString(string2) : null;
                    xPathAction2.finalAttrDecls[n5].localName = string3 != null ? simpleTypeUtil.internString(string3) : null;
                    xPathAction2.finalAttrDecls[n5].index = xPathAttributeInfoArray[n5].index();
                    if (!bl) continue;
                    xPathAction2.finalAttrs.setBit(xPathAttributeInfoArray[n5].index());
                }
            }
            xPathAction2.startFieldActions = IDCInstructionBuilder.convertIDCActions(xPathAction.startFieldActions(), simpleTypeUtil, n2);
            xPathAction2.finalFieldsStartSize = xPathAction.startFieldActionsFinalSize();
            xPathAction2.depthIncrement = 1;
            xPathActionArray[i] = xPathAction2;
        }
        return xPathActionArray;
    }
}

