/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.converter;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.converter.Converter;
import com.ibm.xml.xlxp.internal.s1.converter.DVFactory;
import com.ibm.xml.xlxp.internal.s1.converter.Merger;
import com.ibm.xml.xlxp.internal.s1.grammar.Grammar;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class MergerContext {
    public static final Logger logger = LoggerUtil.getLogger(MergerContext.class);
    protected Grammar grammar = null;
    protected Merger merger;
    protected final boolean validating;
    protected boolean invalid = false;

    public MergerContext(boolean bl) {
        this.validating = bl;
        this.merger = null;
        this.invalid = false;
    }

    public abstract boolean handleUnknownComponent(VMContext var1, String var2, String var3, short var4);

    public abstract XSModel getXSModel();

    public abstract int getGrammarVersionFromScanner(VMContext var1);

    public abstract void setGrammarVersionOnScanner(VMContext var1, int var2);

    public abstract void setDynamicSchemaResolverOnScanner(VMContext var1);

    public abstract void waitUntilUpdateComplete();

    private final void ensureConsistency() {
        if (this.invalid) {
            throw new RuntimeException("Internal error: inconsistent MergerContext");
        }
    }

    protected boolean mergeGrammar(VMContext vMContext) {
        this.ensureConsistency();
        XSModel xSModel = this.getXSModel();
        if (xSModel == this.grammar.xsModel) {
            int n2 = this.grammar.getVersion();
            if (this.getGrammarVersionFromScanner(vMContext) != n2) {
                this.setGrammarVersionOnScanner(vMContext, n2);
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "mergeGrammar", "merge returned true with version update");
                }
                return true;
            }
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "mergeGrammar", "merge returned false with no change");
            }
            return false;
        }
        this.grammar.incrementVersion();
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "mergeGrammar", "merge started");
        }
        boolean bl = false;
        try {
            bl = this.merger.merge(null, null, xSModel, DVFactory.forVersion((short)0), this.grammar);
        }
        catch (Converter.ConverterException converterException) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "mergeGrammar", "ConverterException: " + converterException.getMessage());
            }
            throw new RuntimeException(converterException);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "mergeGrammar", "merge returned " + bl);
        }
        this.grammar.incrementVersion();
        int n3 = this.grammar.getVersion();
        this.setGrammarVersionOnScanner(vMContext, n3);
        return bl;
    }

    public void convertGrammar() {
        try {
            this.ensureConsistency();
            XSModel xSModel = this.getXSModel();
            if (this.grammar == null) {
                this.merger = Merger.createMerger(this.validating, this);
                this.grammar = this.merger.convert(xSModel, DVFactory.forVersion((short)0), null, null);
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "convertGrammar", "convert initial");
                }
            } else if (this.grammar.xsModel != xSModel) {
                this.grammar.incrementVersion();
                this.merger.merge(null, null, xSModel, DVFactory.forVersion((short)0), this.grammar);
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "convertGrammar", "merge *initial");
                }
                this.grammar.incrementVersion();
            } else if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "convertGrammar", "grammar up-to-date *initial");
            }
        }
        catch (Converter.ConverterException converterException) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "convertGrammar", "ConverterException: " + converterException.getMessage());
            }
            throw new RuntimeException(converterException);
        }
    }

    protected boolean retryKnownSchema(VMContext vMContext) {
        int n2 = this.grammar.getVersion();
        if (this.getGrammarVersionFromScanner(vMContext) < n2) {
            this.setGrammarVersionOnScanner(vMContext, n2);
            return true;
        }
        return false;
    }
}

