/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.converter;

import com.ibm.xml.xlxp.internal.s1.converter.DVFactory;
import com.ibm.xml.xlxp.internal.s1.converter.SimpleTypeUtil;
import com.ibm.xml.xlxp.internal.s1.converter.ValueInfo;
import com.ibm.xml.xlxp.internal.s1.converter.XSFacets;
import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.AnySimpleTypeDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.ListDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.QNameDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.UnionDV;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xml4j.api.s1.xs.ShortList;
import com.ibm.xml.xml4j.api.s1.xs.StringList;
import com.ibm.xml.xml4j.api.s1.xs.XSFacet;
import com.ibm.xml.xml4j.api.s1.xs.XSMultiValueFacet;
import com.ibm.xml.xml4j.api.s1.xs.XSObject;
import com.ibm.xml.xml4j.api.s1.xs.XSObjectList;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.ObjectList;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSDateTime;
import com.ibm.xml.xml4j.internal.s1.impl.dv.xs.XSSimpleTypeDecl;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class TypeValidatorFactoryImpl
extends DVFactory {
    @Override
    public TypeValidator createSimpleType(String string2, String string3, XSSimpleTypeDefinition xSSimpleTypeDefinition, HashMap<XSTypeDefinition, TypeValidator> hashMap, SimpleTypeUtil simpleTypeUtil) {
        TypeValidator typeValidator = hashMap.get(xSSimpleTypeDefinition);
        if (typeValidator != null) {
            return typeValidator;
        }
        XSFacets xSFacets = new XSFacets();
        this.getFacets(xSSimpleTypeDefinition, xSFacets);
        short s = xSSimpleTypeDefinition.getBuiltInKind();
        switch (s) {
            case 45: {
                XSObjectList xSObjectList = xSSimpleTypeDefinition.getMemberTypes();
                int n2 = xSObjectList.getLength();
                TypeValidator[] typeValidatorArray = new TypeValidator[n2];
                for (int i = 0; i < n2; ++i) {
                    typeValidatorArray[i] = this.createSimpleType(string2, string3, (XSSimpleTypeDefinition)xSObjectList.item(i), hashMap, simpleTypeUtil);
                }
                typeValidator = simpleTypeUtil.createUnionDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets, typeValidatorArray);
                break;
            }
            case 1: {
                typeValidator = new AnySimpleTypeDV(string2, string3, xSSimpleTypeDefinition.getName());
                break;
            }
            case 2: 
            case 21: 
            case 22: {
                typeValidator = simpleTypeUtil.createStringDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets, s);
                break;
            }
            case 3: {
                typeValidator = simpleTypeUtil.createBooleanDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 4: {
                typeValidator = simpleTypeUtil.createDecimalDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: {
                typeValidator = simpleTypeUtil.createIntegerDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets, s);
                break;
            }
            case 16: {
                typeValidator = simpleTypeUtil.createHexBinaryDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 24: {
                typeValidator = simpleTypeUtil.createNMTOKENDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 25: {
                typeValidator = simpleTypeUtil.createNameDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 26: {
                typeValidator = simpleTypeUtil.createNCNameDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 33: {
                typeValidator = simpleTypeUtil.createLongDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 34: {
                typeValidator = simpleTypeUtil.createIntDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 35: {
                typeValidator = simpleTypeUtil.createShortDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 36: {
                typeValidator = simpleTypeUtil.createByteDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 39: {
                typeValidator = simpleTypeUtil.createUnsignedIntDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 40: {
                typeValidator = simpleTypeUtil.createUnsignedShortDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 41: {
                typeValidator = simpleTypeUtil.createUnsignedByteDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 7: {
                typeValidator = simpleTypeUtil.createDurationDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 12: {
                typeValidator = simpleTypeUtil.createYearDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 15: {
                typeValidator = simpleTypeUtil.createMonthDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 14: {
                typeValidator = simpleTypeUtil.createDayDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 11: {
                typeValidator = simpleTypeUtil.createYearMonthDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 13: {
                typeValidator = simpleTypeUtil.createMonthDayDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 10: {
                typeValidator = simpleTypeUtil.createDateDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 9: {
                typeValidator = simpleTypeUtil.createTimeDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 8: {
                typeValidator = simpleTypeUtil.createDateTimeDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 5: {
                typeValidator = simpleTypeUtil.createFloatDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 6: {
                typeValidator = simpleTypeUtil.createDoubleDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 18: {
                typeValidator = simpleTypeUtil.createAnyURIDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 19: 
            case 20: {
                typeValidator = simpleTypeUtil.createQNameDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets, s);
                break;
            }
            case 43: 
            case 44: {
                XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
                TypeValidator typeValidator2 = this.createSimpleType(string2, string3, xSSimpleTypeDefinition2, hashMap, simpleTypeUtil);
                typeValidator = simpleTypeUtil.createListDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets, s, typeValidator2);
                break;
            }
            case 27: {
                typeValidator = simpleTypeUtil.createIDDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 28: {
                typeValidator = simpleTypeUtil.createIDREFDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 29: {
                typeValidator = simpleTypeUtil.createENTITYDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 23: {
                typeValidator = simpleTypeUtil.createLanguageDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            case 17: {
                typeValidator = simpleTypeUtil.createBase64BinaryDV(string2, string3, xSSimpleTypeDefinition.getName(), xSFacets);
                break;
            }
            default: {
                throw new RuntimeException("TypeValidatorFactory: unsupported or unknown built-in type.");
            }
        }
        hashMap.put(xSSimpleTypeDefinition, typeValidator);
        typeValidator.xsTypeDefinition = xSSimpleTypeDefinition;
        return typeValidator;
    }

    @Override
    public TypeValidator createListType(String string2, String string3, TypeValidator typeValidator, SimpleTypeUtil simpleTypeUtil) {
        XSFacets xSFacets = new XSFacets();
        return simpleTypeUtil.createListDV(string2, string3, null, xSFacets, 44, typeValidator);
    }

    @Override
    public ValidatedInfo getActualValue(TypeValidator typeValidator, ValueInfo valueInfo, SimpleTypeUtil simpleTypeUtil) {
        ValidatedInfo validatedInfo = new ValidatedInfo();
        if (typeValidator == null) {
            return simpleTypeUtil.parseUntypedValue(validatedInfo, valueInfo);
        }
        int n2 = typeValidator.builtInKind;
        String string2 = valueInfo.lexicalValue();
        Object object2 = null;
        String string3 = simpleTypeUtil.getSymbol(valueInfo.defaultNamespace());
        String[] stringArray = simpleTypeUtil.getSymbols(valueInfo.namespaceMapping());
        if (n2 == 45) {
            object2 = ((UnionDV)typeValidator).getActualValue(string2, valueInfo.type(), valueInfo.itemTypes(), stringArray, string3, validatedInfo, simpleTypeUtil);
        } else if (n2 == 19 || n2 == 20) {
            object2 = ((QNameDV)typeValidator).getActualValue(string2, stringArray, string3, validatedInfo);
        } else if (n2 == 44 || n2 == 43) {
            object2 = ((ListDV)typeValidator).getActualValue(string2, valueInfo.itemTypes(), stringArray, string3, validatedInfo, simpleTypeUtil);
        } else {
            XMLString xMLString = new XMLString();
            simpleTypeUtil.addString(string2, xMLString);
            object2 = typeValidator.getActualValue(xMLString, validatedInfo);
            xMLString.unregister();
        }
        return object2 != null ? validatedInfo : null;
    }

    private void getFacets(XSSimpleTypeDefinition xSSimpleTypeDefinition, XSFacets xSFacets) {
        XSObject xSObject;
        int n2;
        xSFacets.definedFacets = 0;
        XSObjectList xSObjectList = xSSimpleTypeDefinition.getFacets();
        XSObjectList xSObjectList2 = xSSimpleTypeDefinition.getMultiValueFacets();
        XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)xSSimpleTypeDefinition;
        block16: for (n2 = 0; n2 < xSObjectList.getLength(); ++n2) {
            xSObject = (XSFacet)xSObjectList.item(n2);
            switch (xSObject.getFacetKind()) {
                case 1: {
                    xSFacets.length = Integer.parseInt(xSObject.getLexicalFacetValue());
                    xSFacets.definedFacets |= 1;
                    continue block16;
                }
                case 2: {
                    xSFacets.minLength = Integer.parseInt(xSObject.getLexicalFacetValue());
                    xSFacets.definedFacets |= 2;
                    continue block16;
                }
                case 4: {
                    xSFacets.maxLength = Integer.parseInt(xSObject.getLexicalFacetValue());
                    xSFacets.definedFacets |= 4;
                    continue block16;
                }
                case 16: {
                    if ("preserve".equals(xSObject.getLexicalFacetValue())) {
                        xSFacets.whiteSpace = 0;
                    } else if ("replace".equals(xSObject.getLexicalFacetValue())) {
                        xSFacets.whiteSpace = 1;
                    } else if ("collapse".equals(xSObject.getLexicalFacetValue())) {
                        xSFacets.whiteSpace = (byte)2;
                    } else {
                        throw new RuntimeException("TypeValidatorFactory: whiteSpace facet must be preserve/replace/collapse.");
                    }
                    xSFacets.definedFacets |= 0x10;
                    continue block16;
                }
                case 32: {
                    xSFacets.maxInclusive = this.getMinMaxFacetValue(xSSimpleTypeDecl, (XSFacet)xSObject);
                    xSFacets.definedFacets |= 0x20;
                    continue block16;
                }
                case 64: {
                    xSFacets.maxExclusive = this.getMinMaxFacetValue(xSSimpleTypeDecl, (XSFacet)xSObject);
                    xSFacets.definedFacets |= 0x40;
                    continue block16;
                }
                case 128: {
                    xSFacets.minExclusive = this.getMinMaxFacetValue(xSSimpleTypeDecl, (XSFacet)xSObject);
                    xSFacets.definedFacets |= 0x80;
                    continue block16;
                }
                case 256: {
                    xSFacets.minInclusive = this.getMinMaxFacetValue(xSSimpleTypeDecl, (XSFacet)xSObject);
                    xSFacets.definedFacets |= 0x100;
                    continue block16;
                }
                case 512: {
                    xSFacets.totalDigits = Integer.parseInt(xSObject.getLexicalFacetValue());
                    xSFacets.definedFacets |= 0x200;
                    continue block16;
                }
                case 1024: {
                    xSFacets.fractionDigits = Integer.parseInt(xSObject.getLexicalFacetValue());
                    xSFacets.definedFacets |= 0x400;
                }
            }
        }
        block17: for (n2 = 0; n2 < xSObjectList2.getLength(); ++n2) {
            xSObject = (XSMultiValueFacet)xSObjectList2.item(n2);
            switch (xSObject.getFacetKind()) {
                case 8: {
                    StringList stringList = xSObject.getLexicalFacetValues();
                    int n3 = stringList.getLength();
                    String[] stringArray = new String[n3];
                    for (int i = 0; i < n3; ++i) {
                        stringArray[i] = stringList.item(i);
                    }
                    xSFacets.pattern = stringArray;
                    xSFacets.definedFacets |= 8;
                    continue block17;
                }
                case 2048: {
                    StringList stringList = xSSimpleTypeDefinition.getLexicalEnumeration();
                    ShortList shortList = xSSimpleTypeDecl.getEnumerationTypeList();
                    ObjectList objectList = xSSimpleTypeDecl.getActualEnumeration();
                    ObjectList objectList2 = xSSimpleTypeDecl.getEnumerationItemTypeList();
                    int n3 = stringList.getLength();
                    ValueInfo[] valueInfoArray = new ValueInfo[n3];
                    for (int i = 0; i < n3; ++i) {
                        valueInfoArray[i] = new ValueInfo(stringList.item(i), objectList.item(i), shortList.item(i), (ShortList)objectList2.item(i));
                    }
                    xSFacets.enumeration = valueInfoArray;
                    xSFacets.definedFacets |= 0x800;
                }
            }
        }
    }

    private String getMinMaxFacetValue(XSSimpleTypeDecl xSSimpleTypeDecl, XSFacet xSFacet) {
        switch (xSSimpleTypeDecl.getBuiltInKind()) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                short s = xSFacet.getFacetKind();
                if (s == 256) {
                    return ((XSDateTime)xSSimpleTypeDecl.getMinInclusiveValue()).getLexicalValue();
                }
                if (s == 128) {
                    return ((XSDateTime)xSSimpleTypeDecl.getMinExclusiveValue()).getLexicalValue();
                }
                if (s == 32) {
                    return ((XSDateTime)xSSimpleTypeDecl.getMaxInclusiveValue()).getLexicalValue();
                }
                if (s != 64) break;
                return ((XSDateTime)xSSimpleTypeDecl.getMaxExclusiveValue()).getLexicalValue();
            }
        }
        return xSFacet.getLexicalFacetValue();
    }
}

