/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XDateTime {
    public static final int EQUAL = 0;
    public static final int GREATER_THAN = 1;
    public static final int LESS_THAN = -1;
    public static final int DEFAULT_YEAR = 2000;
    public static final int DEFAULT_MONTH = 1;
    public static final int DEFAULT_DAY = 1;
    public static final int POSITION_YEAR = 0;
    public static final int POSITION_MONTH = 1;
    public static final int POSITION_DAY = 2;
    public static final int POSITION_TIME = 3;
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int utc;
    public double second;
    public int timezoneHr;
    public int timezoneMin;
    public int position;
    public int type;
    private static final int INDETERMINATE = 999;
    private static final XDateTime[] DATETIMES = new XDateTime[]{new XDateTime(1696, 9, 1, 0, 0, 0.0, 90, 0), new XDateTime(1697, 2, 1, 0, 0, 0.0, 90, 0), new XDateTime(1903, 3, 1, 0, 0, 0.0, 90, 0), new XDateTime(1903, 7, 1, 0, 0, 0.0, 90, 0)};

    public XDateTime() {
    }

    public XDateTime(int n2, int n3, int n4, int n5, int n6, double d, int n7, int n8) {
        this.year = n2;
        this.month = n3;
        this.day = n4;
        this.hour = n5;
        this.minute = n6;
        this.second = d;
        this.utc = n7;
        this.type = n8;
    }

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof XDateTime) {
            if (this.type == 7) {
                return this.compareDurations((XDateTime)object2, true) == 0;
            }
            return this.compareDates((XDateTime)object2, true) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.position < 3) {
            if (this.position < 2) {
                if (this.position < 1) {
                    n2 = this.year;
                }
                n2 += this.month;
            }
            n2 += this.day;
        }
        return n2 + this.hour + this.minute + (int)this.second;
    }

    public void reuse(int n2, int n3) {
        this.clear();
        this.type = n2;
        this.position = n3;
    }

    public String toString() {
        switch (this.type) {
            case 7: {
                return this.durationToString();
            }
            case 9: {
                return this.timeToString();
            }
            case 8: {
                return this.dateTimeToString();
            }
            case 10: {
                return this.dateToString();
            }
            case 12: {
                return this.yearToString();
            }
            case 15: {
                return this.monthToString();
            }
            case 14: {
                return this.dayToString();
            }
            case 11: {
                return this.yearMonthToString();
            }
            case 13: {
                return this.monthDayToString();
            }
        }
        return null;
    }

    private String durationToString() {
        StringBuilder stringBuilder = new StringBuilder(30);
        if (this.year < 0 || this.month < 0 || this.day < 0 || this.hour < 0 || this.minute < 0 || this.second < 0.0) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        stringBuilder.append((this.year < 0 ? -1 : 1) * this.year);
        stringBuilder.append('Y');
        stringBuilder.append((this.month < 0 ? -1 : 1) * this.month);
        stringBuilder.append('M');
        stringBuilder.append((this.day < 0 ? -1 : 1) * this.day);
        stringBuilder.append('D');
        stringBuilder.append('T');
        stringBuilder.append((this.hour < 0 ? -1 : 1) * this.hour);
        stringBuilder.append('H');
        stringBuilder.append((this.minute < 0 ? -1 : 1) * this.minute);
        stringBuilder.append('M');
        stringBuilder.append((double)(this.second < 0.0 ? -1 : 1) * this.second);
        stringBuilder.append('S');
        return stringBuilder.toString();
    }

    private String timeToString() {
        StringBuilder stringBuilder = new StringBuilder(16);
        this.append(stringBuilder, this.hour, 2);
        stringBuilder.append(':');
        this.append(stringBuilder, this.minute, 2);
        stringBuilder.append(':');
        this.append(stringBuilder, this.second);
        this.append(stringBuilder, (char)this.utc, 0);
        return stringBuilder.toString();
    }

    private String dateTimeToString() {
        StringBuilder stringBuilder = new StringBuilder(25);
        this.append(stringBuilder, this.year, 4);
        stringBuilder.append('-');
        this.append(stringBuilder, this.month, 2);
        stringBuilder.append('-');
        this.append(stringBuilder, this.day, 2);
        stringBuilder.append('T');
        this.append(stringBuilder, this.hour, 2);
        stringBuilder.append(':');
        this.append(stringBuilder, this.minute, 2);
        stringBuilder.append(':');
        this.append(stringBuilder, this.second);
        this.append(stringBuilder, (char)this.utc, 0);
        return stringBuilder.toString();
    }

    private String dateToString() {
        StringBuilder stringBuilder = new StringBuilder(25);
        this.append(stringBuilder, this.year, 4);
        stringBuilder.append('-');
        this.append(stringBuilder, this.month, 2);
        stringBuilder.append('-');
        this.append(stringBuilder, this.day, 2);
        this.append(stringBuilder, (char)this.utc, 0);
        return stringBuilder.toString();
    }

    private String yearToString() {
        StringBuilder stringBuilder = new StringBuilder(5);
        this.append(stringBuilder, this.year, 4);
        this.append(stringBuilder, (char)this.utc, 0);
        return stringBuilder.toString();
    }

    private String monthToString() {
        StringBuilder stringBuilder = new StringBuilder(5);
        stringBuilder.append('-');
        stringBuilder.append('-');
        this.append(stringBuilder, this.month, 2);
        this.append(stringBuilder, (char)this.utc, 0);
        return stringBuilder.toString();
    }

    private String dayToString() {
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.append('-');
        stringBuilder.append('-');
        stringBuilder.append('-');
        this.append(stringBuilder, this.day, 2);
        this.append(stringBuilder, (char)this.utc, 0);
        return stringBuilder.toString();
    }

    private String yearMonthToString() {
        StringBuilder stringBuilder = new StringBuilder(25);
        this.append(stringBuilder, this.year, 4);
        stringBuilder.append('-');
        this.append(stringBuilder, this.month, 2);
        this.append(stringBuilder, (char)this.utc, 0);
        return stringBuilder.toString();
    }

    private String monthDayToString() {
        StringBuilder stringBuilder = new StringBuilder(8);
        stringBuilder.append('-');
        stringBuilder.append('-');
        this.append(stringBuilder, this.month, 2);
        stringBuilder.append('-');
        this.append(stringBuilder, this.day, 2);
        this.append(stringBuilder, (char)this.utc, 0);
        return stringBuilder.toString();
    }

    private void append(StringBuilder stringBuilder, int n2, int n3) {
        if (n2 < 0) {
            stringBuilder.append('-');
            n2 = -n2;
        }
        if (n3 == 4) {
            if (n2 < 10) {
                stringBuilder.append("000");
            } else if (n2 < 100) {
                stringBuilder.append("00");
            } else if (n2 < 1000) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n2);
        } else if (n3 == 2) {
            if (n2 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n2);
        } else if (n2 != 0) {
            stringBuilder.append((char)n2);
        }
    }

    private void append(StringBuilder stringBuilder, double d) {
        if (d < 0.0) {
            stringBuilder.append('-');
            d = -d;
        }
        if (d < 10.0) {
            stringBuilder.append('0');
        }
        stringBuilder.append(d);
    }

    private void copyFields(XDateTime xDateTime) {
        xDateTime.year = this.year;
        xDateTime.month = this.month;
        xDateTime.day = this.day;
        xDateTime.hour = this.hour;
        xDateTime.minute = this.minute;
        xDateTime.second = this.second;
        xDateTime.utc = this.utc;
        xDateTime.timezoneHr = this.timezoneHr;
        xDateTime.timezoneMin = this.timezoneMin;
    }

    public void normalize() {
        if (this.timezoneHr != 0 || this.timezoneMin != 0 || this.utc == 43 || this.utc == 45) {
            int n2 = -1;
            int n3 = this.minute + n2 * this.timezoneMin;
            int n4 = XDateTime.fQuotient(n3, 60);
            this.minute = XDateTime.mod(n3, 60, n4);
            n3 = this.hour + n2 * this.timezoneHr + n4;
            n4 = XDateTime.fQuotient(n3, 24);
            this.hour = XDateTime.mod(n3, 24, n4);
            this.day += n4;
            while (true) {
                n3 = XDateTime.maxDayInMonthFor(this.year, this.month);
                if (this.day < 1) {
                    this.day += XDateTime.maxDayInMonthFor(this.year, this.month - 1);
                    n4 = -1;
                } else {
                    if (this.day <= n3) break;
                    this.day -= n3;
                    n4 = 1;
                }
                n3 = this.month + n4;
                this.month = XDateTime.modulo(n3, 1, 13);
                this.year += XDateTime.fQuotient(n3, 1, 13);
                if (this.year != 0) continue;
                this.year = this.timezoneHr < 0 || this.timezoneMin < 0 ? 1 : -1;
            }
            this.utc = 90;
        }
    }

    public int maxDayInMonthFor() {
        return XDateTime.maxDayInMonthFor(this.year, this.month);
    }

    private static int maxDayInMonthFor(int n2, int n3) {
        if (n3 == 4 || n3 == 6 || n3 == 9 || n3 == 11) {
            return 30;
        }
        if (n3 == 2) {
            if (XDateTime.isLeapYear(n2)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static boolean isLeapYear(int n2) {
        return n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
    }

    private static int mod(int n2, int n3, int n4) {
        return n2 - n4 * n3;
    }

    private static int fQuotient(int n2, int n3) {
        return (int)Math.floor((float)n2 / (float)n3);
    }

    private static int modulo(int n2, int n3, int n4) {
        int n5 = n2 - n3;
        int n6 = n4 - n3;
        return XDateTime.mod(n5, n6, XDateTime.fQuotient(n5, n6)) + n3;
    }

    private static int fQuotient(int n2, int n3, int n4) {
        return XDateTime.fQuotient(n2 - n3, n4 - n3);
    }

    private short compareOrder(XDateTime xDateTime) {
        if (this.position < 3) {
            if (this.position < 2) {
                if (this.position < 1) {
                    if (this.year < xDateTime.year) {
                        return -1;
                    }
                    if (this.year > xDateTime.year) {
                        return 1;
                    }
                }
                if (this.month < xDateTime.month) {
                    return -1;
                }
                if (this.month > xDateTime.month) {
                    return 1;
                }
            }
            if (this.day < xDateTime.day) {
                return -1;
            }
            if (this.day > xDateTime.day) {
                return 1;
            }
        }
        if (this.hour < xDateTime.hour) {
            return -1;
        }
        if (this.hour > xDateTime.hour) {
            return 1;
        }
        if (this.minute < xDateTime.minute) {
            return -1;
        }
        if (this.minute > xDateTime.minute) {
            return 1;
        }
        if (this.second < xDateTime.second) {
            return -1;
        }
        if (this.second > xDateTime.second) {
            return 1;
        }
        return 0;
    }

    public short compareDates(XDateTime xDateTime, boolean bl) {
        if (xDateTime == null) {
            return 999;
        }
        if (this.utc == xDateTime.utc) {
            return this.compareOrder(xDateTime);
        }
        XDateTime xDateTime2 = new XDateTime();
        xDateTime2.type = this.type;
        xDateTime2.position = this.position;
        if (this.utc == 90) {
            xDateTime.copyFields(xDateTime2);
            xDateTime2.timezoneHr = 14;
            xDateTime2.timezoneMin = 0;
            xDateTime2.utc = 43;
            xDateTime2.normalize();
            short s = this.compareOrder(xDateTime2);
            if (s == -1) {
                return s;
            }
            xDateTime.copyFields(xDateTime2);
            xDateTime2.timezoneHr = -14;
            xDateTime2.timezoneMin = 0;
            xDateTime2.utc = 45;
            xDateTime2.normalize();
            short s2 = this.compareOrder(xDateTime2);
            if (s2 == 1) {
                return s2;
            }
            return 999;
        }
        if (xDateTime.utc == 90) {
            this.copyFields(xDateTime2);
            xDateTime2.timezoneHr = -14;
            xDateTime2.timezoneMin = 0;
            xDateTime2.utc = 45;
            xDateTime2.normalize();
            short s = xDateTime2.compareOrder(xDateTime);
            if (s == -1) {
                return s;
            }
            this.copyFields(xDateTime2);
            xDateTime2.timezoneHr = 14;
            xDateTime2.timezoneMin = 0;
            xDateTime2.utc = 43;
            xDateTime2.normalize();
            short s3 = xDateTime2.compareOrder(xDateTime);
            if (s3 == 1) {
                return s3;
            }
            return 999;
        }
        return 999;
    }

    public short compareDurations(XDateTime xDateTime, boolean bl) {
        short s = 999;
        short s2 = this.compareOrder(xDateTime);
        if (s2 == 0) {
            return 0;
        }
        XDateTime xDateTime2 = new XDateTime();
        XDateTime xDateTime3 = new XDateTime();
        xDateTime2.type = this.type;
        xDateTime2.position = this.position;
        xDateTime3.type = this.type;
        xDateTime3.position = this.position;
        this.addDuration(DATETIMES[0], xDateTime2);
        xDateTime.addDuration(DATETIMES[0], xDateTime3);
        s2 = xDateTime2.compareOrder(xDateTime3);
        if (s2 == 999) {
            return 999;
        }
        this.addDuration(DATETIMES[1], xDateTime2);
        xDateTime.addDuration(DATETIMES[1], xDateTime3);
        s = xDateTime2.compareOrder(xDateTime3);
        s2 = XDateTime.compareResults(s2, s, bl);
        if (s2 == 999) {
            return 999;
        }
        this.addDuration(DATETIMES[2], xDateTime2);
        xDateTime.addDuration(DATETIMES[2], xDateTime3);
        s = xDateTime2.compareOrder(xDateTime3);
        s2 = XDateTime.compareResults(s2, s, bl);
        if (s2 == 999) {
            return 999;
        }
        this.addDuration(DATETIMES[3], xDateTime2);
        xDateTime.addDuration(DATETIMES[3], xDateTime3);
        s = xDateTime2.compareOrder(xDateTime3);
        s2 = XDateTime.compareResults(s2, s, bl);
        return s2;
    }

    private void clear() {
        this.year = 0;
        this.month = 0;
        this.day = 0;
        this.hour = 0;
        this.minute = 0;
        this.second = 0.0;
        this.utc = 0;
        this.timezoneHr = 0;
        this.timezoneMin = 0;
    }

    private void addDuration(XDateTime xDateTime, XDateTime xDateTime2) {
        xDateTime2.clear();
        int n2 = xDateTime.month + this.month;
        xDateTime2.month = XDateTime.modulo(n2, 1, 13);
        int n3 = XDateTime.fQuotient(n2, 1, 13);
        xDateTime2.year = xDateTime.year + this.year + n3;
        double d = xDateTime.second + this.second;
        n3 = (int)Math.floor(d / 60.0);
        xDateTime2.second = d - (double)(n3 * 60);
        n2 = xDateTime.minute + this.minute + n3;
        n3 = XDateTime.fQuotient(n2, 60);
        xDateTime2.minute = XDateTime.mod(n2, 60, n3);
        n2 = xDateTime.hour + this.hour + n3;
        n3 = XDateTime.fQuotient(n2, 24);
        xDateTime2.hour = XDateTime.mod(n2, 24, n3);
        xDateTime2.day = xDateTime.day + this.day + n3;
        while (true) {
            n2 = XDateTime.maxDayInMonthFor(xDateTime2.year, xDateTime2.month);
            if (xDateTime2.day < 1) {
                xDateTime2.day += XDateTime.maxDayInMonthFor(xDateTime2.year, xDateTime2.month - 1);
                n3 = -1;
            } else {
                if (xDateTime2.day <= n2) break;
                xDateTime2.day -= n2;
                n3 = 1;
            }
            n2 = xDateTime2.month + n3;
            xDateTime2.month = XDateTime.modulo(n2, 1, 13);
            xDateTime2.year += XDateTime.fQuotient(n2, 1, 13);
        }
        xDateTime2.utc = 90;
    }

    private static short compareResults(short s, short s2, boolean bl) {
        if (s2 == 999) {
            return 999;
        }
        if (s != s2 && bl) {
            return 999;
        }
        if (s != s2 && !bl) {
            if (s != 0 && s2 != 0) {
                return 999;
            }
            return s != 0 ? s : s2;
        }
        return s;
    }
}

