/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSAnyURIUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class AnyURIDV
extends TypeValidator {
    private final XMLString[] enumeration;
    private final int length;
    private final int minLength;
    private final int maxLength;

    public AnyURIDV(String string2, String string3, String string4, String[] stringArray, XMLString[] xMLStringArray, int n2, int n3, int n4, int n5) {
        super(string2, string3, string4, 18, 18, stringArray, n5, false);
        this.length = n2;
        this.minLength = n3;
        this.maxLength = n4;
        this.enumeration = xMLStringArray;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XMLString xMLString2 = AnyURIDV.parse(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xMLString2;
            validatedInfo.errorCode = validatedInfo.actualValue != null ? 0 : 1;
        }
        return xMLString2;
    }

    private static XMLString parse(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return null;
        }
        nArray[0] = 0;
        if (xMLString.bytes != null) {
            return AnyURIDV.parseURIUnbuffered(xMLString, validationContext, nArray);
        }
        return AnyURIDV.parseURIBuffered(xMLString, validationContext, nArray);
    }

    private static XMLString parseURIBuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        int n2;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n3 = xMLString.startOffset;
        int n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n3];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n3 < n4) {
                    by2 = dataBuffer.bytes[n3];
                    continue;
                }
                if (n3 != n4 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n3];
            }
        }
        if (n3 == n4) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            NullDataBufferFactory.setEmptyStringValues(xMLString2);
            return xMLString2;
        }
        by2 = dataBuffer.bytes[n3];
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        int n5 = xMLStringBuffer.getOffset();
        boolean bl = false;
        boolean bl2 = false;
        if (XSAnyURIUtil.isAlpha(by2)) {
            xMLStringBuffer.appendChar(by2);
            n2 = n3;
            DataBuffer dataBuffer3 = dataBuffer;
            while (true) {
                if (++n2 < n4) {
                    by2 = dataBuffer3.bytes[n2];
                    xMLStringBuffer.appendChar(by2);
                    if (by2 != 58 && by2 != 47 && by2 != 63 && by2 != 35 && XSAnyURIUtil.isSchemeCharacter(by2)) continue;
                    break;
                }
                if (dataBuffer3 == dataBuffer2) break;
                dataBuffer3 = dataBuffer3.next;
                n2 = dataBuffer3.startOffset - 1;
                n4 = dataBuffer3 == dataBuffer2 ? xMLString.endOffset : dataBuffer3.endOffset;
            }
            if (by2 == 58) {
                bl2 = true;
                while (true) {
                    if (n2 + 1 < n4) break;
                    if (dataBuffer3 == dataBuffer2) {
                        nArray[0] = 1;
                        return null;
                    }
                    dataBuffer3 = dataBuffer3.next;
                    n2 = dataBuffer3.startOffset - 1;
                    n4 = dataBuffer3 == dataBuffer2 ? xMLString.endOffset : dataBuffer3.endOffset;
                }
                by2 = dataBuffer3.bytes[n2 + 1];
                if (by2 == 35) {
                    nArray[0] = 1;
                    return null;
                }
                n3 = n2 + 1;
                dataBuffer = dataBuffer3;
                n4 = dataBuffer3 == dataBuffer2 ? xMLString.endOffset : dataBuffer3.endOffset;
                by2 = dataBuffer.bytes[n3];
            } else {
                xMLStringBuffer.reset(true);
                n5 = xMLStringBuffer.getOffset();
            }
        }
        if (by2 == 47) {
            int n6 = n2 = n3;
            DataBuffer dataBuffer4 = dataBuffer;
            while (true) {
                if (n2 + 1 < n4) {
                    by2 = dataBuffer4.bytes[n2 + 1];
                    break;
                }
                if (dataBuffer4 == dataBuffer2) break;
                dataBuffer4 = dataBuffer4.next;
                n2 = dataBuffer4.startOffset - 1;
                n4 = dataBuffer4 == dataBuffer2 ? xMLString.endOffset : dataBuffer4.endOffset;
            }
            if (n2 + 1 < n4 && by2 == 47) {
                n3 = n2 + 1;
                dataBuffer = dataBuffer4;
                n4 = dataBuffer4 == dataBuffer2 ? xMLString.endOffset : dataBuffer4.endOffset;
                XMLString xMLString3 = validationContext != null ? validationContext.getXMLString() : new XMLString();
                xMLStringBuffer.setStringValues(n5, xMLStringBuffer.getOffset(), xMLString3);
                xMLStringBuffer.appendChar(47);
                xMLStringBuffer.appendChar(47);
                int n7 = 0;
                while (true) {
                    if (++n3 < n4) {
                        by2 = dataBuffer.bytes[n3];
                        if (by2 == 47 || by2 == 35 || by2 == 63) break;
                        if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                            bl = true;
                            continue;
                        }
                        if (bl) {
                            xMLStringBuffer.appendChar(32);
                            bl = false;
                        }
                        xMLStringBuffer.appendChar(by2);
                        ++n7;
                        continue;
                    }
                    if (dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n3 = dataBuffer.startOffset - 1;
                    n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                if (bl) {
                    xMLStringBuffer.appendChar(32);
                    bl = false;
                }
                if (n7 > 0 && !XSAnyURIUtil.parseAuthority(xMLString, new DataBuffer[]{dataBuffer4, dataBuffer}, new int[]{n2 + 2, n3})) {
                    n3 = n6;
                    dataBuffer = dataBuffer4;
                    n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    xMLStringBuffer.reset(true);
                    n5 = xMLStringBuffer.getOffset();
                    xMLStringBuffer.appendXMLString(xMLString3);
                }
                xMLString3.unregister();
            }
        }
        if (!XSAnyURIUtil.parsePath(xMLString, xMLStringBuffer, n3, dataBuffer, bl2)) {
            nArray[0] = 1;
            return null;
        }
        XMLString xMLString4 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        xMLStringBuffer.setStringValues(n5, xMLStringBuffer.getOffset(), xMLString4);
        return xMLString4;
    }

    private static XMLString parseURIUnbuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) == n3) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            NullDataBufferFactory.setEmptyStringValues(xMLString2);
            return xMLString2;
        }
        byte by2 = xMLString.bytes[n2];
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        int n4 = xMLStringBuffer.getOffset();
        boolean bl = false;
        boolean bl2 = false;
        if (XSAnyURIUtil.isAlpha(by2)) {
            int n5 = 0;
            for (n5 = n2; n5 < n3; ++n5) {
                by2 = xMLString.bytes[n5];
                xMLStringBuffer.appendChar(by2);
                if (by2 == 58 || by2 == 47 || by2 == 63 || by2 == 35 || !XSAnyURIUtil.isSchemeCharacter(by2)) break;
            }
            if (by2 == 58) {
                bl2 = true;
                if (n5 + 1 >= n3 || xMLString.bytes[n5 + 1] == 35) {
                    nArray[0] = 1;
                    return null;
                }
                n2 = n5 + 1;
                by2 = xMLString.bytes[n2];
            } else {
                xMLStringBuffer.reset(true);
                n4 = xMLStringBuffer.getOffset();
            }
        }
        if (by2 == 47 && n2 + 1 < n3 && xMLString.bytes[n2 + 1] == 47) {
            n2 += 2;
            bl = false;
            XMLString xMLString3 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            xMLStringBuffer.setStringValues(n4, xMLStringBuffer.getOffset(), xMLString3);
            xMLStringBuffer.appendChar(47);
            xMLStringBuffer.appendChar(47);
            int n6 = n2;
            while ((by2 = xMLString.bytes[n2]) != 47 && by2 != 63 && by2 != 35) {
                if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                    bl = true;
                } else {
                    if (bl) {
                        xMLStringBuffer.appendChar(32);
                        bl = false;
                    }
                    xMLStringBuffer.appendChar(by2);
                }
                if (++n2 < n3) continue;
            }
            if (bl) {
                xMLStringBuffer.appendChar(32);
                bl = false;
            }
            if (n2 > n6 && !XSAnyURIUtil.parseAuthority(xMLString, n6, n2)) {
                n2 = n6 - 2;
                xMLStringBuffer.reset(true);
                n4 = xMLStringBuffer.getOffset();
                xMLStringBuffer.appendXMLString(xMLString3);
            }
            xMLString3.unregister();
        }
        if (!XSAnyURIUtil.parsePath(xMLString, xMLStringBuffer, n2, bl2)) {
            nArray[0] = 1;
            return null;
        }
        XMLString xMLString4 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        xMLStringBuffer.setStringValues(n4, xMLStringBuffer.getOffset(), xMLString4);
        return xMLString4;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        XMLString xMLString2 = AnyURIDV.parse(xMLString, validationContext, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = xMLString2.equals(validatedInfo.actualValue) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xMLString2);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xMLString2;
    }

    private int checkFacets(XMLString xMLString) {
        int n2 = -1;
        if ((this.definedFacets & 2) != 0 && (n2 = XMLStringUtil.getUnicodeCharLength(xMLString)) < this.minLength) {
            return 1;
        }
        if ((this.definedFacets & 4) != 0) {
            if (n2 == -1) {
                n2 = XMLStringUtil.getUnicodeCharLength(xMLString);
            }
            if (n2 > this.maxLength) {
                return 1;
            }
        }
        if ((this.definedFacets & 1) != 0) {
            if (n2 == -1) {
                n2 = XMLStringUtil.getUnicodeCharLength(xMLString);
            }
            if (n2 != this.length) {
                return 1;
            }
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equalsXMLString(xMLString)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public static XMLString parse(XMLString xMLString) {
        return AnyURIDV.parse(xMLString, null, dummyOneElementArray);
    }
}

