/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XInt;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class BooleanDV
extends TypeValidator {
    private static final int[] trueChars = new int[]{114, 117, 101};
    private static final int[] falseChars = new int[]{97, 108, 115, 101};

    public BooleanDV(String string2, String string3, String string4, String[] stringArray, int n2) {
        super(string2, string3, string4, 3, 3, stringArray, n2, false);
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        Boolean bl;
        Boolean bl2 = bl = xMLString.bytes != null ? BooleanDV.parseBooleanUnbuffered(xMLString) : BooleanDV.parseBooleanBuffered(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = bl;
            validatedInfo.errorCode = validatedInfo.actualValue != null ? 0 : 1;
        }
        return bl;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        Boolean bl = BooleanDV.parseBoolean(xMLString);
        if (this.definedFacets != 0 && !this.pattern.matches(xMLString)) {
            validatedInfo2.errorCode = 1;
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = bl.equals(validatedInfo.actualValue) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        validatedInfo2.actualValue = bl;
        validatedInfo2.errorCode = validatedInfo2.actualValue != null ? 0 : 1;
    }

    public static Boolean parseBoolean(XMLString xMLString) {
        return xMLString.bytes != null ? BooleanDV.parseBooleanUnbuffered(xMLString) : BooleanDV.parseBooleanBuffered(xMLString);
    }

    private static Boolean parseBooleanUnbuffered(XMLString xMLString) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) >= n3) {
            return null;
        }
        if (xMLString.bytes[n2] == 116) {
            if (++n2 < n3 && xMLString.bytes[n2++] == 114 && n2 < n3 && xMLString.bytes[n2++] == 117 && n2 < n3 && xMLString.bytes[n2] == 101) {
                ++n2;
                if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                    return null;
                }
                return Boolean.TRUE;
            }
            return null;
        }
        if (xMLString.bytes[n2] == 102) {
            if (++n2 < n3 && xMLString.bytes[n2++] == 97 && n2 < n3 && xMLString.bytes[n2++] == 108 && n2 < n3 && xMLString.bytes[n2++] == 115 && n2 < n3 && xMLString.bytes[n2] == 101) {
                ++n2;
                if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                    return null;
                }
                return Boolean.FALSE;
            }
            return null;
        }
        if (xMLString.bytes[n2] == 49) {
            ++n2;
            if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                return null;
            }
            return Boolean.TRUE;
        }
        if (xMLString.bytes[n2] == 48) {
            ++n2;
            if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                return null;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    private static Boolean parseBooleanBuffered(XMLString xMLString) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n2];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    continue;
                }
                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2];
            }
        }
        int n4 = 0;
        if (by2 == 116) {
            while (true) {
                if (++n2 < n3) {
                    if (n4 == 3 || trueChars[n4++] != (by2 = dataBuffer.bytes[n2])) break;
                    continue;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (n4 != 3) {
                return null;
            }
            if (by2 <= 32) {
                while (true) {
                    if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        continue;
                    }
                    if (n2 != n3 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by2 = dataBuffer.bytes[n2];
                }
            }
            if (n2 < n3) {
                return null;
            }
            return Boolean.TRUE;
        }
        if (by2 == 102) {
            while (true) {
                if (++n2 < n3) {
                    if (n4 == 4 || falseChars[n4++] != (by2 = dataBuffer.bytes[n2])) break;
                    continue;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (n4 != 4) {
                return null;
            }
            if (by2 <= 32) {
                while (true) {
                    if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        continue;
                    }
                    if (n2 != n3 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by2 = dataBuffer.bytes[n2];
                }
            }
            if (n2 < n3) {
                return null;
            }
            return Boolean.FALSE;
        }
        if (by2 == 49) {
            while (true) {
                if (++n2 < n3) break;
                if (dataBuffer == dataBuffer2) {
                    return Boolean.TRUE;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            by2 = dataBuffer.bytes[n2];
            if (by2 <= 32) {
                while (true) {
                    if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        continue;
                    }
                    if (n2 != n3 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by2 = dataBuffer.bytes[n2];
                }
            }
            if (n2 < n3) {
                return null;
            }
            return Boolean.TRUE;
        }
        if (by2 == 48) {
            while (true) {
                if (++n2 < n3) break;
                if (dataBuffer == dataBuffer2) {
                    return Boolean.FALSE;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            by2 = dataBuffer.bytes[n2];
            if (by2 <= 32) {
                while (true) {
                    if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        continue;
                    }
                    if (n2 != n3 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by2 = dataBuffer.bytes[n2];
                }
            }
            if (n2 < n3) {
                return null;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    private int parseBooleanUnbuffered(ParsedEntity parsedEntity, XInt xInt, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n2 = parsedEntity.offset;
        int n3 = parsedEntity.endOffset;
        if ((n2 = BooleanDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
            return -1;
        }
        if (byArray[n2] == 116) {
            if (n2 + 3 < n3 && byArray[++n2] == 114 && byArray[++n2] == 117 && byArray[++n2] == 101) {
                ++n2;
                if ((n2 = BooleanDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
                    return -1;
                }
                xInt.value = 1;
                return n2;
            }
            return -1;
        }
        if (byArray[n2] == 102) {
            if (n2 + 4 < n3 && byArray[++n2] == 97 && byArray[++n2] == 108 && byArray[++n2] == 115 && byArray[++n2] == 101) {
                ++n2;
                if ((n2 = BooleanDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
                    return -1;
                }
                return n2;
            }
            return -1;
        }
        if (byArray[n2] == 49) {
            ++n2;
            if ((n2 = BooleanDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
                return -1;
            }
            xInt.value = 1;
            return n2;
        }
        if (byArray[n2] == 48) {
            ++n2;
            if ((n2 = BooleanDV.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
                return -1;
            }
            return n2;
        }
        return -1;
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XInt xInt = vMContext.dvContext.getXInt(0);
        int n2 = this.parseBooleanUnbuffered(parsedEntity, xInt, this.fNormalized);
        if (n2 == -1) {
            return null;
        }
        parsedEntity.offset = n2;
        return xInt.value == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        if (this.definedFacets != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        return 0;
    }
}

