/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XByte;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.Pattern;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ByteDV
extends TypeValidator {
    private final int totalDigits;
    private final byte[] enumeration;
    private final byte maxInclusive;
    private final byte maxExclusive;
    private final byte minInclusive;
    private final byte minExclusive;

    public ByteDV(String string2, String string3, String string4, String[] stringArray, byte[] byArray, byte by2, byte by3, byte by4, byte by5, int n2, int n3) {
        super(string2, string3, string4, 36, 4, stringArray, ByteDV.computeDefinedFacets(n3, by2, by3, by4, by5), false);
        this.totalDigits = n2;
        this.enumeration = byArray;
        this.maxInclusive = by4;
        this.maxExclusive = by5;
        this.minInclusive = by2;
        this.minExclusive = by3;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XByte xByte = new XByte(ByteDV.parse(xMLString));
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xByte;
            validatedInfo.errorCode = 0;
        }
        return xByte;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        byte by2 = XSIntegerUtil.parseByte(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = by2 == ((XByte)validatedInfo.actualValue).value ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        validatedInfo2.errorCode = this.preCheckFacets(by2, xMLString);
        if (validatedInfo2.errorCode != 0) {
            return;
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXByte(by2);
    }

    public int preCheckFacets(byte by2, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(by2, xMLString);
        }
        return 0;
    }

    private int checkFacets(byte by2, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && this.getTotalDigits(by2) > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && by2 < this.minInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && by2 <= this.minExclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && by2 > this.maxInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && by2 >= this.maxExclusive) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (this.enumeration[i] != by2) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private static int computeDefinedFacets(int n2, byte by2, byte by3, byte by4, byte by5) {
        if ((n2 & 0x100) != 0 && by2 <= -128) {
            n2 &= 0xFFFFFEFF;
        }
        if ((n2 & 0x20) != 0 && by4 >= 127) {
            n2 &= 0xFFFFFFDF;
        }
        if ((n2 & 0x80) != 0 && by3 < -128) {
            n2 &= 0xFFFFFF7F;
        }
        if ((n2 & 0x40) != 0 && by5 > 127) {
            n2 &= 0xFFFFFFBF;
        }
        return n2;
    }

    private int getTotalDigits(byte by2) {
        if (by2 >= 0) {
            return by2 < 10 ? 1 : (by2 < 100 ? 2 : 3);
        }
        return by2 > -10 ? 1 : (by2 > -100 ? 2 : 3);
    }

    protected Pattern createPattern(String[] stringArray, int n2) {
        int n3;
        if ((n2 & 8) == 0 || stringArray.length == 1 && "[\\-+]?[0-9]+".equals(stringArray[0])) {
            return null;
        }
        int n4 = n3 = stringArray != null ? stringArray.length : 0;
        if (n3 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\-+]?[0-9]+")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static byte parse(XMLString xMLString) {
        return XSIntegerUtil.parseByte(xMLString, dummyOneElementArray);
    }
}

