/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.Pattern;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.StringDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSNormalizer;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class NCNameDV
extends StringDV {
    public NCNameDV(String string2, String string3, String string4, String[] stringArray, XMLString[] xMLStringArray, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super(string2, string3, string4, stringArray, xMLStringArray, n2, n3, n4, (byte)2, n5, n6, bl);
        this.fMultiBuffered = false;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        if (!XMLStringUtil.isNCName(xMLString = XSNormalizer.trim(xMLString, validationContext))) {
            validatedInfo2.errorCode = 1;
            return;
        }
        this.checkAdditionalConstraints(xMLString, validatedInfo, validationContext, validatedInfo2);
    }

    protected Pattern createPattern(String[] stringArray, int n2) {
        int n3;
        if ((n2 & 8) == 0) {
            return null;
        }
        if (stringArray.length == 2) {
            n3 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if ("[\\i-[:]][\\c-[:]]*".equals(stringArray[i]) || "\\i\\c*".equals(stringArray[i])) continue;
                n3 = 1;
            }
            if (n3 == 0) {
                return null;
            }
        }
        int n4 = n3 = stringArray != null ? stringArray.length : 0;
        if (n3 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\i-[:]][\\c-[:]]*") || stringArray[i].equals("\\i\\c*")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XMLString xMLString = vMContext.dvContext.getXMLString();
        int n2 = XMLStringUtil.parseNCNameUnbuffered(parsedEntity, xMLString, this.fNormalized);
        if (n2 == -1) {
            return null;
        }
        parsedEntity.offset = n2;
        if (this.builtInKind == 28) {
            vMContext.dvContext.addIdRef(xMLString);
        } else if (this.builtInKind == 27) {
            if (vMContext.dvContext.isIdDeclared(xMLString)) {
                if (vMContext.validating) {
                    vMContext.generateError(25, xMLString);
                }
            } else {
                vMContext.dvContext.addId(xMLString);
            }
        }
        return xMLString;
    }

    protected int preCheckFacets(Object object2, XMLString xMLString) {
        return this.preCheckFacets((XMLString)object2);
    }
}

