/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XDecimal;
import com.ibm.xml.xlxp.internal.s1.datatype.XInt;
import com.ibm.xml.xlxp.internal.s1.datatype.XLong;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.Pattern;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UnsignedShortDV
extends TypeValidator {
    private final int totalDigits;
    private final int[] enumeration;
    private final int maxInclusive;
    private final int maxExclusive;
    private final int minInclusive;
    private final int minExclusive;

    public UnsignedShortDV(String string2, String string3, String string4, String[] stringArray, int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(string2, string3, string4, 40, 4, stringArray, UnsignedShortDV.computeDefinedFacets(n7, n2, n3, n4, n5), false);
        this.totalDigits = n6;
        this.enumeration = nArray;
        this.maxInclusive = n4;
        this.maxExclusive = n5;
        this.minInclusive = n2;
        this.minExclusive = n3;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XInt xInt = new XInt(UnsignedShortDV.parse(xMLString));
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xInt;
            validatedInfo.errorCode = 0;
        }
        return xInt;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        int n2 = XSIntegerUtil.parseUShort(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            Object object2 = validatedInfo.actualValue;
            validatedInfo2.errorCode = object2 instanceof XInt ? (n2 == ((XInt)validatedInfo.actualValue).value ? 0 : 1) : (object2 instanceof XLong ? ((long)n2 == ((XLong)object2).value ? 0 : 1) : (object2 instanceof XDecimal ? (((XDecimal)object2).equals(n2) ? 0 : 1) : 1));
            validatedInfo2.actualValue = object2;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(n2, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXInt(n2);
    }

    private int checkFacets(int n2, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && this.getTotalDigits(n2) > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && n2 < this.minInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && n2 <= this.minExclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && n2 > this.maxInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && n2 >= this.maxExclusive) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (this.enumeration[i] != n2) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private static int computeDefinedFacets(int n2, int n3, int n4, int n5, int n6) {
        if ((n2 & 0x100) != 0 && n3 <= 0) {
            n2 &= 0xFFFFFEFF;
        }
        if ((n2 & 0x20) != 0 && n5 >= 65535) {
            n2 &= 0xFFFFFFDF;
        }
        if ((n2 & 0x80) != 0 && n4 < 0) {
            n2 &= 0xFFFFFF7F;
        }
        if ((n2 & 0x40) != 0 && n6 > 65535) {
            n2 &= 0xFFFFFFBF;
        }
        return n2;
    }

    private int getTotalDigits(int n2) {
        if (n2 < 1000) {
            return n2 < 10 ? 1 : (n2 < 100 ? 2 : 3);
        }
        return n2 < 10000 ? 4 : 5;
    }

    protected Pattern createPattern(String[] stringArray, int n2) {
        int n3;
        if ((n2 & 8) == 0 || stringArray.length == 1 && "[\\-+]?[0-9]+".equals(stringArray[0])) {
            return null;
        }
        int n4 = n3 = stringArray != null ? stringArray.length : 0;
        if (n3 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\-+]?[0-9]+")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static int parse(XMLString xMLString) {
        return XSIntegerUtil.parseUShort(xMLString, dummyOneElementArray);
    }
}

