/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XMLStringTokenizer {
    private final XMLString ref = new XMLString();
    private DataBuffer db;
    private DataBuffer lastBuffer;
    private int startOffset;
    private int endOffset;

    public void setString(XMLString xMLString) {
        this.ref.setValues(xMLString);
        this.db = this.ref.firstBuffer;
        this.lastBuffer = this.ref.lastBuffer == null ? this.db : this.ref.lastBuffer;
        this.startOffset = this.ref.startOffset;
        this.endOffset = this.db == this.lastBuffer ? this.ref.endOffset : this.db.endOffset;
    }

    public boolean next(XMLString xMLString) {
        xMLString.setStartPos(this.db, this.startOffset);
        block0: while (true) {
            if (this.startOffset < this.endOffset) {
                byte by2 = this.db.bytes[this.startOffset];
                if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                    while (true) {
                        if (this.startOffset + 1 < this.endOffset) break;
                        if (this.db == this.lastBuffer) break block0;
                        this.db = this.db.next;
                        this.startOffset = this.db.startOffset - 1;
                        this.endOffset = this.db == this.lastBuffer ? this.ref.endOffset : this.db.endOffset;
                    }
                    by2 = this.db.bytes[this.startOffset + 1];
                    if (by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                        xMLString.setStartPos(this.db, this.startOffset + 1);
                    }
                } else {
                    while (true) {
                        if (this.startOffset + 1 < this.endOffset) break;
                        if (this.db == this.lastBuffer) {
                            xMLString.setEndPos(this.db, this.startOffset + 1);
                            ++this.startOffset;
                            return true;
                        }
                        this.db = this.db.next;
                        this.startOffset = this.db.startOffset - 1;
                        this.endOffset = this.db == this.lastBuffer ? this.ref.endOffset : this.db.endOffset;
                    }
                    by2 = this.db.bytes[this.startOffset + 1];
                    if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        xMLString.setEndPos(this.db, this.startOffset + 1);
                        ++this.startOffset;
                        return true;
                    }
                }
                ++this.startOffset;
                continue;
            }
            if (this.db == this.lastBuffer) break;
            this.db = this.db.next;
            this.startOffset = this.db.startOffset - 1;
            this.endOffset = this.db == this.lastBuffer ? this.ref.endOffset : this.db.endOffset;
        }
        this.ref.unregister();
        xMLString.unregister();
        return false;
    }
}

