/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XMLStringUtil {
    private static final int[] fgMultiByteLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
    private static final int[] fgFirstByteValueMask = new int[]{0, 0, 31, 15, 7};

    public static int getUnicodeCharLength(XMLString xMLString) {
        if (xMLString.length == 0) {
            return 0;
        }
        return xMLString.bytes != null ? XMLStringUtil.getUnicodeCharLengthUnbuffered(xMLString) : XMLStringUtil.getUnicodeCharLengthBuffered(xMLString);
    }

    private static int getUnicodeCharLengthUnbuffered(XMLString xMLString) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        while (n2 < n3) {
            if (xMLString.bytes[n2++] >= 0) continue;
            --n2;
            break;
        }
        if (n2 == n3) {
            return xMLString.length;
        }
        int n4 = n2 - xMLString.startOffset;
        while (n2 < n3) {
            ++n4;
            byte by2 = xMLString.bytes[n2];
            if (by2 >= 0) {
                ++n2;
                continue;
            }
            n2 += fgMultiByteLength[(by2 & 0xFF) >> 3];
        }
        return n4;
    }

    private static int getUnicodeCharLengthBuffered(XMLString xMLString) {
        int n2;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n3 = xMLString.startOffset;
        block0: while (true) {
            int n4 = n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            while (n3 < n2) {
                if (dataBuffer.bytes[n3] < 0) break block0;
                ++n3;
            }
            if (dataBuffer == dataBuffer2) {
                return xMLString.length;
            }
            dataBuffer = dataBuffer.next;
            n3 = dataBuffer.startOffset;
        }
        int n5 = n3 - dataBuffer.startOffset;
        DataBuffer dataBuffer3 = xMLString.firstBuffer;
        if (dataBuffer3 != dataBuffer) {
            n5 += dataBuffer3.endOffset - xMLString.startOffset;
            DataBuffer dataBuffer4 = dataBuffer3.next;
            while (dataBuffer4 != dataBuffer) {
                n5 += dataBuffer4.endOffset - dataBuffer4.startOffset;
                dataBuffer4 = dataBuffer4.next;
            }
        }
        while (true) {
            if (n3 < n2) {
                ++n5;
                byte by2 = dataBuffer.bytes[n3];
                if (by2 >= 0) {
                    ++n3;
                    continue;
                }
                n3 += fgMultiByteLength[(by2 & 0xFF) >> 3];
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                return n5;
            }
            dataBuffer = dataBuffer.next;
            n3 = dataBuffer.startOffset + (n3 - n2);
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
    }

    public static boolean isNMTOKEN(XMLString xMLString) {
        if (xMLString.length == 0) {
            return false;
        }
        return xMLString.bytes != null ? XMLStringUtil.isNMTOKENUnbuffered(xMLString) : XMLStringUtil.isNMTOKENBuffered(xMLString);
    }

    private static boolean isNMTOKENUnbuffered(XMLString xMLString) {
        int n2;
        int n3;
        int n4 = xMLString.endOffset;
        for (n3 = xMLString.startOffset; n3 < n4 && (n2 = xMLString.bytes[n3]) >= 0; ++n3) {
            if (XMLCharacterProperties.nameChar10(n2)) continue;
            return false;
        }
        if (n3 == n4) {
            return true;
        }
        while (n3 < n4) {
            if ((n2 = xMLString.bytes[n3++]) >= 0) {
                if (XMLCharacterProperties.nameChar10(n2)) continue;
                return false;
            }
            int n5 = fgMultiByteLength[(n2 &= 0xFF) >> 3];
            int n6 = n2 & fgFirstByteValueMask[n5];
            switch (n5) {
                case 2: {
                    n6 = (n6 << 6) + (0x3F & xMLString.bytes[n3++]);
                    break;
                }
                case 3: {
                    n6 = (n6 << 12) + ((0x3F & xMLString.bytes[n3++]) << 6) + (0x3F & xMLString.bytes[n3++]);
                    break;
                }
                default: {
                    n6 = (n6 << 18) + ((0x3F & xMLString.bytes[n3++]) << 12) + ((0x3F & xMLString.bytes[n3++]) << 6) + (0x3F & xMLString.bytes[n3++]);
                }
            }
            if (XMLCharacterProperties.nameChar10(n6)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNMTOKENBuffered(XMLString xMLString) {
        int n2;
        int n3;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n4 = xMLString.startOffset;
        int n5 = n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        while (true) {
            if (n4 < n3) {
                n2 = dataBuffer.bytes[n4];
                if (n2 < 0) break;
                if (!XMLCharacterProperties.nameChar10(n2)) {
                    return false;
                }
                ++n4;
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n4 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        if (n4 == n3) {
            return true;
        }
        while (true) {
            if (n4 < n3) {
                if ((n2 = dataBuffer.bytes[n4++]) >= 0) {
                    if (XMLCharacterProperties.nameChar10(n2)) continue;
                    return false;
                }
                int n6 = fgMultiByteLength[(n2 &= 0xFF) >> 3];
                int n7 = n2 & fgFirstByteValueMask[n6];
                byte by2 = 0;
                byte by3 = 0;
                byte by4 = 0;
                switch (n6) {
                    case 2: {
                        while (true) {
                            if (n4 < n3) {
                                by2 = dataBuffer.bytes[n4++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n4 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        n7 = (n7 << 6) + (0x3F & by2);
                        break;
                    }
                    case 3: {
                        while (true) {
                            if (n4 < n3) {
                                by2 = dataBuffer.bytes[n4++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n4 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        while (true) {
                            if (n4 < n3) {
                                by3 = dataBuffer.bytes[n4++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n4 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        n7 = (n7 << 12) + ((0x3F & by2) << 6) + (0x3F & by3);
                        break;
                    }
                    default: {
                        while (true) {
                            if (n4 < n3) {
                                by2 = dataBuffer.bytes[n4++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n4 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        while (true) {
                            if (n4 < n3) {
                                by3 = dataBuffer.bytes[n4++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n4 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        while (true) {
                            if (n4 < n3) {
                                by4 = dataBuffer.bytes[n4++];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n4 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        n7 = (n7 << 18) + ((0x3F & by2) << 12) + ((0x3F & by3) << 6) + (0x3F & by4);
                    }
                }
                if (XMLCharacterProperties.nameChar10(n7)) continue;
                return false;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n4 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        return true;
    }

    public static int parseNMTOKENUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n2 = parsedEntity.offset;
        int n3 = parsedEntity.endOffset;
        if ((n2 = TypeValidator.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
            return -1;
        }
        int n4 = n2;
        while (n2 < n3) {
            int n5 = byArray[n2];
            if (n5 >= 0) {
                if (!XMLCharacterProperties.nameChar10(n5)) {
                    break;
                }
            } else {
                int n6 = fgMultiByteLength[(n5 &= 0xFF) >> 3];
                int n7 = n5 & fgFirstByteValueMask[n6];
                switch (n6) {
                    case 2: {
                        if (++n2 >= n3) {
                            return -1;
                        }
                        n7 = (n7 << 6) + (0x3F & byArray[n2]);
                        break;
                    }
                    case 3: {
                        if (++n2 + 1 >= n3) {
                            return -1;
                        }
                        n7 = (n7 << 12) + ((0x3F & byArray[n2]) << 6) + (0x3F & byArray[++n2]);
                        break;
                    }
                    default: {
                        if (++n2 + 2 >= n3) {
                            return -1;
                        }
                        n7 = (n7 << 18) + ((0x3F & byArray[n2]) << 12) + ((0x3F & byArray[++n2]) << 6) + (0x3F & byArray[++n2]);
                    }
                }
                if (!XMLCharacterProperties.nameChar10(n7)) {
                    return -1;
                }
            }
            ++n2;
        }
        int n8 = n2;
        if ((n2 = TypeValidator.removeWhitespace(byArray, n2, n3, blArray)) >= n3) {
            return -1;
        }
        xMLString.setValues(parsedEntity.buffer, n4, n8);
        xMLString.flags = 1;
        return n2;
    }

    public static boolean isName(XMLString xMLString) {
        if (xMLString.length == 0) {
            return false;
        }
        return xMLString.bytes != null ? XMLStringUtil.isNameUnbuffered(xMLString) : XMLStringUtil.isNameBuffered(xMLString);
    }

    private static boolean isNameUnbuffered(XMLString xMLString) {
        int n2;
        int n3;
        int n4;
        int n5 = xMLString.startOffset;
        int n6 = xMLString.endOffset;
        if ((n4 = xMLString.bytes[n5++]) >= 0) {
            if (!XMLCharacterProperties.nameStartChar10(n4)) {
                return false;
            }
        } else {
            n3 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
            n2 = n4 & fgFirstByteValueMask[n3];
            switch (n3) {
                case 2: {
                    n2 = (n2 << 6) + (0x3F & xMLString.bytes[n5++]);
                    break;
                }
                case 3: {
                    n2 = (n2 << 12) + ((0x3F & xMLString.bytes[n5++]) << 6) + (0x3F & xMLString.bytes[n5++]);
                    break;
                }
                default: {
                    n2 = (n2 << 18) + ((0x3F & xMLString.bytes[n5++]) << 12) + ((0x3F & xMLString.bytes[n5++]) << 6) + (0x3F & xMLString.bytes[n5++]);
                }
            }
            if (!XMLCharacterProperties.nameStartChar10(n2)) {
                return false;
            }
        }
        while (n5 < n6 && (n4 = xMLString.bytes[n5]) >= 0) {
            if (!XMLCharacterProperties.nameChar10(n4)) {
                return false;
            }
            ++n5;
        }
        if (n5 == n6) {
            return true;
        }
        while (n5 < n6) {
            if ((n4 = xMLString.bytes[n5++]) >= 0) {
                if (XMLCharacterProperties.nameChar10(n4)) continue;
                return false;
            }
            n2 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
            n3 = n4 & fgFirstByteValueMask[n2];
            switch (n2) {
                case 2: {
                    n3 = (n3 << 6) + (0x3F & xMLString.bytes[n5++]);
                    break;
                }
                case 3: {
                    n3 = (n3 << 12) + ((0x3F & xMLString.bytes[n5++]) << 6) + (0x3F & xMLString.bytes[n5++]);
                    break;
                }
                default: {
                    n3 = (n3 << 18) + ((0x3F & xMLString.bytes[n5++]) << 12) + ((0x3F & xMLString.bytes[n5++]) << 6) + (0x3F & xMLString.bytes[n5++]);
                }
            }
            if (XMLCharacterProperties.nameChar10(n3)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNameBuffered(XMLString xMLString) {
        return true;
    }

    public static int parseNameUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, boolean[] blArray) {
        int n2;
        int n3;
        byte[] byArray = parsedEntity.bytes;
        int n4 = parsedEntity.offset;
        int n5 = parsedEntity.endOffset;
        if ((n4 = TypeValidator.removeWhitespace(byArray, n4, n5, blArray)) >= n5) {
            return -1;
        }
        int n6 = n4;
        int n7 = byArray[n4];
        if (n7 >= 0) {
            if (!XMLCharacterProperties.nameStartChar10(n7)) {
                return -1;
            }
        } else {
            n3 = fgMultiByteLength[(n7 &= 0xFF) >> 3];
            n2 = n7 & fgFirstByteValueMask[n3];
            switch (n3) {
                case 2: {
                    if (++n4 >= n5) {
                        return -1;
                    }
                    n2 = (n2 << 6) + (0x3F & byArray[n4]);
                    break;
                }
                case 3: {
                    if (++n4 + 1 >= n5) {
                        return -1;
                    }
                    n2 = (n2 << 12) + ((0x3F & byArray[n4]) << 6) + (0x3F & byArray[++n4]);
                    break;
                }
                default: {
                    if (++n4 + 2 >= n5) {
                        return -1;
                    }
                    n2 = (n2 << 18) + ((0x3F & byArray[n4]) << 12) + ((0x3F & byArray[++n4]) << 6) + (0x3F & byArray[++n4]);
                }
            }
            if (!XMLCharacterProperties.nameStartChar10(n2)) {
                return -1;
            }
        }
        while (n4 < n5) {
            n7 = byArray[n4];
            if (n7 >= 0) {
                if (!XMLCharacterProperties.nameChar10(n7)) {
                    break;
                }
            } else {
                n3 = fgMultiByteLength[(n7 &= 0xFF) >> 3];
                n2 = n7 & fgFirstByteValueMask[n3];
                switch (n3) {
                    case 2: {
                        if (++n4 >= n5) {
                            return -1;
                        }
                        n2 = (n2 << 6) + (0x3F & byArray[n4++]);
                        break;
                    }
                    case 3: {
                        if (++n4 + 1 >= n5) {
                            return -1;
                        }
                        n2 = (n2 << 12) + ((0x3F & byArray[n4++]) << 6) + (0x3F & byArray[n4++]);
                        break;
                    }
                    default: {
                        if (++n4 + 2 >= n5) {
                            return -1;
                        }
                        n2 = (n2 << 18) + ((0x3F & byArray[n4++]) << 12) + ((0x3F & byArray[n4++]) << 6) + (0x3F & byArray[n4++]);
                    }
                }
                if (!XMLCharacterProperties.nameChar10(n2)) {
                    return -1;
                }
            }
            ++n4;
        }
        int n8 = n4;
        if ((n4 = TypeValidator.removeWhitespace(byArray, n4, n5, blArray)) >= n5) {
            return -1;
        }
        xMLString.setValues(parsedEntity.buffer, n6, n8);
        xMLString.flags = 1;
        return n4;
    }

    public static boolean isNCName(XMLString xMLString) {
        if (xMLString.length == 0) {
            return false;
        }
        return xMLString.bytes != null ? XMLStringUtil.isNCNameUnbuffered(xMLString) : XMLStringUtil.isNCNameBuffered(xMLString);
    }

    private static boolean isNCNameUnbuffered(XMLString xMLString) {
        int n2;
        int n3;
        int n4;
        int n5 = xMLString.startOffset;
        int n6 = xMLString.endOffset;
        if ((n4 = xMLString.bytes[n5++]) >= 0) {
            if (n4 == 58 || !XMLCharacterProperties.nameStartChar10(n4)) {
                return false;
            }
        } else {
            n3 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
            n2 = n4 & fgFirstByteValueMask[n3];
            switch (n3) {
                case 2: {
                    n2 = (n2 << 6) + (0x3F & xMLString.bytes[n5++]);
                    break;
                }
                case 3: {
                    n2 = (n2 << 12) + ((0x3F & xMLString.bytes[n5++]) << 6) + (0x3F & xMLString.bytes[n5++]);
                    break;
                }
                default: {
                    n2 = (n2 << 18) + ((0x3F & xMLString.bytes[n5++]) << 12) + ((0x3F & xMLString.bytes[n5++]) << 6) + (0x3F & xMLString.bytes[n5++]);
                }
            }
            if (!XMLCharacterProperties.nameStartChar10(n2)) {
                return false;
            }
        }
        while (n5 < n6 && (n4 = xMLString.bytes[n5]) >= 0) {
            if (n4 == 58 || !XMLCharacterProperties.nameChar10(n4)) {
                return false;
            }
            ++n5;
        }
        if (n5 == n6) {
            return true;
        }
        while (n5 < n6) {
            if ((n4 = xMLString.bytes[n5++]) >= 0) {
                if (n4 != 58 && XMLCharacterProperties.nameChar10(n4)) continue;
                return false;
            }
            n2 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
            n3 = n4 & fgFirstByteValueMask[n2];
            switch (n2) {
                case 2: {
                    n3 = (n3 << 6) + (0x3F & xMLString.bytes[n5++]);
                    break;
                }
                case 3: {
                    n3 = (n3 << 12) + ((0x3F & xMLString.bytes[n5++]) << 6) + (0x3F & xMLString.bytes[n5++]);
                    break;
                }
                default: {
                    n3 = (n3 << 18) + ((0x3F & xMLString.bytes[n5++]) << 12) + ((0x3F & xMLString.bytes[n5++]) << 6) + (0x3F & xMLString.bytes[n5++]);
                }
            }
            if (XMLCharacterProperties.nameChar10(n3)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNCNameBuffered(XMLString xMLString) {
        return true;
    }

    public static int parseNCNameUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, boolean[] blArray) {
        int n2;
        int n3;
        byte[] byArray = parsedEntity.bytes;
        int n4 = parsedEntity.offset;
        int n5 = parsedEntity.endOffset;
        if ((n4 = TypeValidator.removeWhitespace(byArray, n4, n5, blArray)) >= n5) {
            return -1;
        }
        int n6 = n4;
        int n7 = byArray[n4];
        if (n7 >= 0) {
            if (n7 == 58 || !XMLCharacterProperties.nameStartChar10(n7)) {
                return -1;
            }
        } else {
            n3 = fgMultiByteLength[(n7 &= 0xFF) >> 3];
            n2 = n7 & fgFirstByteValueMask[n3];
            switch (n3) {
                case 2: {
                    if (++n4 >= n5) {
                        return -1;
                    }
                    n2 = (n2 << 6) + (0x3F & byArray[n4]);
                    break;
                }
                case 3: {
                    if (++n4 + 1 >= n5) {
                        return -1;
                    }
                    n2 = (n2 << 12) + ((0x3F & byArray[n4]) << 6) + (0x3F & byArray[++n4]);
                    break;
                }
                default: {
                    if (++n4 + 2 >= n5) {
                        return -1;
                    }
                    n2 = (n2 << 18) + ((0x3F & byArray[n4]) << 12) + ((0x3F & byArray[++n4]) << 6) + (0x3F & byArray[++n4]);
                }
            }
            if (!XMLCharacterProperties.nameStartChar10(n2)) {
                return -1;
            }
        }
        while (n4 < n5) {
            n7 = byArray[n4];
            if (n7 >= 0) {
                if (n7 == 58) {
                    return -1;
                }
                if (!XMLCharacterProperties.nameChar10(n7)) {
                    break;
                }
            } else {
                n3 = fgMultiByteLength[(n7 &= 0xFF) >> 3];
                n2 = n7 & fgFirstByteValueMask[n3];
                switch (n3) {
                    case 2: {
                        if (++n4 >= n5) {
                            return -1;
                        }
                        n2 = (n2 << 6) + (0x3F & byArray[n4++]);
                        break;
                    }
                    case 3: {
                        if (++n4 + 1 >= n5) {
                            return -1;
                        }
                        n2 = (n2 << 12) + ((0x3F & byArray[n4++]) << 6) + (0x3F & byArray[n4++]);
                        break;
                    }
                    default: {
                        if (++n4 + 2 >= n5) {
                            return -1;
                        }
                        n2 = (n2 << 18) + ((0x3F & byArray[n4++]) << 12) + ((0x3F & byArray[n4++]) << 6) + (0x3F & byArray[n4++]);
                    }
                }
                if (!XMLCharacterProperties.nameChar10(n2)) {
                    return -1;
                }
            }
            ++n4;
        }
        int n8 = n4;
        if ((n4 = TypeValidator.removeWhitespace(byArray, n4, n5, blArray)) >= n5) {
            return -1;
        }
        xMLString.setValues(parsedEntity.buffer, n6, n8);
        xMLString.flags = 1;
        return n4;
    }

    private XMLStringUtil() {
    }

    public static XMLString[] tokenizeToXMLStringList(XMLString xMLString) {
        if (xMLString.length == 0) {
            return null;
        }
        if (xMLString.bytes != null) {
            return XMLStringUtil.tokenizeUnbuffered(xMLString);
        }
        return XMLStringUtil.tokenizeBuffered(xMLString);
    }

    private static XMLString[] tokenizeBuffered(XMLString xMLString) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n2];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    continue;
                }
                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2];
            }
        }
        if (n2 == n3) {
            return null;
        }
        ArrayList<XMLString> arrayList = new ArrayList<XMLString>();
        XMLString xMLString2 = new XMLString(xMLString);
        block1: while (true) {
            if (n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                    while (true) {
                        if (n2 + 1 < n3) break;
                        if (dataBuffer == dataBuffer2) break block1;
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset - 1;
                        n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by2 = dataBuffer.bytes[n2 + 1];
                    if (by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                        xMLString2.startOffset = n2 + 1;
                        xMLString2.firstBuffer = dataBuffer;
                    }
                } else {
                    XMLString xMLString3;
                    while (true) {
                        if (n2 + 1 < n3) break;
                        if (dataBuffer == dataBuffer2) {
                            xMLString2.endOffset = n2 + 1;
                            xMLString2.lastBuffer = dataBuffer;
                            xMLString3 = new XMLString(xMLString2);
                            arrayList.add(xMLString3);
                            break block1;
                        }
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset - 1;
                        n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by2 = dataBuffer.bytes[n2 + 1];
                    if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        xMLString2.endOffset = n2 + 1;
                        xMLString2.lastBuffer = dataBuffer;
                        xMLString3 = new XMLString(xMLString2);
                        arrayList.add(xMLString3);
                    }
                }
                ++n2;
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset - 1;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        xMLString2.unregister();
        return arrayList.toArray(ArrayAllocator.newObjectArray(XMLString.class, arrayList.size()));
    }

    private static XMLString[] tokenizeUnbuffered(XMLString xMLString) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        if ((n2 = XMLStringUtil.removeWhitespace(xMLString.bytes, n2, n3)) == n3) {
            return null;
        }
        byte by2 = 0;
        ArrayList<XMLString> arrayList = new ArrayList<XMLString>();
        XMLString xMLString2 = new XMLString(xMLString);
        xMLString2.startOffset = n2;
        while (n2 < n3) {
            XMLString xMLString3;
            by2 = xMLString.bytes[n2];
            if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n2 + 1 < n3 && (by2 = xMLString.bytes[n2 + 1]) != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                    xMLString2.startOffset = n2 + 1;
                }
            } else if (n2 + 1 < n3) {
                by2 = xMLString.bytes[n2 + 1];
                if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                    xMLString2.endOffset = n2 + 1;
                    xMLString2.length = xMLString2.endOffset - xMLString2.startOffset;
                    xMLString3 = new XMLString(xMLString2);
                    arrayList.add(xMLString3);
                }
            } else {
                xMLString2.endOffset = n2 + 1;
                xMLString2.length = xMLString2.endOffset - xMLString2.startOffset;
                xMLString3 = new XMLString(xMLString2);
                arrayList.add(xMLString3);
                break;
            }
            ++n2;
        }
        xMLString2.unregister();
        return arrayList.toArray(ArrayAllocator.newObjectArray(XMLString.class, arrayList.size()));
    }

    public static int removeWhitespace(byte[] byArray, int n2, int n3) {
        if (n2 < n3) {
            byte by2 = byArray[n2];
            while ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                by2 = byArray[n2];
            }
        }
        return n2;
    }
}

