/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.XBinary;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XSHexBinaryUtil {
    private static final byte[] hexCharNibbleMap = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final XBinary ZERO_LENGTH_HEX_BINARY = new XBinary(ArrayAllocator.newByteArray(0), 0);

    public static XBinary parseHexBinary(XMLString xMLString) {
        if (xMLString.length == 0) {
            return ZERO_LENGTH_HEX_BINARY;
        }
        if (xMLString.bytes != null) {
            return XSHexBinaryUtil.parseHexBinaryUnbuffered(xMLString);
        }
        return XSHexBinaryUtil.parseHexBinaryBuffered(xMLString);
    }

    private static XBinary parseHexBinaryUnbuffered(XMLString xMLString) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        byte[] byArray = xMLString.bytes;
        byte[] byArray2 = ArrayAllocator.newByteArray(xMLString.length >> 1);
        int n4 = 0;
        while (n2 < n3) {
            byte by2;
            byte by3 = byArray[n2];
            byte by4 = hexCharNibbleMap[by3 & 0xFF];
            if (by4 == -1) {
                if (by3 <= 32) {
                    boolean bl;
                    boolean bl2 = bl = xMLString.startOffset == n2;
                    while ((by3 == 32 || by3 == 10 || by3 == 9 || by3 == 13) && ++n2 < n3) {
                        by3 = byArray[n2];
                    }
                    if (n2 == n3) {
                        return !bl ? new XBinary(byArray2, n4) : ZERO_LENGTH_HEX_BINARY;
                    }
                    if (!bl || (by4 = hexCharNibbleMap[by3 & 0xFF]) == -1) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (++n2 == n3) {
                return null;
            }
            if ((by2 = hexCharNibbleMap[byArray[n2++] & 0xFF]) == -1) {
                return null;
            }
            byArray2[n4++] = (byte)(by4 << 4 | by2);
        }
        return new XBinary(byArray2, n4);
    }

    private static XBinary parseHexBinaryBuffered(XMLString xMLString) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        byte[] byArray = ArrayAllocator.newByteArray(xMLString.length >> 1);
        int n3 = 0;
        while (true) {
            int n4;
            int n5 = n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            while (n2 < n4) {
                byte by2;
                byte by3 = dataBuffer.bytes[n2];
                byte by4 = hexCharNibbleMap[by3 & 0xFF];
                if (by4 == -1) {
                    if (by3 <= 32) {
                        boolean bl;
                        boolean bl2 = bl = xMLString.startOffset == n2;
                        while (true) {
                            if ((by3 == 32 || by3 == 10 || by3 == 9 || by3 == 13) && ++n2 < n4) {
                                by3 = dataBuffer.bytes[n2];
                                continue;
                            }
                            if (n2 != n4 || dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset;
                            n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by3 = dataBuffer.bytes[n2];
                        }
                        if (n2 == n4) {
                            return !bl ? new XBinary(byArray, n3) : ZERO_LENGTH_HEX_BINARY;
                        }
                        if (!bl || (by4 = hexCharNibbleMap[by3 & 0xFF]) == -1) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                if (++n2 == n4) {
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    int n6 = n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                if ((by2 = hexCharNibbleMap[dataBuffer.bytes[n2++] & 0xFF]) == -1) {
                    return null;
                }
                byArray[n3++] = (byte)(by4 << 4 | by2);
            }
            if (dataBuffer == dataBuffer2) {
                return new XBinary(byArray, n3);
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
        }
    }

    public static int parseHexBinaryBuffered(ParsedEntity parsedEntity, XBinary xBinary, boolean[] blArray) {
        int n2;
        int n3;
        block21: {
            byte by2;
            byte[] byArray;
            block18: {
                n3 = parsedEntity.offset;
                n2 = parsedEntity.endOffset;
                byArray = parsedEntity.bytes;
                xBinary.length = 0;
                if (xBinary.value == null || xBinary.value.length >= 4096) {
                    xBinary.value = ArrayAllocator.newByteArray(256);
                }
                if (byArray[n3] > 32) break block18;
                while (true) {
                    block19: {
                        block20: {
                            if (n3 >= n2) break block19;
                            by2 = byArray[n3];
                            if (by2 == 32) break block20;
                            if (by2 != 10 && by2 != 9 && by2 != 13) break block19;
                            blArray[0] = false;
                        }
                        ++n3;
                        continue;
                    }
                    if (n3 != n2 || parsedEntity.loadMore() == 0) break;
                    byArray = parsedEntity.bytes;
                    n3 = parsedEntity.offset;
                    n2 = parsedEntity.endOffset;
                }
            }
            if (n3 == n2) {
                return -1;
            }
            while (true) {
                if (n3 < n2) {
                    byte by3;
                    by2 = byArray[n3];
                    byte by4 = hexCharNibbleMap[by2 & 0xFF];
                    if (by4 == -1) break;
                    if (++n3 >= n2) {
                        if (parsedEntity.loadMore() == 0) {
                            parsedEntity.resetToMark();
                            return -1;
                        }
                        byArray = parsedEntity.bytes;
                        n3 = parsedEntity.offset;
                        n2 = parsedEntity.endOffset;
                    }
                    if ((by3 = hexCharNibbleMap[byArray[n3++] & 0xFF]) == -1) {
                        return -1;
                    }
                    if (xBinary.length >= xBinary.value.length) {
                        xBinary.value = ArrayAllocator.resizeByteArray(xBinary.value, xBinary.value.length * 2);
                    }
                    xBinary.value[xBinary.length++] = (byte)(by4 << 4 | by3);
                    continue;
                }
                if (parsedEntity.loadMore() == 0) {
                    return -1;
                }
                byArray = parsedEntity.bytes;
                n3 = parsedEntity.offset;
                n2 = parsedEntity.endOffset;
            }
            if (by2 > 32) break block21;
            while (true) {
                block22: {
                    block23: {
                        if (n3 >= n2) break block22;
                        by2 = byArray[n3];
                        if (by2 == 32) break block23;
                        if (by2 != 10 && by2 != 9 && by2 != 13) break block22;
                        blArray[0] = false;
                    }
                    ++n3;
                    continue;
                }
                if (n3 != n2 || parsedEntity.loadMore() == 0) break;
                byArray = parsedEntity.bytes;
                n3 = parsedEntity.offset;
                n2 = parsedEntity.endOffset;
            }
        }
        if (n3 == n2) {
            return -1;
        }
        return n3;
    }

    private XSHexBinaryUtil() {
    }
}

