/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XSIntegerUtil {
    public static final long UNSIGNED_INT_MAX_VALUE = 0xFFFFFFFFL;
    public static final int UNSIGNED_SHORT_MAX_VALUE = 65535;
    public static final int UNSIGNED_BYTE_MAX_VALUE = 255;
    private static final int SIGNED_INT_MULTMIN = -214748364;
    private static final long SIGNED_LONG_MULTMIN = -922337203685477580L;

    public static long parseLong(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0L;
        }
        if (xMLString.bytes != null) {
            return XSIntegerUtil.parseLongUnbuffered(xMLString, nArray);
        }
        return XSIntegerUtil.parseLongBuffered(xMLString, nArray);
    }

    public static int parseInt(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return XSIntegerUtil.parseIntUnbuffered(xMLString, nArray);
        }
        return XSIntegerUtil.parseIntBuffered(xMLString, nArray);
    }

    public static long parseUInt(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0L;
        }
        if (xMLString.bytes != null) {
            return XSIntegerUtil.parseUIntUnbuffered(xMLString, nArray);
        }
        return XSIntegerUtil.parseUIntBuffered(xMLString, nArray);
    }

    public static short parseShort(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return (short)XSIntegerUtil.parseSignedUnbuffered(xMLString, Short.MAX_VALUE, Short.MIN_VALUE, nArray);
        }
        return (short)XSIntegerUtil.parseSignedBuffered(xMLString, Short.MAX_VALUE, Short.MIN_VALUE, nArray);
    }

    public static int parseUShort(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return XSIntegerUtil.parseUSignedUnbuffered(xMLString, 65535, nArray);
        }
        return XSIntegerUtil.parseUSignedBuffered(xMLString, 65535, nArray);
    }

    public static byte parseByte(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return (byte)XSIntegerUtil.parseSignedUnbuffered(xMLString, 127, -128, nArray);
        }
        return (byte)XSIntegerUtil.parseSignedBuffered(xMLString, 127, -128, nArray);
    }

    public static short parseUByte(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return (short)XSIntegerUtil.parseUSignedUnbuffered(xMLString, 255, nArray);
        }
        return (short)XSIntegerUtil.parseUSignedBuffered(xMLString, 255, nArray);
    }

    private static long parseLongUnbuffered(XMLString xMLString, int[] nArray) {
        byte by2;
        boolean bl = false;
        long l = -9223372036854775807L;
        long l2 = -922337203685477580L;
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by2 = xMLString.bytes[n2++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n2 < n3) {
                    by2 = xMLString.bytes[n2++];
                    continue;
                }
                nArray[0] = 1;
                return 0L;
            }
        }
        if (by2 == 45) {
            bl = true;
            l = Long.MIN_VALUE;
            if (n2 < n3) {
                by2 = xMLString.bytes[n2++];
            }
        } else if (by2 == 43 && n2 < n3) {
            by2 = xMLString.bytes[n2++];
        }
        if (by2 >= 48 && by2 <= 57) {
            long l3 = 48 - by2;
            while (n2 < n3) {
                if ((by2 = xMLString.bytes[n2++]) >= 48 && by2 <= 57) {
                    int n4;
                    if (l3 >= l2 && (l3 *= 10L) >= l + (long)(n4 = by2 - 48)) {
                        l3 -= (long)n4;
                        continue;
                    }
                } else if (by2 <= 32) {
                    while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        if (n2 < n3) {
                            by2 = xMLString.bytes[n2++];
                            continue;
                        }
                        return bl ? l3 : -l3;
                    }
                }
                nArray[0] = 1;
                return 0L;
            }
            return bl ? l3 : -l3;
        }
        nArray[0] = 1;
        return 0L;
    }

    private static long parseLongBuffered(XMLString xMLString, int[] nArray) {
        byte by2;
        boolean bl = false;
        long l = -9223372036854775807L;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by2 = dataBuffer.bytes[n2++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n2 < n3) {
                    by2 = dataBuffer.bytes[n2++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0L;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2++];
            }
        }
        if (by2 == 45) {
            bl = true;
            l = Long.MIN_VALUE;
            while (true) {
                if (n2 < n3) {
                    by2 = dataBuffer.bytes[n2++];
                } else if (dataBuffer != dataBuffer2) {
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    continue;
                }
                break;
            }
        } else if (by2 == 43) {
            while (true) {
                if (n2 < n3) {
                    by2 = dataBuffer.bytes[n2++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by2 >= 48 && by2 <= 57) {
            long l2 = 48 - by2;
            while (true) {
                if (n2 < n3) {
                    if ((by2 = dataBuffer.bytes[n2++]) >= 48 && by2 <= 57) {
                        int n4 = by2 - 48;
                        if (l2 >= -922337203685477580L && (l2 *= 10L) >= l + (long)n4) {
                            l2 -= (long)n4;
                            continue;
                        }
                    } else if (by2 <= 32) {
                        while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                            if (n2 < n3) {
                                by2 = dataBuffer.bytes[n2++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return bl ? l2 : -l2;
                            }
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n2++];
                        }
                    }
                    nArray[0] = 1;
                    return 0L;
                }
                if (dataBuffer == dataBuffer2) {
                    return bl ? l2 : -l2;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0L;
    }

    private static int parseIntUnbuffered(XMLString xMLString, int[] nArray) {
        byte by2;
        boolean bl = false;
        int n2 = -2147483647;
        int n3 = -214748364;
        int n4 = xMLString.startOffset;
        int n5 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by2 = xMLString.bytes[n4++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n4 < n5) {
                    by2 = xMLString.bytes[n4++];
                    continue;
                }
                nArray[0] = 1;
                return 0;
            }
        }
        if (by2 == 45) {
            bl = true;
            n2 = Integer.MIN_VALUE;
            if (n4 < n5) {
                by2 = xMLString.bytes[n4++];
            }
        } else if (by2 == 43 && n4 < n5) {
            by2 = xMLString.bytes[n4++];
        }
        if (by2 >= 48 && by2 <= 57) {
            int n6 = 48 - by2;
            while (n4 < n5) {
                if ((by2 = xMLString.bytes[n4++]) >= 48 && by2 <= 57) {
                    int n7;
                    if (n6 >= n3 && (n6 *= 10) >= n2 + (n7 = by2 - 48)) {
                        n6 -= n7;
                        continue;
                    }
                } else if (by2 <= 32) {
                    while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        if (n4 < n5) {
                            by2 = xMLString.bytes[n4++];
                            continue;
                        }
                        return bl ? n6 : -n6;
                    }
                }
                nArray[0] = 1;
                return 0;
            }
            return bl ? n6 : -n6;
        }
        nArray[0] = 1;
        return 0;
    }

    private static int parseIntBuffered(XMLString xMLString, int[] nArray) {
        byte by2;
        boolean bl = false;
        int n2 = -2147483647;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n3 = xMLString.startOffset;
        int n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by2 = dataBuffer.bytes[n3++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n3 < n4) {
                    by2 = dataBuffer.bytes[n3++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0;
                }
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n3++];
            }
        }
        if (by2 == 45) {
            bl = true;
            n2 = Integer.MIN_VALUE;
            while (true) {
                if (n3 < n4) {
                    by2 = dataBuffer.bytes[n3++];
                } else if (dataBuffer != dataBuffer2) {
                    dataBuffer = dataBuffer.next;
                    n3 = dataBuffer.startOffset;
                    n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    continue;
                }
                break;
            }
        } else if (by2 == 43) {
            while (true) {
                if (n3 < n4) {
                    by2 = dataBuffer.bytes[n3++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by2 >= 48 && by2 <= 57) {
            int n5 = 48 - by2;
            while (true) {
                if (n3 < n4) {
                    if ((by2 = dataBuffer.bytes[n3++]) >= 48 && by2 <= 57) {
                        int n6 = by2 - 48;
                        if (n5 >= -214748364 && (n5 *= 10) >= n2 + n6) {
                            n5 -= n6;
                            continue;
                        }
                    } else if (by2 <= 32) {
                        while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                            if (n3 < n4) {
                                by2 = dataBuffer.bytes[n3++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return bl ? n5 : -n5;
                            }
                            dataBuffer = dataBuffer.next;
                            n3 = dataBuffer.startOffset;
                            n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n3++];
                        }
                    }
                    nArray[0] = 1;
                    return 0;
                }
                if (dataBuffer == dataBuffer2) {
                    return bl ? n5 : -n5;
                }
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0;
    }

    private static long parseUIntUnbuffered(XMLString xMLString, int[] nArray) {
        byte by2;
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by2 = xMLString.bytes[n2++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n2 < n3) {
                    by2 = xMLString.bytes[n2++];
                    continue;
                }
                nArray[0] = 1;
                return 0L;
            }
        }
        if (by2 == 43 && n2 < n3) {
            by2 = xMLString.bytes[n2++];
        }
        if (by2 >= 48 && by2 <= 57) {
            long l = by2 - 48;
            while (n2 < n3) {
                if ((by2 = xMLString.bytes[n2++]) >= 48 && by2 <= 57) {
                    if ((l = l * 10L + (long)(by2 - 48)) <= 0xFFFFFFFFL) {
                        continue;
                    }
                } else if (by2 <= 32) {
                    while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        if (n2 < n3) {
                            by2 = xMLString.bytes[n2++];
                            continue;
                        }
                        return l;
                    }
                }
                nArray[0] = 1;
                return 0L;
            }
            return l;
        }
        nArray[0] = 1;
        return 0L;
    }

    private static long parseUIntBuffered(XMLString xMLString, int[] nArray) {
        byte by2;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by2 = dataBuffer.bytes[n2++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n2 < n3) {
                    by2 = dataBuffer.bytes[n2++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0L;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2++];
            }
        }
        if (by2 == 43) {
            while (true) {
                if (n2 < n3) {
                    by2 = dataBuffer.bytes[n2++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by2 >= 48 && by2 <= 57) {
            long l = by2 - 48;
            while (true) {
                if (n2 < n3) {
                    if ((by2 = dataBuffer.bytes[n2++]) >= 48 && by2 <= 57) {
                        if ((l = l * 10L + (long)(by2 - 48)) <= 0xFFFFFFFFL) {
                            continue;
                        }
                    } else if (by2 <= 32) {
                        while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                            if (n2 < n3) {
                                by2 = dataBuffer.bytes[n2++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return l;
                            }
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n2++];
                        }
                    }
                    nArray[0] = 1;
                    return 0L;
                }
                if (dataBuffer == dataBuffer2) {
                    return l;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0L;
    }

    private static int parseSignedUnbuffered(XMLString xMLString, int n2, int n3, int[] nArray) {
        byte by2;
        boolean bl = false;
        int n4 = n2;
        int n5 = xMLString.startOffset;
        int n6 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by2 = xMLString.bytes[n5++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n5 < n6) {
                    by2 = xMLString.bytes[n5++];
                    continue;
                }
                nArray[0] = 1;
                return 0;
            }
        }
        if (by2 == 45) {
            bl = true;
            n4 = -n3;
            if (n5 < n6) {
                by2 = xMLString.bytes[n5++];
            }
        } else if (by2 == 43 && n5 < n6) {
            by2 = xMLString.bytes[n5++];
        }
        if (by2 >= 48 && by2 <= 57) {
            int n7 = by2 - 48;
            while (n5 < n6) {
                if ((by2 = xMLString.bytes[n5++]) >= 48 && by2 <= 57) {
                    if ((n7 = n7 * 10 + (by2 - 48)) <= n4) {
                        continue;
                    }
                } else if (by2 <= 32) {
                    while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        if (n5 < n6) {
                            by2 = xMLString.bytes[n5++];
                            continue;
                        }
                        return bl ? -n7 : n7;
                    }
                }
                nArray[0] = 1;
                return 0;
            }
            return bl ? -n7 : n7;
        }
        nArray[0] = 1;
        return 0;
    }

    private static int parseSignedBuffered(XMLString xMLString, int n2, int n3, int[] nArray) {
        byte by2;
        boolean bl = false;
        int n4 = n2;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n5 = xMLString.startOffset;
        int n6 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by2 = dataBuffer.bytes[n5++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n5 < n6) {
                    by2 = dataBuffer.bytes[n5++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0;
                }
                dataBuffer = dataBuffer.next;
                n5 = dataBuffer.startOffset;
                n6 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n5++];
            }
        }
        if (by2 == 45) {
            bl = true;
            n4 = -n3;
            while (true) {
                if (n5 < n6) {
                    by2 = dataBuffer.bytes[n5++];
                } else if (dataBuffer != dataBuffer2) {
                    dataBuffer = dataBuffer.next;
                    n5 = dataBuffer.startOffset;
                    n6 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    continue;
                }
                break;
            }
        } else if (by2 == 43) {
            while (true) {
                if (n5 < n6) {
                    by2 = dataBuffer.bytes[n5++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n5 = dataBuffer.startOffset;
                n6 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by2 >= 48 && by2 <= 57) {
            int n7 = by2 - 48;
            while (true) {
                if (n5 < n6) {
                    if ((by2 = dataBuffer.bytes[n5++]) >= 48 && by2 <= 57) {
                        if ((n7 = n7 * 10 + (by2 - 48)) <= n4) {
                            continue;
                        }
                    } else if (by2 <= 32) {
                        while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                            if (n5 < n6) {
                                by2 = dataBuffer.bytes[n5++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return bl ? -n7 : n7;
                            }
                            dataBuffer = dataBuffer.next;
                            n5 = dataBuffer.startOffset;
                            n6 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n5++];
                        }
                    }
                    nArray[0] = 1;
                    return 0;
                }
                if (dataBuffer == dataBuffer2) {
                    return bl ? -n7 : n7;
                }
                dataBuffer = dataBuffer.next;
                n5 = dataBuffer.startOffset;
                n6 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0;
    }

    private static int parseUSignedUnbuffered(XMLString xMLString, int n2, int[] nArray) {
        byte by2;
        int n3 = xMLString.startOffset;
        int n4 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by2 = xMLString.bytes[n3++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n3 < n4) {
                    by2 = xMLString.bytes[n3++];
                    continue;
                }
                nArray[0] = 1;
                return 0;
            }
        }
        if (by2 == 43 && n3 < n4) {
            by2 = xMLString.bytes[n3++];
        }
        if (by2 >= 48 && by2 <= 57) {
            int n5 = by2 - 48;
            while (n3 < n4) {
                if ((by2 = xMLString.bytes[n3++]) >= 48 && by2 <= 57) {
                    if ((n5 = n5 * 10 + (by2 - 48)) <= n2) {
                        continue;
                    }
                } else if (by2 <= 32) {
                    while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        if (n3 < n4) {
                            by2 = xMLString.bytes[n3++];
                            continue;
                        }
                        return n5;
                    }
                }
                nArray[0] = 1;
                return 0;
            }
            return n5;
        }
        nArray[0] = 1;
        return 0;
    }

    private static int parseUSignedBuffered(XMLString xMLString, int n2, int[] nArray) {
        byte by2;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n3 = xMLString.startOffset;
        int n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by2 = dataBuffer.bytes[n3++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n3 < n4) {
                    by2 = dataBuffer.bytes[n3++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0;
                }
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n3++];
            }
        }
        if (by2 == 43) {
            while (true) {
                if (n3 < n4) {
                    by2 = dataBuffer.bytes[n3++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by2 >= 48 && by2 <= 57) {
            int n5 = by2 - 48;
            while (true) {
                if (n3 < n4) {
                    if ((by2 = dataBuffer.bytes[n3++]) >= 48 && by2 <= 57) {
                        if ((n5 = n5 * 10 + (by2 - 48)) <= n2) {
                            continue;
                        }
                    } else if (by2 <= 32) {
                        while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                            if (n3 < n4) {
                                by2 = dataBuffer.bytes[n3++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return n5;
                            }
                            dataBuffer = dataBuffer.next;
                            n3 = dataBuffer.startOffset;
                            n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n3++];
                        }
                    }
                    nArray[0] = 1;
                    return 0;
                }
                if (dataBuffer == dataBuffer2) {
                    return n5;
                }
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0;
    }

    public static int getTotalDigits(XMLString xMLString) {
        return xMLString.bytes != null ? XSIntegerUtil.getTotalDigitsUnbuffered(xMLString) : XSIntegerUtil.getTotalDigitsBuffered(xMLString);
    }

    private static int getTotalDigitsUnbuffered(XMLString xMLString) {
        byte by2;
        byte[] byArray = xMLString.bytes;
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        int n4 = xMLString.length;
        while (n2 < n3 && ((by2 = byArray[n2++]) < 49 || by2 > 57)) {
            --n4;
        }
        while (n2 < n3 && ((by2 = byArray[--n3]) < 48 || by2 > 57)) {
            --n4;
        }
        return n4;
    }

    private static int getTotalDigitsBuffered(XMLString xMLString) {
        byte by2;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        int n4 = xMLString.length;
        while (true) {
            if (n2 < n3) {
                if ((by2 = dataBuffer.bytes[n2++]) >= 49 && by2 <= 57) break;
                --n4;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                return n4;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        while (true) {
            if (n2 < n3) {
                if ((by2 = dataBuffer.bytes[n2++]) >= 48 && by2 <= 57) continue;
                n4 -= n3 - n2 + 1;
                break;
            }
            if (dataBuffer == dataBuffer2) {
                return n4;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        while (dataBuffer != dataBuffer2) {
            dataBuffer = dataBuffer.next;
            n4 -= (dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset) - dataBuffer.startOffset;
        }
        return n4;
    }

    private XSIntegerUtil() {
    }
}

