/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.grammar;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.converter.MergerContext;
import com.ibm.xml.xlxp.internal.s1.grammar.ElementType;
import com.ibm.xml.xlxp.internal.s1.grammar.NamedDeclaration;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.validation.idc.XPathDFA;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import java.util.logging.Level;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class Grammar {
    private static final String COPYRIGHT_YEARS = "Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int INDEX_NONS_SL = 0;
    public static final int INDEX_SL = 1;
    public static final int INDEX_XSI_TYPE = 2;
    public static final int INDEX_XSI_NIL = 3;
    public static final int TOTAL_XSI_ATTRS = 4;
    public static final byte ELEMENT_DECLARATION = 1;
    public static final byte ATTRIBUTE_DECLARATION = 2;
    public static final byte TYPE_DEFINITION = 4;
    public ElementType.DFAInfo root;
    public int idcCount;
    public XSModel xsModel;
    private UnresolvedComponentCache unresolvedComponentCache;
    public GlobalTypesInfo globalTypesInfo;
    private XPathDFA[] xpathDFAs;
    private int version = 1;

    public final int numXpathDFAs() {
        return this.xpathDFAs != null ? this.xpathDFAs.length : 0;
    }

    public final XPathDFA getXpathDFA(int n2) {
        return this.xpathDFAs[n2];
    }

    public final void setXpathDFAs(XPathDFA[] xPathDFAArray) {
        this.xpathDFAs = xPathDFAArray;
    }

    public final int findQNameInGlobalTypes(String string2, String string3) {
        return NamedDeclaration.findQNameInChoices(this.globalTypesInfo.globalTypes, this.globalTypesInfo.globalTypesTable, string2, string3);
    }

    public final GlobalTypesInfo extendGlobalTypesArray(int n2) {
        GlobalTypesInfo globalTypesInfo = new GlobalTypesInfo();
        globalTypesInfo.globalTypes = new ElementType[n2];
        System.arraycopy(this.globalTypesInfo.globalTypes, 0, globalTypesInfo.globalTypes, 0, this.globalTypesInfo.globalTypes.length);
        return globalTypesInfo;
    }

    public final void setGlobalTypes(GlobalTypesInfo globalTypesInfo) {
        globalTypesInfo.globalTypesTable = NamedDeclaration.createMap(globalTypesInfo.globalTypes, true);
        this.globalTypesInfo = globalTypesInfo;
    }

    public final int getVersion() {
        return this.version;
    }

    public final void incrementVersion() {
        ++this.version;
        if (LoggerUtil.isAnyTracingEnabled() && MergerContext.logger.isLoggable(Level.FINER)) {
            MergerContext.logger.logp(Level.FINER, this.getClass().getName(), "incrementVersion", "returning " + this.version);
        }
    }

    public boolean isComponentUnresolved(String string2, String string3, byte by2) {
        return this.unresolvedComponentCache != null ? this.unresolvedComponentCache.isComponentUnresolved(string2, string3, by2) : false;
    }

    public synchronized void addUnresolvedComponent(String string2, String string3, byte by2) {
        if (this.unresolvedComponentCache == null) {
            UnresolvedComponentCache unresolvedComponentCache = new UnresolvedComponentCache();
            unresolvedComponentCache.addUnresolvedComponent(string2, string3, by2);
            this.unresolvedComponentCache = unresolvedComponentCache;
        } else {
            this.unresolvedComponentCache.addUnresolvedComponent(string2, string3, by2);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class UnresolvedComponentCache {
        private static final int MAX_SIZE = 512;
        private int size;
        private final UnresolvedComponent[] components = new UnresolvedComponent[128];

        protected boolean isComponentUnresolved(String string2, String string3, byte by2) {
            int n2 = this.hash(string2, string3) & this.components.length - 1;
            UnresolvedComponent unresolvedComponent = this.components[n2];
            while (unresolvedComponent != null) {
                if (unresolvedComponent.equals(string2, string3, by2, false)) {
                    return true;
                }
                unresolvedComponent = unresolvedComponent.next;
            }
            return false;
        }

        protected void addUnresolvedComponent(String string2, String string3, byte by2) {
            int n2 = this.hash(string2, string3) & this.components.length - 1;
            int n3 = 0;
            UnresolvedComponent unresolvedComponent = this.components[n2];
            while (unresolvedComponent != null) {
                if (unresolvedComponent.equals(string2, string3, by2, true)) {
                    return;
                }
                ++n3;
                unresolvedComponent = unresolvedComponent.next;
            }
            if (this.size < 512) {
                ++this.size;
                unresolvedComponent = this.components[n2];
            } else {
                this.size = this.size - n3 + 1;
                unresolvedComponent = null;
            }
            this.components[n2] = new UnresolvedComponent(string2, string3, by2, unresolvedComponent);
        }

        private int hash(String string2, String string3) {
            return this.hash(string2) ^ this.hash(string3);
        }

        private int hash(String string2) {
            return string2 != null ? string2.hashCode() : 0;
        }

        @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
        private static final class UnresolvedComponent {
            private final String ns;
            private final String local;
            private byte componentType;
            private final UnresolvedComponent next;

            public UnresolvedComponent(String string2, String string3, byte by2, UnresolvedComponent unresolvedComponent) {
                this.ns = string2;
                this.local = string3;
                this.componentType = by2;
                this.next = unresolvedComponent;
            }

            public boolean equals(String string2, String string3, byte by2, boolean bl) {
                if (string3 == this.local && string2 == this.ns) {
                    if ((this.componentType & by2) != 0) {
                        return true;
                    }
                    if (bl) {
                        this.componentType = (byte)(this.componentType | by2);
                        return true;
                    }
                }
                return false;
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class GlobalTypesInfo {
        public ElementType[] globalTypes;
        public NamedDeclaration.Entry[] globalTypesTable;
    }
}

